/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.ml.JSMLCompletionRankingProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLContextFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLElementFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLTrackingCompletionProvider;
import com.intellij.lang.javascript.completion.ml.Origin;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getIdentifiersSimilarity", "", "identifierWords", "", "targetWords", "getName", "isAcceptable", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSMLElementFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMLElementFeaturesProvider.kt\ncom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1774#2,4:143\n*S KotlinDebug\n*F\n+ 1 JSMLElementFeaturesProvider.kt\ncom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider\n*L\n138#1:143,4\n*E\n"})
public class JSMLElementFeaturesProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "js";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        PsiElement parent;
        Class[] classArray;
        PsiElement psiElement;
        JSPostfixTemplateProvider.JSPostfixTemplateKind templateKind;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        if (!this.isAcceptable(location)) {
            return MapsKt.emptyMap();
        }
        Map result2 = new LinkedHashMap();
        JSMLTrackingCompletionProvider.Kind provider = (JSMLTrackingCompletionProvider.Kind)((Object)element.getUserData(JSMLTrackingCompletionProvider.JS_PROVIDER_KEY));
        if (provider != null) {
            result2.put("provider", MLFeatureValue.Companion.categorical((Enum)provider));
        }
        Object object = element.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object obj = object;
        if (obj instanceof JSCompletionKeyword) {
            result2.put("keyword", MLFeatureValue.Companion.categorical((Enum)obj));
        }
        if (element instanceof PostfixTemplateLookupElement && (templateKind = JSPostfixTemplateProvider.findKindByTemplate(((PostfixTemplateLookupElement)element).getPostfixTemplate())) != null) {
            result2.put("postfix_template", MLFeatureValue.Companion.categorical((Enum)templateKind));
        }
        if ((psiElement = element.getPsiElement()) == null) {
            return result2;
        }
        Origin origin = TypeScriptPsiUtil.isAmbientDeclaration(psiElement) ? Origin.DTS : (PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])(classArray = new Class[]{JSEmbeddedContent.class})) != null ? Origin.HTML : (DialectDetector.isTypeScript(psiElement) ? Origin.TS : Origin.JS));
        result2.put("origin", MLFeatureValue.Companion.categorical((Enum)origin));
        PsiFile psiFile = psiElement.getContainingFile();
        VirtualFile elementFile = psiFile != null ? psiFile.getVirtualFile() : null;
        boolean isFromCoreLibrary = elementFile != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(elementFile);
        result2.put("is_from_core_library", MLFeatureValue.Companion.binary(isFromCoreLibrary));
        result2.put("kind", MLFeatureValue.Companion.categorical((Enum)JSNamedElementKind.kind(psiElement)));
        CompletionParameters completionParameters = location.getCompletionParameters();
        PsiElement psiElement2 = completionParameters != null && (completionParameters = completionParameters.getPosition()) != null ? completionParameters.getParent() : (parent = null);
        if (parent instanceof JSReferenceExpression) {
            PsiElement psiElement3;
            SoftlyCachedValue softlyCachedValue = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getEXPECTED_TYPE_WORDS_KEY());
            List list2 = softlyCachedValue != null ? (List)softlyCachedValue.getUpToDateOrNull() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List expectedTypeWords = list2;
            SoftlyCachedValue softlyCachedValue2 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getINITIALIZED_ELEMENT_WORDS_KEY());
            List list3 = softlyCachedValue2 != null ? (List)softlyCachedValue2.getUpToDateOrNull() : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List initializedElementWords = list3;
            double expectedTypeSimilarity = 0.0;
            double initializedNameSimilarity = 0.0;
            double expectedAndElementTypesSimilarity = 0.0;
            double initializedNameAndElementTypeSimilarity = 0.0;
            if (!((Collection)expectedTypeWords).isEmpty() || !((Collection)initializedElementWords).isEmpty()) {
                PsiElement typeOfElement;
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                List<String> identifierWords = JSMLContextFeaturesProviderKt.wordsFromQualifiedName(string);
                expectedTypeSimilarity = this.getIdentifiersSimilarity(identifierWords, expectedTypeWords);
                initializedNameSimilarity = this.getIdentifiersSimilarity(identifierWords, initializedElementWords);
                psiElement3 = psiElement;
                Object object2 = psiElement3 instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)psiElement).getTypeElement() : (psiElement3 instanceof JSFunction ? ((JSFunction)psiElement).getReturnTypeElement() : (typeOfElement = psiElement3 instanceof JSClass ? psiElement : null));
                if (typeOfElement != null) {
                    List<String> elementTypeWords = JSMLContextFeaturesProviderKt.identifiersFromTypeDeclaration(typeOfElement);
                    expectedAndElementTypesSimilarity = this.getIdentifiersSimilarity(elementTypeWords, expectedTypeWords);
                    initializedNameAndElementTypeSimilarity = this.getIdentifiersSimilarity(elementTypeWords, initializedElementWords);
                }
            }
            boolean isFromReferencedFile = false;
            boolean isFromReferencedModule = false;
            if (elementFile != null) {
                SoftlyCachedValue softlyCachedValue3 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_FILES_KEY());
                Set set = softlyCachedValue3 != null ? (Set)softlyCachedValue3.getUpToDateOrNull() : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set referencedFiles2 = set;
                isFromReferencedFile = referencedFiles2.contains(elementFile);
                SoftlyCachedValue softlyCachedValue4 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_MODULES_KEY());
                Set set2 = softlyCachedValue4 != null ? (Set)softlyCachedValue4.getUpToDateOrNull() : null;
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Set referencedModules = set2;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)location.getProject()).getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
                ProjectFileIndex fileIndex = projectFileIndex;
                isFromReferencedModule = CollectionsKt.contains((Iterable)referencedModules, (Object)JSMLContextFeaturesProviderKt.getLibrarySourceRootForFile(fileIndex, elementFile));
            }
            psiElement3 = new PsiElement[]{TuplesKt.to((Object)"expected_type_and_ref_name_similarity", (Object)MLFeatureValue.Companion.float(expectedTypeSimilarity)), TuplesKt.to((Object)"initialized_name_similarity", (Object)MLFeatureValue.Companion.float(initializedNameSimilarity)), TuplesKt.to((Object)"expected_and_element_types_similarity", (Object)MLFeatureValue.Companion.float(expectedAndElementTypesSimilarity)), TuplesKt.to((Object)"initialized_name_and_element_type_similarity", (Object)MLFeatureValue.Companion.float(initializedNameAndElementTypeSimilarity)), TuplesKt.to((Object)"is_from_referenced_file", (Object)MLFeatureValue.Companion.binary(isFromReferencedFile)), TuplesKt.to((Object)"is_from_referenced_module", (Object)MLFeatureValue.Companion.binary(isFromReferencedModule))};
            MapsKt.putAll((Map)result2, (Pair[])psiElement3);
        }
        return result2;
    }

    public boolean isAcceptable(@NotNull CompletionLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompletionParameters completionParameters = location.getCompletionParameters();
        if (completionParameters == null || (completionParameters = completionParameters.getPosition()) == null) {
            return false;
        }
        CompletionParameters position = completionParameters;
        Language language = DialectDetector.languageOfElement((PsiElement)position);
        JSLanguageDialect jSLanguageDialect = language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
        if (jSLanguageDialect == null) {
            return false;
        }
        JSLanguageDialect language2 = jSLanguageDialect;
        return JSMLCompletionRankingProviderKt.isJSMLSupported(language2);
    }

    private final double getIdentifiersSimilarity(List<String> identifierWords, List<String> targetWords) {
        int n;
        if (identifierWords.isEmpty() || targetWords.isEmpty()) {
            return 0.0;
        }
        Iterable $this$count$iv = identifierWords;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                if (!targetWords.contains(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return (double)n / (double)Math.max(identifierWords.size(), targetWords.size());
    }
}

