/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableNameCompletionContributor
extends CompletionContributor {
    static final int BEFORE_NAME_COMPLETION_PRIORITY = -2;
    private static final int EXPLICIT_CONTEXT_PRIORITY = -3;
    private static final int NAMED_TYPE_PRIORITY = -4;
    private static final int DEFAULT_PRIORITY = -5;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement position;
        PsiElement parent;
        if (parameters == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((parent = JSVariableNameCompletionContributor.getNameParent(position = parameters.getPosition())) instanceof JSVariable) || JSCompletionUtil.isUnparsedGenericTail(parent)) {
            return;
        }
        PsiElement typeElement2 = ((JSVariable)parent).getTypeElement();
        if (typeElement2 != null) {
            if (typeElement2 instanceof JSTypeDeclaration) {
                JSType type2 = ((JSTypeDeclaration)typeElement2).getJSType();
                JSVariableNameCompletionContributor.addAllNamesForType(result2, type2, parent);
            }
            return;
        }
        JSExpression initializer = ((JSVariable)parent).getInitializerOrStub();
        if (initializer != null) {
            initializer = (JSExpression)CompletionUtil.getOriginalOrSelf((PsiElement)initializer);
            for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(initializer, parent, "", ContainerUtil.emptyList(), JSNameSuggestionsUtil.getEntityKind(parent))) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
            return;
        }
        if (parent instanceof TypeScriptEnumField) {
            return;
        }
        JSType type3 = JSTypeUtils.getTypeOfElement(parent);
        if (type3 != null) {
            JSVariableNameCompletionContributor.addAllNamesForType(result2, type3, parent);
            return;
        }
        JSApplicationSettings settings2 = JSApplicationSettings.getInstance();
        if (!(parent instanceof JSField) && !settings2.isUseVarNamesCompletion() || parent instanceof JSField && !settings2.isUseFieldNamesCompletion()) {
            return;
        }
        JSApplicationSettings.VariableCompletionKind completionKind = settings2.getVariableCompletionKind();
        if (!completionKind.allowsFields() && parent instanceof JSField) {
            return;
        }
        PsiFile file = parameters.getOriginalFile();
        JSIconProvider iconProvider = JSIconProvider.getForLanguage(position);
        boolean canAddTypeAnnotation = DialectDetector.hasFeature(parent, JSLanguageFeature.TYPES) && JSVariableNameCompletionContributor.isMatchingContext(parent, completionKind);
        Set<String> localKeys = JSVariableNameCompletionContributor.collectLocals(file);
        Project project = file.getProject();
        HashSet<String> miscKeys = new HashSet<String>(StubIndex.getInstance().getAllKeys(JSGlobalSymbolIndex.KEY, project));
        JSVariableNameCompletionContributor.processClassOnlyKeys(result2, iconProvider, project, miscKeys, localKeys, canAddTypeAnnotation);
        for (String key2 : miscKeys) {
            JSVariableNameCompletionContributor.addLookupItems(result2, project, key2, EntityKind.SYMBOL, iconProvider, localKeys, canAddTypeAnnotation);
        }
    }

    @Nullable
    static PsiElement getNameParent(PsiElement position) {
        if (!(position instanceof LeafPsiElement) || ((LeafPsiElement)position).getElementType() != JSTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof JSNamedElement) || ((JSNamedElement)parent).getNameIdentifier() != position || JSDestructuringUtil.isDestructuring(parent.getParent())) {
            return null;
        }
        return parent;
    }

    @NotNull
    private static Set<String> collectLocals(@NotNull PsiFile file) {
        if (file == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(2);
        }
        HashSet<String> localKeys = new HashSet<String>();
        StubIndex.getInstance().processAllKeys(JSClassIndex.KEY, k -> {
            localKeys.add((String)k);
            return true;
        }, GlobalSearchScope.fileScope((PsiFile)file));
        HashSet<String> hashSet = localKeys;
        if (hashSet == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void processClassOnlyKeys(@NotNull CompletionResultSet result2, @NotNull JSIconProvider iconProvider, @NotNull Project project, @NotNull Set<String> miscKeys, @NotNull Set<String> localKeys, boolean canAddTypeAnnotation) {
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(4);
        }
        if (iconProvider == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(6);
        }
        if (miscKeys == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(7);
        }
        if (localKeys == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(8);
        }
        Collection classKeys = StubIndex.getInstance().getAllKeys(JSClassIndex.KEY, project);
        for (String key2 : classKeys) {
            if (StringUtil.isEmptyOrSpaces((String)key2)) continue;
            boolean isInterface = false;
            if (key2.charAt(0) == '^') {
                isInterface = true;
                key2 = key2.substring(1);
            }
            JSVariableNameCompletionContributor.addLookupItems(result2, project, key2, isInterface ? EntityKind.INTERFACE : EntityKind.CLASS, iconProvider, localKeys, canAddTypeAnnotation);
            miscKeys.remove(key2);
        }
    }

    private static void addLookupItems(@NotNull CompletionResultSet result2, @NotNull Project project, @NotNull String key2, @NotNull EntityKind symbol, @NotNull JSIconProvider iconProvider, @NotNull Set<String> localKeys, boolean canAddTypeAnnotation) {
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(10);
        }
        if (key2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(11);
        }
        if (symbol == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(12);
        }
        if (iconProvider == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(13);
        }
        if (localKeys == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isCapitalized((String)key2) || StringUtil.isUpperCase((CharSequence)key2) || StringUtil.containsChar((String)key2, (char)'_') || StringUtil.containsChar((String)key2, (char)'$')) {
            return;
        }
        for (String variant : NameUtil.getSuggestionsByName((String)JSVariableNameCompletionContributor.normalizeVariableName(key2), (String)"", (String)"", (boolean)false, (boolean)false, (boolean)false)) {
            if (!JSRefactoringUtil.isValidIdentifier(variant, project)) continue;
            LookupElementBuilder builder2 = LookupElementBuilder.create((String)variant);
            if (symbol != EntityKind.SYMBOL && canAddTypeAnnotation) {
                Icon icon2 = symbol.getIcon(iconProvider);
                if (icon2 != null) {
                    builder2 = builder2.withIcon(icon2);
                }
                final String typeAnnotation = ": " + key2;
                builder2 = builder2.withTailText(typeAnnotation, true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                        PsiElement anchor;
                        if (context2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((anchor = 1.getAnchor(context2)) != null) {
                            int offset = anchor.getTextRange().getEndOffset();
                            context2.getDocument().insertString(offset, (CharSequence)typeAnnotation);
                            context2.getEditor().getCaretModel().moveToOffset(offset + typeAnnotation.length());
                            context2.commitDocument();
                        }
                    }

                    @Nullable
                    private static PsiElement getAnchor(InsertionContext context2) {
                        return context2.getFile().findElementAt(context2.getEditor().getCaretModel().getOffset() - 1);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            int priority = symbol.getPriority();
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)(localKeys.contains(variant) ? (double)(priority + 1) : (double)priority)));
        }
    }

    private static boolean isMatchingContext(PsiElement parent, JSApplicationSettings.VariableCompletionKind kind) {
        return switch (kind) {
            case JSApplicationSettings.VariableCompletionKind.NAMES_ONLY -> false;
            case JSApplicationSettings.VariableCompletionKind.TYPES_FOR_PARAMS -> parent instanceof JSParameter;
            case JSApplicationSettings.VariableCompletionKind.TYPES_FOR_PARAMS_FIELDS -> {
                if (parent instanceof JSParameter || parent instanceof JSField) {
                    yield true;
                }
                yield false;
            }
            case JSApplicationSettings.VariableCompletionKind.TYPES_EVERYWHERE -> true;
            default -> false;
        };
    }

    @NotNull
    private static String normalizeVariableName(@NotNull String key2) {
        String decapitalized;
        if (key2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(15);
        }
        if (!Character.isUpperCase((decapitalized = StringUtil.decapitalize((String)key2)).charAt(0))) {
            String string = decapitalized;
            if (string == null) {
                JSVariableNameCompletionContributor.$$$reportNull$$$0(16);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        boolean lowerCase = true;
        for (int i = 0; i < decapitalized.length(); ++i) {
            char ch = decapitalized.charAt(i);
            if (lowerCase && !Character.isUpperCase(ch)) {
                builder2.replace(i - 1, i, String.valueOf(Character.toUpperCase(builder2.charAt(i - 1))));
                lowerCase = false;
            }
            builder2.append(lowerCase ? Character.toLowerCase(ch) : ch);
        }
        String string = builder2.toString();
        if (string == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void addAllNamesForType(@NotNull CompletionResultSet result2, @NotNull JSType type2, @NotNull PsiElement parent) {
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(18);
        }
        if (type2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(20);
        }
        for (String name : JSNameSuggestionsUtil.generateVariableNamesFromType(type2, parent, ContainerUtil.emptyList())) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)-3.0));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconProvider";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "miscKeys";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localKeys";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLocals";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectLocals";
                break;
            }
            case 3: 
            case 16: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processClassOnlyKeys";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItems";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVariableName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addAllNamesForType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static enum EntityKind {
        CLASS,
        INTERFACE,
        SYMBOL;


        private Icon getIcon(@NotNull JSIconProvider provider) {
            if (provider == null) {
                EntityKind.$$$reportNull$$$0(0);
            }
            return switch (this) {
                case CLASS -> provider.getClassIcon();
                case INTERFACE -> provider.getInterfaceIcon();
                default -> null;
            };
        }

        private int getPriority() {
            return switch (this) {
                case CLASS, INTERFACE -> -4;
                default -> -5;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor$EntityKind", "getIcon"));
        }
    }
}

