/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSmartCompletionContributor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartCompletionContributor {
    public static final LanguageExtension<JSSmartCompletionContributor> EP_NAME = new LanguageExtension("JavaScript.smartCompletionContributor");
    private static final JSSmartCompletionContributor INSTANCE = new JSSmartCompletionContributor();

    public static JSSmartCompletionContributor getInstance() {
        return INSTANCE;
    }

    @Nullable
    public List<LookupElement> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        PsiElement parent;
        PsiElement originalParent;
        JSType expectedClassType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((expectedClassType = JSTypeUtils.getValuableType(JSTypeUtils.removeNullableComponents(this.findClassType(originalParent = CompletionUtil.getOriginalOrSelf((PsiElement)(parent = location.getParent())))))) instanceof JSNamedType || expectedClassType instanceof JSGenericTypeImpl) {
            if (expectedClassType instanceof JSGenericTypeImpl && !DialectDetector.hasFeature((PsiElement)location, JSLanguageFeature.GENERICS)) {
                expectedClassType = ((JSGenericTypeImpl)expectedClassType).getType();
            }
            return this.getClassTypeVariants((PsiElement)location, parent, expectedClassType);
        }
        if (location.getQualifier() == null) {
            List<LookupElement> smart;
            TypeScriptType element;
            PsiElement grand;
            List<LookupElement> smart2;
            JSType qualifierType;
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(location);
            List<LookupElement> stringLiteralVariants = this.getStringLiteralVariants(location, false, expectedType);
            if (stringLiteralVariants != null) {
                return stringLiteralVariants;
            }
            List<LookupElement> elements = JSSmartCompletionContributor.addOtherSmartVariants(expectedType);
            if (elements != null && !elements.isEmpty()) {
                return elements;
            }
            if (parent instanceof JSIndexedPropertyAccessExpression && (qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)parent).getQualifier())) != null && !(smart2 = this.getItemsForPropertyNamesInIndexer(location, qualifierType)).isEmpty()) {
                return smart2;
            }
            if (parent instanceof TypeScriptSingleType && (grand = parent.getParent()) instanceof TypeScriptIndexedAccessType && (element = ((TypeScriptIndexedAccessType)grand).getOwnerTypeElement()) != null && !(smart = this.getItemsForPropertyNamesInIndexer(location, element.getJSType())).isEmpty()) {
                return smart;
            }
        }
        return null;
    }

    @NotNull
    private List<LookupElement> getItemsForPropertyNamesInIndexer(@NotNull JSReferenceExpression location, @NotNull JSType qualifierType) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if (qualifierType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if (qualifierType instanceof JSTupleType || qualifierType instanceof JSArrayType) {
            List<LookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSSmartCompletionContributor.$$$reportNull$$$0(3);
            }
            return list2;
        }
        SmartList smart = new SmartList();
        for (JSRecordType.PropertySignature propertySignature : qualifierType.asRecordType().getProperties()) {
            boolean isSymbol;
            ItemWithAction item;
            PsiElement element = propertySignature.getMemberSource().getSingleElement();
            if (element instanceof JSComputedPropertyNameOwner && (item = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)element, (PsiElement)location)) != null && item.item.startsWith("[")) {
                this.addLiteralLookupItem(location, true, (List<LookupElement>)smart, null, StringUtil.trimEnd((String)item.item.substring(1), (String)"]"), JSLookupPriority.SMART_PRIORITY, item.importAction);
                continue;
            }
            String name = propertySignature.getMemberName();
            this.addLiteralLookupItem(location, isSymbol, (List<LookupElement>)smart, null, (isSymbol = name.startsWith("[Symbol.")) ? StringUtil.trimEnd((String)name.substring(1), (String)"]") : name, JSLookupPriority.SMART_PRIORITY);
        }
        SmartList smartList = smart;
        if (smartList == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Nullable
    private static List<LookupElement> addOtherSmartVariants(@Nullable JSType expectedType) {
        List<LookupElement> staticItems;
        if (expectedType == null) {
            return null;
        }
        if (expectedType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)expectedType;
            expectedType = genericType.getType();
        }
        if ((staticItems = JSSmartCompletionContributor.addStaticFactoryMethods(expectedType = JSTypeUtils.getValuableType(JSTypeUtils.removeNullableComponents(expectedType)))) != null) {
            return staticItems;
        }
        return null;
    }

    @Nullable
    private static List<LookupElement> addStaticFactoryMethods(@NotNull JSType expectedType) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        if (!(expectedType instanceof JSResolvableType)) {
            return null;
        }
        JSResolvableType resolvableType = (JSResolvableType)expectedType;
        JSClass jsClass = resolvableType.resolveType().getDeclarationOfType(JSClass.class);
        if (jsClass == null) {
            return null;
        }
        ArrayList<LookupElement> staticItems = new ArrayList<LookupElement>();
        for (JSFunction function2 : jsClass.getFunctions()) {
            JSAttributeList list2 = function2.getAttributeList();
            if (list2 == null || list2.getAccessType() != JSAttributeList.AccessType.PUBLIC || !list2.hasModifier(JSAttributeList.ModifierType.STATIC)) continue;
            JSType returnType = function2.getReturnType();
            if (returnType instanceof JSEvaluableTypeBase) {
                returnType = returnType.substitute();
            }
            if (returnType == null || !returnType.isEquivalentTo(expectedType, null)) continue;
            staticItems.add(JSLookupUtilImpl.createLookupItemForStaticCall(function2, jsClass));
        }
        return staticItems;
    }

    @NotNull
    public List<LookupElement> getClassTypeVariants(PsiElement location, PsiElement parent, JSType expectedClassType) {
        JSAttributeList.AccessType constructorAccessType;
        String qualifiedName;
        JSType possiblyResolvable;
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        String className = expectedClassType.getTypeText(JSType.TypeTextFormat.CODE);
        JSQualifiedNamedElement valueElement = null;
        if (expectedClassType instanceof JSPrimitiveType) {
            String matchingTypeName = JSTypeUtils.getQualifiedNameMatchingType(expectedClassType, false);
            if (matchingTypeName == null) {
                ArrayList<LookupElement> arrayList = variants;
                if (arrayList == null) {
                    JSSmartCompletionContributor.$$$reportNull$$$0(6);
                }
                return arrayList;
            }
            className = matchingTypeName;
        }
        JSType jSType = possiblyResolvable = expectedClassType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)expectedClassType).getType() : expectedClassType;
        if (possiblyResolvable instanceof JSResolvableType) {
            JSResolvedTypeInfo info2 = ((JSResolvableType)possiblyResolvable).resolveType();
            valueElement = info2.getDeclarationOfType(JSClass.class);
        }
        JSVariable variable = null;
        if (valueElement instanceof TypeScriptInterface && (qualifiedName = valueElement.getQualifiedName()) != null) {
            Collection<PsiElement> elements = new TypeScriptQualifiedNameResolver(parent, false).resolveQualifiedName(qualifiedName);
            for (PsiElement element : elements) {
                if (element instanceof JSClass && ((JSClass)element).isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS) {
                    valueElement = (JSClass)element;
                    break;
                }
                if (!(element instanceof JSVariable)) continue;
                variable = JSSmartCompletionContributor.verifyVariable((JSVariable)element, possiblyResolvable);
            }
        }
        JSFunction constructor = valueElement == null ? null : JSResolveUtil.getClassConstructor((JSClass)valueElement);
        JSAttributeList.AccessType accessType = constructorAccessType = constructor == null ? JSAttributeList.AccessType.PUBLIC : constructor.getAccessType();
        if (variable == null && this.shouldAddAsAbstract(parent, (JSClass)valueElement)) {
            if (constructorAccessType != JSAttributeList.AccessType.PRIVATE) {
                variants.add(JSLookupUtilImpl.createImplementAbstractOrInterfaceLookupItem((PsiElement)valueElement, className));
            }
        } else if (variable != null || constructorAccessType == JSAttributeList.AccessType.PUBLIC || JSDialectSpecificHandlersFactory.forElement(location).createAccessibilityProcessingHandler(location, false).acceptsConstructorWithNew((PsiElement)valueElement, valueElement.getName())) {
            LookupElement lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)(variable == null ? valueElement : variable), (String)(className.endsWith(">") ? className + "()" : className), JSLookupPriority.SMART_PRIORITY);
            variants.add(lookupItem);
        }
        JSSmartCompletionContributor.addAllJSClassInheritors(variants, className, parent);
        ArrayList<LookupElement> arrayList = variants;
        if (arrayList == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static JSVariable verifyVariable(@Nullable JSVariable variable, @NotNull JSType possiblyResolvable) {
        if (possiblyResolvable == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(8);
        }
        if (variable == null) {
            return null;
        }
        JSType elementType = JSTypeUtils.getTypeOfElement((PsiElement)variable);
        if (elementType == null) {
            return null;
        }
        List<JSRecordType.CallSignature> callSignatures = elementType.asRecordType().getCallSignatures();
        if (!callSignatures.isEmpty() && callSignatures.stream().filter(s -> s.hasNew()).anyMatch(signature -> JSSmartCompletionContributor.areEquivalentDroppingGenerics(signature.getReturnType(), possiblyResolvable))) {
            return variable;
        }
        return null;
    }

    private static boolean areEquivalentDroppingGenerics(@Nullable JSType type2, @NotNull JSType resolvable) {
        if (resolvable == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(9);
        }
        if (type2 instanceof JSGenericTypeImpl) {
            type2 = ((JSGenericTypeImpl)type2).getType();
        }
        return resolvable.isEquivalentTo(type2, null) || resolvable instanceof JSTypeImpl && type2 instanceof JSTypeImpl && resolvable.getResolvedTypeText().equals(type2.getResolvedTypeText());
    }

    @Contract(value="_, null -> false")
    public boolean shouldAddAsAbstract(@Nullable PsiElement parent, @Nullable JSClass valueElement) {
        return parent instanceof JSNewExpression && valueElement != null && (valueElement.isInterface() || TypeScriptPsiUtil.isAbstractElement(valueElement));
    }

    @Nullable
    protected List<LookupElement> getStringLiteralVariants(@NotNull JSExpression location, boolean insideStringLiteral) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(10);
        }
        JSExpression sourceLocation = (JSExpression)CompletionUtil.getOriginalOrSelf((PsiElement)location);
        return this.getStringLiteralVariants(sourceLocation, insideStringLiteral, JSDialectSpecificHandlersFactory.findExpectedType(sourceLocation));
    }

    @Nullable
    private List<LookupElement> getStringLiteralVariants(@NotNull JSExpression location, boolean insideStringLiteral, @Nullable JSType expectedType) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(11);
        }
        if (expectedType != null) {
            return this.getLiteralVariantsForExpectedType(location, insideStringLiteral, expectedType);
        }
        PsiElement parent = location.getParent();
        if (parent instanceof TypeScriptEnumField && ((TypeScriptEnumField)parent).getInitializer() == location && ((TypeScriptEnumField)parent).getName() != null) {
            SmartList smart = new SmartList();
            this.addLiteralLookupItem(location, insideStringLiteral, (List<LookupElement>)smart, null, ((TypeScriptEnumField)parent).getName(), JSLookupPriority.SMART_PRIORITY);
            return smart;
        }
        return null;
    }

    @Nullable
    protected List<LookupElement> getLiteralVariantsForExpectedType(@NotNull JSExpression location, boolean insideStringLiteral, @Nullable JSType expectedType) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(12);
        }
        expectedType = JSSmartCompletionContributor.substituteCompletely(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSSmartCompletionContributor.replaceGenericsWithConstraints(expectedType)));
        SmartList literalVariants = new SmartList();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)arg_0 -> this.lambda$getLiteralVariantsForExpectedType$2(location, insideStringLiteral, (List)literalVariants, arg_0)), expectedType, false, true, true);
        if (!literalVariants.isEmpty()) {
            return literalVariants;
        }
        return null;
    }

    @Nullable
    private static JSType substituteCompletely(@Nullable JSType expectedType) {
        if (expectedType instanceof JSTypeWithIncompleteSubstitution) {
            expectedType = ((JSTypeWithIncompleteSubstitution)expectedType).substituteCompletely();
        }
        return expectedType;
    }

    @Nullable
    private static JSType replaceGenericsWithConstraints(@Nullable JSType expectedType) {
        return expectedType == null ? null : expectedType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> {
            JSType constraintType;
            if (t instanceof JSGenericParameterType && (constraintType = ((JSGenericParameterType)t).getConstraintType()) != null) {
                return constraintType;
            }
            return t;
        }));
    }

    private void addFromEnum(@NotNull JSExpression location, @NotNull List<LookupElement> literalVariants, @NotNull JSResolvableType type2) {
        JSResolvedTypeInfo info2;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(13);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(15);
        }
        if ((info2 = type2.resolveType()).isEnumWithLiteralValues()) {
            for (TypeScriptEnum typeScriptEnum : info2.getDeclarationsOfType(TypeScriptEnum.class)) {
                for (JSField field : typeScriptEnum.getFields()) {
                    if (!(field instanceof TypeScriptEnumField)) continue;
                    this.addStringFromEnumField(location, literalVariants, ((TypeScriptEnumField)field).getConstantValue());
                }
            }
        } else {
            this.addStringFromEnumField(location, literalVariants, info2.getEnumConstValue());
        }
    }

    private void addStringFromEnumField(@NotNull JSExpression location, @NotNull List<LookupElement> literalVariants, @NotNull EnumConstantValue value) {
        String stringValue;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(16);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(17);
        }
        if (value == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(18);
        }
        if ((stringValue = value.getStringValue()) != null) {
            this.addLiteralLookupItem(location, true, literalVariants, null, stringValue, JSLookupPriority.SMART_PRIORITY);
        }
    }

    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type2) {
        List<LookupElement> variantsForExpectedType;
        JSType constraintType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(19);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(20);
        }
        if (!DialectDetector.isActionScript((PsiElement)location) && type2 instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type2).getConstraintType()) != null && (variantsForExpectedType = this.getLiteralVariantsForExpectedType(location, insideStringLiteral, constraintType)) != null) {
            literalVariants.addAll(variantsForExpectedType);
        }
        if (type2 instanceof JSPrimitiveLiteralType) {
            Object literal = ((JSPrimitiveLiteralType)type2).getLiteral();
            this.addLiteralLookupItem(location, insideStringLiteral, literalVariants, type2, literal, JSLookupPriority.SMART_PRIORITY);
        }
    }

    protected void addLiteralLookupItem(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, @Nullable JSType type2, Object literal, JSLookupPriority priority) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(21);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(22);
        }
        this.addLiteralLookupItem(location, insideStringLiteral, literalVariants, type2, literal, priority, null);
    }

    protected void addLiteralLookupItem(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, @Nullable JSType type2, Object literal, JSLookupPriority priority, @Nullable Runnable insertHandlerAction) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(23);
        }
        if (literalVariants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(24);
        }
        if (insideStringLiteral && !(literal instanceof String)) {
            return;
        }
        assert (literal instanceof String || type2 != null);
        String q = literal instanceof String && !insideStringLiteral ? JSCodeStyleSettings.getQuote((PsiElement)location) : "";
        Object desc = literal instanceof String ? q + literal + q : type2.getTypeText(JSType.TypeTextFormat.CODE);
        String string = literal instanceof String ? (String)literal : null;
        LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(type2 instanceof JSTypeKeyTypeImpl ? type2.getSourceElement() : null, (String)desc, priority, false, null, false, string, insertHandlerAction);
        literalVariants.add(prioritizedLookupItem);
    }

    private static void addAllJSClassInheritors(List<LookupElement> variants, String className, PsiElement place) {
        ArrayList all = new ArrayList();
        JSTypeEvaluateManager.iterateSubclasses(place, className, (Processor<? super JSType>)((Processor)type2 -> {
            String qName = JSTypeUtils.getQualifiedNameMatchingType(type2, false);
            if (qName != null) {
                all.add(qName);
            }
            return true;
        }));
        for (String subclass : all) {
            LookupElement item = JSLookupUtilImpl.createPrioritizedLookupItem(null, subclass, JSLookupPriority.SMART_PRIORITY);
            variants.add(item);
        }
    }

    @Nullable
    protected JSType findClassType(PsiElement parent) {
        IElementType opSign;
        if (parent instanceof JSNewExpression) {
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression && ((opSign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.AS_KEYWORD || opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.INSTANCEOF_KEYWORD)) {
            JSType type2 = JSResolveUtil.getExpressionJSType(((JSBinaryExpression)parent).getLOperand());
            if (type2 != null && !(type2 instanceof JSAnyType) && !(type2 instanceof JSObjectType)) {
                return type2;
            }
            return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent);
        }
        return null;
    }

    @NotNull
    protected List<LookupElement> addVariantsForUnqualifiedReference(@NotNull JSReferenceExpression location) {
        JSType expectedType;
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(25);
        }
        if ((expectedType = JSDialectSpecificHandlersFactory.findExpectedType(location)) == null) {
            List<LookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSSmartCompletionContributor.$$$reportNull$$$0(26);
            }
            return list2;
        }
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        this.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
        ArrayList<LookupElement> arrayList = variants;
        if (arrayList == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<LookupElement> variants) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(28);
        }
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(29);
        }
        if (variants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(30);
        }
        PsiElement parent = location.getParent();
        int qualifiedStaticVariantsStart = Integer.MAX_VALUE;
        PsiElement parentInOriginalTree = CompletionUtil.getOriginalOrSelf((PsiElement)parent);
        SinkResolveProcessor<CompletionResultSink> processor = JSSmartCompletionContributor.createProcessor(expectedType, parentInOriginalTree);
        JSClass ourClass = JSResolveUtil.getClassOfContext(parentInOriginalTree);
        this.processVariantsIfDoingSmartCompletion(expectedType, variants, parentInOriginalTree, processor, ourClass);
        this.processClasses(parentInOriginalTree, processor);
        qualifiedStaticVariantsStart = this.processContextClass(location, expectedType, parent, variants, qualifiedStaticVariantsStart, processor, ourClass);
        int i = 0;
        HashSet<String> used = new HashSet<String>();
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            JSParameterItem parameter;
            String referencedParameterName = null;
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument(location, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            for (PsiElement o : results) {
                PsiElement element;
                JSNamedElement namedElement = (JSNamedElement)o;
                Object name = namedElement.getName();
                String additionalPrefix = null;
                if ((namedElement instanceof JSVariable || namedElement instanceof JSFunction) && this.needToQualify(qualifiedStaticVariantsStart, i) && (element = JSResolveUtil.findParent((PsiElement)namedElement)) instanceof JSClass) {
                    additionalPrefix = name;
                    name = ((JSClass)element).getName() + "." + (String)name;
                }
                if (name == null || !used.add((String)name)) {
                    if (i >= qualifiedStaticVariantsStart) continue;
                    --qualifiedStaticVariantsStart;
                    continue;
                }
                JSLookupPriority priority = JSLookupPriority.getSmartVariantPriority(((String)name).equals(referencedParameterName));
                LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)namedElement, (String)name, priority, false, null, false, additionalPrefix);
                variants.add(prioritizedLookupItem);
                ++i;
            }
        }
    }

    protected void processVariantsIfDoingSmartCompletion(@NotNull JSType expectedType, @NotNull List<LookupElement> variants, PsiElement parentInOriginalTree, @NotNull SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (expectedType == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(31);
        }
        if (variants == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(33);
        }
        if (JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            processor.setToProcessHierarchy(true);
            processor.configureClassScope(ourClass);
            JSResolveUtil.treeWalkUp(processor, parentInOriginalTree, parentInOriginalTree.getParent(), parentInOriginalTree);
            processor.setAllowUnqualifiedStaticsFromInstance(false);
            if (expectedType instanceof JSBooleanType) {
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "true", JSLookupPriority.SMART_PRIORITY));
                variants.add(JSLookupUtilImpl.createPrioritizedLookupItem(null, "false", JSLookupPriority.SMART_PRIORITY));
            }
        }
    }

    @NotNull
    private static SinkResolveProcessor<CompletionResultSink> createProcessor(final JSType expectedType, PsiElement parentInOriginalTree) {
        final CompletionResultSink resultSink = new CompletionResultSink(parentInOriginalTree, null);
        resultSink.setSmartCompletionInheritanceProcessingContext(JSSmartCompletionVariantsHandler.initProcessingContext(parentInOriginalTree));
        return new SinkResolveProcessor<CompletionResultSink>(resultSink){
            {
                super(arg0);
                this.setAllowUnqualifiedStaticsFromInstance(true);
                this.setLocalResolve(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, expectedType, resultSink.getSmartCompletionInheritanceProcessingContext()) || super.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected int processContextClass(@NotNull JSReferenceExpression location, JSType expectedType, PsiElement parent, List<LookupElement> variants, int qualifiedStaticVariantsStart, SinkResolveProcessor<?> processor, JSClass ourClass) {
        if (location == null) {
            JSSmartCompletionContributor.$$$reportNull$$$0(34);
        }
        return qualifiedStaticVariantsStart;
    }

    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return qualifiedStaticVariantsStart <= i;
    }

    protected void processClasses(PsiElement parentInOriginalTree, SinkResolveProcessor<?> processor) {
    }

    @Nullable
    protected static <T> List<T> mergeVariants(@Nullable List<T> completionVariants, @Nullable List<T> extraVariants) {
        if (extraVariants == null) {
            return completionVariants;
        }
        if (completionVariants == null) {
            return extraVariants;
        }
        return ContainerUtil.concat(extraVariants, completionVariants);
    }

    private /* synthetic */ boolean lambda$getLiteralVariantsForExpectedType$2(JSExpression location, boolean insideStringLiteral, List literalVariants, JSType type2) {
        type2 = JSSmartCompletionContributor.substituteCompletely(type2);
        this.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, type2);
        if (insideStringLiteral && type2 instanceof JSResolvableType) {
            this.addFromEnum(location, literalVariants, (JSResolvableType)type2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor";
                break;
            }
            case 5: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyResolvable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvable";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSSmartCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForPropertyNamesInIndexer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypeVariants";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addVariantsForUnqualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemsForPropertyNamesInIndexer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 26: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addStaticFactoryMethods";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "verifyVariable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalentDroppingGenerics";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralVariants";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralVariantsForExpectedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFromEnum";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addStringFromEnumField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSingleLiteralVariant";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addLiteralLookupItem";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForUnqualifiedReference";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsIfDoingSmartCompletion";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processContextClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 26, 27 -> new IllegalStateException(string);
        };
    }
}

