/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementMerger;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSBoundNameOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportCompletionUtil {
    public static final JSLookupPriority IMPORT_PRIORITY = JSLookupPriority.LOWEST_PRIORITY;
    @NotNull
    public static final InsertHandler<LookupElement> TAG_IMPORT_INSERT_HANDLER = (context2, item) -> {
        PsiFile originalFile = context2.getFile();
        PsiElement originalElement = originalFile.findElementAt(context2.getStartOffset());
        if (originalElement != null) {
            XmlTagNameSynchronizer.runWithoutCancellingSyncTagsEditing((Document)context2.getDocument(), () -> {
                Object object = item.getObject();
                JSImportCompletionUtil.insertLookupItem(context2, item, (JSImportCandidate)ObjectUtils.tryCast((Object)object, JSImportCandidate.class), (Consumer<JSImportCandidateWithExecutor>)((Consumer)el -> {
                    if (el != null) {
                        PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getDocument());
                        PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(context2.getDocument());
                        XmlTagInsertHandler.INSTANCE.handleInsert(context2, item);
                    }
                }));
            });
        }
    };

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(0);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(1);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression.getQualifier() == null);
        JSImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportDeclarationPart specifier, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(3);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(4);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(5);
        }
        JSImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Collection<LookupElement> localAndGlobalElements, @NotNull CompletionResultSet completionResultSet) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(6);
        }
        if (localAndGlobalElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(7);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(8);
        }
        if (JSImportCompletionUtil.skipPlace(place)) {
            return;
        }
        int count = localAndGlobalElements.size();
        if (!JSImportCompletionUtil.checkLimit(completionResultSet, JSCompletionUtil.getCompletionLimit(), count)) {
            return;
        }
        PsiElement originalPlace = CompletionUtilCoreImpl.getOriginalElement((PsiElement)place);
        if (originalPlace != null) {
            place = originalPlace;
        }
        PrefixMatcher matcher = completionResultSet.getPrefixMatcher();
        Set<String> localAndProcessedElements = JSImportCompletionUtil.getLocalElementNames(localAndGlobalElements, place, matcher);
        JSImportPlaceInfo info2 = JSHandlersFactory.forElement(place).createImportPlaceInfo(place);
        AtomicInteger counter2 = new AtomicInteger(count);
        JSImportCompletionUtil.processExportedElements(place, completionResultSet, counter2, localAndProcessedElements, localAndGlobalElements, info2);
    }

    private static void processExportedElements(@NotNull PsiElement place, @NotNull CompletionResultSet completionResultSet, @NotNull AtomicInteger counter2, @NotNull Set<String> localElements, @NotNull Collection<LookupElement> localAndGlobalElements, @NotNull JSImportPlaceInfo info2) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(9);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(10);
        }
        if (counter2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(11);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(12);
        }
        if (localAndGlobalElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(13);
        }
        if (info2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(14);
        }
        int limit = JSCompletionUtil.getCompletionLimit();
        PsiFile containingFile2 = place.getContainingFile().getOriginalFile();
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        boolean excludeNonLatin = JSImportCompletionUtil.isExcludeWithNonLatinFirstSymbol(completionResultSet);
        Predicate<String> keyFilter = el -> !el.isEmpty() && !localElements.contains(el) && prefixMatcher.prefixMatches(el) && (!excludeNonLatin || JSImportCompletionUtil.isLatin(el.charAt(0)));
        JSLookupElementMerger merger = new JSLookupElementMerger(place, (el, priority) -> info2.isAcceptable(el), limit, true);
        List<JSImportCandidatesProvider> candidates = JSImportCandidatesProvider.getProviders(info2);
        NotNullLazyValue localAndGlobalElementNames = NotNullLazyValue.lazy(() -> ContainerUtil.map2Set((Collection)localAndGlobalElements, LookupElement::getLookupString));
        JSImportCompletionUtil.processExportedElements(place, candidates, keyFilter, (PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String>)((PairProcessor)(elements, name) -> {
            if (JSChangeUtil.isExactWellKnownPredefined(name) && JSImportCompletionUtil.isImportWithSuggestedName(elements) && ((Set)localAndGlobalElementNames.getValue()).contains(name)) {
                return true;
            }
            localElements.add((String)name);
            InsertHandler<LookupElement> insertHandler = JSImportCompletionUtil.getImportInsertHandler(containingFile2, elements);
            JSImportCompletionUtil.fillLookupItemForElements(completionResultSet, insertHandler, name, elements, merger);
            counter2.incrementAndGet();
            return JSImportCompletionUtil.checkLimit(completionResultSet, limit, counter2.get());
        }));
    }

    private static boolean isImportWithSuggestedName(Collection<? extends JSImportCandidate> elements) {
        JSImportCandidate importCandidate = (JSImportCandidate)ContainerUtil.getFirstItem(elements);
        if (importCandidate == null) {
            return false;
        }
        PsiElement element = importCandidate.getElement();
        return element instanceof TypeScriptModule || element instanceof JSFile;
    }

    public static boolean processExportedElements(@NotNull PsiElement place, @NotNull List<JSImportCandidatesProvider> providers, @NotNull Predicate<String> keyFilter, @NotNull PairProcessor<? super Collection<? extends JSImportCandidate>, ? super String> processor) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(15);
        }
        if (providers == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(16);
        }
        if (keyFilter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(18);
        }
        ProgressManager.checkCanceled();
        TreeSet allKeys = new TreeSet();
        ArrayList<Pair> listOfProviders = new ArrayList<Pair>();
        for (JSImportCandidatesProvider candidateProvider : providers) {
            ProgressManager.checkCanceled();
            HashSet providerKeys = new HashSet();
            candidateProvider.collectNames(name -> {
                if (keyFilter.test((String)name)) {
                    providerKeys.add(name);
                }
            });
            allKeys.addAll(providerKeys);
            listOfProviders.add(Pair.create(providerKeys, (Object)candidateProvider));
        }
        JSImportPlaceInfo info2 = JSHandlersFactory.forElement(place).createImportPlaceInfo(place);
        for (String name2 : allKeys) {
            ProgressManager.checkCanceled();
            JSCandidatesProcessor collector = new JSCandidatesProcessor(info2);
            for (Pair provider : listOfProviders) {
                if (!((Set)provider.first).contains(name2)) continue;
                ((JSImportCandidatesProvider)provider.second).processCandidates(name2, collector);
            }
            List<JSImportCandidate> elements = collector.getResults();
            if (elements.isEmpty() || processor.process(elements, (Object)name2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static InsertHandler<LookupElement> getImportInsertHandler(@NotNull PsiFile containingFile2, @NotNull Collection<? extends JSImportCandidate> elements) {
        if (containingFile2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(19);
        }
        if (elements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(20);
        }
        if (containingFile2 instanceof JSExpressionCodeFragment) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(21);
            }
            return insertHandler;
        }
        JSImportCandidate item = (JSImportCandidate)ContainerUtil.getFirstItem(elements);
        if (item == null) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(22);
            }
            return insertHandler;
        }
        List psiElements = StreamEx.of(elements).map(el -> el.getElement()).nonNull().toList();
        PsiElement element = item.getElement();
        PsiElement toImport = element != null && psiElements.size() == elements.size() ? JSLookupElementMerger.mergeOverloads(psiElements, element) : null;
        JSImportCandidate candidate = toImport == null ? null : (JSImportCandidate)ContainerUtil.find(elements, el -> toImport == el.getElement());
        return new ImportInsertHandler(candidate);
    }

    private static boolean isExcludeWithNonLatinFirstSymbol(@NotNull CompletionResultSet completionResultSet) {
        PrefixMatcher matcher;
        String prefix;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(23);
        }
        if ((prefix = (matcher = completionResultSet.getPrefixMatcher()).getPrefix()).isEmpty()) {
            completionResultSet.restartCompletionOnAnyPrefixChange();
            return true;
        }
        return JSImportCompletionUtil.isLatin(prefix.charAt(0));
    }

    private static boolean checkLimit(@NotNull CompletionResultSet completionResultSet, int limit, int count) {
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(24);
        }
        if (count <= limit) {
            return true;
        }
        JSCompletionUtil.handleOverflow(completionResultSet);
        return false;
    }

    private static boolean skipPlace(@NotNull PsiElement place) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(25);
        }
        return TypeScriptPsiUtil.isTsIndexerType(place) || place.getContext() instanceof JSExportAssignment;
    }

    @NotNull
    public static Set<String> getLocalElementNames(@NotNull Collection<LookupElement> sinkResults, @NotNull PsiElement place, @NotNull PrefixMatcher matcher) {
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(26);
        }
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(27);
        }
        if (matcher == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(28);
        }
        HashSet<String> localElements = new HashSet<String>();
        JSImportCompletionUtil.fillImportedElements(place, localElements);
        PsiFile containingFile2 = place.getContainingFile();
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(containingFile2.getProject());
        for (LookupElement lookupElement : sinkResults) {
            PsiFile currentFile;
            PsiElement currentElement = lookupElement.getPsiElement();
            if (currentElement != null && (currentFile = currentElement.getContainingFile()) != null && currentFile.getOriginalFile() != containingFile2) {
                double priority = JSCompletionUtil.getLookupElementPriority(lookupElement);
                if (libraries.contains(currentFile.getVirtualFile()) || (double)JSLookupPriority.SMART_MATCHED_PARAMETER_NAME.getPriorityValue() > priority) continue;
            }
            if (!matcher.prefixMatches(lookupElement)) continue;
            localElements.add(lookupElement.getLookupString());
        }
        HashSet<String> hashSet = localElements;
        if (hashSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    private static void fillImportedElements(@NotNull PsiElement place, @NotNull Set<String> localElements) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(30);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(31);
        }
        JSElement scope2 = ES6PsiUtil.getExportScope(place);
        while (scope2 != null) {
            List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)scope2);
            for (ES6ImportDeclaration declaration : declarations) {
                String name;
                ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
                ES6ImportedBinding[] bindings = declaration.getImportedBindings();
                for (ES6ImportedBinding eS6ImportedBinding : bindings) {
                    name = eS6ImportedBinding.getDeclaredName();
                    if (name == null) continue;
                    localElements.add(name);
                }
                for (JSBoundNameOwner jSBoundNameOwner : specifiers) {
                    name = jSBoundNameOwner.getDeclaredName();
                    if (name == null) continue;
                    localElements.add(name);
                }
            }
            if (scope2 instanceof PsiFile) break;
            scope2 = ES6PsiUtil.getExportScope((PsiElement)scope2);
        }
    }

    private static void fillLookupItemForElements(@NotNull CompletionResultSet completionResultSet, @NotNull InsertHandler<LookupElement> insertImportHandler, @NotNull String name, @NotNull Collection<? extends JSImportCandidate> candidates, @NotNull JSLookupElementMerger merger) {
        Collection<LookupElement> merged;
        LookupElement item;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(32);
        }
        if (insertImportHandler == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(33);
        }
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(34);
        }
        if (candidates == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(35);
        }
        if (merger == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(36);
        }
        List elements = StreamEx.of(candidates).map(el -> el.getElement()).select(JSElement.class).nonNull().toList();
        List infos = JSImportCompletionUtil.createInfos(name, elements);
        if (candidates.size() > 0 && infos.size() == 0) {
            infos = ContainerUtil.map(candidates, candidate -> JSImportCompletionUtil.createInfo(name, candidate));
        }
        if ((item = (LookupElement)ContainerUtil.getFirstItem(merged = merger.merge(name, infos, true))) != null) {
            if (item instanceof PrioritizedLookupElement) {
                item = ((PrioritizedLookupElement)item).getDelegate();
            }
            if (item instanceof LookupElementBuilder) {
                item = ((LookupElementBuilder)item).withInsertHandler(insertImportHandler);
            }
            item = JSCompletionUtil.withJSLookupPriority(item, IMPORT_PRIORITY);
            completionResultSet.addElement(item);
        }
    }

    @NotNull
    private static Set<PsiElement> expandElements(Collection<JSElement> elements) {
        Set<PsiElement> set = elements.stream().flatMap(el -> {
            if (el instanceof ES6ExportSpecifier || el instanceof ES6ExportSpecifierAlias || el instanceof ES6ExportDefaultAssignment && (((ES6ExportDefaultAssignment)el).getStubSafeElement() != null || ((ES6ExportDefaultAssignment)el).getInitializerReference() != null)) {
                return ES6PsiUtil.expandElements((PsiElement)el, Collections.singleton(el)).stream();
            }
            return Stream.of(el);
        }).collect(Collectors.toSet());
        if (set == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(37);
        }
        return set;
    }

    private static boolean isLatin(char symbol) {
        return symbol >= 'A' && symbol <= 'Z' || symbol >= 'a' && symbol <= 'z';
    }

    private static void importForElement(@NotNull InsertionContext context2, @NotNull LookupElement item, @Nullable JSImportCandidate candidate) {
        if (context2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(38);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(39);
        }
        JSImportCompletionUtil.insertLookupItem(context2, item, candidate, (Consumer<JSImportCandidateWithExecutor>)((Consumer)importedElement -> {
            if (importedElement == null) {
                return;
            }
            PsiElement elementToHandle = importedElement.getElement();
            if (elementToHandle == null) {
                return;
            }
            PsiElement originalElement = context2.getFile().findElementAt(context2.getStartOffset());
            if (originalElement != null) {
                PsiElement toProcessPlace;
                PsiElement psiElement = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                if (toProcessPlace instanceof JSReferenceExpression && toProcessPlace.isValid()) {
                    context2.commitDocument();
                    PsiElement resolved = ((JSReferenceExpression)toProcessPlace).resolve();
                    if (resolved != null) {
                        elementToHandle = resolved;
                    }
                }
            }
            PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(context2.getDocument());
            if (item.getPsiElement() != null) {
                JSInsertHandler.DEFAULT.handleInsert(context2, item);
            } else if (item instanceof LookupElementBuilder) {
                JSInsertHandler.DEFAULT.handleInsert(context2, (LookupElement)((LookupElementBuilder)item).withPsiElement(elementToHandle));
            }
        }));
    }

    @NotNull
    private static Collection<JSLookupElementInfo> createInfos(@NotNull String name, Collection<JSElement> elements) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(40);
        }
        Set<PsiElement> expandedElements = JSImportCompletionUtil.expandElements(elements);
        List list2 = ContainerUtil.map(expandedElements, el -> JSImportCompletionUtil.createInfo(name, el));
        if (list2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(41);
        }
        return list2;
    }

    private static JSLookupElementInfo createInfo(@NotNull String name, @NotNull PsiElement element) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(42);
        }
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(43);
        }
        return JSImportCompletionUtil.createInfo(name, element, null);
    }

    private static JSLookupElementInfo createInfo(@NotNull String name, @Nullable JSImportCandidate candidate) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(44);
        }
        return JSImportCompletionUtil.createInfo(name, null, candidate);
    }

    private static JSLookupElementInfo createInfo(final @NotNull String name, final @Nullable PsiElement element, final @Nullable JSImportCandidate candidate) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(45);
        }
        return new JSLookupElementInfoImpl(element, name, IMPORT_PRIORITY, BaseJSSymbolProcessor.MatchType.COMPLETE, null){

            @Override
            public LookupElement toLookupElement() {
                Icon icon2;
                LookupElementBuilder builder2 = element == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)element, (String)name);
                JSLookupElementRenderer renderer = new JSLookupElementRenderer(name, IMPORT_PRIORITY, false, null);
                Icon icon3 = icon2 = candidate != null ? candidate.getIcon(0) : null;
                if (icon2 != null) {
                    return renderer.applyToBuilderWithIcon(builder2, icon2);
                }
                return renderer.applyToBuilder(builder2);
            }
        };
    }

    public static InsertHandler<LookupElement> createInsertHandler(@NotNull JSImportCandidate element) {
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(46);
        }
        return new ImportInsertHandler(element);
    }

    public static void insertLookupItem(@NotNull InsertionContext context2, @NotNull LookupElement item, @Nullable JSImportCandidate candidate, @Nullable Consumer<JSImportCandidateWithExecutor> afterInsert) {
        if (context2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(47);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(48);
        }
        context2.commitDocument();
        CaretModel model = context2.getEditor().getCaretModel();
        if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
            return;
        }
        PsiElement originalElement = context2.getFile().findElementAt(context2.getStartOffset());
        if (originalElement == null || !JSImportCompletionUtil.shouldAddImportFromCompletion(originalElement)) {
            return;
        }
        if (originalElement instanceof LeafElement) {
            originalElement = originalElement.getParent();
        }
        String name = item.getLookupString();
        JSImportAction action = new JSImportAction(context2.getEditor(), originalElement, name);
        List<JSImportCandidateWithExecutor> candidateWithExecutors = JSImportCandidateWithExecutor.sortWithExecutors(candidate, originalElement);
        if (candidateWithExecutors.size() == 1) {
            action.executeFor(candidateWithExecutors.get(0), afterInsert);
        } else {
            action.executeForAllVariants(afterInsert);
        }
    }

    private static boolean shouldAddImportFromCompletion(@NotNull PsiElement element) {
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(49);
        }
        JSApplicationSettings settings2 = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings2.hasTSImportCompletionEffective(element.getProject()) : settings2.hasJSImportCompletionEffective(element.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 22, 29, 37, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResults";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAndGlobalElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: 
            case 22: 
            case 29: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertImportHandler";
                break;
            }
            case 34: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 38: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInsertHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElementNames";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExportedVariants";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processExportedElements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImportInsertHandler";
                break;
            }
            case 21: 
            case 22: 
            case 29: 
            case 37: 
            case 41: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExcludeWithNonLatinFirstSymbol";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkLimit";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "skipPlace";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElementNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fillImportedElements";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillLookupItemForElements";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "importForElement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createInfos";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "insertLookupItem";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddImportFromCompletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 22, 29, 37, 41 -> new IllegalStateException(string);
        };
    }

    private static final class ImportInsertHandler
    implements InsertHandler<LookupElement> {
        private final JSImportCandidate myElement;

        private ImportInsertHandler(@Nullable JSImportCandidate element) {
            this.myElement = element;
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (context2 == null) {
                ImportInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                ImportInsertHandler.$$$reportNull$$$0(1);
            }
            JSImportCompletionUtil.importForElement(context2, item, this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil$ImportInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

