/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDocTagsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final List<String> asdocTags = Arrays.asList("copy", "default", "eventType", "example", "exampleText", "includeExample", "inheritDoc", "internal", "param", "private", "return", "see", "since", "throws", "module", "final", "title", "config", "global");
    private static final List<String> jsdocTags = Arrays.asList("abstract", "access", "alias", "async", "augments", "author", "borrows", "callback", "cfg", "class", "classdesc", "constant", "constructor", "constructs", "copyright", "default", "deprecated", "desc", "description", "enum", "event", "example", "exports", "extends", "external", "host", "field", "fieldOf", "file", "fileOverview", "overview", "fires", "emits", "function", "generator", "global", "hideconstructor", "ignore", "implements", "inner", "instance", "kind", "lends", "licence", "listens", "link", "member", "var", "memberof", "method", "methodOf", "mixes", "mixin", "module", "name", "namespace", "override", "package", "param", "private", "property", "protected", "public", "readonly", "requires", "returns", "return", "see", "since", "static", "summary", "this", "throws", "exception", "todo", "tutorial", "type", "typedef", "variation", "version", "yields", "yield", "mixes", "mixin");
    private static final List<String> closureTags = Arrays.asList("author", "code", "const", "constructor", "define", "deprecated", "enum", "export", "extends", "externs", "fileoverview", "implements", "inheritDoc", "interface", "lends", "license", "preserve", "noalias", "nosideeffects", "override", "param", "private", "protected", "return", "see", "supported", "suppress", "template", "this", "type", "typedef");
    private static final List<String> otherTags = Arrays.asList("flow", "internal");
    private static final Collection<String> jsTags = new HashSet<String>(ContainerUtil.concat((List[])new List[]{jsdocTags, closureTags, otherTags}));

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        int i;
        if (parameters == null) {
            JSDocTagsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSDocTagsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSDocTagsCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement docTagName = parameters.getPosition();
        String text2 = docTagName.getText();
        int index = parameters.getOffset() - docTagName.getTextOffset();
        String s = text2.substring(0, index);
        for (i = s.length() - 1; i >= 0 && Character.isJavaIdentifierPart(s.charAt(i)); --i) {
        }
        if (i >= 0 && s.charAt(i) == '@') {
            Collection<String> variants = DialectDetector.isActionScript(docTagName) ? asdocTags : jsTags;
            for (String variant : variants) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)variant).withInsertHandler(JSInsertHandler.DEFAULT));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSDocTagsCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

