/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunSettings {
    private static final String TAG_PACKAGE_JSON_PATH = "package-json";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_SCRIPTS = "scripts";
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_PACKAGE_MANAGER = "package-manager";
    private final String myPackageJsonSystemIndependentPath;
    private final String myPackageJsonSystemDependentPath;
    private final NpmCommand myCommand;
    private final List<String> myScriptNames;
    private final String myArguments;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final NodePackageRef myPackageManagerPackageRef;
    private final EnvironmentVariablesData myEnvData;

    public NpmRunSettings(@NotNull Builder builder2) {
        if (builder2 == null) {
            NpmRunSettings.$$$reportNull$$$0(0);
        }
        this.myPackageJsonSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder2.myPackageJsonPath);
        this.myPackageJsonSystemDependentPath = FileUtil.toSystemDependentName((String)this.myPackageJsonSystemIndependentPath);
        this.myCommand = builder2.myCommand;
        this.myScriptNames = builder2.myScriptNames;
        this.myArguments = builder2.myArguments;
        this.myInterpreterRef = builder2.myInterpreterRef;
        this.myNodeOptions = builder2.myNodeOptions;
        this.myPackageManagerPackageRef = builder2.myPackageManagerPackageRef;
        this.myEnvData = builder2.myEnvData;
    }

    @NotNull
    @NlsSafe
    public String getPackageJsonSystemIndependentPath() {
        String string = this.myPackageJsonSystemIndependentPath;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getPackageJsonSystemDependentPath() {
        String string = this.myPackageJsonSystemDependentPath;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NpmCommand getCommand() {
        NpmCommand npmCommand = this.myCommand;
        if (npmCommand == null) {
            NpmRunSettings.$$$reportNull$$$0(3);
        }
        return npmCommand;
    }

    public @NotNull List<@NlsSafe String> getScriptNames() {
        List<String> list2 = this.myScriptNames;
        if (list2 == null) {
            NpmRunSettings.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    @NlsSafe
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            NpmRunSettings.$$$reportNull$$$0(6);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    @NlsSafe
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public NodePackageRef getPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = this.myPackageManagerPackageRef;
        if (nodePackageRef == null) {
            NpmRunSettings.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NpmRunSettings.$$$reportNull$$$0(9);
        }
        return environmentVariablesData;
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(10);
        }
        if (!this.myPackageJsonSystemIndependentPath.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_PACKAGE_JSON_PATH, (String)this.myPackageJsonSystemIndependentPath);
        }
        JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_COMMAND, (String)NpmRunSettings.getNpmCommandString(this.myCommand));
        this.writeScripts(parent);
        if (!this.myArguments.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_ARGUMENTS, (String)this.myArguments);
        }
        JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_INTERPRETER, (String)this.myInterpreterRef.getReferenceName());
        if (!this.myNodeOptions.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_OPTIONS, (String)this.myNodeOptions);
        }
        if (!NpmUtil.isProjectPackageManagerPackageRef(this.myPackageManagerPackageRef)) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_PACKAGE_MANAGER, (String)this.myPackageManagerPackageRef.getIdentifier());
        }
        this.myEnvData.writeExternal(parent);
    }

    @NotNull
    private static String getNpmCommandString(@NotNull NpmCommand command) {
        if (command == null) {
            NpmRunSettings.$$$reportNull$$$0(11);
        }
        if (command == NpmCommand.RUN_SCRIPT) {
            String string = NpmCommand.RUN_SCRIPT.getCliOption();
            if (string == null) {
                NpmRunSettings.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = StringUtil.toLowerCase((String)command.name());
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static NpmCommand getNpmCommand(@Nullable String npmCommandString) {
        if (StringUtil.isEmptyOrSpaces((String)npmCommandString)) {
            return null;
        }
        if (NpmCommand.RUN_SCRIPT.getCliOption().equals(npmCommandString)) {
            return NpmCommand.RUN_SCRIPT;
        }
        try {
            return NpmCommand.valueOf(StringUtil.toUpperCase((String)npmCommandString));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void writeScripts(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(14);
        }
        if (NpmCommand.RUN_SCRIPT == this.myCommand) {
            Element scriptsElement = new Element(TAG_SCRIPTS);
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)scriptsElement, (String)TAG_SCRIPT, this.myScriptNames);
            parent.addContent(scriptsElement);
        }
    }

    @NotNull
    public static NpmRunSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(15);
        }
        Builder builder2 = new Builder();
        builder2.setPackageJsonPath(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_PACKAGE_JSON_PATH)));
        NpmCommand command = NpmRunSettings.getNpmCommand(JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_COMMAND));
        if (command != null) {
            builder2.setCommand(command);
        }
        builder2.setScriptNames(NpmRunSettings.readScripts(parent));
        builder2.setArguments(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_ARGUMENTS)));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_INTERPRETER);
        if (interpreterRefName != null) {
            builder2.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        }
        builder2.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_OPTIONS)));
        String packageManagerReferenceName = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_PACKAGE_MANAGER);
        builder2.setPackageManagerPackageRef(packageManagerReferenceName == null ? NpmUtil.createProjectPackageManagerPackageRef() : NpmUtil.DESCRIPTOR.createPackageRef(packageManagerReferenceName));
        builder2.setEnvData(EnvironmentVariablesData.readExternal((Element)parent));
        NpmRunSettings npmRunSettings = builder2.build();
        if (npmRunSettings == null) {
            NpmRunSettings.$$$reportNull$$$0(16);
        }
        return npmRunSettings;
    }

    @NotNull
    private static List<String> readScripts(@NotNull Element parent) {
        Element tasksElement;
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(17);
        }
        if ((tasksElement = parent.getChild(TAG_SCRIPTS)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmRunSettings.$$$reportNull$$$0(18);
            }
            return list2;
        }
        List list3 = JDOMExternalizerUtil.getChildrenValueAttributes((Element)tasksElement, (String)TAG_SCRIPT);
        if (list3 == null) {
            NpmRunSettings.$$$reportNull$$$0(19);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 16, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = TAG_COMMAND;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonSystemDependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageRef";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmCommandString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "readScripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNpmCommandString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeScripts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readScripts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 16, 18, 19 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        private String myPackageJsonPath;
        private NpmCommand myCommand;
        private List<String> myScriptNames;
        private String myArguments;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private NodePackageRef myPackageManagerPackageRef;
        private EnvironmentVariablesData myEnvData;

        private Builder() {
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = List.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myPackageManagerPackageRef = NpmUtil.createProjectPackageManagerPackageRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
        }

        private Builder(@NotNull NpmRunSettings copy) {
            if (copy == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = List.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myPackageManagerPackageRef = NpmUtil.createProjectPackageManagerPackageRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myPackageJsonPath = copy.myPackageJsonSystemIndependentPath;
            this.myCommand = copy.myCommand;
            this.myScriptNames = copy.myScriptNames;
            this.myArguments = copy.myArguments;
            this.myInterpreterRef = copy.myInterpreterRef;
            this.myNodeOptions = copy.myNodeOptions;
            this.myPackageManagerPackageRef = copy.myPackageManagerPackageRef;
            this.myEnvData = copy.myEnvData;
        }

        @NotNull
        public Builder setPackageJsonPath(@NotNull String packageJsonPath) {
            if (packageJsonPath == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myPackageJsonPath = packageJsonPath;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setCommand(@NotNull NpmCommand command) {
            if (command == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myCommand = command;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder setScriptNames(@NotNull List<String> scriptNames) {
            if (scriptNames == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myScriptNames = List.copyOf(scriptNames);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder setNodeOptions(@NotNull String nodeOptions) {
            if (nodeOptions == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myNodeOptions = nodeOptions;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder setPackageManagerPackageRef(@NotNull NodePackageRef packageManagerPackageRef) {
            if (packageManagerPackageRef == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myPackageManagerPackageRef = packageManagerPackageRef;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myEnvData = envData;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public NpmRunSettings build() {
            return new NpmRunSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 8, 10, 12, 14, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonPath";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = NpmRunSettings.TAG_COMMAND;
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptNames";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = NpmRunSettings.TAG_ARGUMENTS;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeOptions";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageManagerPackageRef";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPackageJsonPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setScriptNames";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPackageManagerPackageRef";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setPackageJsonPath";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setScriptNames";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setNodeOptions";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setPackageManagerPackageRef";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6, 8, 10, 12, 14, 16 -> new IllegalStateException(string);
            };
        }
    }
}

