/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunProfileState;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
BeforeRunTaskAwareConfiguration {
    private static final Logger LOG = Logger.getInstance(GulpRunConfiguration.class);
    private GulpRunSettings myRunSettings;

    public GulpRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
    }

    public void onNewConfigurationCreated() {
        VirtualFile gulpfile;
        GulpRunSettings runSettings = this.getRunSettings();
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getGulpfilePath()) && (gulpfile = GulpService.getInstance(this.getProject()).detectFirstBuildfileInContentRoots(false)) != null) {
            this.myRunSettings = GulpRunSettings.builder(runSettings).setGulpfilePath(gulpfile.getPath()).build();
        }
    }

    @NotNull
    public GulpRunSettings getRunSettings() {
        if (this.myRunSettings == null) {
            this.myRunSettings = new GulpRunSettings.Builder().build();
        }
        GulpRunSettings gulpRunSettings = this.myRunSettings;
        if (gulpRunSettings == null) {
            GulpRunConfiguration.$$$reportNull$$$0(1);
        }
        return gulpRunSettings;
    }

    public void setRunSettings(@NotNull GulpRunSettings runSettings) {
        if (runSettings == null) {
            GulpRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myRunSettings = runSettings;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GulpRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        GulpRunSettings.Builder builder2 = GulpUtil.readFromXml(element);
        this.myRunSettings = builder2.build();
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GulpRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        GulpRunSettings runSettings = this.myRunSettings;
        if (runSettings != null) {
            GulpUtil.writeToXml(element, this.getRunSettings());
        }
    }

    @Nullable
    private static GulpRunConfiguration getTemplateRunConfiguration(@NotNull Project project) {
        RunManager runManager;
        RunnerAndConfigurationSettings templateSettings;
        RunConfiguration rc;
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((rc = (templateSettings = (runManager = RunManager.getInstance((Project)project)).getConfigurationTemplate(GulpConfigurationType.getFactory())).getConfiguration()) instanceof GulpRunConfiguration) {
            return (GulpRunConfiguration)rc;
        }
        LOG.warn("No Gulp.js template run configuration found: " + rc);
        return null;
    }

    @NotNull
    public static GulpRunSettings getTemplateRunSettings(@NotNull Project project) {
        GulpRunConfiguration rc;
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(6);
        }
        if ((rc = GulpRunConfiguration.getTemplateRunConfiguration(project)) != null) {
            GulpRunSettings gulpRunSettings = rc.getRunSettings();
            if (gulpRunSettings == null) {
                GulpRunConfiguration.$$$reportNull$$$0(7);
            }
            return gulpRunSettings;
        }
        GulpRunSettings gulpRunSettings = new GulpRunSettings.Builder().build();
        if (gulpRunSettings == null) {
            GulpRunConfiguration.$$$reportNull$$$0(8);
        }
        return gulpRunSettings;
    }

    public static void setTemplateRunSettings(@NotNull Project project, @NotNull GulpRunSettings runSettings) {
        GulpRunConfiguration rc;
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(9);
        }
        if (runSettings == null) {
            GulpRunConfiguration.$$$reportNull$$$0(10);
        }
        if ((rc = GulpRunConfiguration.getTemplateRunConfiguration(project)) != null) {
            rc.setRunSettings(runSettings);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        GulpRunConfiguration.checkRunSettings(this.getProject(), this.myRunSettings);
    }

    public static void checkRunSettings(@NotNull Project project, @NotNull GulpRunSettings settings2) throws RuntimeConfigurationError {
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(11);
        }
        if (settings2 == null) {
            GulpRunConfiguration.$$$reportNull$$$0(12);
        }
        GulpUtil.checkConfiguration(project, GulpRunConfiguration.getGulpPackage(project, settings2), settings2);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new GulpRunConfigurationEditor(this.getProject());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            GulpRunConfiguration.$$$reportNull$$$0(13);
        }
        if (environment == null) {
            GulpRunConfiguration.$$$reportNull$$$0(14);
        }
        NodePackage gulpPackage = GulpRunConfiguration.getGulpPackage(this.getProject(), this.myRunSettings);
        return new GulpRunProfileState(environment, this.getRunSettings(), gulpPackage);
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myRunSettings.getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    private static NodePackage getGulpPackage(@NotNull Project project, @NotNull GulpRunSettings settings2) {
        if (project == null) {
            GulpRunConfiguration.$$$reportNull$$$0(15);
        }
        if (settings2 == null) {
            GulpRunConfiguration.$$$reportNull$$$0(16);
        }
        NodeJsInterpreter interpreter = settings2.getInterpreterRef().resolve(project);
        NodePackage nodePackage = GulpUtil.getGulpPackage(project, interpreter, settings2.getGulpfile());
        if (nodePackage == null) {
            GulpRunConfiguration.$$$reportNull$$$0(17);
        }
        return nodePackage;
    }

    public boolean useRunExecutor() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateRunSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateRunSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateRunSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkRunSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGulpPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 17 -> new IllegalStateException(string);
        };
    }
}

