/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GulpUtil {
    public static final String DEFAULT_TASK_NAME = "default";
    private static final String GULP__PACKAGE_NAME = "gulp";
    private static final String GULP_CLI__PACKAGE_NAME = "gulp-cli";
    public static final NodePackageDescriptor GULP = new NodePackageDescriptor("gulp");
    private static final String STORAGE_GULP_PACKAGE_DIR_PATH = "js.buildTools.gulp.gulp_package_dir";
    private static final Logger LOG = Logger.getInstance(GulpUtil.class);
    private static final String TAG_NODE_INTERPRETER_REF = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_GULPFILE = "gulpfile";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_TASK = "task";
    private static final String TAG_PASS_PARENT_ENV_VARS = "pass-parent-envs";

    private GulpUtil() {
    }

    public static void writeToXml(@NotNull Element parent, @NotNull GulpRunSettings runSettings) {
        if (parent == null) {
            GulpUtil.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            GulpUtil.$$$reportNull$$$0(1);
        }
        GulpUtil.addElement(parent, TAG_NODE_INTERPRETER_REF, runSettings.getInterpreterRef().getReferenceName());
        GulpUtil.addElement(parent, TAG_NODE_OPTIONS, runSettings.getNodeOptions());
        GulpUtil.addElement(parent, TAG_GULPFILE, runSettings.getGulpfileSystemIndependentPath());
        parent.addContent(GulpUtil.createTasksElement(runSettings.getTasks()));
        GulpUtil.addElement(parent, TAG_ARGUMENTS, runSettings.getArguments());
        EnvironmentVariablesData envData = runSettings.getEnvData();
        if (runSettings.isNewEnvFormat()) {
            envData.writeExternal(parent);
        } else {
            GulpUtil.addElement(parent, TAG_PASS_PARENT_ENV_VARS, Boolean.toString(envData.isPassParentEnvs()));
            EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)envData.getEnvs());
        }
    }

    private static void addElement(@NotNull Element parent, @NotNull String tagName, @NotNull String textContent) {
        if (parent == null) {
            GulpUtil.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            GulpUtil.$$$reportNull$$$0(3);
        }
        if (textContent == null) {
            GulpUtil.$$$reportNull$$$0(4);
        }
        Element element = new Element(tagName);
        element.addContent(textContent);
        parent.addContent(element);
    }

    @NotNull
    private static Element createTasksElement(@NotNull List<String> tasks) {
        if (tasks == null) {
            GulpUtil.$$$reportNull$$$0(5);
        }
        Element tasksElement = new Element(TAG_TASKS);
        for (String task : tasks) {
            Element taskElement = new Element(TAG_TASK);
            taskElement.addContent(task);
            tasksElement.addContent(taskElement);
        }
        Element element = tasksElement;
        if (element == null) {
            GulpUtil.$$$reportNull$$$0(6);
        }
        return element;
    }

    @NotNull
    public static GulpRunSettings.Builder readFromXml(@NotNull Element parent) {
        EnvironmentVariablesData envData;
        if (parent == null) {
            GulpUtil.$$$reportNull$$$0(7);
        }
        GulpRunSettings.Builder builder2 = new GulpRunSettings.Builder();
        String interpreterRefName = GulpUtil.getTagValue(parent, TAG_NODE_INTERPRETER_REF);
        NodeJsInterpreterRef interpreterRef = NodeJsInterpreterRef.create(interpreterRefName);
        builder2.setInterpreterRef(interpreterRef);
        builder2.setNodeOptions(StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_NODE_OPTIONS)));
        builder2.setGulpfilePath(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_GULPFILE))));
        builder2.setTasks(GulpUtil.readTasks(parent.getChild(TAG_TASKS)));
        builder2.setArguments(StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_ARGUMENTS)));
        String passParentEnvsStr = GulpUtil.getTagValue(parent, TAG_PASS_PARENT_ENV_VARS);
        if (passParentEnvsStr != null) {
            LinkedHashMap envVars = new LinkedHashMap();
            EnvironmentVariablesComponent.readExternal((Element)parent, envVars);
            envData = EnvironmentVariablesData.create(envVars, (!Boolean.toString(false).equals(passParentEnvsStr) ? 1 : 0) != 0);
        } else {
            envData = EnvironmentVariablesData.readExternal((Element)parent);
        }
        builder2.setNewEnvFormat(passParentEnvsStr == null);
        builder2.setEnvData(envData);
        GulpRunSettings.Builder builder3 = builder2;
        if (builder3 == null) {
            GulpUtil.$$$reportNull$$$0(8);
        }
        return builder3;
    }

    @NotNull
    private static List<String> readTasks(@Nullable Element tasksElement) {
        if (tasksElement != null) {
            List children = tasksElement.getChildren(TAG_TASK);
            ArrayList<String> tasks = new ArrayList<String>();
            for (Element child : children) {
                tasks.add(child.getText());
            }
            ArrayList<String> arrayList = tasks;
            if (arrayList == null) {
                GulpUtil.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GulpUtil.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    private static String getTagValue(@NotNull Element parent, @NotNull String tagName) {
        List children;
        if (parent == null) {
            GulpUtil.$$$reportNull$$$0(11);
        }
        if (tagName == null) {
            GulpUtil.$$$reportNull$$$0(12);
        }
        if ((children = parent.getChildren(tagName)).size() == 0) {
            return null;
        }
        if (children.size() > 1) {
            LOG.warn("Ambiguous child: " + tagName);
        }
        Element first = (Element)children.get(0);
        return first.getText();
    }

    public static void checkConfiguration(@NotNull Project project, @NotNull NodePackage gulpPackage, @NotNull GulpRunSettings settings2) throws RuntimeConfigurationError {
        if (project == null) {
            GulpUtil.$$$reportNull$$$0(13);
        }
        if (gulpPackage == null) {
            GulpUtil.$$$reportNull$$$0(14);
        }
        if (settings2 == null) {
            GulpUtil.$$$reportNull$$$0(15);
        }
        GulpUtil.validateFile(settings2.getGulpfilePath(), JavaScriptBundle.message("gulp.gulpfile.unspecified", new Object[0]), JavaScriptBundle.message("gulp.gulpfile.not.found", new Object[0]));
        NodeInterpreterUtil.checkForRunConfiguration(settings2.getInterpreterRef().resolve(project));
        gulpPackage.validateForRunConfiguration(GULP.getPackageNames().get(0));
    }

    private static void validateFile(@NotNull String filePath, @NotNull @NlsContexts.DialogMessage String emptyPathMessage, @NotNull @NlsContexts.DialogMessage String fileNotFoundMessage) throws RuntimeConfigurationError {
        if (filePath == null) {
            GulpUtil.$$$reportNull$$$0(16);
        }
        if (emptyPathMessage == null) {
            GulpUtil.$$$reportNull$$$0(17);
        }
        if (fileNotFoundMessage == null) {
            GulpUtil.$$$reportNull$$$0(18);
        }
        if (filePath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File file = new File(filePath);
        if (!file.isAbsolute() || !file.isFile()) {
            throw new RuntimeConfigurationError(fileNotFoundMessage);
        }
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isGulpPackage(@Nullable NodePackageVersion nodePackageVersion) {
        return nodePackageVersion != null && GULP__PACKAGE_NAME.equals(nodePackageVersion.getPackageName());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isGulpCliPackage(@Nullable NodePackageVersion nodePackageVersion) {
        return nodePackageVersion != null && GULP_CLI__PACKAGE_NAME.equals(nodePackageVersion.getPackageName());
    }

    @NotNull
    public static NodePackage getGulpPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        NodePackage pkg;
        String packageDir;
        if (project == null) {
            GulpUtil.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmpty((String)(packageDir = PropertiesComponent.getInstance((Project)project).getValue(STORAGE_GULP_PACKAGE_DIR_PATH))) && !(pkg = GULP.findFirstDirectDependencyPackage(project, interpreter, contextGruntfile)).isEmptyPath()) {
            GulpUtil.setGulpPackage(project, pkg);
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                GulpUtil.$$$reportNull$$$0(20);
            }
            return nodePackage;
        }
        NodePackage nodePackage = GULP.createPackage(StringUtil.notNullize((String)packageDir));
        if (nodePackage == null) {
            GulpUtil.$$$reportNull$$$0(21);
        }
        return nodePackage;
    }

    public static void setGulpPackage(@NotNull Project project, @NotNull NodePackage gulpPackage) {
        if (project == null) {
            GulpUtil.$$$reportNull$$$0(22);
        }
        if (gulpPackage == null) {
            GulpUtil.$$$reportNull$$$0(23);
        }
        PropertiesComponent.getInstance((Project)project).setValue(STORAGE_GULP_PACKAGE_DIR_PATH, gulpPackage.getSystemIndependentPath());
    }

    @NotNull
    public static File getGulpBinFile(@NotNull NodePackage gulpPackage) {
        if (gulpPackage == null) {
            GulpUtil.$$$reportNull$$$0(24);
        }
        return new File(gulpPackage.getSystemDependentPath(), "bin" + File.separator + "gulp.js");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = TAG_TASKS;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpUtil";
                break;
            }
            case 13: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpPackage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyPathMessage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTasksElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromXml";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readTasks";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeToXml";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTasksElement";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTagValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGulpPackage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setGulpPackage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGulpBinFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 20, 21 -> new IllegalStateException(string);
        };
    }
}

