/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListFetchUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskTreeView;
import com.intellij.lang.javascript.buildTools.gulp.GulpTasksFetchSettingsDialog;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GulpService
extends JsbtService {
    private static final String GULPFILE_NAME_WITHOUT_EXT = "Gulpfile";
    private static final String[] FILENAMES_WITHOUT_EXT = new String[]{"gulpfile", "gulpfile.babel"};
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "es6", "js", "ts"};

    public GulpService(@NotNull Project project) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    public static GulpService getInstance(@NotNull Project project) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(1);
        }
        GulpService gulpService = (GulpService)project.getService(GulpService.class);
        if (gulpService == null) {
            GulpService.$$$reportNull$$$0(2);
        }
        return gulpService;
    }

    @Override
    @NotNull
    public GulpApplicationService getApplicationService() {
        GulpApplicationService gulpApplicationService = GulpApplicationService.getInstance();
        if (gulpApplicationService == null) {
            GulpService.$$$reportNull$$$0(3);
        }
        return gulpApplicationService;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager() {
        GulpfileManager gulpfileManager = GulpfileManager.getInstance(this.myProject);
        if (gulpfileManager == null) {
            GulpService.$$$reportNull$$$0(4);
        }
        return gulpfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager() {
        return new JsbtToolWindowManager(this.myProject, "Gulp", JavaScriptLanguageIcons.BuildTools.Gulp_toolwindow, "reference.tool.window.js.build_tools.gulp", this);
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@Nullable String layoutPlace) {
        return new GulpTaskTreeView(this, this.myProject, layoutPlace);
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(JsbtUtil.detectAllBuildfiles(this.myProject, GULPFILE_NAME_WITHOUT_EXT, FILENAMES_WITHOUT_EXT, KNOWN_EXTENSIONS));
        List<VirtualFile> indexFiles = JsbtUtil.detectAllBuildfiles(this.myProject, "index.", new String[]{"index"}, KNOWN_EXTENSIONS);
        for (VirtualFile indexFile : indexFiles) {
            if (!GulpService.isIndexFile(indexFile)) continue;
            result2.add(indexFile);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            GulpService.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        List<VirtualFile> files = JsbtUtil.detectAllBuildfilesInContentRoots(this.myProject, webModulesOnly, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS, true);
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                VirtualFile indexFile = GulpService.findIndexFile(file);
                if (indexFile == null) continue;
                result2.add(indexFile);
                continue;
            }
            result2.add(file);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            GulpService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile findIndexFile(@NotNull VirtualFile gulpfileJsDir) {
        if (gulpfileJsDir == null) {
            GulpService.$$$reportNull$$$0(7);
        }
        if (GulpService.isNameMatchedStrictly(gulpfileJsDir, "gulpfile")) {
            VirtualFile[] children;
            for (VirtualFile file : children = (VirtualFile[])ObjectUtils.notNull((Object)gulpfileJsDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                if (file.isDirectory() || !GulpService.isNameMatchedStrictly(file, "index")) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            GulpService.$$$reportNull$$$0(8);
        }
        if (JsbtUtil.isFilenameMatched(file.getNameSequence(), GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS)) {
            return true;
        }
        return GulpService.isIndexFile(file);
    }

    @Override
    @Nullable
    public VirtualFile findBuildfileInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            GulpService.$$$reportNull$$$0(9);
        }
        return dir.findChild("Gulpfile.js");
    }

    private static boolean isIndexFile(@NotNull VirtualFile indexFile) {
        VirtualFile parent;
        if (indexFile == null) {
            GulpService.$$$reportNull$$$0(10);
        }
        return (parent = indexFile.getParent()) != null && GulpService.isNameMatchedStrictly(parent, "gulpfile") && GulpService.isNameMatchedStrictly(indexFile, "index");
    }

    private static boolean isNameMatchedStrictly(@NotNull VirtualFile file, @NotNull String nameWithoutExtension) {
        String ext;
        if (file == null) {
            GulpService.$$$reportNull$$$0(11);
        }
        if (nameWithoutExtension == null) {
            GulpService.$$$reportNull$$$0(12);
        }
        return (ext = file.getExtension()) != null && ArrayUtil.contains((String)ext, (String[])KNOWN_EXTENSIONS) && nameWithoutExtension.equals(file.getNameWithoutExtension());
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            GulpService.$$$reportNull$$$0(13);
        }
        return new GulpfileStructure(buildfile);
    }

    @Override
    @NotNull
    public JsbtFileStructure fetchBuildfileStructure(@NotNull VirtualFile buildfile) throws JsbtTaskFetchException {
        if (buildfile == null) {
            GulpService.$$$reportNull$$$0(14);
        }
        GulpfileStructure gulpfileStructure = GulpTaskListFetchUtil.listTasks(this.myProject, buildfile);
        if (gulpfileStructure == null) {
            GulpService.$$$reportNull$$$0(15);
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GulpConfigurationType.getFactory();
        if (configurationFactory == null) {
            GulpService.$$$reportNull$$$0(16);
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            GulpService.$$$reportNull$$$0(17);
        }
        if (patternObject == null) {
            GulpService.$$$reportNull$$$0(18);
        }
        if (runConfiguration instanceof GulpRunConfiguration) {
            GulpRunSettings runSettings = ((GulpRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof GulpRunSettings) {
                GulpRunSettings patternRunSettings = (GulpRunSettings)patternObject;
                return JsbtUtil.equalsOrderless(patternRunSettings.getTasks(), runSettings.getTasks()) && patternRunSettings.getGulpfileSystemIndependentPath().equals(runSettings.getGulpfileSystemIndependentPath()) && patternRunSettings.getArguments().equals(runSettings.getArguments());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getTasks()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getGulpfileSystemIndependentPath()) && patternTaskSet.getArguments().equals(runSettings.getArguments());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            GulpService.$$$reportNull$$$0(19);
        }
        if (taskSet == null) {
            GulpService.$$$reportNull$$$0(20);
        }
        GulpfileStructure structure = (GulpfileStructure)taskSet.getStructure();
        GulpRunConfiguration gulpRunConfiguration = (GulpRunConfiguration)runConfiguration;
        GulpRunSettings merged = new GulpRunSettings.Builder(gulpRunConfiguration.getRunSettings()).setGulpfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GulpRunConfigurationProducer.setupConfigurationFromSettings(gulpRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@Nullable VirtualFile contextGruntfile) {
        return new GulpTasksFetchSettingsDialog(this.myProject, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(boolean webModulesOnly) {
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpfileJsDir";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithoutExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIndexFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileInDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNameMatchedStrictly";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static final class GulpApplicationService
    extends JsbtApplicationService {
        private GulpApplicationService() {
        }

        @NotNull
        public static GulpApplicationService getInstance() {
            GulpApplicationService gulpApplicationService = (GulpApplicationService)JsbtApplicationService.EP_NAME.findExtensionOrFail(GulpApplicationService.class);
            if (gulpApplicationService == null) {
                GulpApplicationService.$$$reportNull$$$0(0);
            }
            return gulpApplicationService;
        }

        @Override
        @NotNull
        public GulpService getProjectService(@NotNull Project project) {
            if (project == null) {
                GulpApplicationService.$$$reportNull$$$0(1);
            }
            GulpService gulpService = GulpService.getInstance(project);
            if (gulpService == null) {
                GulpApplicationService.$$$reportNull$$$0(2);
            }
            return gulpService;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getName() {
            return "Gulp";
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = JavaScriptLanguageIcons.BuildTools.Gulp16;
            if (icon2 == null) {
                GulpApplicationService.$$$reportNull$$$0(3);
            }
            return icon2;
        }

        @Override
        @NotNull
        public String getBuildfileCommonName() {
            return GulpService.GULPFILE_NAME_WITHOUT_EXT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpService$GulpApplicationService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpService$GulpApplicationService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectService";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

