/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GruntTask {
    private final GruntfileStructure myStructure;
    @NlsSafe
    @NotNull
    private final String myName;
    @NlsSafe
    private final String myInfo;
    @NlsSafe
    private final String myFilePath;
    private final boolean myMulti;

    protected GruntTask(@NotNull GruntfileStructure structure, @NlsSafe @NotNull String name, @NlsSafe @Nullable String info2, @NlsSafe @Nullable String filePath, boolean multi) {
        if (structure == null) {
            GruntTask.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GruntTask.$$$reportNull$$$0(1);
        }
        this.myStructure = structure;
        this.myName = name;
        this.myInfo = info2;
        this.myFilePath = filePath != null ? FileUtil.toSystemIndependentName((String)filePath) : null;
        this.myMulti = multi;
    }

    @NotNull
    public GruntfileStructure getStructure() {
        GruntfileStructure gruntfileStructure = this.myStructure;
        if (gruntfileStructure == null) {
            GruntTask.$$$reportNull$$$0(2);
        }
        return gruntfileStructure;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GruntTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    public String getInfo() {
        return this.myInfo;
    }

    @NlsSafe
    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public boolean isMulti() {
        return this.myMulti;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GruntTask task = (GruntTask)o;
        return this.myName.equals(task.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Nullable
    public static GruntTask getUserObject(@Nullable DefaultMutableTreeNode node) {
        return JsbtTree.getUserObject(node, GruntTask.class);
    }

    @NotNull
    public static Collection<GruntTask> listAllDependentTasksFor(@NotNull GruntTask task) {
        if (task == null) {
            GruntTask.$$$reportNull$$$0(4);
        }
        HashSet<GruntTask> visitedTasks = new HashSet<GruntTask>();
        GruntTask.listAllDependentTasksFor(task, visitedTasks);
        HashSet<GruntTask> hashSet = visitedTasks;
        if (hashSet == null) {
            GruntTask.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static void listAllDependentTasksFor(@NotNull GruntTask task, @NotNull Set<GruntTask> visitedTasks) {
        if (task == null) {
            GruntTask.$$$reportNull$$$0(6);
        }
        if (visitedTasks == null) {
            GruntTask.$$$reportNull$$$0(7);
        }
        if (!visitedTasks.contains(task)) {
            visitedTasks.add(task);
            if (task instanceof GruntAliasTask) {
                ImmutableList<String> deps = ((GruntAliasTask)task).getDependencies();
                for (String dep : deps) {
                    GruntTask depTask = task.getStructure().findTaskByName(dep);
                    if (depTask == null) continue;
                    GruntTask.listAllDependentTasksFor(depTask, visitedTasks);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntTask";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllDependentTasksFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "listAllDependentTasksFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

