/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskListingSettingsDialog;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskTreeView;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GruntService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(GruntService.class);
    private static final String GRUNTFILE_NAME_WITHOUT_EXT = "Gruntfile";
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "js"};

    public GruntService(@NotNull Project project) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    public static GruntService getInstance(@NotNull Project project) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(1);
        }
        GruntService gruntService = (GruntService)project.getService(GruntService.class);
        if (gruntService == null) {
            GruntService.$$$reportNull$$$0(2);
        }
        return gruntService;
    }

    @Override
    @NotNull
    public JsbtApplicationService getApplicationService() {
        GruntApplicationService gruntApplicationService = GruntApplicationService.getInstance();
        if (gruntApplicationService == null) {
            GruntService.$$$reportNull$$$0(3);
        }
        return gruntApplicationService;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager() {
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(this.myProject);
        if (gruntfileManager == null) {
            GruntService.$$$reportNull$$$0(4);
        }
        return gruntfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager() {
        return new JsbtToolWindowManager(this.myProject, "Grunt", JavaScriptLanguageIcons.BuildTools.Grunt.Grunt_toolwindow, "reference.tool.window.grunt", this);
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@Nullable String layoutPlace) {
        return new GruntTaskTreeView(this, this.myProject, layoutPlace);
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles() {
        List<VirtualFile> list2 = JsbtUtil.detectAllBuildfiles(this.myProject, GRUNTFILE_NAME_WITHOUT_EXT, new String[]{GRUNTFILE_NAME_WITHOUT_EXT}, KNOWN_EXTENSIONS);
        if (list2 == null) {
            GruntService.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        List<VirtualFile> list2 = JsbtUtil.detectAllBuildfilesInContentRoots(this.myProject, webModulesOnly, GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS, false);
        if (list2 == null) {
            GruntService.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            GruntService.$$$reportNull$$$0(7);
        }
        return !file.isDirectory() && JsbtUtil.isFilenameMatched(file.getNameSequence(), GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
    }

    @Override
    @Nullable
    public VirtualFile findBuildfileInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            GruntService.$$$reportNull$$$0(8);
        }
        return dir.findChild("Gruntfile.js");
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            GruntService.$$$reportNull$$$0(9);
        }
        return new GruntfileStructure(buildfile);
    }

    @Override
    @NotNull
    public GruntfileStructure fetchBuildfileStructure(@NotNull VirtualFile gruntfile) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        if (gruntfile == null) {
            GruntService.$$$reportNull$$$0(10);
        }
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(this.myProject);
        NodeJsInterpreter interpreter = templateRunSettings.getInterpreterRef().resolve(this.myProject);
        GruntNonSharedSettings settings2 = GruntUtil.getGruntPackage(this.myProject, interpreter, gruntfile);
        try {
            gruntfileStructure = GruntTaskStructureUtil.fetchStructure(this.myProject, interpreter, templateRunSettings.getNodeOptions(), settings2.getGruntCliPackage(), gruntfile, templateRunSettings.getEnvData());
        }
        catch (JsbtTaskFetchException e) {
            String description = e.getDescription();
            LOG.info(description);
            throw e;
        }
        if (gruntfileStructure == null) {
            GruntService.$$$reportNull$$$0(11);
        }
        return gruntfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GruntConfigurationType gruntConfigurationType = GruntConfigurationType.getInstance();
        if (gruntConfigurationType == null) {
            GruntService.$$$reportNull$$$0(12);
        }
        return gruntConfigurationType;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            GruntService.$$$reportNull$$$0(13);
        }
        if (patternObject == null) {
            GruntService.$$$reportNull$$$0(14);
        }
        if (runConfiguration instanceof GruntRunConfiguration) {
            GruntRunSettings runSettings = ((GruntRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                if (JsbtUtil.equalsOrderless(runSettings.getTasks(), patternTaskSet.getTaskNames())) {
                    String systemIndependentPath = patternTaskSet.getStructure().getBuildfile().getPath();
                    return systemIndependentPath.equals(FileUtil.toSystemIndependentName((String)runSettings.getGruntfilePath())) && patternTaskSet.getArguments().equals(runSettings.getArguments());
                }
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            GruntService.$$$reportNull$$$0(15);
        }
        if (taskSet == null) {
            GruntService.$$$reportNull$$$0(16);
        }
        GruntfileStructure structure = (GruntfileStructure)taskSet.getStructure();
        GruntRunConfiguration gruntRunConfiguration = (GruntRunConfiguration)runConfiguration;
        GruntRunSettings merged = new GruntRunSettings.Builder(gruntRunConfiguration.getRunSettings()).setGruntfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GruntRunConfigurationProducer.setupConfigurationFromSettings(gruntRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@Nullable VirtualFile contextGruntfile) {
        return new GruntTaskListingSettingsDialog(this.myProject, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(boolean webModulesOnly) {
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntfile";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileInDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static final class GruntApplicationService
    extends JsbtApplicationService {
        private GruntApplicationService() {
        }

        @NotNull
        public static GruntApplicationService getInstance() {
            GruntApplicationService gruntApplicationService = (GruntApplicationService)JsbtApplicationService.EP_NAME.findExtensionOrFail(GruntApplicationService.class);
            if (gruntApplicationService == null) {
                GruntApplicationService.$$$reportNull$$$0(0);
            }
            return gruntApplicationService;
        }

        @Override
        @NotNull
        public GruntService getProjectService(@NotNull Project project) {
            if (project == null) {
                GruntApplicationService.$$$reportNull$$$0(1);
            }
            GruntService gruntService = GruntService.getInstance(project);
            if (gruntService == null) {
                GruntApplicationService.$$$reportNull$$$0(2);
            }
            return gruntService;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getName() {
            return "Grunt";
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = JavaScriptLanguageIcons.BuildTools.Grunt.Grunt;
            if (icon2 == null) {
                GruntApplicationService.$$$reportNull$$$0(3);
            }
            return icon2;
        }

        @Override
        @NotNull
        public String getBuildfileCommonName() {
            return GruntService.GRUNTFILE_NAME_WITHOUT_EXT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntService$GruntApplicationService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntService$GruntApplicationService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectService";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

