/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigManager;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfiguration;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigurationMode;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinitionsProvider;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0011\u0018\u00010\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "automaticModeButton", "Lcom/intellij/ui/components/JBRadioButton;", "configManager", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager;", "getConfigManager", "()Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager;", "configPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "disabledModeButton", "fileFilter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileFilter", "()Lcom/intellij/openapi/util/Condition;", "manualModeButton", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "createConfiguration", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfiguration;", "getSelectedMode", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigurationMode;", "isModified", "", "reset", "setupConfigPathField", "validateConfiguration", "configuration", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigurable.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public abstract class WebBundlerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final Project project;
    @NotNull
    private final TextFieldWithBrowseButton configPathField;
    @NotNull
    private final JBRadioButton automaticModeButton;
    @NotNull
    private final JBRadioButton manualModeButton;
    @NotNull
    private final JBRadioButton disabledModeButton;
    @Nullable
    private final Condition<? super VirtualFile> fileFilter;

    public WebBundlerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.configPathField = new TextFieldWithBrowseButton();
        this.automaticModeButton = new JBRadioButton(JavaScriptBundle.message("bundler.configuration.automatic", new Object[0]));
        this.manualModeButton = new JBRadioButton(JavaScriptBundle.message("bundler.configuration.manual", new Object[0]));
        this.disabledModeButton = new JBRadioButton(JavaScriptBundle.message("bundler.configuration.disabled", new Object[0]));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract WebBundlerConfigManager getConfigManager();

    public boolean isModified() {
        String globalConfigPath = this.getConfigManager().getGlobalConfigPath();
        String string = FileUtil.toSystemDependentName((String)globalConfigPath);
        String string2 = this.configPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        boolean configChanged = !Intrinsics.areEqual((Object)string, (Object)((Object)StringsKt.trim((CharSequence)string2)).toString());
        WebBundlerConfigurationMode mode = this.getConfigManager().getConfigurationMode();
        boolean modeChanged = this.getSelectedMode() != mode;
        return configChanged || modeChanged;
    }

    private final WebBundlerConfigurationMode getSelectedMode() {
        return this.manualModeButton.isSelected() ? WebBundlerConfigurationMode.MANUAL : (this.disabledModeButton.isSelected() ? WebBundlerConfigurationMode.DISABLED : WebBundlerConfigurationMode.AUTO);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JComponent createComponent() {
        void $this$createComponent_u24lambda_u244_u24lambda_u243;
        ButtonGroup buttonGroup;
        Object object = WebBundlerDefinitionsProvider.Companion.getInstance(this.project).findDefinitionById(this.getConfigManager().getBundlerId());
        if (object == null || (object = object.getPresentation()) == null) {
            throw new IllegalStateException(("Bundler definition " + this.getConfigManager().getBundlerId() + " is not found").toString());
        }
        Object bundlerName = object;
        ButtonGroup $this$createComponent_u24lambda_u240 = buttonGroup = new ButtonGroup();
        boolean bl = false;
        $this$createComponent_u24lambda_u240.add((AbstractButton)this.automaticModeButton);
        $this$createComponent_u24lambda_u240.add((AbstractButton)this.manualModeButton);
        $this$createComponent_u24lambda_u240.add((AbstractButton)this.disabledModeButton);
        ButtonGroup modeButtonsGroup = buttonGroup;
        this.setupConfigPathField();
        JPanel jPanel = UI.PanelFactory.panel((JComponent)((JComponent)this.configPathField)).withLabel(JavaScriptBundle.message("bundler.configuration.field", new Object[0])).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel configurationFieldsPanel = jPanel;
        JPanel $this$createComponent_u24lambda_u241 = bl = new JPanel(new BorderLayout(0, 0));
        boolean bl2 = false;
        $this$createComponent_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)5, (int)JSLinterUtil.getMarginForRadioButton((JRadioButton)this.manualModeButton), (int)0, (int)0));
        $this$createComponent_u24lambda_u241.add((Component)configurationFieldsPanel, "North");
        JPanel configurationPanel = bl;
        JPanel $this$createComponent_u24lambda_u244 = $this$createComponent_u24lambda_u241 = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl3 = false;
        $this$createComponent_u24lambda_u244.add((Component)this.automaticModeButton);
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), bundlerName};
        objectArray = ContextHelpLabel.createWithLink(null, (String)JavaScriptBundle.message("bundler.configuration.automatic.hint", objectArray), (String)JavaScriptBundle.message("bundler.configuration.automatic.how.it.works", new Object[0]), () -> WebBundlerConfigurable.createComponent$lambda$4$lambda$2(this));
        Object object2 = objectArray;
        JPanel jPanel2 = $this$createComponent_u24lambda_u244;
        boolean bl4 = false;
        $this$createComponent_u24lambda_u244_u24lambda_u243.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        jPanel2.add((Component)objectArray);
        JPanel automaticModeWithHelp = $this$createComponent_u24lambda_u241;
        Object object3 = new Object[]{bundlerName};
        FormBuilder builder2 = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4).addComponent((JComponent)new JBLabel(JavaScriptBundle.message("bundler.configuration.detect.description", (Object[])object3))).addComponent((JComponent)this.disabledModeButton).addComponent((JComponent)automaticModeWithHelp).addComponent((JComponent)this.manualModeButton).addComponent((JComponent)configurationPanel);
        ItemListener it = arg_0 -> WebBundlerConfigurable.createComponent$lambda$5(configurationPanel, this, arg_0);
        boolean bl5 = false;
        Enumeration<AbstractButton> enumeration = modeButtonsGroup.getElements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getElements(...)");
        object2 = CollectionsKt.iterator(enumeration);
        while (object2.hasNext()) {
            AbstractButton element = (AbstractButton)object2.next();
            element.addItemListener(it);
        }
        Object $this$createComponent_u24lambda_u247 = object3 = new JPanel(new BorderLayout());
        boolean bl6 = false;
        ((Container)$this$createComponent_u24lambda_u247).add((Component)builder2.getPanel(), "North");
        return (JComponent)object3;
    }

    @Nullable
    protected Condition<? super VirtualFile> getFileFilter() {
        return this.fileFilter;
    }

    private final void setupConfigPathField() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(this.getFileFilter());
        this.configPathField.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, this.project));
    }

    public void apply() {
        CharSequence charSequence;
        WebBundlerConfiguration webBundlerConfiguration;
        WebBundlerConfiguration $this$apply_u24lambda_u249 = webBundlerConfiguration = this.createConfiguration();
        boolean bl = false;
        WebBundlerConfiguration webBundlerConfiguration2 = $this$apply_u24lambda_u249;
        String string = this.configPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (charSequence2.length() == 0) {
            WebBundlerConfiguration webBundlerConfiguration3 = webBundlerConfiguration2;
            boolean bl2 = false;
            charSequence = null;
            webBundlerConfiguration2 = webBundlerConfiguration3;
        } else {
            charSequence = charSequence2;
        }
        webBundlerConfiguration2.setPath((String)charSequence);
        $this$apply_u24lambda_u249.setMode(this.getSelectedMode());
        WebBundlerConfiguration configuration = webBundlerConfiguration;
        this.validateConfiguration(configuration);
        this.getConfigManager().applySettings(configuration, true);
    }

    @NotNull
    public abstract WebBundlerConfiguration createConfiguration();

    private final void validateConfiguration(WebBundlerConfiguration configuration) {
        CharSequence charSequence;
        if (configuration.getMode() == WebBundlerConfigurationMode.MANUAL && ((charSequence = (CharSequence)configuration.getPath()) == null || charSequence.length() == 0)) {
            throw new ConfigurationException(JavaScriptBundle.message("bundler.configuration.field.required.error", new Object[0]));
        }
    }

    public void reset() {
        this.configPathField.setText(FileUtil.toSystemDependentName((String)this.getConfigManager().getGlobalConfigPath()));
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfigManager().getConfigurationMode().ordinal()]) {
            case 1: {
                this.manualModeButton.setSelected(true);
                break;
            }
            case 2: {
                this.disabledModeButton.setSelected(true);
                break;
            }
            default: {
                this.automaticModeButton.setSelected(true);
            }
        }
    }

    private static final void createComponent$lambda$4$lambda$2(WebBundlerConfigurable this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HelpManager.getInstance().invokeHelp(this$0.getHelpTopic());
    }

    private static final void createComponent$lambda$5(JPanel $configurationPanel, WebBundlerConfigurable this$0, ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)$configurationPanel, (String)"$configurationPanel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (e.getStateChange() != 1) {
            return;
        }
        $configurationPanel.setVisible(this$0.manualModeButton.isSelected());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WebBundlerConfigurationMode.values().length];
            try {
                nArray[WebBundlerConfigurationMode.MANUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebBundlerConfigurationMode.DISABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

