/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfig;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerNotifier;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerStampedConfig;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H$J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH$J6\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010*\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010+\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-*\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "bundlerId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "marker", "getMarker", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "configureCommandLine", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "path", "workingDir", "isESM", "", "createTargetRun", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getErrorDetails", "output", "Lcom/intellij/execution/process/ProcessOutput;", "getErrorMessage", "configPath", "getInterpreter", "getWorkingDir", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerStampedConfig;", "timestamp", "", "parseJsonResult", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "result", "run", "Lkotlin/Pair;", "explicitWorkingDir", "showErrorNotification", "convertPathToLocal", "convertPathsToLocal", "", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerConfigExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigExecutor.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n46#2,5:186\n11#2:195\n1549#3:191\n1620#3,3:192\n*S KotlinDebug\n*F\n+ 1 WebBundlerConfigExecutor.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor\n*L\n49#1:186,5\n166#1:195\n145#1:191\n145#1:192,3\n*E\n"})
public abstract class WebBundlerConfigExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String bundlerId;
    @NotNull
    private final String marker;
    @NotNull
    public static final String EXECUTION_TIMEOUT_KEY = "webpack.execution.timeout.ms";
    public static final int VERSION = 9;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ERROR_REGEX;

    public WebBundlerConfigExecutor(@NotNull Project project, @NotNull String bundlerId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bundlerId, (String)"bundlerId");
        this.project = project;
        this.bundlerId = bundlerId;
        this.marker = "!!!" + ApplicationNamesInfo.getInstance().getFullProductName() + " bundler loader!!!";
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getMarker() {
        return this.marker;
    }

    @NotNull
    public final WebBundlerStampedConfig loadConfig(@NotNull String configPath, long timestamp, @Nullable String workingDir2) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        if (((CharSequence)configPath).length() == 0) {
            LOG.warn("Empty path provided to " + this.bundlerId + " executor");
            return new WebBundlerStampedConfig(null, 0L, 9, null, null, this.bundlerId, 27, null);
        }
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            Object[] objectArray = new Object[]{PathUtil.getFileName((String)configPath)};
            String string = JavaScriptBundle.message("web.bundler.failed.to.load", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
            WebBundlerNotifier.INSTANCE.notify(this.project, string, messageType, configPath, this.bundlerId, NodeSettingsConfigurable.createConfigureInterpreterAction(this.project, null));
            return new WebBundlerStampedConfig(null, 0L, 9, configPath, workingDir2, this.bundlerId, 3, null);
        }
        Pair<NodeTargetRun, ProcessOutput> pair = this.run(this.project, interpreter, configPath, workingDir2);
        NodeTargetRun targetRun = (NodeTargetRun)pair.component1();
        ProcessOutput run2 = (ProcessOutput)pair.component2();
        if (run2.getExitCode() == 0) {
            String string;
            String string2 = run2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String stdOut = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("stdout: " + stdOut + "\nstderr: " + run2.getStderr(), e$iv);
            }
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (String)this.marker, (int)0, (boolean)false, (int)6, null);
            int startIndex = lastNewLine + this.marker.length() + 1;
            if (lastNewLine >= 0 && stdOut.length() >= startIndex) {
                String string3 = stdOut.substring(startIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = stdOut;
            }
            String result2 = string;
            try {
                WebBundlerConfig config = this.parseJsonResult(result2, targetRun);
                return new WebBundlerStampedConfig(config, timestamp, 9, configPath, workingDir2, this.bundlerId);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage() + "\nstdout: " + run2.getStdout() + "\nstderr: " + run2.getStderr(), (Throwable)e);
                this.showErrorNotification(configPath, run2);
                return new WebBundlerStampedConfig(new WebBundlerConfig(null, null, 3, null), timestamp, 9, configPath, workingDir2, this.bundlerId);
            }
        }
        LOG.warn("Failed to evaluate " + this.bundlerId + " config. exit code: " + run2.getExitCode() + (run2.isTimeout() ? ", timed out" : "") + "\nstdout: " + run2.getStdout() + "\nstderr: " + run2.getStderr());
        this.showErrorNotification(configPath, run2);
        return new WebBundlerStampedConfig(new WebBundlerConfig(null, null, 3, null), timestamp, 9, configPath, workingDir2, this.bundlerId);
    }

    @NotNull
    protected abstract WebBundlerConfig parseJsonResult(@NotNull String var1, @NotNull NodeTargetRun var2);

    private final void showErrorNotification(String configPath, ProcessOutput output) {
        String string = this.getErrorMessage(configPath, output);
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
        WebBundlerNotifier.notify$default(WebBundlerNotifier.INSTANCE, this.project, string, messageType, configPath, this.bundlerId, null, 32, null);
    }

    @NlsContexts.NotificationContent
    private final String getErrorMessage(String configPath, ProcessOutput output) {
        Object[] objectArray = new Object[]{"<a href=\"#\">" + PathUtil.getFileName((String)configPath) + "</a>"};
        String string = JavaScriptBundle.message("web.bundler.cannot.analyze", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        HtmlBuilder builder2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().addRaw(message)).append((HtmlChunk)HtmlChunk.br());
        String details = this.getErrorDetails(output);
        if (((CharSequence)details).length() > 0) {
            Object[] objectArray2 = new Object[]{details};
            builder2.append((HtmlChunk)HtmlChunk.p().addText(JavaScriptBundle.message("web.bundler.error.details", objectArray2)));
        } else {
            builder2.append((HtmlChunk)HtmlChunk.p().addText(JavaScriptBundle.message("web.bundler.possible.reasons", new Object[0])));
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    protected String getErrorDetails(@NotNull ProcessOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string = output.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        char[] cArray = new char[]{'\n', '\r'};
        for (String part : StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            MatchResult match = Regex.find$default((Regex)ERROR_REGEX, (CharSequence)part, (int)0, (int)2, null);
            if (match == null) continue;
            String string2 = part.substring(match.getRange().getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return "";
    }

    private final Pair<NodeTargetRun, ProcessOutput> run(Project project, NodeJsInterpreter interpreter, String path2, String explicitWorkingDir) {
        VirtualFile packageJson = Companion.findPackageJson(path2);
        String string = explicitWorkingDir;
        if (string == null) {
            string = this.getWorkingDir(packageJson);
        }
        String workingDir2 = string;
        VirtualFile virtualFile = packageJson;
        boolean isESM = virtualFile != null ? PackageJsonData.getOrCreate(virtualFile).isModuleType() : false;
        NodeTargetRun targetRun = this.createTargetRun(interpreter, project, workingDir2);
        LOG.info("Execute " + this.bundlerId + " config: path=" + path2 + ", working directory=" + workingDir2);
        this.configureCommandLine(targetRun, path2, workingDir2, isESM);
        KillableProcessHandler processHandler = targetRun.startProcessEx().getProcessHandler();
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess(Registry.intValue((String)EXECUTION_TIMEOUT_KEY, (int)20000), true);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput processOutput2 = processOutput;
        return new Pair((Object)targetRun, (Object)processOutput2);
    }

    private final NodeTargetRun createTargetRun(NodeJsInterpreter interpreter, Project project, String workingDir2) {
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, project, null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        targetRun.getCommandLineBuilder().setWorkingDirectory(targetRun.path(workingDir2));
        targetRun.getCommandLineBuilder().addEnvironmentVariable("NODE_ENV", "development");
        return targetRun;
    }

    protected abstract void configureCommandLine(@NotNull NodeTargetRun var1, @NotNull String var2, @NotNull String var3, boolean var4);

    private final String getWorkingDir(VirtualFile packageJson) {
        String string;
        VirtualFile virtualFile = packageJson;
        if (virtualFile != null) {
            String string2 = virtualFile.getParent().getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        } else {
            String string3 = this.project.getBasePath();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string;
    }

    private final NodeJsInterpreter getInterpreter() {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.project).getInterpreter();
        return interpreter != null && interpreter.validate(this.project) == null ? interpreter : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Collection<String> convertPathsToLocal(@NotNull Collection<String> $this$convertPathsToLocal, @NotNull NodeTargetRun targetRun) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertPathsToLocal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        Iterable $this$map$iv = $this$convertPathsToLocal;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertPathToLocal((String)it, targetRun));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final String convertPathToLocal(@NotNull String $this$convertPathToLocal, @NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)$this$convertPathToLocal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        Promise<String> promise = targetRun.convertTargetPathToLocal($this$convertPathToLocal);
        if (promise.getState() == Promise.State.PENDING) {
            throw new RuntimeException("Still pending for " + $this$convertPathToLocal);
        }
        try {
            Object object = promise.blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert target path to local: " + $this$convertPathToLocal, e);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebBundlerConfigExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ERROR_REGEX = new Regex("Error(\\s\\[\\w+])?:");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor$Companion;", "", "()V", "ERROR_REGEX", "Lkotlin/text/Regex;", "EXECUTION_TIMEOUT_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VERSION", "", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "from", "path", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile findPackageJson(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.findPackageJson(VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)path2)));
        }

        @Nullable
        public final VirtualFile findPackageJson(@Nullable VirtualFile from) {
            if (from == null) {
                return null;
            }
            VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(from);
            while (packageJson != null && JSLibraryUtil.hasDirectoryInPath(packageJson, "node_modules", null)) {
                packageJson = PackageJsonUtil.findUpPackageJson(packageJson.getParent().getParent());
            }
            return packageJson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

