/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfig;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigCache;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigCacheState;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigChange;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigEvaluationContext;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigExecutor;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinition;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinitionsProvider;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerStampedConfig;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="webBundlerCache", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00016B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\rJ\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\u00192\b\b\u0002\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010.J\u000e\u0010/\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\b\u00101\u001a\u00020\u0019H\u0002J\u0010\u00102\u001a\u00020\u00192\b\b\u0002\u00103\u001a\u000204J\b\u00105\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCacheState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/Alarm;", "bundlerDefinitionsProvider", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerDefinitionsProvider;", "configs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigEvaluationContext;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerStampedConfig;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "rootsChangedScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "", "evaluateConfig", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigChange;", "context", "getCachedConfigs", "", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "bundlerId", "", "getConfigForFile", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getState", "loadState", "state", "notifyCacheChanged", "rootsChanged", "", "remove", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeAll", "runConfigEvaluator", "scheduleRootsChangedEvent", "scheduleUpdate", "timeout", "", "update", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerConfigCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigCache.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n60#2,3:325\n46#2,5:328\n46#2,5:340\n46#2,5:345\n46#2,5:364\n46#2,5:375\n11#2:380\n766#3:333\n857#3,2:334\n1549#3:336\n1620#3,3:337\n1747#3,3:369\n1747#3,3:372\n135#4,9:350\n215#4:359\n216#4:361\n144#4:362\n1#5:360\n1#5:363\n*S KotlinDebug\n*F\n+ 1 WebBundlerConfigCache.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache\n*L\n77#1:325,3\n81#1:328,5\n183#1:340,5\n188#1:345,5\n112#1:364,5\n121#1:375,5\n280#1:380\n89#1:333\n89#1:334,2\n89#1:336\n89#1:337,3\n119#1:369,3\n120#1:372,3\n208#1:350,9\n208#1:359\n208#1:361\n208#1:362\n208#1:360\n*E\n"})
public final class WebBundlerConfigCache
implements PersistentStateComponent<WebBundlerConfigCacheState>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final AtomicBoolean rootsChangedScheduled;
    @NotNull
    private final ConcurrentHashMap<WebBundlerConfigEvaluationContext, WebBundlerStampedConfig> configs;
    @NotNull
    private final WebBundlerDefinitionsProvider bundlerDefinitionsProvider;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @NotNull
    private static final Logger LOG;
    private static final int UPDATE_TIMEOUT = 3000;
    @NotNull
    private static final WebBundlerConfig EMPTY_CONFIG;

    public WebBundlerConfigCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Web Bundler Cache");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.rootsChangedScheduled = new AtomicBoolean();
        this.configs = new ConcurrentHashMap();
        this.bundlerDefinitionsProvider = WebBundlerDefinitionsProvider.Companion.getInstance(this.project);
        this.modificationTracker = new SimpleModificationTracker();
    }

    public void dispose() {
    }

    @NotNull
    public final WebBundlerConfig getConfigForFile(@Nullable WebBundlerConfigEvaluationContext context2) {
        Object object;
        if (context2 == null) {
            return EMPTY_CONFIG;
        }
        VirtualFile file = context2.getFile();
        if (!file.isValid()) {
            return EMPTY_CONFIG;
        }
        this.configs.putIfAbsent(context2, WebBundlerStampedConfig.Companion.createConfigForEvaluation$intellij_javascript_impl(context2));
        boolean requiresUpdate = false;
        WebBundlerStampedConfig stampedConfig = this.configs.get(context2);
        if (stampedConfig == null || stampedConfig.getTimestamp() != file.getTimeStamp() || stampedConfig.getVersion() != 9) {
            requiresUpdate = true;
        }
        if (requiresUpdate) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Object $this$runAndLogException_u24lambda_u240$iv;
                Logger $this$runAndLogException$iv = LOG;
                boolean $i$f$runAndLogException = false;
                Logger logger = $this$runAndLogException$iv;
                try {
                    $this$runAndLogException_u24lambda_u240$iv = logger;
                    boolean bl = false;
                    boolean bl2 = false;
                    $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)((Object)this.runConfigEvaluator(context2)));
                }
                catch (Throwable throwable) {
                    $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv);
                Object object2 = this.configs.get(context2);
                if (object2 == null || (object2 = ((WebBundlerStampedConfig)object2).getConfig()) == null) {
                    object2 = EMPTY_CONFIG;
                }
                return object2;
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Scheduling update for file: '" + file.getPath() + "'", e$iv);
            }
            WebBundlerConfigCache.scheduleUpdate$default(this, 0, 1, null);
        }
        if ((object = stampedConfig) == null || (object = ((WebBundlerStampedConfig)object).getConfig()) == null) {
            object = EMPTY_CONFIG;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WebBundlerConfig> getCachedConfigs(@NotNull String bundlerId) {
        void $this$mapTo$iv$iv;
        WebBundlerStampedConfig it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bundlerId, (String)"bundlerId");
        Collection<WebBundlerStampedConfig> collection = this.configs.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WebBundlerStampedConfig)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getBundlerId(), (Object)bundlerId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WebBundlerStampedConfig)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getConfig());
        }
        return (List)destination$iv$iv;
    }

    public final void scheduleUpdate(int timeout) {
        if (this.alarm.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(this::update, timeout);
    }

    public static /* synthetic */ void scheduleUpdate$default(WebBundlerConfigCache webBundlerConfigCache, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3000;
        }
        webBundlerConfigCache.scheduleUpdate(n);
    }

    private final void update() {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ WebBundlerConfigCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ((ConcurrentHashMap.KeySetView)WebBundlerConfigCache.access$getConfigs$p(this.this$0).keySet()).removeIf(arg_0 -> update.1.invoke$lambda$0((Function1)new Function1<WebBundlerConfigEvaluationContext, Boolean>(this.this$0){
                    final /* synthetic */ WebBundlerConfigCache this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(WebBundlerConfigEvaluationContext it) {
                        return !it.getFile().isValid() || WebBundlerConfigCache.access$getBundlerDefinitionsProvider$p(this.this$0).findDefinitionById(it.getBundlerId()) == null;
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }));
        if (this.configs.isEmpty()) {
            return;
        }
        if (!TrustedProjects.isTrusted((Project)this.project)) {
            LOG.info("Web bundler config evaluation skipped for untrusted project");
            return;
        }
        ProgressIndicator progressIndicator = this.createProcessIndicator();
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator indicator = progressIndicator;
        ProgressManager.getInstance().runProcess(() -> WebBundlerConfigCache.update$lambda$8(this, indicator), indicator);
    }

    private final ProgressIndicator createProcessIndicator() {
        return (ProgressIndicator)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<StandardProgressIndicator>(this){
            final /* synthetic */ WebBundlerConfigCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final StandardProgressIndicator invoke() {
                return WebBundlerConfigCache.access$getProject$p(this.this$0).isDisposed() || !WebBundlerConfigCache.access$getProject$p(this.this$0).isOpen() ? null : (ApplicationManager.getApplication().isUnitTestMode() ? (StandardProgressIndicator)new EmptyProgressIndicator() : (StandardProgressIndicator)new BackgroundableProcessIndicator(WebBundlerConfigCache.access$getProject$p(this.this$0), JavaScriptBundle.message("web.bundler.analyzing.configs.progress", new Object[0]), "", "", false));
            }
        }), (int)1, null);
    }

    private final CompletableFuture<WebBundlerConfigChange> evaluateConfig(WebBundlerConfigEvaluationContext context2) {
        Ref.ObjectRef future = new Ref.ObjectRef();
        CompletableFuture<WebBundlerConfigChange> completableFuture = CompletableFuture.completedFuture(WebBundlerConfigChange.UNMODIFIED);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        future.element = completableFuture;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document2 = (Document)ActionsKt.runReadAction((Function0)((Function0)new Function0<Document>(fileDocumentManager2, context2){
            final /* synthetic */ FileDocumentManager $fileDocumentManager;
            final /* synthetic */ WebBundlerConfigEvaluationContext $context;
            {
                this.$fileDocumentManager = $fileDocumentManager;
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final Document invoke() {
                return this.$fileDocumentManager.getDocument(this.$context.getFile());
            }
        }));
        if (document2 == null) {
            return (CompletableFuture)future.element;
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(context2, this, document2, fileDocumentManager2, (Ref.ObjectRef<CompletableFuture<WebBundlerConfigChange>>)future){
            final /* synthetic */ WebBundlerConfigEvaluationContext $context;
            final /* synthetic */ WebBundlerConfigCache this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ FileDocumentManager $fileDocumentManager;
            final /* synthetic */ Ref.ObjectRef<CompletableFuture<WebBundlerConfigChange>> $future;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                this.$document = $document;
                this.$fileDocumentManager = $fileDocumentManager;
                this.$future = $future;
                super(0);
            }

            public final void invoke() {
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$context, this.this$0, this.$document, this.$fileDocumentManager, this.$future){
                    final /* synthetic */ WebBundlerConfigEvaluationContext $context;
                    final /* synthetic */ WebBundlerConfigCache this$0;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ FileDocumentManager $fileDocumentManager;
                    final /* synthetic */ Ref.ObjectRef<CompletableFuture<WebBundlerConfigChange>> $future;
                    {
                        this.$context = $context;
                        this.this$0 = $receiver;
                        this.$document = $document;
                        this.$fileDocumentManager = $fileDocumentManager;
                        this.$future = $future;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.$context.getFile().isValid() || WebBundlerConfigCache.access$getProject$p(this.this$0).isDisposed()) {
                            return;
                        }
                        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)WebBundlerConfigCache.access$getProject$p(this.this$0));
                        if (psiDocumentManager.isUncommited(this.$document) || this.$fileDocumentManager.isDocumentUnsaved(this.$document)) {
                            psiDocumentManager.commitDocument(this.$document);
                            this.$fileDocumentManager.saveDocument(this.$document);
                        }
                        if (WolfTheProblemSolver.getInstance((Project)WebBundlerConfigCache.access$getProject$p(this.this$0)).hasSyntaxErrors(this.$context.getFile())) {
                            ((Map)WebBundlerConfigCache.access$getConfigs$p(this.this$0)).put(this.$context, WebBundlerStampedConfig.Companion.createEmptyUpToDateConfig$intellij_javascript_impl(this.$context));
                        } else {
                            CompletableFuture<WebBundlerConfigChange> completableFuture = CompletableFuture.supplyAsync(() -> evaluateConfig.1.invoke$lambda$0(this.this$0, this.$context), WebBundlerConfigCache.access$getExecutor$p(this.this$0));
                            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
                            this.$future.element = completableFuture;
                        }
                    }

                    private static final WebBundlerConfigChange invoke$lambda$0(WebBundlerConfigCache this$0, WebBundlerConfigEvaluationContext $context) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                        return WebBundlerConfigCache.access$runConfigEvaluator(this$0, $context);
                    }
                }));
            }
        }), (int)1, null);
        return (CompletableFuture)future.element;
    }

    private final WebBundlerConfigChange runConfigEvaluator(WebBundlerConfigEvaluationContext context2) {
        Logger logger;
        VirtualFile file = context2.component1();
        String workingDir2 = context2.component2();
        String bundlerId = context2.component3();
        Pair pair = (Pair)ActionsKt.runReadAction((Function0)((Function0)new Function0<Pair<? extends String, ? extends Long>>(this, file){
            final /* synthetic */ WebBundlerConfigCache this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Pair<String, Long> invoke() {
                return !WebBundlerConfigCache.access$getProject$p(this.this$0).isDisposed() && this.$file.isValid() ? TuplesKt.to((Object)this.$file.getPath(), (Object)this.$file.getTimeStamp()) : null;
            }
        }));
        if (pair == null) {
            return WebBundlerConfigChange.UNMODIFIED;
        }
        Pair pair2 = pair;
        String path2 = (String)pair2.component1();
        long timestamp = ((Number)pair2.component2()).longValue();
        WebBundlerStampedConfig prevStampedConfig = this.configs.get(context2);
        if (prevStampedConfig != null && prevStampedConfig.getTimestamp() == timestamp && prevStampedConfig.getVersion() == 9) {
            return WebBundlerConfigChange.UNMODIFIED;
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Previous config: " + prevStampedConfig + ", context: " + context2, e$iv);
        }
        long start = System.currentTimeMillis();
        WebBundlerDefinition bundlerDefinition = this.bundlerDefinitionsProvider.findDefinitionById(bundlerId);
        if (bundlerDefinition == null) {
            Logger $this$debug_u24default$iv2 = LOG;
            Throwable e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Bundler definition with id=" + bundlerId + " is not found", e$iv2);
            }
            this.configs.remove(context2);
            return WebBundlerConfigChange.UNMODIFIED;
        }
        WebBundlerConfigExecutor webBundlerConfigExecutor = bundlerDefinition.createConfigExecutor(this.project);
        Intrinsics.checkNotNull((Object)path2);
        WebBundlerStampedConfig stampedConfig = webBundlerConfigExecutor.loadConfig(path2, timestamp, workingDir2);
        LOG.info(bundlerId + " config evaluation for '" + path2 + "' took " + (System.currentTimeMillis() - start) + " ms");
        ((Map)this.configs).put(context2, stampedConfig);
        WebBundlerStampedConfig webBundlerStampedConfig = prevStampedConfig;
        if (!Intrinsics.areEqual((Object)(webBundlerStampedConfig != null ? webBundlerStampedConfig.getConfig() : null), (Object)stampedConfig.getConfig())) {
            Object object = prevStampedConfig;
            if (!Intrinsics.areEqual((Object)(object != null && (object = ((WebBundlerStampedConfig)object).getConfig()) != null ? ((WebBundlerConfig)object).getOutput() : null), (Object)stampedConfig.getConfig().getOutput())) {
                return WebBundlerConfigChange.ROOTS_CHANGED;
            }
            return WebBundlerConfigChange.RESOLVE_CHANGED;
        }
        return WebBundlerConfigChange.UNMODIFIED;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public WebBundlerConfigCacheState getState() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = this.configs;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            WebBundlerStampedConfig it$iv$iv;
            CharSequence charSequence;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            WebBundlerConfigEvaluationContext context2 = (WebBundlerConfigEvaluationContext)entry.getKey();
            WebBundlerStampedConfig config = (WebBundlerStampedConfig)entry.getValue();
            if ((!context2.getFile().isValid() ? null : ((charSequence = (CharSequence)config.getPath()) == null || charSequence.length() == 0 ? WebBundlerStampedConfig.Companion.createConfigForEvaluation$intellij_javascript_impl(context2) : config)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newConfigs = (List)destination$iv$iv;
        return new WebBundlerConfigCacheState(newConfigs);
    }

    public void loadState(@NotNull WebBundlerConfigCacheState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Set refreshQueue = new LinkedHashSet();
        for (WebBundlerStampedConfig config : state.getConfigs()) {
            VirtualFile virtualFile;
            String string = config.getPath();
            if (string == null) continue;
            String it = string;
            boolean bl = false;
            VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)it));
            if (virtualFile2 == null) continue;
            VirtualFile it2 = virtualFile = virtualFile2;
            boolean bl2 = false;
            Object object = it2.isValid() ? virtualFile : null;
            if (object == null) continue;
            VirtualFile file = object;
            CharSequence charSequence = config.getBundlerId();
            if (charSequence == null || charSequence.length() == 0) continue;
            refreshQueue.add(file);
            ((Map)this.configs).put(new WebBundlerConfigEvaluationContext(file, config.getWorkingDir(), config.getBundlerId()), config);
        }
        if (!((Collection)refreshQueue).isEmpty()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), (Function0)((Function0)new Function0<Unit>((Set<VirtualFile>)refreshQueue, this){
                final /* synthetic */ Set<VirtualFile> $refreshQueue;
                final /* synthetic */ WebBundlerConfigCache this$0;
                {
                    this.$refreshQueue = $refreshQueue;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.$refreshQueue;
                    WebBundlerConfigCache webBundlerConfigCache = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl = false;
                        it.refresh(true, false, () -> WebBundlerConfigCache.scheduleUpdate$default(webBundlerConfigCache, 0, 1, null));
                    }
                }
            }));
        }
    }

    public final void remove(@Nullable VirtualFile file) {
        if (file != null) {
            ((ConcurrentHashMap.KeySetView)this.configs.keySet()).removeIf(arg_0 -> WebBundlerConfigCache.remove$lambda$14((Function1)new Function1<WebBundlerConfigEvaluationContext, Boolean>(file){
                final /* synthetic */ VirtualFile $file;
                {
                    this.$file = $file;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(WebBundlerConfigEvaluationContext it) {
                    return Intrinsics.areEqual((Object)it.getFile(), (Object)this.$file);
                }
            }, arg_0));
        }
    }

    public final void removeAll(@NotNull String bundlerId) {
        Intrinsics.checkNotNullParameter((Object)bundlerId, (String)"bundlerId");
        ((ConcurrentHashMap.KeySetView)this.configs.keySet()).removeIf(arg_0 -> WebBundlerConfigCache.removeAll$lambda$15((Function1)new Function1<WebBundlerConfigEvaluationContext, Boolean>(bundlerId){
            final /* synthetic */ String $bundlerId;
            {
                this.$bundlerId = $bundlerId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(WebBundlerConfigEvaluationContext it) {
                return Intrinsics.areEqual((Object)it.getBundlerId(), (Object)this.$bundlerId);
            }
        }, arg_0));
    }

    public final void notifyCacheChanged(boolean rootsChanged) {
        ApplicationManager.getApplication().invokeLater(() -> WebBundlerConfigCache.notifyCacheChanged$lambda$16(this, rootsChanged), this.project.getDisposed());
    }

    public static /* synthetic */ void notifyCacheChanged$default(WebBundlerConfigCache webBundlerConfigCache, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        webBundlerConfigCache.notifyCacheChanged(bl);
    }

    private final void scheduleRootsChangedEvent() {
        if (this.rootsChangedScheduled.compareAndSet(false, true)) {
            DumbService.Companion.getInstance(this.project).runWhenSmart(() -> WebBundlerConfigCache.scheduleRootsChangedEvent$lambda$17(this));
        }
    }

    @NotNull
    public final ModificationTracker getModificationTracker() {
        return (ModificationTracker)this.modificationTracker;
    }

    private static final void update$lambda$8(WebBundlerConfigCache this$0, ProgressIndicator $indicator) {
        boolean bl;
        boolean resolveChanged;
        Logger logger;
        block11: {
            boolean bl2;
            ArrayList<WebBundlerConfigChange> changes;
            block10: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                Logger $this$debug_u24default$iv = LOG;
                Iterator e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("Configs: " + this$0.configs, e$iv);
                }
                changes = new ArrayList<WebBundlerConfigChange>(this$0.configs.size());
                for (WebBundlerConfigEvaluationContext context2 : (ConcurrentHashMap.KeySetView)this$0.configs.keySet()) {
                    $indicator.checkCanceled();
                    Intrinsics.checkNotNull((Object)context2);
                    changes.add(this$0.evaluateConfig(context2).get());
                }
                Iterable $this$any$iv = changes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WebBundlerConfigChange it = (WebBundlerConfigChange)((Object)element$iv);
                        boolean bl4 = false;
                        if (!it.getResolveChanged()) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            resolveChanged = bl2;
            Iterable $this$any$iv = changes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WebBundlerConfigChange it = (WebBundlerConfigChange)((Object)element$iv);
                    boolean bl5 = false;
                    if (!it.getRootsChanged()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean rootsChanged = bl;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl6 = false;
            logger.debug("Resolve changed: " + resolveChanged + ", roots changed: " + rootsChanged, e$iv);
        }
        if (resolveChanged) {
            this$0.notifyCacheChanged(rootsChanged);
        }
    }

    private static final boolean remove$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeAll$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void notifyCacheChanged$lambda$16(WebBundlerConfigCache this$0, boolean $rootsChanged) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.modificationTracker.incModificationCount();
        PsiManager.getInstance((Project)this$0.project).dropPsiCaches();
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart();
        if ($rootsChanged) {
            this$0.scheduleRootsChangedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleRootsChangedEvent$lambda$17(WebBundlerConfigCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0){
                final /* synthetic */ WebBundlerConfigCache this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ProjectRootManagerEx.getInstanceEx((Project)WebBundlerConfigCache.access$getProject$p(this.this$0)).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                }
            }));
        }
        finally {
            this$0.rootsChangedScheduled.set(false);
        }
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConfigs$p(WebBundlerConfigCache $this) {
        return $this.configs;
    }

    public static final /* synthetic */ WebBundlerDefinitionsProvider access$getBundlerDefinitionsProvider$p(WebBundlerConfigCache $this) {
        return $this.bundlerDefinitionsProvider;
    }

    public static final /* synthetic */ Project access$getProject$p(WebBundlerConfigCache $this) {
        return $this.project;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(WebBundlerConfigCache $this) {
        return $this.executor;
    }

    public static final /* synthetic */ WebBundlerConfigChange access$runConfigEvaluator(WebBundlerConfigCache $this, WebBundlerConfigEvaluationContext context2) {
        return $this.runConfigEvaluator(context2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebBundlerConfigCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EMPTY_CONFIG = new WebBundlerConfig(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache$Companion;", "", "()V", "EMPTY_CONFIG", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "getEMPTY_CONFIG", "()Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "UPDATE_TIMEOUT", "", "getInstance", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nWebBundlerConfigCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigCache.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,324:1\n31#2,2:325\n*S KotlinDebug\n*F\n+ 1 WebBundlerConfigCache.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache$Companion\n*L\n284#1:325,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebBundlerConfig getEMPTY_CONFIG() {
            return EMPTY_CONFIG;
        }

        @NotNull
        public final WebBundlerConfigCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WebBundlerConfigCache> serviceClass$iv = WebBundlerConfigCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebBundlerConfigCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

