/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskListFetchFail {
    private static final Key<JsbtTaskListFetchFail> MARKER_KEY = Key.create((String)"jsbt task list fetch: command line");
    private final VirtualFile myBuildfile;
    private final JsbtApplicationService myService;
    private final String myBuildToolName;
    private final Icon myIcon;
    private final String myMessage;
    private final GeneralCommandLine myCommandLine;
    private final String myCommandLineFoldedText;
    private final ExecutionException myExecutionException;
    private final ProcessHandler myHandler;
    private final ProcessOutput myOutput;

    public JsbtTaskListFetchFail(@NotNull VirtualFile buildfile, @NotNull JsbtApplicationService service2, @NotNull String buildToolName, @Nullable Icon icon2, @NotNull String message, @Nullable GeneralCommandLine commandLine, @Nullable String commandLineFoldedText, @Nullable ExecutionException executionException, @Nullable ProcessHandler handler, @Nullable ProcessOutput output) {
        if (buildfile == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(0);
        }
        if (service2 == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(1);
        }
        if (buildToolName == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(2);
        }
        if (message == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(3);
        }
        this.myBuildfile = buildfile;
        this.myService = service2;
        this.myBuildToolName = buildToolName;
        this.myIcon = icon2;
        this.myMessage = message;
        this.myCommandLine = commandLine;
        this.myCommandLineFoldedText = commandLineFoldedText;
        if (executionException == null == (handler == null)) {
            throw new AssertionError((Object)"ProcessHandler and ExecutionException are mutually exclusive");
        }
        this.myExecutionException = executionException;
        if (handler == null != (output == null)) {
            throw new AssertionError((Object)"ProcessHandler and ProcessOutput: illegal configuration");
        }
        this.myHandler = handler;
        this.myOutput = output;
    }

    @NotNull
    public VirtualFile getBuildfile() {
        VirtualFile virtualFile = this.myBuildfile;
        if (virtualFile == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public JsbtService getService(@NotNull Project project) {
        if (project == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(5);
        }
        JsbtService jsbtService = this.myService.getProjectService(project);
        if (jsbtService == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(6);
        }
        return jsbtService;
    }

    @NotNull
    public String getBuildToolName() {
        String string = this.myBuildToolName;
        if (string == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public GeneralCommandLine getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public String getCommandLineFoldedText() {
        return this.myCommandLineFoldedText;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myHandler;
    }

    @Nullable
    public ProcessOutput getProcessOutput() {
        return this.myOutput;
    }

    @NotNull
    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.myMessage);
        if (this.myCommandLine != null) {
            buf.append("\nCommand: ").append(this.myCommandLine.getCommandLineString());
        }
        if (this.myExecutionException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.myExecutionException.printStackTrace(pw);
            pw.close();
            buf.append(sw.getBuffer());
        } else if (this.myOutput != null) {
            buf.append("\nExit code: ").append(this.myOutput.getExitCode());
            buf.append("\nSTDOUT:\n").append(this.myOutput.getStdout());
            buf.append("\nSTDERR:\n").append(this.myOutput.getStderr());
        }
        String string = buf.toString();
        if (string == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void associateWith(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(10);
        }
        MARKER_KEY.set((UserDataHolder)descriptor.getAttachedContent(), (Object)this);
    }

    public boolean isAssociatedWith(@NotNull RunContentDescriptor descriptor) {
        Content content;
        if (descriptor == null) {
            JsbtTaskListFetchFail.$$$reportNull$$$0(11);
        }
        return MARKER_KEY.get((UserDataHolder)(content = descriptor.getAttachedContent())) == this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildToolName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "associateWith";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

