/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBowerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class BowerSettingsManager
implements PersistentStateComponent<Element> {
    public static final String BOWER_PACKAGE_NAME = "bower";
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("bower");
    private static final String TAG_BOWER_PACKAGE = "bower-package";
    private static final String TAG_BOWER_JSON = "bower.json";
    private final Project myProject;
    private BowerSettings mySettings;

    public BowerSettingsManager(@NotNull Project project) {
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public Element getState() {
        BowerSettings settings2 = this.mySettings;
        if (settings2 == null) {
            return null;
        }
        Element root = new Element("js-bower-settings");
        JDOMExternalizerUtil.writeCustomField((Element)root, (String)TAG_BOWER_PACKAGE, (String)settings2.getBowerPackage().getSystemIndependentPath());
        JDOMExternalizerUtil.writeCustomField((Element)root, (String)TAG_BOWER_JSON, (String)settings2.getBowerJsonPath());
        return root;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            BowerSettingsManager.$$$reportNull$$$0(1);
        }
        this.mySettings = this.createSettings(JDOMExternalizerUtil.readCustomField((Element)state, (String)TAG_BOWER_PACKAGE), JDOMExternalizerUtil.readCustomField((Element)state, (String)TAG_BOWER_JSON));
    }

    @NotNull
    private BowerSettings createSettings(@Nullable String bowerPkgPath, @Nullable String bowerJsonPath) {
        BowerSettings.Builder builder2 = new BowerSettings.Builder(this.myProject);
        NodePackage bowerPkg = bowerPkgPath != null ? new NodePackage(bowerPkgPath) : this.guessBowerPackage();
        builder2.setBowerPackage(bowerPkg);
        if (bowerJsonPath == null) {
            bowerJsonPath = this.guessBowerConfig();
        }
        builder2.setBowerJsonPath(bowerJsonPath);
        BowerSettings bowerSettings = builder2.build();
        if (bowerSettings == null) {
            BowerSettingsManager.$$$reportNull$$$0(2);
        }
        return bowerSettings;
    }

    @NotNull
    private NodePackage guessBowerPackage() {
        NodePackage nodePackage = PKG_DESCRIPTOR.findFirstDirectDependencyPackage(this.myProject, NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter(), null);
        if (nodePackage == null) {
            BowerSettingsManager.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @NotNull
    private String guessBowerConfig() {
        VirtualFile bowerJson;
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && baseDir.isValid() && (bowerJson = baseDir.findChild(TAG_BOWER_JSON)) != null && bowerJson.isValid() && !bowerJson.isDirectory()) {
            String string = FileUtil.toSystemDependentName((String)bowerJson.getPath());
            if (string == null) {
                BowerSettingsManager.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings settings2 = this.mySettings;
        if (settings2 == null) {
            this.mySettings = settings2 = this.createSettings(null, null);
        }
        BowerSettings bowerSettings = this.mySettings;
        if (bowerSettings == null) {
            BowerSettingsManager.$$$reportNull$$$0(5);
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings2) {
        if (settings2 == null) {
            BowerSettingsManager.$$$reportNull$$$0(6);
        }
        this.mySettings = settings2;
    }

    @NotNull
    public static BowerSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            BowerSettingsManager.$$$reportNull$$$0(7);
        }
        BowerSettingsManager bowerSettingsManager = (BowerSettingsManager)project.getService(BowerSettingsManager.class);
        if (bowerSettingsManager == null) {
            BowerSettingsManager.$$$reportNull$$$0(8);
        }
        return bowerSettingsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettingsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBowerPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBowerConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

