/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BowerSettings {
    private final Project myProject;
    private final NodePackage myBowerPackage;
    private final String myBowerJsonPath;

    private BowerSettings(@NotNull Builder builder2) {
        if (builder2 == null) {
            BowerSettings.$$$reportNull$$$0(0);
        }
        this.myProject = builder2.myProject;
        this.myBowerPackage = builder2.myBowerPackage;
        this.myBowerJsonPath = FileUtil.toSystemIndependentName((String)builder2.myBowerJsonPath);
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
    }

    @NotNull
    public NodePackage getBowerPackage() {
        NodePackage nodePackage = this.myBowerPackage;
        if (nodePackage == null) {
            BowerSettings.$$$reportNull$$$0(1);
        }
        return nodePackage;
    }

    @NotNull
    public String getBowerJsonPath() {
        String string = this.myBowerJsonPath;
        if (string == null) {
            BowerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Builder createBuilder() {
        Builder builder2 = new Builder(this.myProject);
        builder2.setBowerPackage(this.myBowerPackage);
        builder2.setBowerJsonPath(this.myBowerJsonPath);
        Builder builder3 = builder2;
        if (builder3 == null) {
            BowerSettings.$$$reportNull$$$0(3);
        }
        return builder3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BowerSettings settings2 = (BowerSettings)o;
        return this.myBowerPackage.equals(settings2.myBowerPackage) && this.myBowerJsonPath.equals(settings2.myBowerJsonPath);
    }

    public int hashCode() {
        int result2 = this.myBowerPackage.hashCode();
        result2 = 31 * result2 + this.myBowerJsonPath.hashCode();
        return result2;
    }

    public String toString() {
        return "bowerPackage='" + this.myBowerPackage + "', bower.json='" + this.myBowerJsonPath + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBowerPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBowerJsonPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private final Project myProject;
        private NodePackage myBowerPackage;
        private String myBowerJsonPath;

        public Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myBowerPackage = new NodePackage("");
            this.myBowerJsonPath = "";
            this.myProject = project;
        }

        @NotNull
        public Builder setBowerPackage(@NotNull NodePackage bowerPackage) {
            if (bowerPackage == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myBowerPackage = bowerPackage;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setBowerJsonPath(@NotNull String bowerJsonPath) {
            if (bowerJsonPath == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myBowerJsonPath = bowerJsonPath;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public BowerSettings build() {
            return new BowerSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bowerPackage";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/bower/BowerSettings$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bowerJsonPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/bower/BowerSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBowerPackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBowerJsonPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setBowerPackage";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setBowerJsonPath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

