/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BowerPackageUtil {
    private static final String BOWER_JSON = "bower.json";
    private static final Logger LOG = Logger.getInstance(BowerPackageUtil.class);

    @Nullable
    public static JsonFile getContainingBowerJsonFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            BowerPackageUtil.$$$reportNull$$$0(0);
        }
        if ((file = element.getContainingFile()) instanceof JsonFile && BOWER_JSON.equals(file.getName())) {
            return (JsonFile)file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static BowerPackageInfo loadPackageInfo(@Nullable ProgressIndicator indicator, @NotNull BowerSettings settings2, @NotNull String packageName) throws ExecutionException {
        if (settings2 == null) {
            BowerPackageUtil.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            BowerPackageUtil.$$$reportNull$$$0(2);
        }
        ProcessOutput output = BowerCommandLineUtil.runBowerCommand(indicator, settings2, "info", packageName, "--json");
        JsonReader reader2 = new JsonReader((Reader)new StringReader(output.getStdout()));
        reader2.setLenient(false);
        JsonParser parser2 = new JsonParser();
        JsonElement rootElement = parser2.parse(reader2);
        if (!rootElement.isJsonObject()) {
            throw new RuntimeException("[loading bower package info] Top level element should be an object");
        }
        BowerPackageInfo bowerPackageInfo = BowerPackageUtil.parsePackageInfo(rootElement.getAsJsonObject());
        BowerPackageInfo bowerPackageInfo2 = bowerPackageInfo;
        if (bowerPackageInfo2 == null) {
            BowerPackageUtil.$$$reportNull$$$0(3);
        }
        return bowerPackageInfo2;
        finally {
            try {
                reader2.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private static BowerPackageInfo parsePackageInfo(@NotNull JsonObject root) {
        if (root == null) {
            BowerPackageUtil.$$$reportNull$$$0(4);
        }
        JsonArray versionsArray = JsonUtil.getChildAsArray((JsonObject)root, (String)"versions");
        List<String> versions = BowerPackageUtil.toVersions(versionsArray);
        JsonObject latestObject = JsonUtil.getChildAsObject((JsonObject)root, (String)"latest");
        return new BowerPackageInfo(versions, latestObject);
    }

    @NotNull
    private static List<String> toVersions(@Nullable JsonArray versionsArray) {
        if (versionsArray == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                BowerPackageUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (JsonElement element : versionsArray) {
            String version2 = JsonUtil.getString((JsonElement)element);
            if (version2 == null) continue;
            builder2.add((Object)version2);
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            BowerPackageUtil.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerPackageUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerPackageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPackageInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBowerJsonFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPackageInfo";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

