/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.lang.javascript.bower.BowerInstalledPackage;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BowerInstalledPackagesParser {
    private BowerInstalledPackagesParser() {
    }

    @NotNull
    public static List<BowerInstalledPackage> parse(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            BowerInstalledPackagesParser.$$$reportNull$$$0(0);
        }
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));
        JsonParser jsonParser = new JsonParser();
        jsonReader.setLenient(false);
        JsonElement element = jsonParser.parse(jsonReader);
        List<BowerInstalledPackage> list2 = BowerInstalledPackagesParser.doParsePackages(element);
        List<BowerInstalledPackage> list3 = list2;
        if (list3 == null) {
            BowerInstalledPackagesParser.$$$reportNull$$$0(1);
        }
        return list3;
        finally {
            jsonReader.close();
        }
    }

    @NotNull
    private static List<BowerInstalledPackage> doParsePackages(@NotNull JsonElement element) throws IOException {
        if (element == null) {
            BowerInstalledPackagesParser.$$$reportNull$$$0(2);
        }
        if (!element.isJsonObject()) {
            throw new IOException("Unexpected root element");
        }
        JsonObject root = element.getAsJsonObject();
        JsonElement dependenciesElement = root.get("dependencies");
        if (dependenciesElement == null || !dependenciesElement.isJsonObject()) {
            throw new IOException("Top level 'dependencies' object key not found");
        }
        JsonObject dependenciesObject = dependenciesElement.getAsJsonObject();
        ArrayList<BowerInstalledPackage> packages = new ArrayList<BowerInstalledPackage>();
        for (Map.Entry entry : dependenciesObject.entrySet()) {
            BowerInstalledPackage pkg;
            JsonElement packageElement = (JsonElement)entry.getValue();
            if (packageElement == null || !packageElement.isJsonObject() || (pkg = BowerInstalledPackagesParser.parsePackage(packageElement.getAsJsonObject())) == null) continue;
            packages.add(pkg);
        }
        ArrayList<BowerInstalledPackage> arrayList = packages;
        if (arrayList == null) {
            BowerInstalledPackagesParser.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static BowerInstalledPackage parsePackage(@NotNull JsonObject pkgObject) {
        JsonElement updateElement;
        JsonObject pkgMetaObject;
        if (pkgObject == null) {
            BowerInstalledPackagesParser.$$$reportNull$$$0(4);
        }
        String name = null;
        String _release = null;
        String target = null;
        String latest = null;
        JsonObject endpointObject = JsonUtil.getChildAsObject((JsonObject)pkgObject, (String)"endpoint");
        if (endpointObject != null) {
            name = JsonUtil.getString((JsonObject)endpointObject, (String)"name");
        }
        if ((pkgMetaObject = JsonUtil.getChildAsObject((JsonObject)pkgObject, (String)"pkgMeta")) != null) {
            if (name == null) {
                name = JsonUtil.getString((JsonObject)pkgMetaObject, (String)"name");
            }
            _release = JsonUtil.getString((JsonObject)pkgMetaObject, (String)"_release");
        }
        if ((updateElement = pkgObject.get("update")) != null && updateElement.isJsonObject()) {
            JsonObject updateObject = updateElement.getAsJsonObject();
            target = JsonUtil.getString((JsonObject)updateObject, (String)"target");
            latest = JsonUtil.getString((JsonObject)updateObject, (String)"latest");
        }
        if (name != null && !name.isEmpty()) {
            return new BowerInstalledPackage(name, (String)ObjectUtils.chooseNotNull((Object)target, (Object)_release), latest);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonContent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerInstalledPackagesParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doParsePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doParsePackages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

