/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.execution.ExecutionException;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.bower.BowerPackageBasicInfo;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerPackageUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.lang.javascript.bower.browsePackages.BowerPackageSearcher;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(BowerCompletionContributor.class);
    private static final List<String> DEPENDENCIES_NAMES = Arrays.asList("dependencies", "devDependencies");
    private static final Map<String, List<String>> ourVersionCache = CollectionFactory.createConcurrentSoftMap();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JsonFile packageJson;
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((packageJson = BowerPackageUtil.getContainingBowerJsonFile((PsiElement)parameters.getOriginalFile())) != null) {
            BowerCompletionContributor.completeDependencies(parameters, result2);
        }
    }

    @Nullable
    private static JsonProperty findEnclosingDependenciesProperty(@NotNull PsiElement element) {
        JsonProperty dependenciesProperty;
        JsonObject obj;
        if (element == null) {
            BowerCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((obj = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class, (boolean)false)) != null && (dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class)) != null && DEPENDENCIES_NAMES.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty)) {
            return dependenciesProperty;
        }
        return null;
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement element;
        JsonProperty dependenciesProperty;
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((dependenciesProperty = BowerCompletionContributor.findEnclosingDependenciesProperty(element = (PsiElement)ObjectUtils.notNull((Object)parameters.getOriginalPosition(), (Object)parameters.getPosition()))) != null) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element) {
                    PrioritizedLookupElement ple;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Double d = (ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element, PrioritizedLookupElement.class)) != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return d;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/bower/BowerCompletionContributor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/bower/BowerCompletionContributor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "weigh";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "weigh";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            result2 = result2.withRelevanceSorter(sorter);
            JsonProperty parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
            if (parentProperty == dependenciesProperty) {
                parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), JsonProperty.class);
            }
            if (parentProperty != null) {
                JsonValue nameElement = parentProperty.getNameElement();
                if (nameElement.getTextRange().containsOffset(parameters.getOffset())) {
                    int prefixLength = parameters.getOffset() - nameElement.getTextRange().getStartOffset();
                    String prefix = StringUtil.unquoteString((String)nameElement.getText().substring(0, prefixLength));
                    prefix = StringUtil.trimStart((String)prefix, (String)"\"");
                    BowerCompletionContributor.completeDependenciesNames(parameters, result2.withPrefixMatcher(prefix), prefix, parentProperty);
                } else {
                    result2 = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(result2.getPrefixMatcher().getPrefix()));
                    BowerCompletionContributor.completeDependenciesVersions(parameters, result2, parentProperty);
                }
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull String packageNamePrefix, @NotNull JsonProperty property) {
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(6);
        }
        if (packageNamePrefix == null) {
            BowerCompletionContributor.$$$reportNull$$$0(7);
        }
        if (property == null) {
            BowerCompletionContributor.$$$reportNull$$$0(8);
        }
        Set alreadyUsedNames = JsonPsiUtil.getOtherSiblingPropertyNames((JsonProperty)property);
        BowerPackageSearcher searcher = BowerPackageSearcher.getInstance();
        List<BowerPackageBasicInfo> popularPackages = searcher.findPopularPackagesByPrefix(packageNamePrefix, 10, (Condition<? super BowerPackageBasicInfo>)((Condition)info2 -> !alreadyUsedNames.contains(info2.getName())));
        AtomicInteger priority = new AtomicInteger(0);
        for (BowerPackageBasicInfo pkg : popularPackages) {
            BowerCompletionContributor.addPackageInfo(parameters, result2, pkg, priority.getAndIncrement());
        }
        Set popularPackageNames = ContainerUtil.map2Set(popularPackages, BowerPackageBasicInfo::getName);
        try {
            searcher.findPackagesByPrefix(ProgressManager.getInstance().getProgressIndicator(), packageNamePrefix, 10, (Condition<? super BowerPackageBasicInfo>)((Condition)info2 -> !alreadyUsedNames.contains(info2.getName()) && !popularPackageNames.contains(info2.getName())), (Consumer<? super BowerPackageBasicInfo>)((Consumer)info2 -> BowerCompletionContributor.addPackageInfo(parameters, result2, info2, priority.getAndIncrement())));
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching '" + packageNamePrefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            LOG.info("Cannot fetch '" + packageNamePrefix + "*' packages from registry", (Throwable)e);
        }
        result2.restartCompletionOnAnyPrefixChange();
    }

    private static <T> T runWithoutReadAction(@Nullable ProgressIndicator indicator, @NotNull Callable<? extends T> callable) throws Exception {
        if (callable == null) {
            BowerCompletionContributor.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (T)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
        }
        return callable.call();
    }

    private static void addPackageInfo(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, final @NotNull BowerPackageBasicInfo info2, int priority) {
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(11);
        }
        if (info2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(12);
        }
        Object lookupString = info2.getName() + " ";
        if (!BowerCompletionContributor.isInsideStringLiteral(parameters)) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)info2, (String)lookupString);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(info2.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info2.getDescription());
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info2.getName()));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(13);
        }
        return parameters.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull JsonProperty packageProperty) {
        List versions;
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(15);
        }
        if (packageProperty == null) {
            BowerCompletionContributor.$$$reportNull$$$0(16);
        }
        String packageName = StringUtil.unquoteString((String)packageProperty.getNameElement().getText());
        try {
            BowerSettings settings2 = BowerSettingsManager.getInstance(packageProperty.getProject()).getSettings();
            versions = Objects.requireNonNull(BowerCompletionContributor.runWithoutReadAction(ProgressManager.getInstance().getProgressIndicator(), () -> BowerCompletionContributor.getOrFetchVersions(packageName, settings2)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            LOG.info("Cannot get versions of '" + packageName + "'", (Throwable)e);
            return;
        }
        int order = 0;
        for (String version2 : versions) {
            BowerCompletionContributor.addVersionCompletionItem(parameters, result2, version2, order++);
        }
    }

    @NotNull
    private static List<String> getOrFetchVersions(@NotNull String packageName, @NotNull BowerSettings settings2) {
        List<String> list2;
        List<String> versions;
        if (packageName == null) {
            BowerCompletionContributor.$$$reportNull$$$0(17);
        }
        if (settings2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(18);
        }
        if ((versions = ourVersionCache.get(packageName)) != null) {
            List<String> list3 = versions;
            if (list3 == null) {
                BowerCompletionContributor.$$$reportNull$$$0(19);
            }
            return list3;
        }
        try {
            BowerPackageInfo info2 = BowerPackageUtil.loadPackageInfo(ProgressManager.getInstance().getProgressIndicator(), settings2, packageName);
            versions = info2.getVersions();
            ourVersionCache.put(packageName, versions);
            list2 = versions;
        }
        catch (ExecutionException e) {
            LOG.info("Cannot load versions for " + packageName + ": " + e.getMessage());
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                BowerCompletionContributor.$$$reportNull$$$0(21);
            }
            return list4;
        }
        if (list2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static void addVersionCompletionItem(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull String version2, int order) {
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(23);
        }
        if (version2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(24);
        }
        final String value = BowerCompletionContributor.getVersion(parameters, version2);
        String lookupString = BowerCompletionContributor.isInsideStringLiteral(parameters) ? value : StringUtil.wrapWithDoubleQuote((String)value);
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)version2, (String)lookupString);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(value);
                presentation.setTypeGrayed(true);
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder2.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    @NotNull
    private static String getVersion(@NotNull CompletionParameters parameters, @NotNull String version2) {
        String text2;
        PsiElement position;
        if (parameters == null) {
            BowerCompletionContributor.$$$reportNull$$$0(25);
        }
        if (version2 == null) {
            BowerCompletionContributor.$$$reportNull$$$0(26);
        }
        if ((position = parameters.getOriginalPosition()) != null && ((text2 = StringUtil.unquoteString((String)position.getText())).startsWith("~") || text2.startsWith("^"))) {
            String string = text2.charAt(0) + version2;
            if (string == null) {
                BowerCompletionContributor.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = version2;
        if (string == null) {
            BowerCompletionContributor.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 21, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageProperty";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerCompletionContributor";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerCompletionContributor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrFetchVersions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingDependenciesProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "completeDependencies";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithoutReadAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPackageInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "completeDependenciesVersions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrFetchVersions";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: {
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addVersionCompletionItem";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 21, 27, 28 -> new IllegalStateException(string);
        };
    }
}

