/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BowerCommandLineUtil {
    private static final Logger LOG = Logger.getInstance(BowerCommandLineUtil.class);
    private static final NullableLazyValue<File> TEMP_DIR = NullableLazyValue.lazyNullable(() -> {
        try {
            return FileUtil.createTempDirectory((String)"jetbrains-intellij-bower", null);
        }
        catch (IOException e) {
            LOG.warn("Cannot create temp dir", (Throwable)e);
            return null;
        }
    });

    private BowerCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput runBowerCommand(@Nullable ProgressIndicator indicator, @NotNull BowerSettings settings2, String ... commands) throws ExecutionException {
        if (settings2 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(0);
        }
        BowerCommandRun bowerCommandRun = BowerCommandLineUtil.startBowerCommand(settings2, commands);
        ProcessOutput processOutput = bowerCommandRun.captureOutput(indicator, TimeUnit.MINUTES.toMillis(10L));
        if (processOutput == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    public static BowerCommandRun startBowerCommand(@NotNull BowerSettings settings2, String ... commands) throws ExecutionException {
        if (settings2 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(2);
        }
        GeneralCommandLine commandLine = BowerCommandLineUtil.createCommandLine(settings2);
        commandLine.addParameters(commands);
        LOG.info("Running bower command: " + commandLine.getCommandLineString());
        return new BowerCommandRun((OSProcessHandler)new KillableColoredProcessHandler(commandLine));
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull BowerSettings settings2) throws ExecutionException {
        if (settings2 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(3);
        }
        NodeJsInterpreter interpreter = settings2.getInterpreter();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        File workingDir2 = BowerCommandLineUtil.getWorkingDir(settings2);
        if (workingDir2 != null) {
            commandLine.setWorkDirectory(workingDir2);
        } else {
            LOG.info("Working directory not specified");
        }
        File mainBowerJsFile = BowerCommandLineUtil.getMainBowerJsFile(settings2.getBowerPackage());
        commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(mainBowerJsFile.getAbsolutePath());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File getMainBowerJsFile(@NotNull NodePackage bowerPackage) throws ExecutionException {
        String errorMessage;
        if (bowerPackage == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(5);
        }
        if ((errorMessage = bowerPackage.getErrorMessage("bower")) != null) {
            throw new ExecutionException(errorMessage);
        }
        String path2 = "bin" + File.separator + "bower";
        File file = new File(bowerPackage.getSystemDependentPath(), path2);
        if (!file.isFile()) {
            throw new ExecutionException(JavaScriptBundle.message("bower.dialog.message.specify.package", path2));
        }
        File file2 = file;
        if (file2 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @Nullable
    private static File getWorkingDir(@NotNull BowerSettings settings2) {
        File bowerConfigFile;
        if (settings2 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(7);
        }
        if ((bowerConfigFile = new File(settings2.getBowerJsonPath())).isFile()) {
            return bowerConfigFile.getParentFile();
        }
        return (File)TEMP_DIR.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerCommandLineUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bowerPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerCommandLineUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "runBowerCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainBowerJsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runBowerCommand";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startBowerCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMainBowerJsFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }
}

