/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptionsKt;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterGuesserService;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.lang.javascript.ui.ProjectGeneratorSettingsCustomizer;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.ProjectTemplate;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Settings>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);
    private static final Key<Boolean> GENERATING = Key.create((String)(NpmPackageProjectGenerator.class.getSimpleName() + ".generating"));
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Project generator");

    protected abstract Filter @NotNull [] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @Deprecated(forRemoval=true)
    @NotNull
    protected String executable(String path2) {
        String string = this.executable(new NodePackage(path2));
        if (string == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        File file;
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(1);
        }
        return (file = pkg.findBinFile(pkg.getName(), null)) != null ? file.getAbsolutePath() : "";
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(3);
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    protected List<String> packageNames() {
        return Collections.singletonList(this.packageName());
    }

    @NotNull
    protected abstract String presentablePackageName();

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list2 = Collections.emptyList();
        if (list2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void generateApp(@NotNull NodeJsInterpreter node, @NotNull Settings settings2, @NotNull VirtualFile baseDir, @NotNull Project project) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(8);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(9);
        }
        File workingDir2 = this.workingDir(settings2, baseDir);
        ProcessHandler processHandler = NpmPackageProjectGenerator.generate(node, settings2.myPackage, (Function<? super NodePackage, String>)((Function)pkg -> this.executable((NodePackage)pkg)), baseDir, workingDir2, project, this.postInstall(project, baseDir, workingDir2), JavaScriptBundle.message("generating.0", baseDir.getName()), this.filters(project, baseDir), this.generatorArgs(project, baseDir, settings2));
        this.onProcessHandlerCreated(processHandler);
    }

    protected void onProcessHandlerCreated(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(10);
        }
    }

    protected String[] generatorArgs(Project project, VirtualFile dir, Settings settings2) {
        return this.generatorArgs(project, dir);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir2) {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(11);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(13);
        }
        Runnable runnable = this.postInstall(project, baseDir, workingDir2);
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(14);
        }
        return runnable;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir2) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(15);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(16);
        }
        Runnable runnable = () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.generateInTemp()) {
                try {
                    ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, JavaScriptBundle.message("copying.files", new Object[0]));
                    FileUtil.copyDir((File)new File(workingDir2, baseDir.getName()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                finally {
                    ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
                }
            }
            if (project.isDisposed()) {
                return;
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> this.onGettingSmartAfterProjectGeneration(project, baseDir));
            DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                NpmPackageProjectGenerator.initBuildfiles(project);
                ((JSLinterGuesserService)project.getService(JSLinterGuesserService.class)).guessLinters(true);
            });
        });
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(17);
        }
        return runnable;
    }

    @RequiresEdt
    protected void onGettingSmartAfterProjectGeneration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(18);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static void initBuildfiles(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.softAssertReadAccess();
        NpmScriptsService instance = NpmScriptsService.getInstance(project);
        List<VirtualFile> buildfiles = instance.detectAllBuildfiles();
        if (!buildfiles.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (VirtualFile buildfile : buildfiles) {
                    instance.getFileManager().addBuildfile(buildfile);
                }
                instance.getToolWindowManager().setAvailable();
            });
        }
    }

    @Deprecated(forRemoval=true)
    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path2, @NotNull VirtualFile baseDir, @NotNull File workingDir2, @NotNull Project project, @Nullable Runnable callback, Filter @NotNull [] filters, String ... args) throws ExecutionException {
        VirtualFile file;
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(21);
        }
        if (path2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(22);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(23);
        }
        if (workingDir2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(24);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(25);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(26);
        }
        VirtualFile packageJson = (file = LocalFileSystem.getInstance().findFileByPath(path2)) != null ? PackageJsonUtil.findUpPackageJson(file) : null;
        VirtualFile dir = packageJson != null ? packageJson.getParent() : null;
        NodePackage pkg = dir != null ? new NodePackage(dir.getPath()) : new NodePackage(path2);
        NpmPackageProjectGenerator.generate((NodeJsInterpreter)node, pkg, (Function<? super NodePackage, String>)((Function)p -> path2), baseDir, workingDir2, project, callback, JavaScriptBundle.message("generating.0", baseDir.getName()), filters, args);
    }

    @RequiresBackgroundThread
    @NotNull
    public static ProcessHandler generate(@NotNull NodeJsInterpreter node, @NotNull NodePackage pkg, @NotNull Function<? super NodePackage, String> binFilePathProvider, final @NotNull VirtualFile baseDir, @NotNull File workingDir2, final @NotNull Project project, final @Nullable Runnable callback, @NotNull @NlsContexts.TabTitle String title, Filter @NotNull [] filters, String ... args) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(27);
        }
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(28);
        }
        if (binFilePathProvider == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(29);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(30);
        }
        if (workingDir2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(31);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(32);
        }
        if (title == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(33);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(34);
        }
        ThreadingAssertions.assertBackgroundThread();
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(null, null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        boolean useConsoleViewImpl = Boolean.getBoolean("npm.project.generators.ConsoleViewImpl");
        NodeTargetRun targetRun = new NodeTargetRun(node, project, null, NodeTargetRunOptionsKt.targetRunOptions(!useConsoleViewImpl));
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        if (pkg instanceof NpxPackageDescriptor.NpxNodePackage) {
            NpxPackageDescriptor.NpxNodePackage npxPkg = (NpxPackageDescriptor.NpxNodePackage)pkg;
            NpmNodePackage npxBinaryFilePackage = npxPkg.getNpxBinaryFilePackageOrThrow(node);
            npxBinaryFilePackage.configureNpmPackage(targetRun, new String[0]);
            commandLine.addParameters(((NpxPackageDescriptor.NpxNodePackage)pkg).blockingGetArguments(node));
        } else if (pkg instanceof NpmNodePackage) {
            ((NpmNodePackage)pkg).configureNpmPackage(targetRun, new String[0]);
        } else {
            commandLine.addParameter(targetRun.path((String)binFilePathProvider.fun((Object)pkg)));
        }
        commandLine.addParameters(args);
        commandLine.setWorkingDirectory(targetRun.path(workingDir2.getPath()));
        final ProcessHandler handler = targetRun.startProcess();
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, JavaScriptBundle.message("project.generation", new Object[0]));
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                baseDir.refresh(false, true);
                baseDir.getChildren();
                handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                done.run();
                GENERATING.set((UserDataHolder)project, null);
                if (callback != null) {
                    callback.run();
                }
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$1", "processTerminated"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> NpmPackageProjectGenerator.showConsole(handler, project, List.of(filters), title));
        ProcessHandler processHandler = handler;
        if (processHandler == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(35);
        }
        return processHandler;
    }

    @RequiresEdt
    private static void showConsole(@NotNull ProcessHandler processHandler, @NotNull Project project, @NotNull List<Filter> filters, @NotNull @NlsContexts.TabTitle String title) {
        if (processHandler == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(36);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(37);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(38);
        }
        if (title == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(39);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ConsoleView console = NodeCommandLineUtil.createConsole(processHandler, project, false);
        for (Filter filter : filters) {
            console.addMessageFilter(filter);
        }
        console.attachToProcess(processHandler);
        ConsoleProgress.install(console, processHandler);
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)JSDisposable.getInstance(project));
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, processHandler, console.getComponent(), title);
        descriptor.setAutoFocusContent(true);
        RunContentManager.getInstance((Project)project).showRunContent(defaultExecutor, descriptor);
        processHandler.startNotify();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings2, @NotNull Module module) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(40);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(41);
        }
        if (settings2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(42);
        }
        if (module == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(43);
        }
        NodeJsInterpreter interpreter = settings2.myInterpreterRef.resolve(project);
        assert (interpreter != null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        StartupManager.getInstance((Project)project).runAfterOpened(() -> NodeJsDownloadService.getInstance().ensureInstalled(null, interpreter, node -> {
            NodeJsInterpreterRef ref = node != interpreter ? NodeJsInterpreterRef.create(node) : settings2.myInterpreterRef;
            NodeJsInterpreterManager.getInstance(project).setInterpreterRef(ref);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.generateApp((NodeJsInterpreter)node, settings2, baseDir, project);
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                        this.customizeModule(baseDir, entry);
                        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)model).commit());
                        project.save();
                    });
                }
                catch (ExecutionException e) {
                    NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("notification.title.cannot.generate", this.getName()), StringUtil.notNullize((String)StringUtil.getMessage((Throwable)e)), NotificationType.ERROR).notify(project);
                    LOG.warn((Throwable)e);
                }
            });
        }));
    }

    @NotNull
    public ProjectGeneratorPeer<Settings> createPeer() {
        return new NpmPackageGeneratorPeer();
    }

    @NotNull
    protected File workingDir(Settings settings2, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(44);
        }
        if (this.generateInTemp()) {
            File file = Files.createTempDir();
            if (file == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(45);
            }
            return file;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (file == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(46);
        }
        return file;
    }

    protected boolean generateInTemp() {
        return false;
    }

    @NlsContexts.DialogMessage
    protected String validateProjectPath(@NotNull String path2) {
        if (path2 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(47);
        }
        return null;
    }

    public static boolean isGenerating(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(48);
        }
        return GENERATING.get((UserDataHolder)project) == Boolean.TRUE;
    }

    protected boolean allowDownload() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 1: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 25: 
            case 32: 
            case 37: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 30: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 22: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 26: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binFilePathProvider";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateApp";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onProcessHandlerCreated";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onGettingSmartAfterProjectGeneration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initBuildfiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showConsole";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isGenerating";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48 -> new IllegalArgumentException(string);
        };
    }

    public static class Settings
    extends UserDataHolderBase {
        public final NodeJsInterpreterRef myInterpreterRef;
        public final NodePackageRef myPackageRef;
        public final NodePackage myPackage;

        public Settings(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull NodePackage pkg) {
            if (interpreterRef == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (pkg == null) {
                Settings.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            this.myPackageRef = NodePackageRef.create(pkg);
            this.myPackage = pkg;
        }

        public Settings(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull NodePackageRef pkgRef, @NotNull NodePackage pkg) {
            if (interpreterRef == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (pkgRef == null) {
                Settings.$$$reportNull$$$0(3);
            }
            if (pkg == null) {
                Settings.$$$reportNull$$$0(4);
            }
            this.myInterpreterRef = interpreterRef;
            this.myPackageRef = pkgRef;
            this.myPackage = pkg;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreterRef";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkgRef";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class NpmPackageGeneratorPeer
    implements ProjectGeneratorPeer<Settings> {
        private final JPanel myPanel;
        @NotNull
        private final List<String> myPackageNames;
        @NotNull
        @NlsSafe
        private final String myPresentablePackageName;
        private NodeJsInterpreterField myInterpreterField;
        private NodePackageField myPackageField;
        private Supplier<String> myProjectRootPathSupplier = () -> null;

        public NpmPackageGeneratorPeer() {
            this.myPackageNames = NpmPackageProjectGenerator.this.packageNames();
            this.myPresentablePackageName = NpmPackageProjectGenerator.this.presentablePackageName();
            this.myPanel = this.createPanel();
        }

        protected NodePackageField getPackageField() {
            return this.myPackageField;
        }

        protected JPanel createPanel() {
            this.myInterpreterField = this.createAndInitInterpreterField(ProjectManager.getInstance().getDefaultProject());
            this.myPackageField = this.createAndInitPackageField(this.myInterpreterField);
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            LabeledComponent interpreterComponent = LabeledComponent.create((JComponent)((Object)this.myInterpreterField), (String)NodeJsInterpreterField.getLabelTextForComponent(), (String)"West");
            LabeledComponent packageComponent = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)this.myPresentablePackageName, (String)"West");
            packageComponent.setAnchor((JComponent)interpreterComponent);
            panel2.add((Component)interpreterComponent);
            panel2.add((Component)packageComponent);
            return panel2;
        }

        @NotNull
        private NodeJsInterpreterField createAndInitInterpreterField(Project project) {
            NodeDownloadableInterpreterType downloadableType = NodeDownloadableInterpreterType.getInstance();
            boolean withDownload = NpmPackageProjectGenerator.this.allowDownload() && downloadableType.isActive();
            NodeJsInterpreterField interpreter = new NodeJsInterpreterField(project, true, withDownload){

                @Override
                public boolean isDefaultProjectInterpreterField() {
                    return true;
                }
            };
            if (withDownload) {
                interpreter.setInterpreterRef(NodeJsInterpreterRef.create(downloadableType.getInterpreters().iterator().next()));
            } else {
                interpreter.setInterpreterRef(NodeJsInterpreterManager.getInstance(project).getInterpreterRef());
            }
            NodeJsInterpreterField nodeJsInterpreterField = interpreter;
            if (nodeJsInterpreterField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(0);
            }
            return nodeJsInterpreterField;
        }

        @NotNull
        protected NodePackageField createAndInitPackageField(@NotNull NodeJsInterpreterField interpreterField) {
            if (interpreterField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(1);
            }
            List<NpxPackageDescriptor.NpxCommand> npxCommands = NpmPackageProjectGenerator.this.getNpxCommands();
            NodePackageField packageField = new NodePackageField(this.myInterpreterField, new NpxPackageDescriptor(this.myPackageNames, npxCommands), null);
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            packageField.setEnabled(false);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                NodePackage pkg = this.calcPreferredPackage(npxCommands, interpreter);
                ApplicationManager.getApplication().invokeLater(() -> {
                    packageField.setEnabled(true);
                    packageField.setSelected(pkg);
                }, ModalityState.any(), interpreterField.getProject().getDisposed());
            });
            NodePackageField nodePackageField = packageField;
            if (nodePackageField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(2);
            }
            return nodePackageField;
        }

        @NotNull
        private NodePackage calcPreferredPackage(@NotNull List<NpxPackageDescriptor.NpxCommand> npxCommands, @Nullable NodeJsInterpreter interpreter) {
            NpxPackageDescriptor.NpxNodePackage npxPackage;
            NpxPackageDescriptor.NpxCommand npxCommand;
            if (npxCommands == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(3);
            }
            if ((npxCommand = (NpxPackageDescriptor.NpxCommand)ContainerUtil.getFirstItem(npxCommands)) != null && (npxPackage = NpxPackageDescriptor.createIfAvailable(interpreter, npxCommand)) != null) {
                NpxPackageDescriptor.NpxNodePackage npxNodePackage = npxPackage;
                if (npxNodePackage == null) {
                    NpmPackageGeneratorPeer.$$$reportNull$$$0(4);
                }
                return npxNodePackage;
            }
            NodePackage nodePackage = NodePackage.findPreferredPackage(this.myInterpreterField.getProject(), this.myPackageNames, interpreter);
            if (nodePackage == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(5);
            }
            return nodePackage;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(6);
            }
            return jPanel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            ModuleNameLocationSettings locationSettings;
            if (settingsStep == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(7);
            }
            if ((locationSettings = settingsStep.getModuleNameLocationSettings()) != null) {
                this.myProjectRootPathSupplier = () -> ((ModuleNameLocationSettings)locationSettings).getModuleContentRoot();
            }
            settingsStep.addSettingsField(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myInterpreterField));
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName), (JComponent)((Object)this.myPackageField));
            this.addExtraFields(settingsStep);
            ProjectGeneratorSettingsCustomizer settingsCustomizer = ProjectGeneratorSettingsCustomizer.getCustomizer(NpmPackageProjectGenerator.this.getId());
            if (settingsCustomizer != null) {
                settingsCustomizer.addExtraFields(settingsStep);
            }
        }

        protected void addExtraFields(@NotNull SettingsStep settingsStep) {
            if (settingsStep == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(8);
            }
        }

        @NotNull
        public Settings getSettings() {
            return new Settings(this.myInterpreterField.getInterpreterRef(), this.myPackageField.getSelectedRef(), this.myPackageField.getSelected());
        }

        @Nullable
        public ValidationInfo validate() {
            String validateMessage;
            String validateInterpreterMessage;
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            if (interpreter == null) {
                return new ValidationInfo(JavaScriptBundle.message("dialog.message.node.interpreter.unspecified.error.text", new Object[0]), (JComponent)((Object)this.myInterpreterField));
            }
            String projectRootPath = this.myProjectRootPathSupplier.get();
            if (projectRootPath != null && (validateInterpreterMessage = NpmPackageGeneratorPeer.validateInterpreterIsSuitableForProjectPath(interpreter, projectRootPath)) != null) {
                return new ValidationInfo(validateInterpreterMessage, (JComponent)((Object)this.myInterpreterField));
            }
            String error = interpreter.validate(null);
            if (error != null) {
                return new ValidationInfo(error, (JComponent)((Object)this.myInterpreterField));
            }
            NodePackage pkg = this.myPackageField.getSelected();
            String pkgError = pkg.validateAndGetErrorMessage(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName), null, interpreter);
            if (pkgError != null) {
                return new ValidationInfo(pkgError, (JComponent)((Object)this.myPackageField));
            }
            String string = validateMessage = projectRootPath != null ? NpmPackageProjectGenerator.this.validateProjectPath(projectRootPath) : null;
            if (validateMessage != null) {
                return new ValidationInfo(validateMessage);
            }
            return null;
        }

        @Nullable
        @Nls
        private static String validateInterpreterIsSuitableForProjectPath(@NotNull NodeJsInterpreter interpreter, @NotNull String projectRootPath) {
            WslPath projectRootWslPath;
            if (interpreter == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(9);
            }
            if (projectRootPath == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(10);
            }
            if (SystemInfo.isWindows && (projectRootWslPath = WslPath.parseWindowsUncPath((String)projectRootPath)) != null) {
                if (!(interpreter instanceof WslNodeInterpreter)) {
                    return JavaScriptBundle.message("dialog.message.node.interpreter.must.be.located.in.wsl", new Object[0]);
                }
                if (!projectRootWslPath.getDistributionId().equals(((WslNodeInterpreter)interpreter).getWslDistributionId())) {
                    return JavaScriptBundle.message("dialog.message.node.interpreter.is.located.in.another.wsl.distribution", new Object[0]);
                }
            }
            return null;
        }

        public boolean isBackgroundJobRunning() {
            return false;
        }

        public void addSettingsListener(@NotNull ProjectGeneratorPeer.SettingsListener listener2) {
            if (listener2 == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(11);
            }
            this.myInterpreterField.addChangeListener(interpreter -> listener2.stateChanged(this.validate() == null));
            this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> listener2.stateChanged(this.validate() == null)));
            listener2.stateChanged(this.validate() == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 7, 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterField";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npxCommands";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsStep";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectRootPath";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitInterpreterField";
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitPackageField";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcPreferredPackage";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createAndInitPackageField";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPreferredPackage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUI";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraFields";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "validateInterpreterIsSuitableForProjectPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addSettingsListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }
    }
}

