/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementArrangementEntry
extends DefaultArrangementEntry
implements JSArrangementEntry,
TypeAwareArrangementEntry,
ModifierAwareArrangementEntry,
NameAwareArrangementEntry {
    private final String myName;
    @NotNull
    private Set<? extends ArrangementSettingsToken> myTypes;
    @NotNull
    private Set<? extends ArrangementSettingsToken> myModifiers;
    private final Language myLanguage;

    public JSElementArrangementEntry(@Nullable ArrangementEntry parent, @NotNull Language language, @Nullable String name, @NotNull Set<? extends ArrangementSettingsToken> types2, @NotNull Set<? extends ArrangementSettingsToken> modifiers, @NotNull TextRange range, boolean canBeMatched) {
        if (language == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(1);
        }
        if (modifiers == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(2);
        }
        if (range == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(3);
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), canBeMatched);
        this.myName = name;
        this.myTypes = types2;
        this.myModifiers = modifiers;
        this.myLanguage = language;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setType(@NotNull ArrangementSettingsToken type2) {
        if (type2 == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(4);
        }
        this.myTypes = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type2});
    }

    @Nullable
    public ArrangementSettingsToken getType() {
        return (ArrangementSettingsToken)ContainerUtil.getFirstItem(this.myTypes);
    }

    @NotNull
    public Set<? extends ArrangementSettingsToken> getTypes() {
        Set<? extends ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void setModifiers(@NotNull Set<? extends ArrangementSettingsToken> modifiers) {
        if (modifiers == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(6);
        }
        this.myModifiers = modifiers;
    }

    @NotNull
    public Set<? extends ArrangementSettingsToken> getModifiers() {
        Set<? extends ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(8);
        }
        return language;
    }

    public String toString() {
        return "JSArrangementEntry{myName='" + this.myName + "', myType=" + this.myTypes + ", myModifiers=" + this.myModifiers + ", dependencies=[" + StringUtil.join((Collection)ContainerUtil.notNullize((List)this.getDependencies()), JSElementArrangementEntry::getNameOrNull, (String)", ") + "], startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndOffset() + "}";
    }

    @Nullable
    private static String getNameOrNull(ArrangementEntry o) {
        NameAwareArrangementEntry entry = o instanceof NameAwareArrangementEntry ? (NameAwareArrangementEntry)o : null;
        return entry != null ? entry.getName() : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

