/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptASTFactory;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptParserDefinition
extends ASTFactory
implements ParserDefinition {
    private static final JavascriptASTFactory ourAstFactory = new JavascriptASTFactory();

    @NotNull
    public Lexer createLexer(Project project) {
        return new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        JSFileElementType jSFileElementType = JSFileElementTypes.FILE;
        if (jSFileElementType == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(0);
        }
        return jSFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSTokenTypes.COMMENTS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavascriptParserDefinition.this.createJSParser(builder2).parseJS(root);
                ASTNode aSTNode = builder2.getTreeBuilt();
                if (aSTNode == null) {
                    1.$$$reportNull$$$0(2);
                }
                return aSTNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parse";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "parse";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public JavaScriptParser<?, ?, ?, ?> createJSParser(@NotNull PsiBuilder builder2) {
        Object parser2;
        Language language;
        if (builder2 == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(4);
        }
        if ((language = this.getFileNodeType().getLanguage()) instanceof JSLanguageDialect && (parser2 = ((JSLanguageDialect)language).createParser(builder2)) instanceof JavaScriptParser) {
            JavaScriptParser javaScriptParser = (JavaScriptParser)parser2;
            if (javaScriptParser == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(5);
            }
            return javaScriptParser;
        }
        return new JSXParser(JavaScriptSupportLoader.ECMA_SCRIPT_6, builder2);
    }

    @Nullable
    public Lexer createLexerForLazyParse(@NotNull Project project, @NotNull Language language, @NotNull ASTNode chameleon) {
        if (project == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(6);
        }
        if (language == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(7);
        }
        if (chameleon == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(9);
        }
        return new JSFileImpl(viewProvider, this.getFileNodeType().getLanguage());
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(10);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(11);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == JSTokenTypes.XML_LBRACE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(12);
            }
            return spaceRequirements;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        if (spaceRequirements == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(13);
        }
        return spaceRequirements;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Object element;
        IElementType type2;
        if (node == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(14);
        }
        if (JSElementTypes.XML_LITERAL_EXPRESSION == (type2 = node.getElementType())) {
            if (!(node instanceof PsiElement)) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            PsiElement psiElement = (PsiElement)node;
            if (psiElement == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        if (type2 instanceof PsiGenerator && (element = ((PsiGenerator)type2).construct(node)) != null) {
            Object t = element;
            if (t == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(16);
            }
            return t;
        }
        if (type2 == JSTokenTypes.DOC_COMMENT) {
            return new JSDocCommentImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    @Nullable
    public CompositeElement createComposite(@NotNull IElementType type2) {
        if (type2 == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(17);
        }
        if (type2 == JSElementTypes.XML_TEXT || type2 == JSElementTypes.XML_ATTRIBUTE_VALUE) {
            return ourAstFactory.createComposite(type2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 8, 9, 14, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSParser";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJSParser";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLexerForLazyParse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 8, 9, 14, 17 -> new IllegalArgumentException(string);
        };
    }
}

