/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMinifiedFileUtil {
    private static final int MINIFIED_FLAG_GIST_VERSION = 1;
    private static final Key<Pair<Long, Boolean>> MINIFIED_STATUS_OF_DOCUMENT_KEY = Key.create((String)"js.minified.status.of.document");
    private static final Key<Pair<Long, Boolean>> MINIFIED_STATUS_OF_FILE_KEY = Key.create((String)"js.cached.minified.of.file");
    private static final TokenSet NO_WHITESPACE_REQUIRED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)JSKeywordSets.IDENTIFIER_NAMES), TokenSet.andNot((TokenSet)JSTokenTypes.COMMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT})), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.ANY_IDENTIFIER})});
    private static final TokenSet NO_WHITESPACE_REQUIRED_BEFORE = TokenSet.orSet((TokenSet[])new TokenSet[]{NO_WHITESPACE_REQUIRED_AFTER, JSTokenTypes.COMMENTS, JSTokenTypes.STRING_LITERALS});
    private static final TokenSet STRING_LITERAL_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART})});
    private static final VirtualFileGist<Boolean> MINIFIED_CONTENT_GIST = GistManager.getInstance().newVirtualFileGist("js.minified.store", 1, (DataExternalizer)BooleanDataDescriptor.INSTANCE, (project, file) -> {
        CharSequence content = JSMinifiedFileUtil.calcFileContent(file);
        return JSMinifiedFileUtil.calculateIsMinified(content);
    });

    private static boolean calculateIsMinified(@NotNull CharSequence content) {
        if (content == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(0);
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        return MinifiedFilesUtil.isMinified((CharSequence)content, (ParserDefinition)def, (TokenSet)NO_WHITESPACE_REQUIRED_BEFORE, (TokenSet)NO_WHITESPACE_REQUIRED_AFTER, (TokenSet)STRING_LITERAL_TYPES);
    }

    public static boolean isFileMinified(@NotNull VirtualFile file, @NotNull Project project) {
        JSLibraryManager libraryManager;
        ThreeState isExplicitlyCompact;
        if (file == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(2);
        }
        if ((isExplicitlyCompact = (libraryManager = JSLibraryManager.getInstance(project)).getFileState(file)) == ThreeState.YES) {
            return true;
        }
        if (isExplicitlyCompact == ThreeState.NO) {
            return false;
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    public static boolean isFileContentMinified(@NotNull VirtualFile file) {
        Document document2;
        long documentTimeStamp;
        if (file == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(3);
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (file instanceof HttpVirtualFile) {
            RemoteFileInfo info2 = ((HttpVirtualFile)file).getFileInfo();
            if (info2 == null || info2.getState() != RemoteFileState.DOWNLOADED) {
                return false;
            }
            VirtualFile localFile = info2.getLocalFile();
            if (localFile == null) {
                return false;
            }
            file = localFile;
        }
        long l = documentTimeStamp = (document2 = FileDocumentManager.getInstance().getCachedDocument(file)) != null ? document2.getModificationStamp() : -1L;
        if (document2 != null && FileDocumentManager.getInstance().isDocumentUnsaved(document2)) {
            Pair status = (Pair)MINIFIED_STATUS_OF_DOCUMENT_KEY.get((UserDataHolder)document2);
            if (status != null && (Long)status.getFirst() == documentTimeStamp) {
                return (Boolean)status.getSecond();
            }
            boolean isMinified = JSMinifiedFileUtil.calculateIsMinified(document2.getCharsSequence());
            MINIFIED_STATUS_OF_DOCUMENT_KEY.set((UserDataHolder)document2, (Object)Pair.create((Object)documentTimeStamp, (Object)isMinified));
            return isMinified;
        }
        Pair status = (Pair)MINIFIED_STATUS_OF_FILE_KEY.get((UserDataHolder)file);
        long fileTimeStamp = file.getTimeStamp();
        if (status != null && (Long)status.getFirst() == fileTimeStamp) {
            return (Boolean)status.getSecond();
        }
        boolean isMinified = JSMinifiedFileUtil.checkAndPersistFileContentMinified(file);
        MINIFIED_STATUS_OF_FILE_KEY.set((UserDataHolder)file, (Object)Pair.create((Object)fileTimeStamp, (Object)isMinified));
        return isMinified;
    }

    @NotNull
    private static CharSequence calcFileContent(@NotNull VirtualFile file) {
        CharSequence charSequence;
        if (file == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(4);
        }
        try {
            charSequence = LoadTextUtil.loadText((VirtualFile)file, (int)0x100000);
        }
        catch (Exception e) {
            return "";
        }
        if (charSequence == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    private static boolean checkAndPersistFileContentMinified(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        if (FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) != JavaScriptFileType.INSTANCE) {
            return false;
        }
        if (fileName.contains(".min.")) {
            return true;
        }
        if (fileName.contains(".dev.")) {
            return false;
        }
        return (Boolean)MINIFIED_CONTENT_GIST.getFileData(null, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSMinifiedFileUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSMinifiedFileUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsMinified";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileMinified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFileContentMinified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcFileContent";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

