/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JavaScriptDialectFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.SubstitutedFileType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DialectDetector {
    public static final FilePropertyKey<String> KEY = FilePropertyKeyImpl.createPersistentStringKey((String)"JS_LANGUAGE_LEVEL", (FileAttribute)new FileAttribute("js_language_level_persistence", 5, true));
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = new FileType[]{JavaScriptSupportLoader.JAVASCRIPT, ES6FileType.INSTANCE, JSXHarmonyFileType.INSTANCE, FlowJSFileType.INSTANCE};
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = List.of(JAVASCRIPT_FILE_TYPES_ARRAY);
    private static final Key<ParameterizedCachedValue<JSLanguageDialect, PsiFile>> KEY_DIALECT_HOLDER = Key.create((String)"JavaScript.Dialect.Holder");
    private static final ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile> PROVIDER = file -> CachedValueProvider.Result.create((Object)((Object)DialectDetector.dialectOfFileNoCache(file)), (Object[])new Object[]{file});

    private DialectDetector() {
    }

    @Nullable
    public static DialectOptionHolder dialectOfElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).getOptionHolder() : null;
    }

    public static boolean hasFeature(@Nullable PsiElement element, @NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectDetector.$$$reportNull$$$0(0);
        }
        return element != null && DialectDetector.hasFeature(DialectDetector.dialectOfElement(element), feature);
    }

    public static boolean hasFeature(@Nullable DialectOptionHolder optionHolder, @NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectDetector.$$$reportNull$$$0(1);
        }
        return optionHolder != null && optionHolder.hasFeature(feature);
    }

    @Nullable
    private static JSLanguageDialect dialectOfFileNoCache(@NotNull PsiFile file) {
        JSLanguageDialect dialect;
        Language language;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(2);
        }
        if ((language = file.getLanguage()) instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        if (language == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (JavaScriptSupportLoader.isMxmlOrFxgFile(file)) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile != null && ("swf".equalsIgnoreCase(virtualFile.getExtension()) || "swc".equalsIgnoreCase(virtualFile.getExtension()))) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null && (dialect = DialectDetector.getLanguageDialect(virtualFile, file.getProject())) != null) {
            return dialect;
        }
        return null;
    }

    @NotNull
    public static Language languageOfElement(@NotNull PsiElement element) {
        PsiFile file;
        PsiElement context2;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(3);
        }
        if (element instanceof LeafPsiElement && (context2 = element.getContext()) instanceof JSElement) {
            Language language = context2.getLanguage();
            if (language == null) {
                DialectDetector.$$$reportNull$$$0(4);
            }
            return language;
        }
        if (element instanceof XmlElement && JavaScriptSupportLoader.isMxmlOrFxgFile(file = element.getContainingFile())) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(5);
            }
            return jSLanguageDialect;
        }
        Language language = element.getLanguage();
        if (language == null) {
            DialectDetector.$$$reportNull$$$0(6);
        }
        return language;
    }

    @NotNull
    public static Language calculateJSLanguage(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(7);
        }
        if (element instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(8);
            }
            return jSLanguageDialect;
        }
        if (element instanceof PsiFile) {
            return DialectDetector.getJSDialectOfFile((PsiFile)element);
        }
        if (element instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            PsiFile file = element.getContainingFile();
            Object object = file instanceof JSFile ? file.getLanguage() : JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element).getElementType(), file, element.getProject());
            if (object == null) {
                DialectDetector.$$$reportNull$$$0(9);
            }
            return object;
        }
        for (parent = element.getContext(); parent != null; parent = parent.getContext()) {
            if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl || parent instanceof JSEmbeddedContent) {
                Language language = parent.getLanguage();
                if (language == null) {
                    DialectDetector.$$$reportNull$$$0(10);
                }
                return language;
            }
            if (!(parent instanceof PsiFile)) continue;
            return DialectDetector.getJSDialectOfFile((PsiFile)parent);
        }
        if (!element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            DialectDetector.$$$reportNull$$$0(11);
        }
        return javascriptLanguage;
    }

    @NotNull
    private static JSLanguageDialect getJSDialectOfFile(@NotNull PsiFile file) {
        JSLanguageDialect dialect;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(12);
        }
        JSLanguageDialect jSLanguageDialect = (dialect = (JSLanguageDialect)((Object)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, KEY_DIALECT_HOLDER, PROVIDER, false, (Object)file))) != null ? dialect : JavascriptLanguage.INSTANCE;
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(13);
        }
        return jSLanguageDialect;
    }

    @Nullable
    public static JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element) {
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(14);
        }
        for (Language language = DialectDetector.languageOfElement(element); language != null; language = language.getBaseLanguage()) {
            if (!(language instanceof JSLanguageDialect)) continue;
            return (JSLanguageDialect)language;
        }
        return null;
    }

    public static boolean isTypeScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(15);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isTypeScript;
    }

    public static boolean isActionScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(16);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == DialectOptionHolder.ECMA_4;
    }

    public static boolean isJavaScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(17);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == null || dialect.isJavaScript();
    }

    public static boolean isJavaScriptFamily(@NotNull PsiElement element) {
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(18);
        }
        return !DialectDetector.isActionScript(element);
    }

    public static boolean hasJSSyntax(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(19);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.hasJSSyntax();
    }

    public static boolean isES6(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(20);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isECMA6;
    }

    public static boolean isES6OrES6Target(@NotNull PsiElement element) {
        TypeScriptConfig config;
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(21);
        }
        if ((dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isTypeScript && (config = TypeScriptConfigService.Provider.get(element.getProject()).getPreferableConfig(element.getContainingFile().getVirtualFile())) != null) {
            return config.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6 || config.getLanguageTarget() == TypeScriptConfig.LanguageTarget.NEXT;
        }
        return dialect != null && dialect.isECMA6;
    }

    public static boolean isFlow(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(22);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isFlow;
    }

    @Contract(value="null->false")
    public static boolean isJSX(@Nullable PsiElement element) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isJSX();
    }

    @Nullable
    public static JSLanguageDialect getJSLanguageFromFileType(@NotNull VirtualFile file) {
        FileType type2;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(23);
        }
        Language language = (type2 = file.getFileType()) instanceof LanguageFileType ? ((LanguageFileType)type2).getLanguage() : null;
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        JSLanguageDialect jsDialect;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(24);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(25);
        }
        if ((jsDialect = DialectDetector.getLanguageDialectForJSFile(file, project)) != null) {
            return jsDialect;
        }
        jsDialect = DialectDetector.getJSLanguageFromFileType(file);
        if (jsDialect != null) {
            return jsDialect;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        FileType type2;
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(26);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(27);
        }
        if ((type2 = SubstitutedFileType.substituteFileType((VirtualFile)file, (FileType)file.getFileType(), (Project)project)) instanceof SubstitutedFileType) {
            type2 = ((SubstitutedFileType)type2).getFileType();
        }
        if (JAVASCRIPT_FILE_TYPES.contains(type2)) {
            JSLanguageLevel configuredJSLevel = DialectDetector.getConfiguredJSLevel(file, project);
            JSLanguageDialect fileSpecialLanguage = type2 instanceof JavaScriptDialectFileType ? ((JavaScriptDialectFileType)type2).getDefaultLanguage() : null;
            return DialectDetector.getCombinedLanguageDialect(configuredJSLevel, fileSpecialLanguage);
        }
        return null;
    }

    @NotNull
    public static JSLanguageDialect getCombinedLanguageDialect(@NotNull JSLanguageLevel configuredLanguage, @Nullable JSLanguageDialect fileSpecialLanguage) {
        if (configuredLanguage == null) {
            DialectDetector.$$$reportNull$$$0(28);
        }
        if (fileSpecialLanguage == null || configuredLanguage.getDialect().isAtLeast(fileSpecialLanguage)) {
            JSLanguageDialect jSLanguageDialect = configuredLanguage.getDialect();
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(29);
            }
            return jSLanguageDialect;
        }
        JSLanguageDialect jSLanguageDialect = fileSpecialLanguage;
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(30);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public static JSLanguageLevel getConfiguredJSLevel(@Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(31);
        }
        VirtualFile virtualFile = file != null ? file.getViewProvider().getVirtualFile() : null;
        return DialectDetector.getConfiguredJSLevel(virtualFile, project);
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file) {
        if (file == null) {
            DialectDetector.$$$reportNull$$$0(32);
        }
        return DialectDetector.getConfiguredJSVersion(file.getViewProvider().getVirtualFile(), file.getProject());
    }

    @NotNull
    public static JSLanguageLevel getConfiguredJSLevel(@Nullable VirtualFile file, @NotNull Project project) {
        VirtualFile originalFile;
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(33);
        }
        if (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        JSLanguageLevel configuredLevel = null;
        if (file != null) {
            VirtualFile parent = file.getParent();
            String level = (String)KEY.getPersistentValue(parent);
            JSLanguageLevel jSLanguageLevel = configuredLevel = level == null ? null : JSLanguageLevel.ofId(level);
        }
        if (configuredLevel == null) {
            JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
            configuredLevel = configuration != null ? configuration.getLanguageLevel() : JSLanguageLevel.DEFAULT;
        }
        JSLanguageLevel jSLanguageLevel = configuredLevel;
        if (jSLanguageLevel == null) {
            DialectDetector.$$$reportNull$$$0(34);
        }
        return jSLanguageLevel;
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(35);
        }
        JSLanguageDialect jSLanguageDialect = DialectDetector.getConfiguredJSLevel(file, project).getDialect();
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(36);
        }
        return jSLanguageDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10, 11, 13, 29, 30, 34, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 12: 
            case 23: 
            case 24: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuredLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "languageOfElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateJSLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSDialectOfFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedLanguageDialect";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredJSLevel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredJSVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfFileNoCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "languageOfElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 29: 
            case 30: 
            case 34: 
            case 36: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateJSLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJSDialectOfFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "languageDialectOfElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScript";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isActionScript";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScript";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFamily";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasJSSyntax";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isES6";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isES6OrES6Target";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isFlow";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguageFromFileType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialect";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialectForJSFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedLanguageDialect";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredJSLevel";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredJSVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 10, 11, 13, 29, 30, 34, 36 -> new IllegalStateException(string);
        };
    }
}

