/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSFileReferencesUtil {
    public static final String FILE_SCHEME = "file://";
    public static final String[] PLATFORMS = new String[]{"ios", "android", "web", "native"};
    public static final String[] DOT_PLATFORMS = ArrayUtil.toStringArray((Collection)ContainerUtil.map((Object[])PLATFORMS, el -> "." + el));
    public static final String[] IMPLICIT_EXTENSIONS = ArrayUtil.mergeArrays((String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS, (String[])new String[]{".coffee", ".jsx", ".es6", ".js.flow", ".js", ".json", ".node", ".vue", ".mjs", ".cjs"});
    public static final String TS_TEMPLATE = "TypeScript_module.ts";
    private static final Map<String[], String[]> ourSortedExtensions = CollectionFactory.createConcurrentSoftMap();
    static volatile JSFileReferencesUtil INSTANCE = new JSFileReferencesUtil();

    @TestOnly
    public static void setInstance(@NotNull JSFileReferencesUtil util) {
        if (util == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(0);
        }
        INSTANCE = util;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner) {
        if (referenceOwner == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(1);
        }
        return JSFileReferencesUtil.resolveModuleReferences(referenceOwner, false);
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner, boolean includeUnindexedFiles) {
        if (referenceOwner == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(2);
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(referenceOwner.getProject()).resolveModuleReferences(referenceOwner, includeUnindexedFiles);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@Nullable PsiElement scope2, @NotNull String refText) {
        if (refText == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(5);
            }
            return list2;
        }
        Collection<PsiElement> collection = JSFileReferenceCache.getInstance(scope2.getProject()).resolveModuleReference(scope2, refText, false);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public static String getReferenceModuleText(@NotNull PsiElement element) {
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(7);
        }
        if (element instanceof JSLiteralExpression) {
            return element.getText();
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getExternalModuleText();
        }
        return null;
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String quoted, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(8);
        }
        if (quoted == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(9);
        }
        return JSModuleReferenceContributor.getReferences(JSStringUtil.unquoteStringLiteralValue(quoted), host, offset, provider);
    }

    public static boolean isLibraryElement(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(10);
        }
        if (DumbService.isDumb((Project)context2.getProject())) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context2.getProject()).getFileIndex();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context2);
        return file != null && index.isInLibrary(file);
    }

    @NotNull
    protected Collection<PsiElement> calculateMainModules(@NotNull PsiElement context2, @NotNull String unquotedString) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(11);
        }
        if (unquotedString == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(12);
        }
        return JSFileReferencesUtil.getMostPriorityModules(context2, unquotedString);
    }

    @NotNull
    protected <T> Supplier<T> createSoftRef(@NotNull T value) {
        if (value == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(13);
        }
        return new SoftReference(value);
    }

    @NotNull
    public static Collection<?> getReferenceDependencies(@NotNull PsiElement referenceOwner) {
        String referenceText;
        if (referenceOwner == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(14);
        }
        if ((referenceText = JSFileReferencesUtil.getReferenceModuleText(referenceOwner)) == null) {
            Set<Object> set = Collections.singleton(JSTypeUtils.getTypeInvalidationDependency());
            if (set == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(15);
            }
            return set;
        }
        PsiElement context2 = JSFileReferenceCache.getModuleContext(referenceOwner);
        if (context2 == null) {
            Set<Object> set = Collections.singleton(JSTypeUtils.getTypeInvalidationDependency());
            if (set == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(16);
            }
            return set;
        }
        String unquotedRef = JSStringUtil.unquoteStringLiteralValue(referenceText);
        HashSet objects = new HashSet(JSModuleReferenceContributor.getAllDependencies(unquotedRef, referenceOwner));
        objects.add(referenceOwner);
        HashSet hashSet = objects;
        if (hashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    protected Collection<?> getAllDependencies(@NotNull PsiElement context2, @NotNull String unquotedString) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(18);
        }
        if (unquotedString == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(19);
        }
        Collection<?> collection = JSModuleReferenceContributor.getAllDependencies(unquotedString, context2);
        if (collection == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context2, PsiReference @NotNull [] references) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(21);
        }
        if (references == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(22);
        }
        HashSet<PsiElement> results = new HashSet<PsiElement>();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            Collection<PsiElement> currentResults;
            int weight = JSFileReferencesUtil.getReferenceWeight(reference);
            if (maxWeight > weight && results.size() > 0 || (currentResults = JSModuleReferenceContributor.resolveModuleReference(reference)).size() == 0) continue;
            String[] extensions = JSFileReferencesUtil.getExtensions(context2);
            for (PsiElement result2 : currentResults) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                if (current == null || !JSFileReferencesUtil.isValidModule(context2, current)) continue;
                if (weight > maxWeight) {
                    results.clear();
                    maxWeight = weight;
                }
                results.add(current);
            }
        }
        HashSet<PsiElement> hashSet = results;
        if (hashSet == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context2, @NotNull String path2) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(24);
        }
        if (path2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(25);
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        String[] extensions = JSFileReferencesUtil.getExtensions(context2);
        ArrayList<PsiElement> invalidResults = new ArrayList<PsiElement>();
        int maxWeight = Integer.MIN_VALUE;
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            int weight;
            if (!contributor.isApplicable(context2) || (weight = contributor.getDefaultWeight()) < maxWeight) continue;
            Collection<PsiElement> elements = contributor.resolveReferences(context2, path2);
            if (!elements.isEmpty()) {
                for (PsiElement result2 : elements) {
                    PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result2);
                    if (current == null) continue;
                    boolean isValid = JSFileReferencesUtil.isValidModule(context2, current);
                    if (isValid) {
                        if (weight > maxWeight) {
                            results.clear();
                            maxWeight = weight;
                        }
                        results.add(current);
                        continue;
                    }
                    invalidResults.add(current);
                }
            }
            if (!(contributor instanceof JSModuleReferenceContributor.JSModuleReferenceMergeContributor)) continue;
            ArrayList<Object> relevantElements = results.isEmpty() ? invalidResults : results;
            Collection<PsiElement> additionalElements = ((JSModuleReferenceContributor.JSModuleReferenceMergeContributor)contributor).resolveReferences(context2, path2, relevantElements);
            relevantElements.addAll(additionalElements);
        }
        return JSFileReferencesUtil.toUniqueImmutableList(results.isEmpty() ? invalidResults : results);
    }

    @NotNull
    private static Collection<PsiElement> toUniqueImmutableList(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(26);
        }
        if (elements.isEmpty()) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(27);
            }
            return list2;
        }
        if (elements.size() == 1) {
            List<PsiElement> list3 = List.of((PsiElement)ContainerUtil.getFirstItem(elements));
            if (list3 == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(28);
            }
            return list3;
        }
        List<PsiElement> list4 = elements.stream().distinct().toList();
        if (list4 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(29);
        }
        return list4;
    }

    private static String @NotNull [] getExtensions(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(30);
        }
        String[] stringArray = DialectDetector.isTypeScript(context2) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : IMPLICIT_EXTENSIONS;
        if (stringArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(31);
        }
        return stringArray;
    }

    @Nullable
    public static PsiElement getModuleForPsiElement(String @NotNull [] extensions, @NotNull PsiElement result2) {
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(32);
        }
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(33);
        }
        PsiElement current = null;
        if (result2 instanceof PsiFileSystemItem && ((PsiFileSystemItem)result2).isDirectory()) {
            PsiFile file = JSFileReferencesUtil.findIndexFile(extensions, (PsiFileSystemItem)result2);
            if (file != null) {
                current = file;
            }
        } else {
            current = result2 instanceof TypeScriptModule ? result2 : JSFileReferencesUtil.findModule(result2);
        }
        return current;
    }

    private static boolean isValidModule(@NotNull PsiElement context2, @NotNull PsiElement module) {
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(34);
        }
        if (module == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(35);
        }
        if (DialectDetector.isTypeScript(context2) && module instanceof TypeScriptModule) {
            return TypeScriptConfigService.Provider.isAccessible(context2, module);
        }
        return true;
    }

    private static int getReferenceWeight(@NotNull PsiReference reference) {
        if (reference == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(36);
        }
        if (reference instanceof JSModuleBaseReference) {
            return ((JSModuleBaseReference)reference).getWeight();
        }
        return 0;
    }

    @NotNull
    public static PsiElement findModule(@NotNull PsiElement result2) {
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(37);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            PsiElement processed = handler.findModule(result2);
            if (processed == null) continue;
            PsiElement psiElement = processed;
            if (psiElement == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(38);
            }
            return psiElement;
        }
        PsiElement psiElement = result2;
        if (psiElement == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(39);
        }
        return psiElement;
    }

    @Nullable
    public static PsiFile findIndexFile(String @NotNull [] extensions, @NotNull PsiFileSystemItem result2) {
        VirtualFile virtualFile;
        VirtualFile file;
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(40);
        }
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(41);
        }
        return (file = JSFileReferencesUtil.findIndexVirtualFile(extensions, virtualFile = result2.getVirtualFile())) == null ? null : result2.getManager().findFile(file);
    }

    @Nullable
    public static VirtualFile findIndexVirtualFile(String @NotNull [] extensions, @Nullable VirtualFile directory) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(42);
        }
        if (directory != null) {
            for (String ext : extensions) {
                VirtualFile child = directory.findChild("index" + ext);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(43);
        }
        return INSTANCE.calcImportExportFromClauseReferencesImpl(element, provider);
    }

    protected PsiReference @NotNull [] calcImportExportFromClauseReferencesImpl(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        Pair<String, PsiElement> pair;
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(44);
        }
        if ((pair = JSPsiImplUtils.getChildStringLiteralWithText(element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(45);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement literalExpression = (PsiElement)pair.second;
        String quotedText = (String)pair.first;
        PsiReference[] psiReferenceArray = JSFileReferencesUtil.createImportExportFromClauseReferences(element, literalExpression.getStartOffsetInParent() + 1, quotedText, provider);
        if (psiReferenceArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(46);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static String getShortestPathInContexts(@Nullable VirtualFile dstVFile, @NotNull Collection<? extends VirtualFile> contexts, boolean skipParent) {
        if (contexts == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(47);
        }
        if (dstVFile == null || contexts.size() == 0) {
            return null;
        }
        String path2 = null;
        String parentDirPath = null;
        for (VirtualFile virtualFile : contexts) {
            String candidate;
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)dstVFile, (boolean)true) || StringUtil.isEmpty((String)(candidate = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)virtualFile, (char)'/')))) continue;
            if (skipParent && virtualFile.equals(dstVFile.getParent())) {
                parentDirPath = candidate;
                continue;
            }
            path2 = path2 == null || path2.length() > candidate.length() ? candidate : path2;
        }
        return path2 == null ? parentDirPath : path2;
    }

    public static boolean startWithLocalPrefix(@NotNull String text2) {
        if (text2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(48);
        }
        return text2.startsWith("./") || text2.startsWith("../");
    }

    @NotNull
    public static String getNodeModuleName(@NotNull String text2) {
        String path2;
        if (text2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(49);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(path2 = JSStringUtil.unquoteStringLiteralValue(text2.trim()))) {
            String string = path2;
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        String[] strings = path2.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(51);
                }
                return string;
            }
            String string = strings[0];
            if (string == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public static PsiReferenceProvider getSimpleReferencesPathProvider(final String @NotNull [] extensions) {
        if (extensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(54);
        }
        return new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof JsonStringLiteral) {
                    boolean isCaseSensitive = JSFileReferencesUtil.isCaseSensitive(element);
                    String value = ((JsonStringLiteral)element).getValue();
                    FileReference[] fileReferenceArray = new FileReferenceSet(value, element, 1, null, isCaseSensitive){

                        @NotNull
                        public Collection<PsiFileSystemItem> computeDefaultContexts() {
                            if (this.isAbsolutePathReference()) {
                                Collection collection = super.computeDefaultContexts();
                                if (collection == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return collection;
                            }
                            Collection collection = this.getParentDirectoryContext();
                            if (collection == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return collection;
                        }

                        protected boolean isSoft() {
                            return true;
                        }

                        public FileReference createFileReference(TextRange range, int index, String text2) {
                            return new JSFileReference(text2, index, range, this){

                                @Override
                                protected boolean isAllowFolders() {
                                    return true;
                                }

                                @Override
                                public String @NotNull [] getImplicitExtensions() {
                                    if (extensions == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return extensions;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1$1$1", "getImplicitExtensions"));
                                }
                            };
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1$1", "computeDefaultContexts"));
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean isAcceptableNodeModulesPackageName(@NotNull String moduleName) {
        if (moduleName == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(55);
        }
        if (JSFileReferencesUtil.startWithLocalPrefix(moduleName)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return false;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return false;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return false;
        }
        return haveNamePartInWord;
    }

    public static boolean isCaseSensitive(@NotNull PsiElement context2) {
        VirtualFile file;
        if (context2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(56);
        }
        return (file = PsiUtilCore.getVirtualFile((PsiElement)context2)) == null ? SystemInfo.isFileSystemCaseSensitive : file.isCaseSensitive();
    }

    public static boolean isDynamicWholeModuleImport(@NotNull PsiReference reference) {
        PsiElement parent;
        PsiElement element;
        if (reference == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(57);
        }
        if ((element = reference.getElement()) instanceof JSLiteralExpression && ((parent = (PsiElement)ObjectUtils.chooseNotNull((Object)JSUtils.findCallExprByArg(element), (Object)JSUtils.getParentSkipParentheses(element))) instanceof JSCallExpression && ((JSCallExpression)parent).isRequireCall() || parent instanceof ES6ImportCall)) {
            PsiElement importTarget = JSUtils.getParentSkipParentheses(parent);
            if (parent instanceof ES6ImportCall) {
                if (ES6PsiUtil.isAwaitExpression(importTarget)) {
                    importTarget = JSUtils.getParentSkipParentheses(importTarget);
                } else {
                    return true;
                }
            }
            return !(importTarget instanceof JSExpressionStatement) && !(importTarget instanceof JSReferenceExpression) && !(importTarget instanceof JSDestructuringElement);
        }
        return false;
    }

    @Nullable
    public static String findFileUrlPrefix(@NotNull String s) {
        if (s == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(58);
        }
        if (s.startsWith(FILE_SCHEME)) {
            int length = FILE_SCHEME.length();
            if (SystemInfo.isWindows && s.startsWith("/", length)) {
                ++length;
            }
            return s.substring(0, length);
        }
        return null;
    }

    public static boolean isFileModuleRequired(@Nullable String requiredModuleName) {
        if (requiredModuleName == null) {
            return false;
        }
        return requiredModuleName.startsWith("/") || requiredModuleName.startsWith("./") || requiredModuleName.startsWith("../");
    }

    public static boolean isRelative(@NotNull String pathString) {
        if (pathString == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(59);
        }
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix(pathString)) {
            return false;
        }
        int length = pathString.length();
        if (length == 0) {
            return false;
        }
        char firstChar = pathString.charAt(0);
        if (length == 1) {
            return firstChar == '.';
        }
        if (firstChar != '.') {
            return false;
        }
        char secondChar = pathString.charAt(1);
        return secondChar == '/' || secondChar == '\\' || secondChar == '.';
    }

    private static boolean isReactPlatform(@Nullable String platform) {
        if (platform == null) {
            return false;
        }
        for (String s : PLATFORMS) {
            if (!s.equalsIgnoreCase(platform)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(String platform, String extension) {
        return "." + platform + "." + extension;
    }

    private static String @NotNull [] getPlatforms(@NotNull String extension) {
        if (extension == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(60);
        }
        String[] result2 = new String[PLATFORMS.length];
        for (int i = 0; i < PLATFORMS.length; ++i) {
            result2[i] = JSFileReferencesUtil.getExtension(PLATFORMS[i], extension);
        }
        if (result2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(61);
        }
        return result2;
    }

    public static String @NotNull [] getExtensionsWithPlatforms(@Nullable PsiElement element, String @NotNull [] defaultExtensions) {
        String extension;
        if (defaultExtensions == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(62);
        }
        if (defaultExtensions.length == 0) {
            if (defaultExtensions == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(63);
            }
            return defaultExtensions;
        }
        if (element != null) {
            String fileNameWithExtension = element.getContainingFile().getName();
            extension = FileUtilRt.getExtension((String)fileNameWithExtension);
            if (StringUtil.isEmpty((String)extension)) {
                if (defaultExtensions == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(64);
                }
                return defaultExtensions;
            }
            String fileName = fileNameWithExtension.substring(0, fileNameWithExtension.length() - extension.length());
            String platform = FileUtilRt.getExtension((String)fileName);
            if (JSFileReferencesUtil.isReactPlatform(platform)) {
                String[] stringArray = (String[])ArrayUtil.prepend((Object)JSFileReferencesUtil.getExtension(platform, extension), (Object[])defaultExtensions);
                if (stringArray == null) {
                    JSFileReferencesUtil.$$$reportNull$$$0(65);
                }
                return stringArray;
            }
        } else {
            extension = "js";
        }
        String[] stringArray = ArrayUtil.mergeArrays((String[])JSFileReferencesUtil.getPlatforms(extension), (String[])defaultExtensions);
        if (stringArray == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(66);
        }
        return stringArray;
    }

    public static String @NotNull [] getSortedExtensions(@NotNull @NotNull String @NotNull [] extensionsWithDot) {
        Object[] sorted;
        if (extensionsWithDot == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(67);
        }
        if ((sorted = ourSortedExtensions.get(extensionsWithDot)) == null) {
            Object[] newArray = (String[])extensionsWithDot.clone();
            ContainerUtil.sort((Object[])newArray, Comparator.comparing(el -> -el.length()));
            ourSortedExtensions.put(extensionsWithDot, (String[])newArray);
            sorted = newArray;
        }
        if (sorted == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(68);
        }
        return sorted;
    }

    public static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(69);
        }
        return (file = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && JSLibraryUtil.hasDirectoryInPath(file, "node_modules", null);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static String findExtension(@Nullable CharSequence fileName, @NotNull @NotNull String @NotNull [] extensionsWithDot) {
        if (extensionsWithDot == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(70);
        }
        String[] sorted = JSFileReferencesUtil.getSortedExtensions(extensionsWithDot);
        if (fileName == null) {
            return null;
        }
        for (String extension : sorted) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)extension)) continue;
            return extension;
        }
        return null;
    }

    @NotNull
    public static CharSequence trimExistingExtension(@NotNull CharSequence fileName, @NotNull String extensionWithDot) {
        if (fileName == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(71);
        }
        if (extensionWithDot == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(72);
        }
        CharSequence charSequence = fileName.subSequence(0, fileName.length() - extensionWithDot.length());
        if (charSequence == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(73);
        }
        return charSequence;
    }

    @NotNull
    public static String trimExistingExtension(@NotNull String fileName, @NotNull String extensionWithDot) {
        if (fileName == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(74);
        }
        if (extensionWithDot == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(75);
        }
        String string = fileName.substring(0, fileName.length() - extensionWithDot.length());
        if (string == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    @Contract(value="!null,_ -> !null")
    public static String getFileNameWithoutExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        String extension = JSFileReferencesUtil.findExtension(fileName, extensions);
        return extension != null ? fileName.substring(0, fileName.length() - extension.length()) : FileUtilRt.getNameWithoutExtension((String)fileName);
    }

    @Contract(value="null -> null")
    public static String findImplicitExtension(@Nullable String fileName) {
        return JSFileReferencesUtil.findExtension(fileName, IMPLICIT_EXTENSIONS);
    }

    @NotNull
    public static String decodePathChars(@NotNull String text2) {
        String string;
        if (text2 == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(77);
        }
        if (SystemInfo.isMac) {
            text2 = Normalizer.normalize(text2, Normalizer.Form.NFC);
        }
        text2 = PathReference.trimPath((String)text2);
        try {
            string = URLUtil.decode((String)text2);
        }
        catch (Exception ignored) {
            String string2 = text2;
            if (string2 == null) {
                JSFileReferencesUtil.$$$reportNull$$$0(79);
            }
            return string2;
        }
        if (string == null) {
            JSFileReferencesUtil.$$$reportNull$$$0(78);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 15, 16, 17, 20, 23, 27, 28, 29, 31, 38, 39, 45, 46, 50, 51, 52, 53, 61, 63, 64, 65, 66, 68, 73, 76, 78, 79 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "util";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 73: 
            case 76: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
            case 7: 
            case 43: 
            case 44: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 21: 
            case 24: 
            case 30: 
            case 34: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: 
            case 41: 
            case 42: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 36: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 48: 
            case 49: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathString";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExtensions";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsWithDot";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionWithDot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostPriorityModules";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toUniqueImmutableList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findModule";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModuleName";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsWithPlatforms";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedExtensions";
                break;
            }
            case 73: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExistingExtension";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "decodePathChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 73: 
            case 76: 
            case 78: 
            case 79: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceModuleText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createImportExportFromClauseReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateMainModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSoftRef";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceDependencies";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMostPriorityModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toUniqueImmutableList";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForPsiElement";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isValidModule";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceWeight";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findIndexFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findIndexVirtualFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferences";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "calcImportExportFromClauseReferencesImpl";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getShortestPathInContexts";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "startWithLocalPrefix";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModuleName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleReferencesPathProvider";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesPackageName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicWholeModuleImport";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findFileUrlPrefix";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isRelative";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getPlatforms";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsWithPlatforms";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getSortedExtensions";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedFileFromNodeModules";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 71: 
            case 72: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "trimExistingExtension";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "decodePathChars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 15, 16, 17, 20, 23, 27, 28, 29, 31, 38, 39, 45, 46, 50, 51, 52, 53, 61, 63, 64, 65, 66, 68, 73, 76, 78, 79 -> new IllegalStateException(string);
        };
    }
}

