/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSFileReferenceCache {
    private static final Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> KEY = Key.create((String)"module.ref.map.key");
    @NotNull
    private final NotNullLazyValue<GlobalSearchScope> myIndexedFilesInProjectScope;

    public static JSFileReferenceCache getInstance(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(0);
        }
        return (JSFileReferenceCache)project.getService(JSFileReferenceCache.class);
    }

    public JSFileReferenceCache(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(1);
        }
        this.myIndexedFilesInProjectScope = NotNullLazyValue.lazy(() -> new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project), (IndexableFileSet)new AdditionalIndexableFileSet(project)));
    }

    @NotNull
    Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner, boolean includeUnindexedFiles) {
        String referenceText;
        if (referenceOwner == null) {
            JSFileReferenceCache.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(referenceOwner)))) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Collection<PsiElement> collection = this.resolveModuleReference(referenceOwner, referenceText, includeUnindexedFiles);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveModuleReference(@Nullable PsiElement context2, @NotNull String referenceText, boolean includeUnindexedFiles) {
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(5);
        }
        if (context2 == null || StringUtil.isEmpty((String)referenceText)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PsiElement moduleContext = JSFileReferenceCache.getModuleContext(context2);
        if (moduleContext == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(7);
            }
            return set;
        }
        return this.resolveDirectModules(moduleContext, referenceText, includeUnindexedFiles);
    }

    @Nullable
    public static PsiElement getModuleContext(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(8);
        }
        if (TypeScriptAugmentationUtil.isExternalModuleAugmentation(moduleReference)) {
            return CompletionUtil.getOriginalOrSelf((PsiElement)moduleReference);
        }
        PsiFile containingFile2 = moduleReference.getContainingFile();
        if (containingFile2 == null) {
            return null;
        }
        PsiFile file = containingFile2.getOriginalFile();
        if (file instanceof JSFile) {
            return file;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(moduleReference);
        if (module != null) {
            return module instanceof PsiFile ? ((PsiFile)module).getOriginalFile() : module;
        }
        return file;
    }

    @NotNull
    private Collection<PsiElement> resolveDirectModules(@NotNull PsiElement element, @NotNull String quotedRef, boolean includeUnindexedFiles) {
        List result2;
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(9);
        }
        if (quotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(10);
        }
        String unquotedRef = JSStringUtil.unquoteStringLiteralValue(quotedRef);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        Collection<Object> collection = result2 = file == null ? JSFileReferencesUtil.INSTANCE.calculateMainModules(element, unquotedRef) : this.getCachedModules(element, unquotedRef);
        if (!includeUnindexedFiles) {
            result2 = ContainerUtil.filter(result2, it -> !this.isUnindexedJSFile(it.getContainingFile()));
        }
        List list2 = result2;
        if (list2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    private Collection<PsiElement> getCachedModules(@NotNull PsiElement element, @NotNull String unquotedRef) {
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(12);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(13);
        }
        Map<String, CachedValue<Collection<PsiElement>>> map = JSFileReferenceCache.getLibraryFilesMap(element);
        Collection collection = (Collection)this.getCachedValue(element, unquotedRef, map).getValue();
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    private CachedValue<Collection<PsiElement>> getCachedValue(@NotNull PsiElement context2, @NotNull String unquotedRef, @NotNull Map<String, CachedValue<Collection<PsiElement>>> map) {
        CachedValue<Collection<PsiElement>> value;
        if (context2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(15);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(16);
        }
        if (map == null) {
            JSFileReferenceCache.$$$reportNull$$$0(17);
        }
        if ((value = map.get(unquotedRef)) != null) {
            CachedValue<Collection<PsiElement>> cachedValue = value;
            if (cachedValue == null) {
                JSFileReferenceCache.$$$reportNull$$$0(18);
            }
            return cachedValue;
        }
        value = this.createLibraryCachedValueForText(context2, unquotedRef);
        CachedValue<Collection<PsiElement>> prev = map.putIfAbsent(unquotedRef, value);
        if (prev != null) {
            value = prev;
        }
        CachedValue<Collection<PsiElement>> cachedValue = value;
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(19);
        }
        return cachedValue;
    }

    @NotNull
    CachedValue<Collection<PsiElement>> createLibraryCachedValueForText(@NotNull PsiElement context2, @NotNull String unquotedRef) {
        if (context2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(20);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(21);
        }
        Project project = context2.getProject();
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Collection<PsiElement> allResolveResults = JSFileReferencesUtil.INSTANCE.calculateMainModules(context2, unquotedRef);
            HashSet deps = new HashSet(JSFileReferencesUtil.INSTANCE.getAllDependencies(context2, unquotedRef));
            deps.addAll(allResolveResults);
            return CachedValueProvider.Result.create(allResolveResults, deps);
        }, false);
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(22);
        }
        return cachedValue;
    }

    @NotNull
    private static Map<String, CachedValue<Collection<PsiElement>>> getLibraryFilesMap(@NotNull PsiElement context2) {
        Supplier data;
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> result2;
        if (context2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(23);
        }
        if ((result2 = (ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>)SoftReference.deref((Supplier)(data = (Supplier)context2.getUserData(KEY)))) != null) {
            ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
            if (concurrentHashMap == null) {
                JSFileReferenceCache.$$$reportNull$$$0(24);
            }
            return concurrentHashMap;
        }
        result2 = new ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>();
        context2.putUserData(KEY, JSFileReferencesUtil.INSTANCE.createSoftRef(result2));
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
        if (concurrentHashMap == null) {
            JSFileReferenceCache.$$$reportNull$$$0(25);
        }
        return concurrentHashMap;
    }

    public boolean isUnindexedJSFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        Boolean value = (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            boolean isJSFile = JavaScriptIndex.getFileTypesToIndexJS().contains(file.getFileType());
            if (!isJSFile) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            }
            VirtualFile virtualFile = file.getVirtualFile();
            boolean isIndexed = virtualFile != null && JavaScriptIndex.isAcceptableFile(virtualFile) && ((GlobalSearchScope)this.myIndexedFilesInProjectScope.getValue()).contains(virtualFile);
            return CachedValueProvider.Result.create((Object)(!isIndexed ? 1 : 0), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, file});
        });
        return Boolean.TRUE.equals(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 11, 14, 18, 19, 22, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRef";
                break;
            }
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRef";
                break;
            }
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedModules";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryCachedValueForText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFilesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectModules";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedModules";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryCachedValueForText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFilesMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 11, 14, 18, 19, 22, 24, 25 -> new IllegalStateException(string);
        };
    }
}

