/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSConfigFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\bH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010%\u001a\u00020\u0006H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010*\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020\bH\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfigurationImpl;", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "place", "Lcom/intellij/psi/PsiElement;", "elementToImport", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "useExistingImports", "", "importedName", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/vfs/VirtualFile;ZLjava/lang/String;)V", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myConfig", "Lcom/intellij/lang/javascript/config/JSConfig;", "myElementToImport", "myFileToImport", "myImportedModuleRoot", "getMyImportedModuleRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "myImportedModuleRoot$delegate", "Lkotlin/Lazy;", "myImportedName", "myPlace", "myPlaceRoot", "getMyPlaceRoot", "myPlaceRoot$delegate", "myUseExistingImports", "config", "kotlin.jvm.PlatformType", "extensions", "", "()[Ljava/lang/String;", "forceExtension", "getConfig", "getElementToImport", "getExportedName", "getFileToImport", "getImportedFileRoot", "getImportedName", "getPlace", "getPlaceRoot", "isProcessRootPaths", "relativeForSamePathMappings", "usePathMappings", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSImportPathConfigurationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSImportPathConfigurationImpl.kt\ncom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfigurationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public class JSImportPathConfigurationImpl
implements JSImportPathConfiguration {
    @NotNull
    private final VirtualFile myFileToImport;
    private final boolean myUseExistingImports;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final PsiElement myElementToImport;
    @Nullable
    private final JSConfig myConfig;
    @Nullable
    private final String myImportedName;
    @NotNull
    private final Lazy myPlaceRoot$delegate;
    @NotNull
    private final Lazy myImportedModuleRoot$delegate;

    private final VirtualFile getMyPlaceRoot() {
        Lazy lazy = this.myPlaceRoot$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final VirtualFile getMyImportedModuleRoot() {
        Lazy lazy = this.myImportedModuleRoot$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final JSConfig config(PsiElement place) {
        return JSConfigFactory.getConfigForPsiFile(place.getContainingFile());
    }

    public JSImportPathConfigurationImpl(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile virtualFile, boolean useExistingImports, @Nullable String importedName) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.myPlaceRoot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VirtualFile>(this){
            final /* synthetic */ JSImportPathConfigurationImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                return NodeModuleUtil.getMainModuleRoot(this.this$0.getPlace());
            }
        }));
        this.myImportedModuleRoot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VirtualFile>(this){
            final /* synthetic */ JSImportPathConfigurationImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                return NodeModuleUtil.findMainModuleRoot(this.this$0.getPlace().getProject(), this.this$0.getFileToImport());
            }
        }));
        this.myUseExistingImports = useExistingImports;
        PsiElement psiElement = elementToImport;
        if (psiElement == null) {
            PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)place.getProject(), (VirtualFile)virtualFile);
            Intrinsics.checkNotNull((Object)psiFileSystemItem);
            psiElement = (PsiElement)psiFileSystemItem;
        }
        this.myElementToImport = psiElement;
        this.myPlace = place;
        this.myFileToImport = virtualFile;
        this.myConfig = this.config(place);
        this.myImportedName = this.getExportedName(importedName, elementToImport);
    }

    private final String getExportedName(String importedName, PsiElement elementToImport) {
        String string = importedName;
        if (string == null) {
            PsiElement psiElement = elementToImport;
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                string = ES6ImportPsiUtil.getExportedElementName(it);
            } else {
                string = null;
            }
        }
        return string;
    }

    public JSImportPathConfigurationImpl(@NotNull PsiElement place, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.myPlaceRoot$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.myImportedModuleRoot$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.myUseExistingImports = false;
        PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)place.getProject(), (VirtualFile)virtualFile);
        Intrinsics.checkNotNull((Object)psiFileSystemItem);
        this.myElementToImport = (PsiElement)psiFileSystemItem;
        this.myFileToImport = virtualFile;
        this.myPlace = place;
        this.myConfig = this.config(place);
        this.myImportedName = this.getExportedName(null, this.getElementToImport());
    }

    @Override
    public boolean forceExtension() {
        return false;
    }

    @Override
    @Nullable
    public String getImportedName() {
        return this.myImportedName;
    }

    @Override
    public boolean isProcessRootPaths() {
        return JSCodeStyleSettings.isUseAbsolutePath(this.myPlace);
    }

    @Override
    @NotNull
    public VirtualFile getFileToImport() {
        return this.myFileToImport;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        return this.myPlace;
    }

    @Override
    @NotNull
    public PsiElement getElementToImport() {
        return this.myElementToImport;
    }

    @Override
    @Nullable
    public JSConfig getConfig() {
        return this.myConfig;
    }

    @Override
    public boolean useExistingImports() {
        return this.myUseExistingImports;
    }

    @Override
    @Nullable
    public VirtualFile getPlaceRoot() {
        return this.getMyPlaceRoot();
    }

    @Override
    @Nullable
    public VirtualFile getImportedFileRoot() {
        return this.getMyImportedModuleRoot();
    }

    @Override
    public boolean usePathMappings() {
        return JSCodeStyleSettings.getSettings((PsiElement)this.myPlace).USE_PATH_MAPPING != JSCodeStyleSettings.PathMappingOption.NEVER;
    }

    @Override
    public boolean relativeForSamePathMappings() {
        return JSCodeStyleSettings.getSettings((PsiElement)this.myPlace).USE_PATH_MAPPING == JSCodeStyleSettings.PathMappingOption.DIFFERENT_PATHS;
    }

    @Override
    @NotNull
    public String[] extensions() {
        String[] stringArray;
        if (DialectDetector.isTypeScript(this.myPlace)) {
            String[] stringArray2 = TypeScriptImportsResolverProvider.getAllFileExtensionsWithDot();
            stringArray = stringArray2;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"getAllFileExtensionsWithDot(...)");
        } else {
            String[] stringArray3 = JSFileReferencesUtil.getExtensionsWithPlatforms(this.myPlace, JSFileReferencesUtil.IMPLICIT_EXTENSIONS);
            stringArray = stringArray3;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"getExtensionsWithPlatforms(...)");
        }
        return stringArray;
    }
}

