/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.actions.JSImportDescriptorBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfigurationImpl;
import com.intellij.lang.ecmascript6.psi.impl.JSImportScope;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportScope;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExecutorFactory;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSTagEmbeddedContent;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6CreateImportUtil {
    public static final String INDEX_WITH_DOT = "index.";
    private static final TokenSet EXPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DECLARATION});

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull PsiElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(0);
        }
        if (fileToCheck == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(3);
        }
        return !ES6CreateImportUtil.resolveSymbolInFile(project, fileToCheck, elementToImport, place, false).isEmpty();
    }

    @NotNull
    public static Collection<JSImportedElementDescriptor> resolveSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull PsiElement elementToImport, @NotNull PsiElement place, boolean includeAlternativeImport) {
        PsiFile possiblePsiFile;
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(4);
        }
        if (fileToCheck == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(5);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(7);
        }
        if (!((possiblePsiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck)) instanceof JSFile)) {
            List<JSImportedElementDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(8);
            }
            return list2;
        }
        JSFile file = (JSFile)possiblePsiFile;
        if (!(elementToImport instanceof JSElement)) {
            if (elementToImport instanceof PsiFile && possiblePsiFile.isEquivalentTo(elementToImport)) {
                Set<JSImportedElementDescriptor> set = Collections.singleton(new ES6ImportPsiUtil.CreateImportExportInfo(StringUtil.notNullize((String)((PsiFile)elementToImport).getName()), ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL));
                if (set == null) {
                    ES6CreateImportUtil.$$$reportNull$$$0(9);
                }
                return set;
            }
            if (!JSImportDescriptorBuilder.isExternalModule(elementToImport)) {
                List<JSImportedElementDescriptor> list3 = Collections.emptyList();
                if (list3 == null) {
                    ES6CreateImportUtil.$$$reportNull$$$0(10);
                }
                return list3;
            }
        }
        if (file.getModuleStatus() == JSModuleStatusOwner.ModuleStatus.NONE) {
            List<JSImportedElementDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(11);
            }
            return list4;
        }
        return ES6CreateImportUtil.resolveSymbolInModule(elementToImport, place, file, includeAlternativeImport);
    }

    public static Collection<JSImportedElementDescriptor> resolveSymbolInModule(@NotNull PsiElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(13);
        }
        if (module == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(14);
        }
        return ES6CreateImportUtil.resolveSymbolInModule(elementToImport, place, module, false);
    }

    @NotNull
    public static Collection<JSImportedElementDescriptor> resolveSymbolInModule(@NotNull PsiElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module, boolean includeAlternativeImport) {
        String name;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(16);
        }
        if (module == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(17);
        }
        if ((name = ES6CreateImportUtil.getExportedNameForResolveInModule(elementToImport)) == null) {
            List<JSImportedElementDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(18);
            }
            return list2;
        }
        JSImportedElementDescriptor descriptor = ES6CreateImportUtil.resolveSymbolInModuleWithName(name, elementToImport, place, module, true);
        if (!includeAlternativeImport) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)descriptor);
            if (list3 == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(19);
            }
            return list3;
        }
        String altName = null;
        if ("default".equals(name)) {
            if (JSImportDescriptorBuilder.isExternalModule(elementToImport)) {
                altName = JSImportDescriptorBuilder.getExportedNameForExternalModule(elementToImport);
            } else if (elementToImport instanceof JSElement) {
                JSElement jsElement2 = (JSElement)elementToImport;
                altName = jsElement2.getName();
            }
        } else {
            altName = "default";
        }
        JSImportedElementDescriptor altDescriptor = ES6CreateImportUtil.resolveSymbolInModuleWithName(altName, elementToImport, place, module, true);
        if (descriptor == null && altDescriptor == null) {
            List<JSImportedElementDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(20);
            }
            return list4;
        }
        SmartList descriptors = new SmartList();
        ContainerUtil.addIfNotNull((Collection)descriptors, (Object)descriptor);
        ContainerUtil.addIfNotNull((Collection)descriptors, (Object)altDescriptor);
        SmartList smartList = descriptors;
        if (smartList == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(21);
        }
        return smartList;
    }

    @Nullable
    public static JSImportedElementDescriptor resolveSymbolInModuleWithName(@Nullable String nameOrDefault, @NotNull PsiElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module, boolean expand) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(22);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(23);
        }
        if (module == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(24);
        }
        if (nameOrDefault == null) {
            return null;
        }
        Object[] results = ES6PsiUtil.resolveSymbolInModule(nameOrDefault, place, module);
        boolean isDefault = "default".equals(nameOrDefault);
        Collection<? extends PsiElement> importedVariants = expand ? ES6CreateImportUtil.expandElement(elementToImport) : Collections.singleton(elementToImport);
        List resolvedByName = ((StreamEx)StreamEx.of((Object[])results).filter(ResolveResult::isValidResult)).map(ResolveResult::getElement).toList();
        for (PsiElement psiElement : importedVariants) {
            for (PsiElement resolved : resolvedByName) {
                String importedName;
                PsiElement candidate = expand ? ES6CreateImportUtil.getIfDirectOrIndirectEquivalent(psiElement, resolved) : resolved;
                if (!(candidate instanceof JSElement)) continue;
                ES6ImportPsiUtil.ImportExportType type2 = isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
                String exportedName = ES6ImportPsiUtil.getExportedElementName(candidate);
                if (elementToImport instanceof JSElement) {
                    JSElement jsElement2 = (JSElement)elementToImport;
                    v0 = jsElement2.getName();
                } else {
                    v0 = importedName = null;
                }
                if (exportedName == null && importedName == null) continue;
                ES6ImportExportDeclaration.ImportExportPrefixKind kind = JSImportDescriptorBuilder.detectPrefixKind(elementToImport, place);
                return new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type2, kind);
            }
        }
        return null;
    }

    @NotNull
    private static Collection<? extends PsiElement> expandElement(@NotNull PsiElement elementToImport) {
        PsiElement original;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(25);
        }
        Object object = original = elementToImport instanceof ES6ExportSpecifier ? ES6CreateImportUtil.expandExportSpecifierForResolveSymbolInModule((ES6ExportSpecifier)elementToImport) : elementToImport;
        if (original instanceof TypeScriptFunction && ((TypeScriptFunction)original).isOverloadImplementation()) {
            Collection<TypeScriptFunction> collection = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)original);
            if (collection == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(26);
            }
            return collection;
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)original);
        if (list2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @Nullable
    private static PsiElement getIfDirectOrIndirectEquivalent(@NotNull PsiElement toImport, @Nullable PsiElement resolvedByName) {
        PsiElement explicit;
        if (toImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(28);
        }
        if (resolvedByName == null) {
            return null;
        }
        if (toImport.isEquivalentTo(resolvedByName)) {
            return toImport;
        }
        if (resolvedByName instanceof TypeScriptProxyImplicitElement && (explicit = ((TypeScriptProxyImplicitElement)resolvedByName).getExplicitElement()) != null && explicit.isEquivalentTo(resolvedByName)) {
            return explicit;
        }
        Collection<PsiElement> expanded = resolvedByName instanceof JSDefinitionExpression ? JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolvedByName) : new ES6QualifiedNameResolver(toImport).expandElement(resolvedByName);
        for (PsiElement element : expanded) {
            if (!toImport.isEquivalentTo(element) && (!JSImportDescriptorBuilder.isExternalModule(toImport) || !JSFileReferencesUtil.findModule(toImport).isEquivalentTo(element))) continue;
            return resolvedByName;
        }
        return null;
    }

    @Nullable
    private static String getExportedNameForResolveInModule(@NotNull PsiElement element) {
        String string;
        JSElementBase elementBase;
        if (element == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(29);
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)element).getDeclaredName();
        }
        if (element instanceof ES6ExportDefaultAssignment) {
            return "default";
        }
        if (element instanceof JSElementBase && (elementBase = (JSElementBase)element).isExportedWithDefault() && !elementBase.isExported()) {
            return "default";
        }
        if (JSImportDescriptorBuilder.isExternalModule(element)) {
            return JSImportDescriptorBuilder.getExportedNameForExternalModule(element);
        }
        if (element instanceof JSElement) {
            JSElement jsElement2 = (JSElement)element;
            string = jsElement2.getName();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    private static JSElement expandExportSpecifierForResolveSymbolInModule(@NotNull ES6ExportSpecifier elementToImport) {
        ES6ExportSpecifierAlias alias;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(30);
        }
        if ((alias = elementToImport.getAlias()) != null) {
            ES6ExportSpecifierAlias eS6ExportSpecifierAlias = alias;
            if (eS6ExportSpecifierAlias == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(31);
            }
            return eS6ExportSpecifierAlias;
        }
        List elements = ContainerUtil.filterIsInstance(JSResolveResult.toElements(elementToImport.multiResolve(false), true), JSElement.class);
        if (!elements.isEmpty()) {
            for (JSElement element : elements) {
                PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
                if (externalModule == null || TypeScriptAugmentationUtil.isExternalModuleAugmentation(externalModule)) continue;
                JSElement jSElement = element;
                if (jSElement == null) {
                    ES6CreateImportUtil.$$$reportNull$$$0(32);
                }
                return jSElement;
            }
            JSElement jSElement = (JSElement)ContainerUtil.getFirstItem((Collection)elements, (Object)elementToImport);
            if (jSElement == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(33);
            }
            return jSElement;
        }
        ES6ExportSpecifier eS6ExportSpecifier = elementToImport;
        if (eS6ExportSpecifier == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(34);
        }
        return eS6ExportSpecifier;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull Project project, @NotNull PsiElement context2) {
        VirtualFile contextFile;
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(35);
        }
        if (context2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(36);
        }
        if ((contextFile = context2.getContainingFile().getOriginalFile().getVirtualFile()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(37);
            }
            return globalSearchScope;
        }
        VirtualFile parent = contextFile.getParent();
        GlobalSearchScope baseScope = JSResolveUtil.getResolveScope(context2);
        if (parent == null) {
            GlobalSearchScope globalSearchScope = baseScope;
            if (globalSearchScope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(38);
            }
            return globalSearchScope;
        }
        if (DialectDetector.isTypeScript(context2)) {
            return new TypeScriptImportScope(project, contextFile, baseScope);
        }
        return new JSImportScope(project, contextFile, baseScope, JSModuleStatusOwner.ModuleStatus.ES6);
    }

    public static void insertExport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType type2, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(39);
        }
        if (type2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(40);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(41);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSModuleNameInfo moduleNameInfo = ES6CreateImportUtil.getModuleInfo(place, (PsiElement)elementToImport, elementToImport.getContainingFile());
        if (moduleNameInfo == null) {
            return;
        }
        PsiElement scope2 = ES6CreateImportUtil.getScopeToAdd(place, true);
        if (scope2 == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo createInfo = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type2, ES6ImportExportDeclaration.ImportExportPrefixKind.EXPORT);
        JSSimpleImportDescriptor descriptor = new JSSimpleImportDescriptor(moduleNameInfo, createInfo);
        JSSourceElement exportDeclaration = ES6ImportPsiUtil.createImportOrExport(place, descriptor);
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope2, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope((PsiElement)exportDeclaration, scope2, placeForAnchor, null);
    }

    public static void insertExportName(@NotNull JSImportExportType type2, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        PsiElement scope2;
        if (type2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(43);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(44);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(45);
        }
        if ((scope2 = ES6CreateImportUtil.getScopeToAdd(place, true)) == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info2 = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type2, ES6ImportExportDeclaration.ImportExportPrefixKind.EXPORT);
        StringBuilder builder2 = new StringBuilder("export ");
        if (type2.isDefault()) {
            builder2.append("default ");
        }
        builder2.append(ES6ImportPsiUtil.getImportExportPartText(info2, false, JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_IMPORTS, false));
        builder2.append(JSCodeStyleSettings.getSemicolon(place));
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope2, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope((PsiElement)JSPsiElementFactory.createJSSourceElement(builder2.toString(), place), scope2, placeForAnchor, null);
    }

    public static void insertImport(@NotNull PsiElement place, @NotNull JSQualifiedNamedElement toImport, @Nullable String importedName) {
        String name;
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(46);
        }
        if (toImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(47);
        }
        String string = name = importedName == null ? toImport.getName() : importedName;
        if (name == null) {
            return;
        }
        List<JSImportExecutorFactory> factories = JSHandlersFactory.forElement(place).createImportFactories(place);
        if (factories.isEmpty()) {
            return;
        }
        JSAddImportExecutor executor = factories.get(0).createExecutor(place);
        ES6ImportCandidate candidate = new ES6ImportCandidate(importedName == null ? toImport.getName() : importedName, (PsiElement)toImport, place);
        executor.createImportOrUpdateExisting(candidate);
    }

    @Nullable
    public static PsiElement getScopeToAdd(@NotNull PsiElement place, boolean fromExternalModule) {
        JSEmbeddedContent content;
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(48);
        }
        if (place instanceof JSTagEmbeddedContent || place instanceof JSFile) {
            return place;
        }
        if (!(place.getContainingFile() instanceof JSFile) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)place, JSEmbeddedContent.class)) != null) {
            return content;
        }
        if (fromExternalModule) {
            PsiElement module = ES6PsiUtil.findExternalModule(place);
            boolean isAugmentation = module instanceof TypeScriptModule && ((TypeScriptModule)module).isAugmentation();
            return module != null && !isAugmentation ? module : place.getContainingFile();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{PsiFile.class, TypeScriptModule.class});
    }

    public static void insertPsiElementToScope(@NotNull PsiElement createdPsi, @NotNull PsiElement scope2, @NotNull Pair<Boolean, PsiElement> placeFor, @Nullable Editor editor) {
        if (createdPsi == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(49);
        }
        if (scope2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(50);
        }
        if (placeFor == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(51);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file = scope2.getContainingFile();
        Project project = scope2.getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(JavaScriptBundle.message("ts.add.import.statement.dialog.title", new Object[0])).run(() -> {
            Boolean addAfter;
            Document document2;
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
            Document document3 = document2 = editor != null ? editor.getDocument() : manager.getDocument(file);
            if (document2 != null) {
                manager.commitDocument(document2);
            }
            if (Boolean.TRUE.equals(addAfter = (Boolean)placeFor.first)) {
                PsiElement added = scope2.addAfter(createdPsi, (PsiElement)placeFor.second);
                if (!ES6ImportPsiUtil.hasNewLineBefore(added) && added.getPrevSibling() != null) {
                    JSChangeUtil.addWs(scope2.getNode(), added.getNode(), "\n");
                }
            } else {
                PsiElement nodeInsertBefore = (PsiElement)placeFor.second;
                boolean isFirstElement = PsiTreeUtil.skipSiblingsBackward((PsiElement)nodeInsertBefore, (Class[])new Class[]{PsiWhiteSpace.class}) == null;
                PsiElement added = JSChangeUtil.doAddBefore(scope2, createdPsi, nodeInsertBefore);
                if (isFirstElement) {
                    JSChangeUtil.addWs(scope2.getNode(), nodeInsertBefore != null ? nodeInsertBefore.getNode() : null, "\n");
                    if (added.getPrevSibling() == null && scope2 instanceof JSEmbeddedContent) {
                        JSChangeUtil.addWs(scope2.getNode(), added.getNode(), "\n");
                    }
                }
            }
        });
    }

    public static void findPlaceAndInsertES6Import(@NotNull PsiElement scope2, @NotNull PsiElement created, @NotNull String moduleName, @Nullable Editor editor) {
        if (scope2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(52);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(53);
        }
        if (moduleName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(54);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceByModuleName(scope2, moduleName);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope2, anchor, editor);
    }

    public static void findPlaceAndInsertAnyImport(@NotNull PsiElement scope2, @NotNull PsiElement created) {
        if (scope2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(55);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(56);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceForImport(scope2);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope2, anchor, null);
    }

    private static boolean insertFromClauseForBinding(@NotNull ES6ImportExportDeclaration originalDeclaration, @NotNull String quotedRefText) {
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(57);
        }
        if (quotedRefText == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(58);
        }
        String currentText = StringUtil.trimEnd((String)originalDeclaration.getText(), (String)";");
        String importText = currentText + " from " + quotedRefText + JSCodeStyleSettings.getSemicolon((PsiElement)originalDeclaration);
        Project project = originalDeclaration.getProject();
        ES6ImportDeclaration importDeclaration = ES6CreateImportUtil.createImportByText(project, originalDeclaration, importText);
        if (importDeclaration == null) {
            return false;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{originalDeclaration.getContainingFile()}).withName(JavaScriptBundle.message("complete.import.binding", new Object[0])).run(() -> originalDeclaration.replace((PsiElement)importDeclaration));
        return true;
    }

    private static boolean importFromClauseForSpecifier(@NotNull ES6ImportExportDeclaration originalDeclaration, @NotNull String quotedRefText) {
        PsiElement errorCandidate;
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(59);
        }
        if (quotedRefText == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(60);
        }
        if ((errorCandidate = originalDeclaration.getLastChild()) instanceof ES6NamedImports) {
            errorCandidate = errorCandidate.getLastChild();
        }
        if (!(errorCandidate instanceof PsiErrorElement)) {
            return false;
        }
        String currentText = originalDeclaration.getText();
        ASTNode originalNamedImports = originalDeclaration.getNode().findChildByType((IElementType)ES6StubElementTypes.NAMED_IMPORTS);
        assert (originalNamedImports != null) : currentText;
        PsiElement anchor = originalNamedImports.getPsi();
        boolean hasCloseBrace = currentText.contains("}");
        String newText = currentText + (hasCloseBrace ? "" : "}") + " from " + quotedRefText + JSCodeStyleSettings.getSemicolon((PsiElement)originalDeclaration);
        Project project = originalDeclaration.getProject();
        ES6ImportDeclaration declaration = ES6CreateImportUtil.createImportByText(project, originalDeclaration, newText);
        if (declaration == null) {
            return false;
        }
        ES6FromClause fromClause = declaration.getFromClause();
        assert (fromClause != null) : newText;
        ASTNode node = declaration.getNode();
        ASTNode importsNode = node.findChildByType((IElementType)ES6StubElementTypes.NAMED_IMPORTS);
        assert (importsNode != null) : newText;
        ASTNode closeBrace = hasCloseBrace ? null : importsNode.findChildByType(JSTokenTypes.RBRACE);
        PsiElement fromPartStartRange = importsNode.getTreeNext().getPsi();
        assert (fromPartStartRange != null) : newText;
        PsiElement fromPartEndRange = declaration.getLastChild();
        PsiElement errorElement = errorCandidate;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{originalDeclaration.getContainingFile()}).withName(JavaScriptBundle.message("complete.import.name", new Object[0])).run(() -> {
            if (!hasCloseBrace) {
                assert (closeBrace != null);
                originalNamedImports.addChild(closeBrace);
            }
            originalDeclaration.addRangeAfter(fromPartStartRange, fromPartEndRange, anchor);
            errorElement.delete();
        });
        return true;
    }

    public static void insertFromClause(@NotNull ES6ImportExportDeclarationPart toComplete, @NotNull ES6ImportExportDeclaration originalDeclaration, @NotNull String quotedRefText) {
        if (toComplete == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(61);
        }
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(62);
        }
        if (quotedRefText == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(63);
        }
        if (toComplete instanceof ES6ImportedBinding) {
            ES6CreateImportUtil.insertFromClauseForBinding(originalDeclaration, quotedRefText);
        } else {
            ES6CreateImportUtil.importFromClauseForSpecifier(originalDeclaration, quotedRefText);
        }
    }

    @Nullable
    private static ES6ImportDeclaration createImportByText(Project project, @NotNull ES6ImportExportDeclaration originalDeclaration, String newText) {
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(64);
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)originalDeclaration);
        if (dialect == null) {
            return null;
        }
        PsiFile dummy = psiFileFactory.createFileFromText("dummy", (Language)dialect, (CharSequence)newText);
        if (!(dummy.getFirstChild() instanceof ES6ImportDeclaration) || dummy.getChildren().length > 1) {
            Logger.getInstance(ES6CreateImportUtil.class).error("Incorrect new import text", new Attachment[]{new Attachment("newText.txt", newText)});
            return null;
        }
        return (ES6ImportDeclaration)dummy.getFirstChild();
    }

    @Nullable
    public static JSModuleNameInfo getExactExternalFileModuleName(@NotNull PsiElement place, @NotNull VirtualFile dstFile) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(65);
        }
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(66);
        }
        JSImportPathBuilder builder2 = JSImportPathBuilder.createBuilder(new JSImportPathConfigurationImpl(place, dstFile));
        Ref ref = Ref.create();
        JSImportDescriptorProcessor processor = JSImportPathBuilder.createSearchProcessor((Ref<? super JSImportDescriptor>)ref, ArrayUtilRt.EMPTY_STRING_ARRAY);
        builder2.processDirectModuleNames(false, processor);
        JSImportDescriptor descriptor = (JSImportDescriptor)ref.get();
        if (descriptor == null) {
            return null;
        }
        return (JSModuleNameInfo)ObjectUtils.tryCast((Object)descriptor.getModuleDescriptor(), JSModuleNameInfo.class);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull PsiElement elementToImport, @NotNull PsiElement place, boolean useExistingImports) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(67);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(68);
        }
        PsiFile originalFile = elementToImport.getContainingFile().getOriginalFile();
        return ES6CreateImportUtil.getExternalFileModuleName(elementToImport, originalFile.getVirtualFile(), place, useExistingImports);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport, @NotNull PsiElement place, boolean useExistingImports) {
        if (fileToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(69);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(70);
        }
        JSImportPathBuilder builder2 = JSImportPathBuilder.createBuilder(new JSImportPathConfigurationImpl(place, elementToImport, fileToImport, useExistingImports, null));
        return ES6CreateImportUtil.getExternalFileModuleName(builder2);
    }

    @Nullable
    public static JSImportDescriptor getImportDescriptor(@Nullable String importedName, @Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport, @NotNull PsiElement place, boolean useExistingImports) {
        if (fileToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(71);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(72);
        }
        JSImportPathConfigurationImpl configuration = new JSImportPathConfigurationImpl(place, elementToImport, fileToImport, useExistingImports, importedName);
        return ES6CreateImportUtil.getImportDescriptor(JSImportPathBuilder.createBuilder(configuration));
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull JSImportPathBuilder builder2) {
        if (builder2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(73);
        }
        Ref ref = Ref.create();
        builder2.processDescriptorsWithModuleName(JSImportPathBuilder.createDefaultSearchProcessor((Ref<JSImportDescriptor>)ref, builder2));
        JSImportDescriptor descriptor = (JSImportDescriptor)ref.get();
        if (descriptor == null) {
            return null;
        }
        return (JSModuleNameInfo)ObjectUtils.tryCast((Object)descriptor.getModuleDescriptor(), JSModuleNameInfo.class);
    }

    @Nullable
    public static JSImportDescriptor getImportDescriptor(@NotNull JSImportPathBuilder builder2) {
        if (builder2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(74);
        }
        Ref ref = Ref.create();
        builder2.processDescriptors(JSImportPathBuilder.createDefaultSearchProcessor((Ref<JSImportDescriptor>)ref, builder2));
        return (JSImportDescriptor)ref.get();
    }

    public static void addRequiredImports(@NotNull ES6ReferenceExpressionsInfo info2, @NotNull PsiElement destinationModule) {
        if (info2 == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(75);
        }
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(76);
        }
        ES6CreateImportUtil.addRequiredImports(Collections.singletonList(info2), (Condition<? super PsiElement>)Conditions.alwaysFalse(), destinationModule);
    }

    public static void addRequiredImports(@NotNull Collection<ES6ReferenceExpressionsInfo> infos, @NotNull Condition<? super PsiElement> excludedFilter, @NotNull PsiElement destinationModule) {
        if (infos == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(77);
        }
        if (excludedFilter == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(78);
        }
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(79);
        }
        List<Pair<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>> imports = infos.stream().flatMap(i -> i.getReferencedImports().entrySet().stream()).filter(pair -> {
            PsiElement toImport = (PsiElement)pair.getValue();
            PsiElement targetModule = ES6PsiUtil.findExternalModule(toImport, false);
            return !destinationModule.isEquivalentTo(targetModule);
        }).map(entry -> Pair.create((Object)((ES6ImportPsiUtil.CreateImportExportInfo)entry.getKey()), (Object)((PsiElement)entry.getValue()))).collect(Collectors.toList());
        ES6CreateImportUtil.addRequiredImports(destinationModule, DialectDetector.languageOfElement(destinationModule), imports);
        List<PsiElement> elements = infos.stream().flatMap(info2 -> info2.getExportedLocalReferencedElements().stream()).filter(e -> !excludedFilter.value(e)).toList();
        for (PsiElement element : elements) {
            if (!(element instanceof JSQualifiedNamedElement)) continue;
            ES6CreateImportUtil.insertImport(destinationModule, (JSQualifiedNamedElement)element, ((JSQualifiedNamedElement)element).getName());
        }
    }

    public static void addRequiredImports(@NotNull PsiElement destinationModule, @NotNull Language contextLanguage, @NotNull Collection<Pair<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>> imports) {
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(80);
        }
        if (contextLanguage == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(81);
        }
        if (imports == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(82);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Pair<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> entry : imports) {
            ES6ImportPsiUtil.CreateImportExportInfo createInfo = (ES6ImportPsiUtil.CreateImportExportInfo)entry.getFirst();
            PsiElement element = (PsiElement)entry.getSecond();
            PsiElement module = ES6PsiUtil.findExternalModule(element, false);
            if (module instanceof TypeScriptModule) {
                String exportedName = createInfo.getExportedName();
                String importedName = createInfo.getImportedName();
                String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
                String externalModuleText = ((TypeScriptModule)module).getExternalModuleText();
                if (externalModuleText == null || actualExportedName == null) continue;
                JSAddImportExecutor executor = JSHandlersFactory.forLanguage(contextLanguage).createAddImportExecutor(destinationModule);
                if (executor == null) {
                    return;
                }
                executor.createImportOrUpdateExisting(new JSSimpleImportDescriptor(module, StringUtil.unquoteString((String)externalModuleText), createInfo));
                continue;
            }
            ES6ImportPsiUtil.insertJSImport(destinationModule, contextLanguage, createInfo, element);
        }
    }

    public static void optimizeImports(@NotNull PsiElement toOptimize) {
        PsiFile file;
        if (toOptimize == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(83);
        }
        if ((file = toOptimize.getContainingFile()) == null) {
            return;
        }
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file);
        for (ImportOptimizer optimizer : optimizers) {
            if (!optimizer.supports(file)) continue;
            optimizer.processFile(file).run();
            return;
        }
        new ES6ImportOptimizer().processFile(file).run();
    }

    public static boolean isIndexFile(@Nullable PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return false;
        }
        return ((PsiFile)element).getName().startsWith(INDEX_WITH_DOT);
    }

    @NotNull
    public static String convertScopedTypesName(@NotNull String name) {
        int separatorIndex;
        if (name == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(84);
        }
        if ((separatorIndex = name.indexOf("__")) <= 0) {
            String string = name;
            if (string == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(85);
            }
            return string;
        }
        String scope2 = name.substring(0, separatorIndex);
        String module = name.substring(separatorIndex + 2);
        if (module.isEmpty()) {
            String string = name;
            if (string == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(86);
            }
            return string;
        }
        String string = "@" + scope2 + "/" + module;
        if (string == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    public static String convertAtTypesToOriginalName(@NotNull String name) {
        if (name == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(88);
        }
        if (name.startsWith("@types/")) {
            return ES6CreateImportUtil.convertScopedTypesName(name.substring("@types/".length()));
        }
        return name;
    }

    @Nullable
    public static JSModuleNameInfo getModuleInfo(@NotNull PsiElement place, @Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile) {
        PsiElement module;
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(89);
        }
        if (targetPsiFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(90);
        }
        if (importedElement != null && (module = ES6PsiUtil.findExternalModule(importedElement)) instanceof TypeScriptModule) {
            return null;
        }
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        JSImportPathConfigurationImpl configuration = new JSImportPathConfigurationImpl(place, importedElement, targetFile, false, null);
        return ES6CreateImportUtil.getExternalFileModuleName(JSImportPathBuilder.createBuilder(configuration));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 18, 19, 20, 21, 26, 27, 31, 32, 33, 34, 37, 38, 85, 86, 87 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: 
            case 22: 
            case 25: 
            case 30: 
            case 39: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 23: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 85: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil";
                break;
            }
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdPsi";
                break;
            }
            case 50: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFor";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 57: 
            case 59: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDeclaration";
                break;
            }
            case 58: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRefText";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toComplete";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 76: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationModule";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFilter";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLanguage";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOptimize";
                break;
            }
            case 84: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInModule";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElement";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "expandExportSpecifierForResolveSymbolInModule";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolToImportSearchScope";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "convertScopedTypesName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolInFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 85: 
            case 86: 
            case 87: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModule";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModuleWithName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIfDirectOrIndirectEquivalent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExportedNameForResolveInModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "expandExportSpecifierForResolveSymbolInModule";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolToImportSearchScope";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "insertExport";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "insertExportName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "insertImport";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getScopeToAdd";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "insertPsiElementToScope";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceAndInsertES6Import";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceAndInsertAnyImport";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "insertFromClauseForBinding";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "importFromClauseForSpecifier";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "insertFromClause";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createImportByText";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getExactExternalFileModuleName";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getExternalFileModuleName";
                break;
            }
            case 71: 
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getImportDescriptor";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredImports";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "convertScopedTypesName";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "convertAtTypesToOriginalName";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 18, 19, 20, 21, 26, 27, 31, 32, 33, 34, 37, 38, 85, 86, 87 -> new IllegalStateException(string);
        };
    }
}

