/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExpressionParser<T extends JavaScriptParser<?, ?, ?, ?>>
extends ExpressionParser<T> {
    public ES6ExpressionParser(T parser2) {
        super(parser2);
    }

    public static int collapseGtAndGetPriority(boolean advance, @NotNull PsiBuilder builder2) {
        IElementType tokenType;
        if (builder2 == null) {
            ES6ExpressionParser.$$$reportNull$$$0(0);
        }
        if ((tokenType = builder2.getTokenType()) == JSTokenTypes.GT && builder2.rawLookup(1) == JSTokenTypes.EQ) {
            if (advance) {
                PsiBuilder.Marker marker = builder2.mark();
                builder2.advanceLexer();
                builder2.advanceLexer();
                marker.collapse(JSTokenTypes.GE);
            }
            return 6;
        }
        if (tokenType == JSTokenTypes.GT && builder2.rawLookup(1) == JSTokenTypes.GT) {
            if (advance) {
                PsiBuilder.Marker marker = builder2.mark();
                builder2.advanceLexer();
                builder2.advanceLexer();
                if (builder2.getTokenType() == JSTokenTypes.GT) {
                    builder2.advanceLexer();
                    marker.collapse(JSTokenTypes.GTGTGT);
                } else {
                    marker.collapse(JSTokenTypes.GTGT);
                }
            }
            return 7;
        }
        return -1;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).tryParseES7Decorators() && this.builder.getTokenType() == JSTokenTypes.RBRACE) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            property.done((IElementType)ES6ElementTypes.ES6_PROPERTY);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected boolean isPropertyStart(IElementType elementType) {
        return super.isPropertyStart(elementType) || elementType == JSTokenTypes.MULT || elementType == JSTokenTypes.AT;
    }

    @Override
    protected void parseDestructuringProperty() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY)) {
            return;
        }
        super.parseDestructuringProperty();
    }

    private boolean tryParseDestructuringRestElement(IElementType type2) {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker property = this.builder.mark();
            this.parseDestructuringRestElementNoMarker(false);
            property.done(type2);
            return true;
        }
        return false;
    }

    protected void parseDestructuringRestElementNoMarker(boolean parseType) {
        assert (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT);
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        if (this.isIdentifierToken(tokenType)) {
            PsiBuilder.Marker var = this.builder.mark();
            this.builder.advanceLexer();
            IElementType varType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (varType != null);
            if (parseType) {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            var.done(varType);
        } else if (tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.LBRACKET) {
            PsiBuilder.Marker mark = this.builder.mark();
            mark.done(this.parseDestructuringElementNoMarker(false, false));
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        }
    }

    @Override
    protected void parseDestructuringArrayElement() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY_REST)) {
            return;
        }
        super.parseDestructuringArrayElement();
    }

    @Override
    protected boolean parseArrayElement(boolean first, Ref<IElementType> elementTypeRef) {
        boolean parseMoreElements = true;
        if (first && this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            while (true) {
                if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                    ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseIfStatementHeader();
                    continue;
                }
                if (this.builder.getTokenType() != JSTokenTypes.FOR_KEYWORD) break;
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            }
            parseMoreElements = false;
        }
        if (!this.parseSpreadExpression()) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            parseMoreElements = false;
        }
        return parseMoreElements;
    }

    @Override
    @Nullable
    protected IElementType getSafeAccessOperator() {
        return JSTokenTypes.ELVIS;
    }

    @Override
    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return super.isReferenceQualifierSeparator(tokenType) || tokenType == this.getSafeAccessOperator();
    }

    @Override
    protected boolean parseArgument() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            return this.parseSpreadExpression();
        }
        return super.parseArgument();
    }

    private boolean parseSpreadExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(true)) {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                marker.drop();
                return false;
            }
            marker.done((IElementType)JSElementTypes.SPREAD_EXPRESSION);
        } else if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected boolean parseUnaryExpression() {
        IElementType type2 = this.builder.getTokenType();
        if (type2 == JSTokenTypes.AWAIT_KEYWORD) {
            if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).isAsyncContext() || !ES6ExpressionParser.hasLineTerminatorAfter(this.builder) && this.myJavaScriptParser.isIdentifierName(this.builder.lookAhead(1))) {
                PsiBuilder.Marker expr = this.builder.mark();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(JSElementTypes.PREFIX_EXPRESSION);
                return true;
            }
            return this.parsePostfixExpression();
        }
        if (type2 == JSTokenTypes.THROW_KEYWORD) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                mark.rollbackTo();
                return false;
            }
            mark.done(JSElementTypes.THROW_EXPRESSION);
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD) {
            PsiBuilder.Marker doMarker = this.builder.mark();
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlock();
            doMarker.done(ES6ElementTypes.DO_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                if (!"target".equals(this.builder.getTokenText())) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.target", new Object[0]));
                }
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
            }
            marker.done(ES6ElementTypes.META_PROPERTY);
            return false;
        }
        return super.parseNewExpression();
    }

    @Override
    public boolean parseAssignmentExpression(boolean allowIn) {
        if ((this.builder.getTokenType() == JSTokenTypes.LPAR || this.isIdentifierToken(this.builder.getTokenType())) && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseAssignmentExpression(allowIn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/ecmascript6/parsing/ES6ExpressionParser", "collapseGtAndGetPriority"));
    }
}

