/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.index;

import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0004\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/ecmascript6/index/JSFrameworkFileIncludeProvider;", "Lcom/intellij/psi/impl/include/FileIncludeProvider;", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "(Lcom/intellij/openapi/fileTypes/LanguageFileType;)V", "acceptFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "createFileIncludeInfos", "", "Lcom/intellij/psi/impl/include/FileIncludeInfo;", "importDeclarations", "", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "(Ljava/util/List;)[Lcom/intellij/psi/impl/include/FileIncludeInfo;", "getId", "", "registerFileTypesUsedForIndexing", "", "fileTypeSink", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSFrameworkFileIncludeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFrameworkFileIncludeProvider.kt\ncom/intellij/lang/ecmascript6/index/JSFrameworkFileIncludeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n*S KotlinDebug\n*F\n+ 1 JSFrameworkFileIncludeProvider.kt\ncom/intellij/lang/ecmascript6/index/JSFrameworkFileIncludeProvider\n*L\n36#1:47\n36#1:48,3\n*E\n"})
public abstract class JSFrameworkFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    private final LanguageFileType fileType;

    public JSFrameworkFileIncludeProvider(@NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    @NotNull
    public final String getId() {
        String string = this.fileType.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return string;
    }

    public final boolean acceptFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)this.fileType);
    }

    public final boolean acceptFile(@NotNull VirtualFile file, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.acceptFile(file);
    }

    public final void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        Intrinsics.checkNotNullParameter(fileTypeSink, (String)"fileTypeSink");
        fileTypeSink.consume((Object)this.fileType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final FileIncludeInfo[] createFileIncludeInfos(@NotNull List<? extends ES6ImportDeclaration> importDeclarations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(importDeclarations, (String)"importDeclarations");
        Iterable $this$map$iv = importDeclarations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ES6ImportDeclaration eS6ImportDeclaration = (ES6ImportDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String importModuleText = it.getImportModuleText();
            String string = importModuleText;
            if (string == null) {
                if (it.getFromClause() == null) {
                    string = null;
                } else {
                    ES6FromClause eS6FromClause;
                    Intrinsics.checkNotNull((Object)eS6FromClause);
                    ES6FromClause fromClause = eS6FromClause;
                    if (fromClause.getReferenceText() == null) {
                        string = null;
                    } else {
                        String string2;
                        Intrinsics.checkNotNull((Object)string2);
                        String referenceText = string2;
                        string = StringUtil.unquoteString((String)referenceText);
                    }
                }
            }
            collection.add(string);
        }
        Set result2 = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        FileIncludeInfo[] fileIncludeInfoArray = ES6FileIncludeProvider.buildFileIncludeInfo(result2);
        Intrinsics.checkNotNullExpressionValue((Object)fileIncludeInfoArray, (String)"buildFileIncludeInfo(...)");
        return fileIncludeInfoArray;
    }
}

