/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSImportsValues;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSCompositeImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExternalModule;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportDescriptorBuilder {
    protected final PsiElement myPlace;
    private final boolean myAllowSameFileImports;

    public JSImportDescriptorBuilder(@NotNull PsiElement place) {
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(0);
        }
        this(place, false);
    }

    public JSImportDescriptorBuilder(@NotNull PsiElement place, boolean allowSameFileImports) {
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(1);
        }
        this.myPlace = place;
        this.myAllowSameFileImports = allowSameFileImports;
    }

    @Nullable
    public JSImportDescriptor createDescriptor(@NotNull String importedName, @NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo.ImportContext importContext) {
        JSImportDescriptor descriptor;
        if (importedName == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(2);
        }
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(3);
        }
        if (importContext == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(4);
        }
        if ((descriptor = this.createDescriptorImpl(importedName, elementToImport)) == null) {
            return null;
        }
        JSImportExportType type2 = descriptor.getImportType();
        return switch (importContext) {
            case JSImportPlaceInfo.ImportContext.BINDING -> {
                if (type2.isDefault()) {
                    yield descriptor;
                }
                yield null;
            }
            case JSImportPlaceInfo.ImportContext.SPECIFIER -> {
                if (type2.isSpecifier()) {
                    yield descriptor;
                }
                yield null;
            }
            default -> descriptor;
        };
    }

    @Nullable
    private JSImportDescriptor createForNamespaceAndModuleImport(@NotNull String importedName, @NotNull PsiElement elementToImport) {
        JSImportDescriptor namespaceDescriptor;
        if (importedName == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(5);
        }
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(6);
        }
        PsiElement current = elementToImport.getParent();
        PsiElement lastElement = null;
        while (current != null) {
            PsiElement parent = current.getParent();
            if (parent != null && ES6PsiUtil.isExternalModule(parent)) {
                lastElement = current;
                break;
            }
            current = parent;
        }
        if (!(lastElement instanceof JSQualifiedNamedElement)) {
            return null;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)lastElement;
        String moduleName = element.getName();
        if (moduleName == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        if (!this.hasImportForNamespace(element, moduleName)) {
            JSImportDescriptor descriptor = this.createDescriptorImpl(moduleName, (PsiElement)element);
            if (descriptor == null) {
                return null;
            }
            descriptors.add(descriptor);
        }
        if ((namespaceDescriptor = this.createDescriptorForImportType(importedName, elementToImport, ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE)) == null) {
            return null;
        }
        descriptors.add(namespaceDescriptor);
        return new JSCompositeImportDescriptor((List<JSImportDescriptor>)descriptors, ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE);
    }

    private boolean hasImportForNamespace(@NotNull JSQualifiedNamedElement element, @NotNull String name) {
        PsiElement scope2;
        if (element == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(8);
        }
        if ((scope2 = ES6CreateImportUtil.getScopeToAdd(this.myPlace, false)) == null) {
            return false;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(name, this.myPlace);
        return result2.getElements().contains(element);
    }

    @Nullable
    private JSImportDescriptor createDescriptorImpl(@NotNull String importedName, @NotNull PsiElement elementToImport) {
        JSImportExportType importType;
        if (importedName == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(9);
        }
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(10);
        }
        if ((importType = JSImportDescriptorBuilder.getImportType(elementToImport, this.myPlace, this.myAllowSameFileImports)) == null) {
            return null;
        }
        return this.createDescriptorForImportType(importedName, elementToImport, importType);
    }

    @Nullable
    public static JSImportExportType getImportType(@NotNull PsiElement candidate, @NotNull PsiElement place) {
        if (candidate == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(12);
        }
        return JSImportDescriptorBuilder.getImportType(candidate, place, false);
    }

    @Nullable
    public static JSImportExportType getImportType(@NotNull PsiElement candidate, @NotNull PsiElement place, boolean allowSameFileImport) {
        JSModuleStatusOwner.ModuleStatus status;
        if (candidate == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(13);
        }
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(14);
        }
        JSElement placeContainer = ES6PsiUtil.getExportScope(place);
        if (JSImportDescriptorBuilder.isExternalModule(candidate) && !Objects.equals(placeContainer, candidate)) {
            return ES6ImportPsiUtil.ImportExportType.DEFAULT;
        }
        if (!(candidate instanceof JSElement)) {
            return null;
        }
        JSElement elementToImport = (JSElement)candidate;
        JSElement elementContainer = JSImportDescriptorBuilder.getDirectOrRelatedExportScope((PsiElement)elementToImport);
        if (elementContainer == null || !allowSameFileImport && elementContainer.isEquivalentTo((PsiElement)placeContainer)) {
            return null;
        }
        if (elementContainer instanceof JSModuleStatusOwner && ((status = ((JSModuleStatusOwner)((Object)elementContainer)).getModuleStatus()) == JSModuleStatusOwner.ModuleStatus.COMMONJS || status == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS)) {
            return JSImportDescriptorBuilder.getImportTypeForCommonJS((JSElement)candidate);
        }
        return JSImportDescriptorBuilder.getImportType(elementToImport, (PsiElement)elementContainer, place);
    }

    @Nullable
    private static JSImportExportType getImportTypeForCommonJS(@NotNull JSElement candidate) {
        if (candidate == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(15);
        }
        if (!(candidate instanceof JSPsiElementBase)) {
            return null;
        }
        return CommonJSUtil.isExportedWithModuleExports((JSPsiElementBase)candidate) ? ES6ImportPsiUtil.ImportExportType.DEFAULT : (CommonJSUtil.isExportNamespace(((JSPsiElementBase)candidate).getJSNamespace()) ? ES6ImportPsiUtil.ImportExportType.SPECIFIER : null);
    }

    public static boolean isExternalModule(@NotNull PsiElement candidate) {
        if (candidate == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(16);
        }
        return candidate instanceof JSExternalModule || !(candidate instanceof JSFile) && candidate instanceof PsiFile;
    }

    @Nullable
    public static String getExportedNameForExternalModule(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(17);
        }
        if ((file = element.getContainingFile()) instanceof JSExternalModule) {
            JSExternalModule externalModule = (JSExternalModule)file;
            return externalModule.getDefaultExportedName();
        }
        String fileName = file.getName();
        String nameWithoutExtension = JSFileReferencesUtil.getFileNameWithoutExtension(fileName, JSFileReferencesUtil.IMPLICIT_EXTENSIONS);
        return StringUtil.capitalizeWords((String)nameWithoutExtension, (String)"-_", (boolean)true, (boolean)false).replace(" ", "");
    }

    @Nullable
    private static JSQualifiedName getElementNamespace(@NotNull PsiElement elementToImport) {
        String name;
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(18);
        }
        if (elementToImport instanceof JSQualifiedNamedElement) {
            return ((JSQualifiedNamedElement)elementToImport).getNamespace();
        }
        if (!(elementToImport instanceof ES6ImportExportDeclarationPart)) {
            return null;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(elementToImport);
        if (module instanceof TypeScriptModule && ((TypeScriptModule)module).isExternal() && !((TypeScriptModule)module).isAugmentation() && (name = ((TypeScriptModule)module).getName()) != null) {
            return JSQualifiedNameImpl.fromQualifiedName(name);
        }
        return null;
    }

    @Nullable
    private JSImportDescriptor createDescriptorForImportType(@NotNull String importedName, @NotNull PsiElement elementToImport, @NotNull JSImportExportType importType) {
        if (importedName == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(19);
        }
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(20);
        }
        if (importType == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(21);
        }
        if (importType.isComposite()) {
            return this.createForNamespaceAndModuleImport(importedName, elementToImport);
        }
        if (JSImportDescriptorBuilder.isExternalModule(elementToImport)) {
            if (importType.isDefault()) {
                VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)elementToImport);
                return file != null ? ES6CreateImportUtil.getImportDescriptor(importedName, elementToImport, file, this.myPlace, true) : null;
            }
            return null;
        }
        JSElement elementExportScope = JSImportDescriptorBuilder.getDirectOrRelatedExportScope(elementToImport);
        if (elementExportScope == null) {
            return null;
        }
        if (importType.isNamespace()) {
            JSQualifiedName namespace = JSImportDescriptorBuilder.getElementNamespace(elementToImport);
            String moduleOrNamespaceName = namespace == null ? importedName : namespace + "." + importedName;
            JSModuleDescriptor.SimpleModuleDescriptor descriptor = new JSModuleDescriptor.SimpleModuleDescriptor(null, moduleOrNamespaceName);
            return new JSSimpleImportDescriptor(descriptor, this.createSimpleElementDescriptor(importedName, elementToImport, importType));
        }
        PsiElement rawExternalModule = JSImportDescriptorBuilder.getRawExternalModule(elementToImport, (PsiElement)elementExportScope);
        if (rawExternalModule == null) {
            return null;
        }
        if (rawExternalModule instanceof PsiFile) {
            PsiFile moduleFile = (PsiFile)rawExternalModule;
            return ES6CreateImportUtil.getImportDescriptor(importedName, elementToImport, moduleFile.getVirtualFile(), this.myPlace, true);
        }
        if (!(rawExternalModule instanceof TypeScriptModule)) {
            return null;
        }
        String rawName = ((TypeScriptModule)rawExternalModule).getExternalModuleText();
        if (rawName == null) {
            return null;
        }
        JSModuleDescriptor.SimpleModuleDescriptor descriptor = new JSModuleDescriptor.SimpleModuleDescriptor(rawExternalModule, StringUtil.unquoteString((String)rawName));
        return new JSSimpleImportDescriptor(descriptor, this.createSimpleElementDescriptor(importedName, elementToImport, importType));
    }

    @NotNull
    private ES6ImportPsiUtil.CreateImportExportInfo createSimpleElementDescriptor(@NotNull String importedName, @NotNull PsiElement elementToImport, @NotNull JSImportExportType importType) {
        if (importedName == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(22);
        }
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(23);
        }
        if (importType == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(24);
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = JSImportDescriptorBuilder.detectPrefixKind(elementToImport, this.myPlace);
        String name = elementToImport instanceof PsiNamedElement ? ((PsiNamedElement)elementToImport).getName() : null;
        return new ES6ImportPsiUtil.CreateImportExportInfo(name, importedName, importType, kind);
    }

    @Nullable
    public static JSElement getDirectOrRelatedExportScope(@NotNull PsiElement elementToImport) {
        JSElement scope2;
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(25);
        }
        if (!((scope2 = ES6PsiUtil.getExportScope(elementToImport)) instanceof TypeScriptModule) || ((TypeScriptModule)scope2).isExternal() || elementToImport instanceof TypeScriptModule) {
            return scope2;
        }
        JSElement externalModule = JSImportDescriptorBuilder.getExternalModuleWithSameName((TypeScriptModule)scope2);
        return externalModule != null ? externalModule : scope2;
    }

    @Nullable
    private static JSElement getExternalModuleWithSameName(@NotNull TypeScriptModule scope2) {
        PsiElement parent;
        if (scope2 == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(26);
        }
        if (!((parent = scope2.getContext()) instanceof JSFile)) {
            return null;
        }
        String name = scope2.getName();
        if (name == null) {
            return null;
        }
        List modules = ((StreamEx)StreamEx.of(JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(parent)).select(TypeScriptModule.class).filter(TypeScriptModule::isExternal)).toList();
        for (TypeScriptModule module : modules) {
            List<PsiElement> elements;
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(module);
            if (assignment == null || !name.equals(assignment.getInitializerReference()) || !(elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, module)).contains(scope2)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    private static PsiElement getRawExternalModule(@NotNull PsiElement elementToImport, @NotNull PsiElement elementContainer) {
        PsiElement externalModuleForContainer;
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(27);
        }
        if (elementContainer == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(28);
        }
        if (ES6PsiUtil.isExternalModule(elementToImport)) {
            return elementToImport;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isAugmentation()) {
            return elementContainer.getParent();
        }
        if (elementContainer instanceof PsiFile || ES6PsiUtil.isEmbeddedModule(elementContainer)) {
            return elementContainer.getContainingFile();
        }
        PsiElement psiElement = externalModuleForContainer = ES6PsiUtil.isExternalModule(elementContainer) ? elementContainer : elementContainer.getParent();
        if (!ES6PsiUtil.isExternalModule(externalModuleForContainer)) {
            return null;
        }
        if (externalModuleForContainer instanceof TypeScriptModule) {
            String currentModuleName = ((TypeScriptModule)externalModuleForContainer).getExternalModuleText();
            return currentModuleName == null ? null : externalModuleForContainer;
        }
        return elementContainer.getContainingFile();
    }

    @NotNull
    public static ES6ImportExportDeclaration.ImportExportPrefixKind detectPrefixKind(@Nullable PsiElement element, @NotNull PsiElement place) {
        boolean isTypeContext;
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(29);
        }
        if (element == null) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT;
            if (importExportPrefixKind == null) {
                JSImportDescriptorBuilder.$$$reportNull$$$0(30);
            }
            return importExportPrefixKind;
        }
        boolean bl = isTypeContext = element instanceof TypeScriptCompileTimeType || element instanceof JSClass && place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place) || place.getParent() instanceof TypeScriptTypeofType;
        if (!isTypeContext) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT;
            if (importExportPrefixKind == null) {
                JSImportDescriptorBuilder.$$$reportNull$$$0(31);
            }
            return importExportPrefixKind;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule(element);
        if (externalModule != null && DialectDetector.isFlow(externalModule)) {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE;
            if (importExportPrefixKind == null) {
                JSImportDescriptorBuilder.$$$reportNull$$$0(32);
            }
            return importExportPrefixKind;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = JSImportDescriptorBuilder.preferImportType(place) ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE : ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE_OR_SIMPLE;
        if (importExportPrefixKind == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(33);
        }
        return importExportPrefixKind;
    }

    public static boolean preferImportType(@NotNull PsiElement place) {
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(34);
        }
        JSCodeStyleSettings.UseImportType useImportType = JSCodeStyleSettings.getSettings(place).getUseImportType();
        return switch (useImportType) {
            default -> throw new IncompatibleClassChangeError();
            case JSCodeStyleSettings.UseImportType.ALWAYS -> true;
            case JSCodeStyleSettings.UseImportType.NEVER -> false;
            case JSCodeStyleSettings.UseImportType.AUTO -> {
                TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile());
                if (config != null && (config.importsNotUsedAsValues() == JSImportsValues.ERROR || config.verbatimModuleSyntax())) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Nullable
    private static ES6ImportPsiUtil.ImportExportType getImportType(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @NotNull PsiElement place) {
        TypeScriptModule container;
        ES6ImportExportSpecifier element;
        if (elementToImport == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(35);
        }
        if (elementContainer == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(36);
        }
        if (place == null) {
            JSImportDescriptorBuilder.$$$reportNull$$$0(37);
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elementToImport instanceof ES6ExportSpecifierAlias && (element = ((ES6ExportSpecifierAlias)elementToImport).findSpecifierElement()) != null) {
            elementToImport = element;
        }
        if (elementToImport instanceof ES6ExportedDefaultBinding) {
            boolean isDefault = "default".equals(elementToImport.getName());
            return isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        if (elementToImport instanceof ES6ExportSpecifier) {
            return ((ES6ExportSpecifier)elementToImport).isExportDefault() ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        if (elementContainer instanceof TypeScriptModule && (container = (TypeScriptModule)elementContainer).isAugmentation()) {
            if (TypeScriptAutoImportUtil.isSelfExportedAugmentationModule(container)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            return null;
        }
        boolean isExported = ES6ImportHandler.checkExportedOrCalculate((PsiElement)elementToImport);
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer);
        if (exportAssignment instanceof TypeScriptExportAssignment) {
            if (isExported && !PsiTreeUtil.isAncestor((PsiElement)elementContainer, (PsiElement)elementToImport, (boolean)true)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile());
            if (config != null && config.allowSyntheticDefaultImports()) {
                return ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            if (elementToImport instanceof TypeScriptModule) {
                return DialectDetector.isTypeScript(place) ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            return ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT;
        }
        if (ES6ImportHandler.checkExportedWithDefaultOrCalculate((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.DEFAULT;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isInternal()) {
            PsiElement module = ES6PsiUtil.findExternalModule(elementContainer);
            if (module == null) {
                return ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE;
            }
            JSExportAssignment externalModuleExportAssignment = TypeScriptAutoImportUtil.getExportAssignment(module);
            if (!(externalModuleExportAssignment instanceof TypeScriptExportAssignment) || elementContainer.getParent() != module) {
                return ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE;
            }
        }
        return elementToImport.getContext() instanceof JSExportAssignment || !isExported ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 30, 31, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContainer";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/actions/JSImportDescriptorBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/actions/JSImportDescriptorBuilder";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPrefixKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForNamespaceAndModuleImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasImportForNamespace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getImportTypeForCommonJS";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExportedNameForExternalModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementNamespace";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorForImportType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleElementDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDirectOrRelatedExportScope";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExternalModuleWithSameName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRawExternalModule";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "detectPrefixKind";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "preferImportType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 30, 31, 32, 33 -> new IllegalStateException(string);
        };
    }
}

