/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.webSymbols.symbols;

import com.intellij.javascript.webSymbols.JSWebSymbolUtils;
import com.intellij.javascript.webSymbols.documentation.JSWebSymbolDocumentationCustomizer;
import com.intellij.javascript.webSymbols.documentation.JSWebSymbolDocumentationCustomizerKt;
import com.intellij.javascript.webSymbols.symbols.JSPropertySymbolKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolOrigin;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.documentation.WebSymbolDocumentation;
import com.intellij.webSymbols.js.WebSymbolJsKind;
import com.intellij.webSymbols.query.WebSymbolsListSymbolsQueryParams;
import com.intellij.webSymbols.query.WebSymbolsNameMatchQueryParams;
import com.intellij.webSymbols.refactoring.WebSymbolRenameTarget;
import com.intellij.webSymbols.search.WebSymbolSearchTarget;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0016\u00100\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u000001H&J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J,\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J,\u0010?\u001a\b\u0012\u0004\u0012\u00020>062\u0006\u0010@\u001a\u00020A2\u0006\u0010:\u001a\u00020B2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\u000bj\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u0016\u0010)\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006F"}, d2={"Lcom/intellij/javascript/webSymbols/symbols/JSWebSymbolBase;", "T", "Lcom/intellij/lang/javascript/psi/JSElement;", "Lcom/intellij/webSymbols/PsiSourcedWebSymbol;", "source", "(Lcom/intellij/lang/javascript/psi/JSElement;)V", "apiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "description", "", "getDescription", "()Ljava/lang/String;", "jsKind", "Lcom/intellij/webSymbols/js/WebSymbolJsKind;", "getJsKind", "()Lcom/intellij/webSymbols/js/WebSymbolJsKind;", "namespace", "Lcom/intellij/webSymbols/SymbolNamespace;", "getNamespace", "origin", "Lcom/intellij/webSymbols/WebSymbolOrigin;", "getOrigin", "()Lcom/intellij/webSymbols/WebSymbolOrigin;", "properties", "", "", "getProperties", "()Ljava/util/Map;", "renameTarget", "Lcom/intellij/webSymbols/refactoring/WebSymbolRenameTarget;", "getRenameTarget", "()Lcom/intellij/webSymbols/refactoring/WebSymbolRenameTarget;", "searchTarget", "Lcom/intellij/webSymbols/search/WebSymbolSearchTarget;", "getSearchTarget", "()Lcom/intellij/webSymbols/search/WebSymbolSearchTarget;", "getSource", "()Lcom/intellij/lang/javascript/psi/JSElement;", "Lcom/intellij/lang/javascript/psi/JSElement;", "type", "getType", "()Ljava/lang/Object;", "createDocumentation", "Lcom/intellij/webSymbols/documentation/WebSymbolDocumentation;", "location", "Lcom/intellij/psi/PsiElement;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "getMatchingSymbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "qualifiedName", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "params", "Lcom/intellij/webSymbols/query/WebSymbolsNameMatchQueryParams;", "scope", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "getSymbols", "qualifiedKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "Lcom/intellij/webSymbols/query/WebSymbolsListSymbolsQueryParams;", "hashCode", "", "isExclusiveFor", "intellij.javascript.web"})
@SourceDebugExtension(value={"SMAP\nJSWebSymbolBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSWebSymbolBase.kt\ncom/intellij/javascript/webSymbols/symbols/JSWebSymbolBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JSWebSymbolUtils.kt\ncom/intellij/javascript/webSymbols/JSWebSymbolUtils\n*L\n1#1,109:1\n1#2:110\n36#3:111\n*S KotlinDebug\n*F\n+ 1 JSWebSymbolBase.kt\ncom/intellij/javascript/webSymbols/symbols/JSWebSymbolBase\n*L\n75#1:111\n*E\n"})
public abstract class JSWebSymbolBase<T extends JSElement>
implements PsiSourcedWebSymbol {
    private final T source;

    public JSWebSymbolBase(T source) {
        this.source = source;
    }

    public T getSource() {
        return this.source;
    }

    @NotNull
    public WebSymbolOrigin getOrigin() {
        return WebSymbolOrigin.Companion.empty();
    }

    @NotNull
    public String getNamespace() {
        return "js";
    }

    @Nullable
    public String getDescription() {
        String string;
        T t = this.getSource();
        if (t != null) {
            T it = t;
            boolean bl = false;
            string = JSWebSymbolDocumentationCustomizerKt.renderDocComment(JSWebSymbolDocumentationCustomizerKt.getJSDocumentationProviderFor((PsiElement)it), (PsiElement)it);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public WebSymbolApiStatus getApiStatus() {
        T t = this.getSource();
        JSElementBase jSElementBase = t instanceof JSElementBase ? (JSElementBase)t : null;
        if (jSElementBase == null || (jSElementBase = JSWebSymbolUtils.getApiStatus(jSElementBase)) == null) {
            jSElementBase = (WebSymbolApiStatus)WebSymbolApiStatus.Stable;
        }
        return jSElementBase;
    }

    @Nullable
    public Object getType() {
        T t = this.getSource();
        JSTypeOwner jSTypeOwner = t instanceof JSTypeOwner ? (JSTypeOwner)t : null;
        return jSTypeOwner != null ? jSTypeOwner.getJSType() : null;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"kind", (Object)this.getJsKind()));
    }

    @NotNull
    public abstract WebSymbolJsKind getJsKind();

    @NotNull
    public List<WebSymbolsScope> getSymbols(@NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull WebSymbolsListSymbolsQueryParams params, @NotNull Stack<WebSymbolsScope> scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        return Intrinsics.areEqual((Object)qualifiedKind, (Object)WebSymbol.Companion.getJS_PROPERTIES()) ? JSPropertySymbolKt.getJSPropertySymbols((WebSymbol)this) : CollectionsKt.emptyList();
    }

    @NotNull
    public List<WebSymbol> getMatchingSymbols(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolsNameMatchQueryParams params, @NotNull Stack<WebSymbolsScope> scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        return Intrinsics.areEqual((Object)qualifiedName.getQualifiedKind(), (Object)WebSymbol.Companion.getJS_PROPERTIES()) ? JSPropertySymbolKt.getMatchingJSPropertySymbols((WebSymbol)this, qualifiedName, params.getQueryExecutor().getNamesProvider()) : CollectionsKt.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExclusiveFor(@NotNull WebSymbolQualifiedKind qualifiedKind) {
        Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
        if (!Intrinsics.areEqual((Object)qualifiedKind, (Object)WebSymbol.Companion.getJS_PROPERTIES())) return false;
        WebSymbol $this$jsType$iv = (WebSymbol)this;
        boolean $i$f$getJSType = false;
        Object object = $this$jsType$iv.getType();
        if (!(object instanceof JSType)) return false;
        JSType jSType = (JSType)object;
        if (jSType == null) return false;
        if (!jSType.isSourceStrict()) return false;
        return true;
    }

    @Nullable
    public WebSymbolSearchTarget getSearchTarget() {
        return WebSymbolSearchTarget.Companion.create((WebSymbol)this);
    }

    @Nullable
    public WebSymbolRenameTarget getRenameTarget() {
        return WebSymbolRenameTarget.Companion.create((WebSymbol)this);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof JSWebSymbolBase && Intrinsics.areEqual(other.getClass(), this.getClass()) && Intrinsics.areEqual(((JSWebSymbolBase)other).getSource(), this.getSource()) && Intrinsics.areEqual((Object)((JSWebSymbolBase)other).getName(), (Object)this.getName());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getSource(), this.getName()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public abstract Pointer<? extends JSWebSymbolBase<T>> createPointer();

    @Nullable
    public WebSymbolDocumentation createDocumentation(@Nullable PsiElement location) {
        JSWebSymbolDocumentationCustomizer.JSWebSymbolDeclarationDocPrinter docPrinter;
        JSWebSymbolDocumentationCustomizer.JSWebSymbolDeclarationDocPrinter jSWebSymbolDeclarationDocPrinter;
        T t = this.getSource();
        if (t != null) {
            T it = t;
            boolean bl = false;
            jSWebSymbolDeclarationDocPrinter = new JSWebSymbolDocumentationCustomizer.JSWebSymbolDeclarationDocPrinter((PsiElement)it, location);
        } else {
            jSWebSymbolDeclarationDocPrinter = null;
        }
        JSWebSymbolDocumentationCustomizer.JSWebSymbolDeclarationDocPrinter jSWebSymbolDeclarationDocPrinter2 = docPrinter = jSWebSymbolDeclarationDocPrinter;
        Pair<String, String> definitionDocWithDetails = jSWebSymbolDeclarationDocPrinter2 != null ? jSWebSymbolDeclarationDocPrinter2.getDefinitionDocWithDetails() : null;
        WebSymbol webSymbol = (WebSymbol)this;
        Object object = definitionDocWithDetails;
        if (object == null || (object = (String)object.getFirst()) == null) {
            WebSymbol webSymbol2 = (WebSymbol)this;
            Object object2 = this.getSource();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = this.getName();
            }
            if ((object = JSWebSymbolUtils.renderJsTypeForDocs$default(webSymbol2, object2, null, 2, null)) == null) {
                String string = Strings.escapeXmlEntities((String)this.getName());
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
            }
        }
        Pair<String, String> pair = definitionDocWithDetails;
        JSWebSymbolDocumentationCustomizer.JSWebSymbolDeclarationDocPrinter jSWebSymbolDeclarationDocPrinter3 = docPrinter;
        return WebSymbolDocumentation.Companion.create$default((WebSymbolDocumentation.Companion)WebSymbolDocumentation.Companion, (WebSymbol)webSymbol, (PsiElement)location, null, object, (String)(pair != null ? (String)pair.getSecond() : null), null, null, null, (boolean)false, null, null, null, null, (String)(jSWebSymbolDeclarationDocPrinter3 != null ? jSWebSymbolDeclarationDocPrinter3.getLocation() : null), (int)8164, null);
    }
}

