/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.webSymbols.nodejs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.webSymbols.nodejs.PackageJsonWebSymbolsRegistryManager;
import com.intellij.javascript.webSymbols.nodejs.WebTypesNpmLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.SemVer;
import com.intellij.webSymbols.webTypes.WebTypesJsonFilesCache;
import com.intellij.webSymbols.webTypes.WebTypesLoadUtilKt;
import com.intellij.webSymbols.webTypes.WebTypesVersionsRegistry;
import com.intellij.webSymbols.webTypes.json.WebTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="WebTypesNpmLoader", storages={@Storage(value="web-types-npm-loader.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0001\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bj\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "myState", "Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$State;", "pluginCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "pluginLoadMap", "Ljava/util/HashMap;", "Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$FutureResultProvider;", "Lkotlin/collections/HashMap;", "updating", "Ljava/util/concurrent/atomic/AtomicBoolean;", "webTypesEnabledPackages", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "createNewState", "getState", "getWebTypes", "fileUrl", "packageName", "packageVersion", "Lcom/intellij/util/text/SemVer;", "getWebTypesNoCache", "loadState", "", "stateElement", "normalizePackageName", "triggerUpdateIfNeeded", "updateState", "state", "updated", "Companion", "FutureResultProvider", "State", "intellij.javascript.web"})
@SourceDebugExtension(value={"SMAP\nWebTypesNpmLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesNpmLoader.kt\ncom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1#2:392\n31#3,2:393\n1855#4:395\n1855#4,2:396\n1856#4:398\n*S KotlinDebug\n*F\n+ 1 WebTypesNpmLoader.kt\ncom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader\n*L\n143#1:393,2\n202#1:395\n205#1:396,2\n202#1:398\n*E\n"})
public final class WebTypesNpmLoader
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State myState = new State((WebTypesVersionsRegistry<String>)new WebTypesVersionsRegistry(), SetsKt.emptySet());
    @NotNull
    private final AtomicBoolean updating = new AtomicBoolean(false);
    @NotNull
    private HashMap<String, FutureResultProvider<WebTypes>> pluginLoadMap = new HashMap();
    @NotNull
    private LoadingCache<String, WebTypes> pluginCache;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String WEB_TYPES_ENABLED_PACKAGES_URL = "https://raw.githubusercontent.com/JetBrains/web-types/master/packages/registry.json";
    @NotNull
    private static final Regex WEB_TYPES_PKG_NAME_REPLACE_PATTERN;
    @NotNull
    private static final String PACKAGE_PREFIX = "@web-types";
    private static final long STATE_UPDATE_INTERVAL;

    public WebTypesNpmLoader() {
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(20L).expireAfterAccess(30L, TimeUnit.MINUTES).build(arg_0 -> WebTypesNpmLoader.pluginCache$lambda$0((Function1)new Function1<String, WebTypes>(this){
            final /* synthetic */ WebTypesNpmLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final WebTypes invoke(String it) {
                return WebTypesNpmLoader.access$getWebTypesNoCache(this.this$0, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.pluginCache = loadingCache;
    }

    private final Set<String> getWebTypesEnabledPackages() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myState.getEnabledPackages();
    }

    @NotNull
    public Element getState() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myState.toElement();
    }

    public void loadState(@NotNull Element stateElement) {
        Intrinsics.checkNotNullParameter((Object)stateElement, (String)"stateElement");
        this.updateState(new State(stateElement));
    }

    private final void updateState(State state) {
        Application app = ApplicationManager.getApplication();
        app.assertReadAccessAllowed();
        if (!Intrinsics.areEqual((Object)this.myState, (Object)state)) {
            if (app.isWriteAccessAllowed()) {
                WebTypesNpmLoader.updateState$replaceStateAndNotify(this, state);
            } else {
                app.invokeLaterOnWriteThread(() -> WebTypesNpmLoader.updateState$replaceStateAndNotify(this, state));
            }
        }
    }

    private final WebTypes getWebTypes(String packageName, SemVer packageVersion) {
        WebTypes webTypes;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String webTypesPackageName = this.normalizePackageName(packageName);
        this.triggerUpdateIfNeeded();
        String string = (String)this.myState.getAvailableVersions().get("@web-types/" + webTypesPackageName, packageVersion);
        if (string != null) {
            String it = string;
            boolean bl = false;
            webTypes = this.getWebTypes(it);
        } else {
            webTypes = null;
        }
        return webTypes;
    }

    private final String normalizePackageName(String packageName) {
        String string;
        String string2 = packageName;
        if (string2 != null) {
            CharSequence charSequence = string2;
            Regex regex = WEB_TYPES_PKG_NAME_REPLACE_PATTERN;
            String string3 = "at-$1-$2";
            string = regex.replace(charSequence, string3);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WebTypes getWebTypes(String fileUrl) {
        FutureResultProvider futureResultProvider;
        Object object;
        Ref.BooleanRef loadingSkipped = new Ref.BooleanRef();
        HashMap<String, FutureResultProvider<WebTypes>> hashMap = this.pluginLoadMap;
        synchronized (hashMap) {
            block8: {
                boolean bl = false;
                object = (WebTypes)this.pluginCache.getIfPresent((Object)fileUrl);
                if (object == null) break block8;
                WebTypes it = object;
                boolean bl2 = false;
                this.pluginLoadMap.remove(fileUrl);
                WebTypes webTypes = it;
                return webTypes;
            }
            futureResultProvider = this.pluginLoadMap.computeIfAbsent(fileUrl, arg_0 -> WebTypesNpmLoader.getWebTypes$lambda$4$lambda$3((Function1)new Function1<String, FutureResultProvider<WebTypes>>(this, fileUrl, loadingSkipped){
                final /* synthetic */ WebTypesNpmLoader this$0;
                final /* synthetic */ String $fileUrl;
                final /* synthetic */ Ref.BooleanRef $loadingSkipped;
                {
                    this.this$0 = $receiver;
                    this.$fileUrl = $fileUrl;
                    this.$loadingSkipped = $loadingSkipped;
                    super(1);
                }

                @NotNull
                public final FutureResultProvider<WebTypes> invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new FutureResultProvider<WebTypes>(() -> getWebTypes.2.2.invoke$lambda$0(this.this$0, this.$fileUrl, this.$loadingSkipped));
                }

                private static final WebTypes invoke$lambda$0(WebTypesNpmLoader this$0, String $fileUrl, Ref.BooleanRef $loadingSkipped) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$fileUrl, (String)"$fileUrl");
                    Intrinsics.checkNotNullParameter((Object)$loadingSkipped, (String)"$loadingSkipped");
                    Object object = WebTypesNpmLoader.access$getPluginCache$p(this$0).get((Object)$fileUrl);
                    Intrinsics.checkNotNull((Object)object);
                    WebTypes result2 = (WebTypes)object;
                    if ($loadingSkipped.element) {
                        WebTypesNpmLoader.access$updated(this$0);
                    }
                    return result2;
                }
            }, arg_0));
        }
        WebTypes webTypes = (WebTypes)futureResultProvider.getResult();
        if (webTypes != null) {
            WebTypes it = webTypes;
            boolean bl = false;
            object = this.pluginLoadMap;
            synchronized (object) {
                boolean bl3 = false;
                FutureResultProvider<WebTypes> futureResultProvider2 = this.pluginLoadMap.remove(fileUrl);
            }
            return it;
        }
        loadingSkipped.element = true;
        return null;
    }

    private final void updated() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PackageJsonWebSymbolsRegistryManager> serviceClass$iv = PackageJsonWebSymbolsRegistryManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((PackageJsonWebSymbolsRegistryManager)object).scheduleRefresh$intellij_javascript_web();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final WebTypes getWebTypesNoCache(String fileUrl) {
        String string = fileUrl;
        Object object = string;
        if (string == null) return null;
        String it = object;
        boolean bl = false;
        InputStream inputStream = WebTypesJsonFilesCache.Companion.getWebTypesJson(it);
        object = inputStream;
        if (inputStream == null) return null;
        WebTypes webTypes = WebTypesLoadUtilKt.readWebTypes((InputStream)object);
        return webTypes;
    }

    private final void triggerUpdateIfNeeded() {
        if (STATE_UPDATE_INTERVAL >= Math.abs(System.currentTimeMillis() - this.myState.getTimestamp()) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!this.updating.compareAndSet(false, true)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> WebTypesNpmLoader.triggerUpdateIfNeeded$lambda$9(this));
    }

    /*
     * Unable to fully structure code
     */
    private final State createNewState() {
        v0 = ApplicationManager.getApplication().executeOnPooledThread((Callable<Serializable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createNewState$lambda$10(), ()Ljava/io/Serializable;)());
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"executeOnPooledThread(...)");
        enabledPackagesFuture = v0;
        packageInfo = new ArrayList<E>();
        NpmRegistryService.getInstance().findPackages(null, NpmRegistryService.fullTextSearch("@web-types"), 50, (Condition<NodePackageBasicInfo>)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, createNewState$lambda$11(com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo ), (Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;)Z)(), (Consumer<NodePackageBasicInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, createNewState$lambda$12(java.util.List com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo ), (Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;)V)((List)packageInfo));
        packagesInfo = ((StreamEx)StreamEx.of((Collection)packageInfo).parallel()).map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createNewState$lambda$13(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)((Function1)createNewState.packagesInfo.1.INSTANCE)).mapToEntry((Function<Object, AvailablePackageVersions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createNewState$lambda$14(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lcom/intellij/javascript/nodejs/npm/AvailablePackageVersions;)((Function1)createNewState.packagesInfo.2.INSTANCE)).nonNullValues().toList();
        availableVersions = new WebTypesVersionsRegistry();
        Intrinsics.checkNotNull((Object)packagesInfo);
        $this$forEach$iv = packagesInfo;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            var9_10 = (Map.Entry)element$iv;
            $i$a$-forEach-WebTypesNpmLoader$createNewState$3 = false;
            Intrinsics.checkNotNull((Object)var9_10);
            pkgName = (String)var9_10.getKey();
            v1 = value = (AvailablePackageVersions)var9_10.getValue();
            Intrinsics.checkNotNull((Object)v1);
            v2 = EntryStream.of((Map)v1.getVersionsInfo()).filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, createNewState$lambda$17$lambda$15(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)createNewState.3.1.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"filter(...)");
            var13_15 = (Iterable)v2;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                var17_19 = (Map.Entry)element$iv;
                $i$a$-forEach-WebTypesNpmLoader$createNewState$3$2 = false;
                Intrinsics.checkNotNull((Object)var17_19);
                version = (SemVer)var17_19.getKey();
                info = (AvailablePackageVersions.VersionInfo)var17_19.getValue();
                Intrinsics.checkNotNull((Object)pkgName);
                Intrinsics.checkNotNull((Object)version);
                v3 = info.getUrl();
                Intrinsics.checkNotNull((Object)v3);
                availableVersions.put(pkgName, version, (Object)v3);
            }
        }
        var6_7 = (Serializable)enabledPackagesFuture.get();
        if (var6_7 == null) ** GOTO lbl-1000
        it = var6_7;
        $i$a$-let-WebTypesNpmLoader$createNewState$enabledPackages$1 = false;
        var11_13 = it;
        if (var11_13 instanceof Exception) {
            throw (Exception)it;
        }
        v4 = var11_13 instanceof String ? ((var12_14 = new ObjectMapper().readTree((String)it)) instanceof ObjectNode ? (ObjectNode)var12_14 : null) : null;
        var7_8 = v4;
        if (var7_8 != null && (var8_9 = var7_8.fields()) != null && (var9_10 = SequencesKt.asSequence((Iterator)var8_9)) != null && (var10_12 = SequencesKt.mapNotNull((Sequence)var9_10, (Function1)createNewState.enabledPackages.2.INSTANCE)) != null && (var11_13 = SequencesKt.flatMap((Sequence)var10_12, (Function1)createNewState.enabledPackages.3.INSTANCE)) != null && (var12_14 = SequencesKt.mapNotNull((Sequence)var11_13, (Function1)createNewState.enabledPackages.4.INSTANCE)) != null) {
            v5 = SequencesKt.toSet((Sequence)var12_14);
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        if ((v6 = (enabledPackages = v5)) == null) {
            v6 = SetsKt.emptySet();
        }
        return new State((WebTypesVersionsRegistry<String>)availableVersions, v6);
    }

    private static final WebTypes pluginCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WebTypes)$tmp0.invoke(p0);
    }

    private static final void updateState$replaceStateAndNotify(WebTypesNpmLoader this$0, State $state) {
        this$0.myState = $state;
        this$0.triggerUpdateIfNeeded();
        this$0.updated();
    }

    private static final FutureResultProvider getWebTypes$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FutureResultProvider)$tmp0.invoke(p0);
    }

    private static final void triggerUpdateIfNeeded$lambda$9$lambda$8(WebTypesNpmLoader this$0, State $newState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newState, (String)"$newState");
        this$0.updateState($newState);
        this$0.updating.set(false);
    }

    private static final void triggerUpdateIfNeeded$lambda$9(WebTypesNpmLoader this$0) {
        State state;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            state = this$0.createNewState();
        }
        catch (IOException e) {
            LOG.warn(e.getMessage());
            return;
        }
        State newState = state;
        ReadAction.run(() -> WebTypesNpmLoader.triggerUpdateIfNeeded$lambda$9$lambda$8(this$0, newState));
    }

    private static final Serializable createNewState$lambda$10() {
        Object object;
        try {
            object = HttpRequests.request((String)WEB_TYPES_ENABLED_PACKAGES_URL).productNameAsUserAgent().gzip(true).readString(null);
            Intrinsics.checkNotNull((Object)object);
            object = (Serializable)object;
        }
        catch (Exception e) {
            object = e;
        }
        return object;
    }

    private static final boolean createNewState$lambda$11(NodePackageBasicInfo it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"@web-types/", (boolean)false, (int)2, null);
    }

    private static final void createNewState$lambda$12(List $packageInfo, NodePackageBasicInfo it) {
        Intrinsics.checkNotNullParameter((Object)$packageInfo, (String)"$packageInfo");
        Intrinsics.checkNotNull((Object)it);
        $packageInfo.add(it);
    }

    private static final String createNewState$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final AvailablePackageVersions createNewState$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AvailablePackageVersions)$tmp0.invoke(p0);
    }

    private static final boolean createNewState$lambda$17$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LoadingCache access$getPluginCache$p(WebTypesNpmLoader $this) {
        return $this.pluginCache;
    }

    public static final /* synthetic */ void access$updated(WebTypesNpmLoader $this) {
        $this.updated();
    }

    public static final /* synthetic */ WebTypes access$getWebTypesNoCache(WebTypesNpmLoader $this, String fileUrl) {
        return $this.getWebTypesNoCache(fileUrl);
    }

    static {
        Logger logger = Logger.getInstance(WebTypesNpmLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        WEB_TYPES_PKG_NAME_REPLACE_PATTERN = new Regex("^@(.*)/(.*)$");
        STATE_UPDATE_INTERVAL = TimeUnit.DAYS.toMillis(3L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PACKAGE_PREFIX", "", "STATE_UPDATE_INTERVAL", "", "WEB_TYPES_ENABLED_PACKAGES_URL", "WEB_TYPES_PKG_NAME_REPLACE_PATTERN", "Lkotlin/text/Regex;", "instance", "Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader;", "getInstance$intellij_javascript_web", "()Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader;", "webTypesEnabledPackages", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "forPackage", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "packageName", "packageVersion", "Lcom/intellij/util/text/SemVer;", "intellij.javascript.web"})
    @SourceDebugExtension(value={"SMAP\nWebTypesNpmLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesNpmLoader.kt\ncom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,391:1\n42#2,3:392\n*S KotlinDebug\n*F\n+ 1 WebTypesNpmLoader.kt\ncom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$Companion\n*L\n56#1:392,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final WebTypes forPackage(@NotNull String packageName, @Nullable SemVer packageVersion) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return this.getInstance$intellij_javascript_web().getWebTypes(packageName, packageVersion);
        }

        @NotNull
        public final Set<String> getWebTypesEnabledPackages() {
            return this.getInstance$intellij_javascript_web().getWebTypesEnabledPackages();
        }

        @NotNull
        public final WebTypesNpmLoader getInstance$intellij_javascript_web() {
            boolean $i$f$service = false;
            Class<WebTypesNpmLoader> serviceClass$iv = WebTypesNpmLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (WebTypesNpmLoader)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u000fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$FutureResultProvider;", "T", "", "operation", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "myFuture", "Ljava/util/concurrent/Future;", "myLock", "Ljava/lang/Object;", "myRetryTime", "", "result", "getResult", "()Ljava/lang/Object;", "Companion", "intellij.javascript.web"})
    private static final class FutureResultProvider<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Callable<T> operation;
        @NotNull
        private final Object myLock;
        @Nullable
        private Future<?> myFuture;
        private long myRetryTime;
        private static final long CHECK_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1L);
        private static final long EDT_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(5L);
        private static final long EDT_RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
        private static final long NON_EDT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
        private static final long NON_EDT_RETRY_INTERVAL = TimeUnit.MINUTES.toMillis(1L);

        public FutureResultProvider(@NotNull Callable<T> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            this.operation = operation;
            this.myLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final T getResult() {
            Future<?> future = null;
            Object object = this.myLock;
            synchronized (object) {
                block25: {
                    boolean bl = false;
                    if (this.myRetryTime <= System.currentTimeMillis()) break block25;
                    T t = null;
                    return t;
                }
                if (this.myFuture == null) {
                    this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> FutureResultProvider._get_result_$lambda$1$lambda$0(this));
                }
                Future<?> future2 = this.myFuture;
                Intrinsics.checkNotNull(future2);
                future = future2;
                Unit unit = Unit.INSTANCE;
            }
            Application app = ApplicationManager.getApplication();
            boolean edt = app.isDispatchThread() && !app.isUnitTestMode();
            long timeout = edt ? EDT_TIMEOUT : NON_EDT_TIMEOUT;
            try {
                while (true) {
                    ProgressManager.checkCanceled();
                    try {
                        Object result2 = future.get(CHECK_TIMEOUT, TimeUnit.MILLISECONDS);
                        if (result2 instanceof ProcessCanceledException) {
                            Object object2 = this.myLock;
                            synchronized (object2) {
                                boolean $i$a$-synchronized-WebTypesNpmLoader$FutureResultProvider$result$52 = false;
                                this.myFuture = null;
                                Unit $i$a$-synchronized-WebTypesNpmLoader$FutureResultProvider$result$52 = Unit.INSTANCE;
                            }
                            return null;
                        }
                        if (result2 instanceof ExecutionException) {
                            throw (Throwable)result2;
                        }
                        if (result2 instanceof Exception) {
                            throw new ExecutionException((Throwable)result2);
                        }
                        return (T)result2;
                    }
                    catch (TimeoutException e) {
                        if ((timeout -= CHECK_TIMEOUT) > 0L) continue;
                        Object object3 = this.myLock;
                        synchronized (object3) {
                            boolean bl = false;
                            this.myRetryTime = Math.max(this.myRetryTime, System.currentTimeMillis() + (edt ? EDT_RETRY_INTERVAL : NON_EDT_RETRY_INTERVAL));
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!(e instanceof ExecutionException) && !(e instanceof CompletionException)) {
                    throw e;
                }
                if (e.getCause() instanceof IOException) {
                    LOG.warn(e.getMessage());
                } else {
                    LOG.error((Throwable)e);
                }
                Object object4 = this.myLock;
                synchronized (object4) {
                    boolean bl = false;
                    this.myRetryTime = Math.max(this.myRetryTime, System.currentTimeMillis() + NON_EDT_RETRY_INTERVAL);
                    this.myFuture = null;
                    Unit unit = Unit.INSTANCE;
                }
            }
            return null;
        }

        private static final Object _get_result_$lambda$1$lambda$0(FutureResultProvider this$0) {
            Exception exception;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            try {
                exception = this$0.operation.call();
            }
            catch (Exception e) {
                exception = e;
            }
            return exception;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$FutureResultProvider$Companion;", "", "()V", "CHECK_TIMEOUT", "", "EDT_RETRY_INTERVAL", "EDT_TIMEOUT", "NON_EDT_RETRY_INTERVAL", "NON_EDT_TIMEOUT", "intellij.javascript.web"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$State;", "", "availableVersions", "Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;", "", "enabledPackages", "", "(Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;Ljava/util/Set;)V", "root", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "getAvailableVersions", "()Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;", "getEnabledPackages", "()Ljava/util/Set;", "timestamp", "", "getTimestamp", "()J", "equals", "", "other", "hashCode", "", "toElement", "Companion", "intellij.javascript.web"})
    @SourceDebugExtension(value={"SMAP\nWebTypesNpmLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesNpmLoader.kt\ncom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$State\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
    private static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final WebTypesVersionsRegistry<String> availableVersions;
        @NotNull
        private final Set<String> enabledPackages;
        private final long timestamp;
        @NotNull
        public static final String WEB_TYPES_ELEMENT = "web-types";
        @NotNull
        public static final String ENABLED_ELEMENT = "enabled";
        @NotNull
        public static final String PACKAGE_ELEMENT = "package";
        @NotNull
        public static final String VERSION_ELEMENT = "version";
        @NotNull
        public static final String TIMESTAMP_ATTR = "timestamp";
        @NotNull
        public static final String NAME_ATTR = "name";
        @NotNull
        public static final String VALUE_ATTR = "value";
        @NotNull
        public static final String URL_ATTR = "url";

        @NotNull
        public final WebTypesVersionsRegistry<String> getAvailableVersions() {
            return this.availableVersions;
        }

        @NotNull
        public final Set<String> getEnabledPackages() {
            return this.enabledPackages;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public State(@NotNull WebTypesVersionsRegistry<String> availableVersions, @NotNull Set<String> enabledPackages2) {
            Intrinsics.checkNotNullParameter(availableVersions, (String)"availableVersions");
            Intrinsics.checkNotNullParameter(enabledPackages2, (String)"enabledPackages");
            this.availableVersions = availableVersions;
            this.enabledPackages = enabledPackages2;
            this.timestamp = System.currentTimeMillis();
        }

        public State(@NotNull Element root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.availableVersions = new WebTypesVersionsRegistry();
            this.enabledPackages = new LinkedHashSet();
            Object object = root.getAttribute(TIMESTAMP_ATTR);
            this.timestamp = object != null && (object = object.getValue()) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
            for (Element versions : root.getChildren(PACKAGE_ELEMENT)) {
                if (versions.getAttributeValue(NAME_ATTR) == null) continue;
                for (Element version2 : versions.getChildren(VERSION_ELEMENT)) {
                    String url;
                    String name;
                    String string = version2.getAttributeValue(VALUE_ATTR);
                    if (string == null) continue;
                    String it = string;
                    boolean bl = false;
                    SemVer semVer = SemVer.parseFromText((String)it);
                    string = semVer;
                    if (semVer == null) {
                        continue;
                    }
                    String ver = string;
                    if (version2.getAttributeValue(URL_ATTR) == null) continue;
                    this.availableVersions.put(name, (SemVer)ver, (Object)url);
                }
            }
            Object object2 = root.getChild(ENABLED_ELEMENT);
            if (object2 == null || (object2 = object2.getChildren(PACKAGE_ELEMENT)) == null) {
                object2 = CollectionsKt.emptyList();
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String it;
                Element enabled = (Element)iterator.next();
                if (enabled.getAttributeValue(NAME_ATTR) == null) continue;
                boolean bl = false;
                this.enabledPackages.add(it);
            }
        }

        @NotNull
        public final Element toElement() {
            Element element;
            Element root = new Element(WEB_TYPES_ELEMENT);
            root.setAttribute(TIMESTAMP_ATTR, String.valueOf(this.timestamp));
            for (Map.Entry entry : this.availableVersions.getVersions().entrySet()) {
                Element versionsEl = new Element(PACKAGE_ELEMENT);
                versionsEl.setAttribute(NAME_ATTR, (String)entry.getKey());
                element = ((Map)entry.getValue()).entrySet().iterator();
                while (element.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)element.next();
                    Element versionEl = new Element(VERSION_ELEMENT);
                    versionEl.setAttribute(VALUE_ATTR, ((SemVer)entry2.getKey()).getRawVersion());
                    versionEl.setAttribute(URL_ATTR, (String)entry2.getValue());
                    versionsEl.addContent(versionEl);
                }
                root.addContent(versionsEl);
            }
            Element enabledList = new Element(ENABLED_ELEMENT);
            for (String name : this.enabledPackages) {
                Element element2 = element = new Element(PACKAGE_ELEMENT);
                Element element3 = enabledList;
                boolean bl = false;
                element2.setAttribute(NAME_ATTR, name);
                element3.addContent(element);
            }
            root.addContent(enabledList);
            return root;
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof State && this.timestamp == ((State)other).timestamp && Intrinsics.areEqual(this.availableVersions, ((State)other).availableVersions) && Intrinsics.areEqual(this.enabledPackages, ((State)other).enabledPackages);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.availableVersions, this.enabledPackages, this.timestamp};
            return Objects.hash(objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/WebTypesNpmLoader$State$Companion;", "", "()V", "ENABLED_ELEMENT", "", "NAME_ATTR", "PACKAGE_ELEMENT", "TIMESTAMP_ATTR", "URL_ATTR", "VALUE_ATTR", "VERSION_ELEMENT", "WEB_TYPES_ELEMENT", "intellij.javascript.web"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

