/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.webSymbols.nodejs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webSymbols.webTypes.WebTypesSymbol;
import com.intellij.webSymbols.webTypes.json.SourceBase;
import com.intellij.webSymbols.webTypes.json.SourceFileOffset;
import com.intellij.webSymbols.webTypes.json.SourceSymbol;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/webSymbols/nodejs/PackageJsonSourceLocationResolver;", "", "()V", "getSymbolLocation", "Lcom/intellij/webSymbols/webTypes/WebTypesSymbol$Location;", "source", "Lcom/intellij/webSymbols/webTypes/json/SourceBase;", "defaultModuleName", "", "context", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.web"})
public final class PackageJsonSourceLocationResolver {
    @NotNull
    public static final PackageJsonSourceLocationResolver INSTANCE = new PackageJsonSourceLocationResolver();

    private PackageJsonSourceLocationResolver() {
    }

    @Nullable
    public final WebTypesSymbol.Location getSymbolLocation(@NotNull SourceBase source, @NotNull String defaultModuleName, @NotNull List<? extends VirtualFile> context2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)defaultModuleName, (String)"defaultModuleName");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        SourceBase sourceBase = source;
        if (sourceBase instanceof SourceSymbol) {
            String symbolName;
            String moduleName;
            String string = ((SourceSymbol)source).getModule();
            if (string == null) {
                string = moduleName = defaultModuleName;
            }
            if ((symbolName = ((SourceSymbol)source).getSymbol()) != null) {
                if (StringsKt.startsWith$default((String)moduleName, (String)"./", (boolean)false, (int)2, null)) {
                    return (WebTypesSymbol.Location)new WebTypesSymbol.FileExport(moduleName, symbolName, context2);
                }
                return (WebTypesSymbol.Location)new WebTypesSymbol.ModuleExport(moduleName, symbolName);
            }
        } else if (sourceBase instanceof SourceFileOffset) {
            String file = ((SourceFileOffset)source).getFile();
            Integer offset = ((SourceFileOffset)source).getOffset();
            if (file != null && offset != null) {
                return (WebTypesSymbol.Location)new WebTypesSymbol.FileOffset(file, offset.intValue(), context2);
            }
        }
        return null;
    }
}

