/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest.config;

import com.intellij.javascript.testing.vitest.config.VitestConfig;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010!\u001a\u00020\"R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/testing/vitest/config/VitestConfig;", "", "()V", "CONFIG_FILE_NAMES_WITHOUT_EXT", "", "", "DEFAULT_CONFIG_NAMES", "", "EXTENSIONS", "TEST_PROPERTY_NAME", "VITEST_CONFIG_NAMES", "VITEST_CONFIG_TS_NAME", "findAncestorTestConfigProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "element", "Lcom/intellij/psi/PsiElement;", "findDefaultConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "generate", "namesWithoutExt", "isConfigFile", "", "file", "psiFile", "Lcom/intellij/psi/PsiFile;", "isConfigFileName", "name", "isTestProperty", "testProperty", "checkPropertyName", "isVitestConfigFile", "listPossibleConfigFilesInProject", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nVitestConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestConfig.kt\ncom/intellij/javascript/testing/vitest/config/VitestConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1446#2,2:61\n1549#2:63\n1620#2,3:64\n1448#2,3:67\n*S KotlinDebug\n*F\n+ 1 VitestConfig.kt\ncom/intellij/javascript/testing/vitest/config/VitestConfig\n*L\n23#1:61,2\n23#1:63\n23#1:64,3\n23#1:67,3\n*E\n"})
public final class VitestConfig {
    @NotNull
    public static final VitestConfig INSTANCE = new VitestConfig();
    @NotNull
    private static final List<String> CONFIG_FILE_NAMES_WITHOUT_EXT;
    @NotNull
    private static final List<String> EXTENSIONS;
    @NotNull
    private static final String VITEST_CONFIG_TS_NAME = "vitest.config.ts";
    @NotNull
    private static final Set<String> VITEST_CONFIG_NAMES;
    @NotNull
    private static final Set<String> DEFAULT_CONFIG_NAMES;
    @NotNull
    public static final String TEST_PROPERTY_NAME = "test";

    private VitestConfig() {
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> generate(List<String> namesWithoutExt) {
        void var3_3;
        void $this$flatMapTo$iv;
        Iterable iterable = namesWithoutExt;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            String nameWithoutExt = (String)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = EXTENSIONS;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(nameWithoutExt + (String)it);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var3_3;
    }

    @Nullable
    public final VirtualFile findDefaultConfigFile(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Stream stream = DEFAULT_CONFIG_NAMES.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream), (Function1)((Function1)new Function1<String, VirtualFile>(dir){
            final /* synthetic */ VirtualFile $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.$dir.findChild(name);
            }
        })), (Function1)findDefaultConfigFile.2.INSTANCE));
    }

    @NotNull
    public final List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
        GlobalSearchScope contentScope = globalSearchScope;
        Collection collection = FilenameIndex.getVirtualFilesByName((String)VITEST_CONFIG_TS_NAME, (GlobalSearchScope)contentScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final boolean isVitestConfigFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return VITEST_CONFIG_NAMES.contains(file.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigFile(@Nullable VirtualFile file) {
        if (file == null) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isConfigFileName(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) return false;
        String string = psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isConfigFileName(string)) return false;
        return true;
    }

    private final boolean isConfigFileName(String name) {
        return DEFAULT_CONFIG_NAMES.contains(name);
    }

    @Nullable
    public final JSProperty findAncestorTestConfigProperty(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class, (boolean)false);
        while (property != null && !this.isTestProperty(property, true)) {
            property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)property), JSProperty.class, (boolean)true);
        }
        return property;
    }

    public final boolean isTestProperty(@NotNull JSProperty testProperty, boolean checkPropertyName) {
        Intrinsics.checkNotNullParameter((Object)testProperty, (String)"testProperty");
        if (checkPropertyName && !Intrinsics.areEqual((Object)testProperty.getName(), (Object)TEST_PROPERTY_NAME)) {
            return false;
        }
        PsiElement psiElement = testProperty.getParent();
        JSObjectLiteralExpression jSObjectLiteralExpression = psiElement instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)psiElement : null;
        if (jSObjectLiteralExpression == null) {
            return false;
        }
        JSObjectLiteralExpression objExpr = jSObjectLiteralExpression;
        PsiElement psiElement2 = objExpr.getParent();
        JSArgumentList jSArgumentList = psiElement2 instanceof JSArgumentList ? (JSArgumentList)psiElement2 : null;
        if (jSArgumentList == null) {
            return false;
        }
        JSArgumentList argList = jSArgumentList;
        Object object = argList.getParent();
        JSCallExpression jSCallExpression = object instanceof JSCallExpression ? (JSCallExpression)object : null;
        if (jSCallExpression == null) {
            return false;
        }
        JSCallExpression callExpr = jSCallExpression;
        object = callExpr.getMethodExpression();
        JSReferenceExpression jSReferenceExpression = object instanceof JSReferenceExpression ? (JSReferenceExpression)object : null;
        return Intrinsics.areEqual((Object)(jSReferenceExpression != null ? jSReferenceExpression.getReferenceName() : null), (Object)"defineConfig");
    }

    static {
        Object[] objectArray = new String[]{"vitest.config", "vite.config"};
        CONFIG_FILE_NAMES_WITHOUT_EXT = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{".ts", ".js", ".mjs"};
        EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        VITEST_CONFIG_NAMES = INSTANCE.generate(CollectionsKt.listOf((Object)"vitest.config"));
        DEFAULT_CONFIG_NAMES = INSTANCE.generate(CONFIG_FILE_NAMES_WITHOUT_EXT);
    }
}

