/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestNavigationItem
implements NavigationItem {
    private final String myName;
    private final PsiElement myElement;
    private final Icon myElementIcon;

    public JsTestNavigationItem(@NotNull JsTestFqn fqn, @NotNull PsiElement element, @Nullable Icon elementIcon) {
        if (fqn == null) {
            JsTestNavigationItem.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JsTestNavigationItem.$$$reportNull$$$0(1);
        }
        this.myName = fqn.getPresentableName();
        this.myElement = element;
        this.myElementIcon = elementIcon;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = JsTestNavigationItem.this.myName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = JsTestNavigationItem.this.myElement.getContainingFile().getName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return JsTestNavigationItem.this.myElementIcon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/javascript/testing/navigation/JsTestNavigationItem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public void navigate(boolean requestFocus) {
        VirtualFile file;
        Navigatable descriptor = null;
        if (this.myElement instanceof JSLiteralExpression && (file = this.myElement.getContainingFile().getVirtualFile()) != null) {
            descriptor = PsiNavigationSupport.getInstance().createNavigatable(this.myElement.getProject(), file, this.myElement.getTextOffset() + 1);
        }
        if (descriptor == null) {
            descriptor = PsiNavigationSupport.getInstance().getDescriptor(this.myElement);
        }
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    public static JsTestNavigationItem tryCreate(@NotNull String indexKey, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        JSFile jsFile;
        PsiElement element;
        JsTestFqn fqn;
        if (indexKey == null) {
            JsTestNavigationItem.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JsTestNavigationItem.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            JsTestNavigationItem.$$$reportNull$$$0(4);
        }
        if ((fqn = JsTestFileByTestNameIndex.toFqn(indexKey)) == null) {
            return null;
        }
        List<VirtualFile> files = JsTestFileByTestNameIndex.findFilesByKey(indexKey, scope2);
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem(files);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof JSFile && (element = fqn.findNavigationElement(jsFile = (JSFile)psiFile)) != null) {
            return new JsTestNavigationItem(fqn, element, JsTestNavigationItem.getIcon(element));
        }
        return null;
    }

    @Nullable
    private static Icon getIcon(@NotNull PsiElement element) {
        Icon icon2;
        if (element == null) {
            JsTestNavigationItem.$$$reportNull$$$0(5);
        }
        return (icon2 = element.getContainingFile().getIcon(0)) != null ? icon2 : element.getIcon(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testing/navigation/JsTestNavigationItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

