/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsPackageDependentTestRunConfigurationProducer;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTestRunnerManager {
    private static final Key<CachedValue<Set<JsPackageDependentTestRunConfigurationProducer<?>>>> DIRECT_DEPS_ONLY_KEY = Key.create((String)JsPackageDependentTestRunConfigurationProducer.class.getSimpleName());
    private static final Key<CachedValue<Set<JsPackageDependentTestRunConfigurationProducer<?>>>> DIRECT_AND_INDIRECT_DEPS_KEY = Key.create((String)JsPackageDependentTestRunConfigurationProducer.class.getSimpleName());
    private static final JSTestRunnerManager INSTANCE = new JSTestRunnerManager();

    @NotNull
    public static JSTestRunnerManager getInstance() {
        JSTestRunnerManager jSTestRunnerManager = INSTANCE;
        if (jSTestRunnerManager == null) {
            JSTestRunnerManager.$$$reportNull$$$0(0);
        }
        return jSTestRunnerManager;
    }

    @NotNull
    private static Set<JsPackageDependentTestRunConfigurationProducer<?>> findTestRunnerAsDirectDependency(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull NotNullLazyValue<List<JsPackageDependentTestRunConfigurationProducer<?>>> allProducers) {
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(1);
        }
        if (fileOrDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(2);
        }
        if (allProducers == null) {
            JSTestRunnerManager.$$$reportNull$$$0(3);
        }
        HashSet result2 = new HashSet(1);
        Ref lastCheckedDirRef = Ref.create();
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            JSTestRunnerManager.addDeclaredProducers(PackageJsonUtil.findChildPackageJsonFile(directory), allProducers, result2);
            lastCheckedDirRef.set((Object)fileOrDir);
            return true;
        }));
        if (result2.isEmpty()) {
            VirtualFile dir;
            VirtualFile virtualFile = lastCheckedDirRef.get() != null ? ((VirtualFile)lastCheckedDirRef.get()).getParent() : (dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent());
            while (dir != null) {
                JSTestRunnerManager.addDeclaredProducers(PackageJsonUtil.findChildPackageJsonFile(dir), allProducers, result2);
                if (JSTestRunnerManager.isProjectRoot(dir)) break;
                dir = dir.getParent();
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            JSTestRunnerManager.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static boolean isProjectRoot(@NotNull VirtualFile dir) {
        if (dir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(5);
        }
        return JSTestRunnerManager.hasChild(dir, ".git", true);
    }

    private static boolean hasChild(@NotNull VirtualFile dir, @NotNull String childName, boolean isDirectory) {
        VirtualFile child;
        if (dir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(6);
        }
        if (childName == null) {
            JSTestRunnerManager.$$$reportNull$$$0(7);
        }
        return (child = dir.findChild(childName)) != null && child.isDirectory() == isDirectory;
    }

    private static void addDeclaredProducers(@Nullable VirtualFile packageJson, @NotNull NotNullLazyValue<List<JsPackageDependentTestRunConfigurationProducer<?>>> allProducers, @NotNull Set<JsPackageDependentTestRunConfigurationProducer<?>> result2) {
        if (allProducers == null) {
            JSTestRunnerManager.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            JSTestRunnerManager.$$$reportNull$$$0(9);
        }
        if (packageJson == null) {
            return;
        }
        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
        for (JsPackageDependentTestRunConfigurationProducer producer : (List)allProducers.getValue()) {
            if (!JSTestRunnerManager.isDeclaredInPackageJson(data, producer)) continue;
            result2.add(producer);
        }
    }

    public static boolean isDeclaredInPackageJson(@NotNull PackageJsonData data, @NotNull JsPackageDependentTestRunConfigurationProducer<?> producer) {
        if (data == null) {
            JSTestRunnerManager.$$$reportNull$$$0(10);
        }
        if (producer == null) {
            JSTestRunnerManager.$$$reportNull$$$0(11);
        }
        return JSTestRunnerManager.isAnyPackageDeclared(data, producer.getTestRunnerPackageDescriptor()) && !JSTestRunnerManager.isAnyPackageDeclared(data, producer.getStopPackageDescriptor());
    }

    private static boolean isAnyPackageDeclared(@NotNull PackageJsonData data, @NotNull NodePackageDescriptor pkgDescriptor) {
        if (data == null) {
            JSTestRunnerManager.$$$reportNull$$$0(12);
        }
        if (pkgDescriptor == null) {
            JSTestRunnerManager.$$$reportNull$$$0(13);
        }
        for (String packageName : pkgDescriptor.getPackageNames()) {
            String dependency;
            if (!data.isDependencyOfAnyType(packageName) || (dependency = pkgDescriptor.getDependencyByPackageName(packageName)) != null && !data.isDependencyOfAnyType(dependency)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<JsPackageDependentTestRunConfigurationProducer<?>> findTestRunnerAsIndirectDependency(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull NotNullLazyValue<List<JsPackageDependentTestRunConfigurationProducer<?>>> allProducers) {
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(14);
        }
        if (fileOrDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(15);
        }
        if (allProducers == null) {
            JSTestRunnerManager.$$$reportNull$$$0(16);
        }
        HashSet result2 = new HashSet(1);
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            for (JsPackageDependentTestRunConfigurationProducer producer : (List)allProducers.getValue()) {
                if (!JSTestRunnerManager.isAnyPackageInstalled(nodeModulesDir, producer.getTestRunnerPackageDescriptor()) || JSTestRunnerManager.isAnyPackageInstalled(nodeModulesDir, producer.getStopPackageDescriptor())) continue;
                result2.add(producer);
            }
            return true;
        }));
        HashSet hashSet = result2;
        if (hashSet == null) {
            JSTestRunnerManager.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    private static boolean isAnyPackageInstalled(@NotNull VirtualFile nodeModulesDir, @NotNull NodePackageDescriptor packageDescriptor) {
        if (nodeModulesDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(18);
        }
        if (packageDescriptor == null) {
            JSTestRunnerManager.$$$reportNull$$$0(19);
        }
        for (String packageName : packageDescriptor.getPackageNames()) {
            if (!JSTestRunnerManager.isPackageInstalled(nodeModulesDir, packageName)) continue;
            String dependency = packageDescriptor.getDependencyByPackageName(packageName);
            return dependency == null || JSTestRunnerManager.isPackageInstalled(nodeModulesDir, dependency);
        }
        return false;
    }

    private static boolean isPackageInstalled(@NotNull VirtualFile nodeModulesDir, @NotNull String packageName) {
        VirtualFile packageDir;
        if (nodeModulesDir == null) {
            JSTestRunnerManager.$$$reportNull$$$0(20);
        }
        if (packageName == null) {
            JSTestRunnerManager.$$$reportNull$$$0(21);
        }
        return (packageDir = nodeModulesDir.findFileByRelativePath(packageName)) != null && packageDir.isDirectory() && packageDir.isValid();
    }

    @NotNull
    public Set<JsTestRunConfigurationProducer<?>> findProducers(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JSTestRunnerManager.$$$reportNull$$$0(22);
        }
        List<JsTestRunConfigurationProducer<?>> allProducers = JSTestRunnerManager.getAllProducers();
        HashSet foundProducers = new HashSet();
        for (JsTestRunConfigurationProducer<?> producer : allProducers) {
            if (!producer.isTestRunnerAvailableFor(psiElement)) continue;
            foundProducers.add(producer);
        }
        HashSet hashSet = foundProducers;
        if (hashSet == null) {
            JSTestRunnerManager.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    public Set<JsPackageDependentTestRunConfigurationProducer<?>> findPackageDependentProducers(@NotNull PsiElement psiElement) {
        PsiDirectory directory;
        if (psiElement == null) {
            JSTestRunnerManager.$$$reportNull$$$0(24);
        }
        if (psiElement instanceof PsiDirectory) {
            PsiDirectory dir;
            directory = dir = (PsiDirectory)psiElement;
        } else {
            PsiFile file = psiElement.getContainingFile();
            PsiDirectory psiDirectory = directory = file != null ? file.getContainingDirectory() : null;
        }
        if (directory == null) {
            Set<JsPackageDependentTestRunConfigurationProducer<?>> set = Set.of();
            if (set == null) {
                JSTestRunnerManager.$$$reportNull$$$0(25);
            }
            return set;
        }
        boolean directDepsOnly = psiElement instanceof PsiDirectory;
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)directory, directDepsOnly ? DIRECT_DEPS_ONLY_KEY : DIRECT_AND_INDIRECT_DEPS_KEY, () -> {
            Project project = directory.getProject();
            Set<JsPackageDependentTestRunConfigurationProducer<?>> producers = JSTestRunnerManager.findPackageDependentProducers(project, PsiUtilCore.getVirtualFile((PsiElement)directory), directDepsOnly);
            return new CachedValueProvider.Result(producers, new Object[]{NodeModulesDirectoryManager.getInstance(project).getNodeModulesDirChangeTracker(), PackageJsonFileManager.getInstance(project).getModificationTracker()});
        });
        if (set == null) {
            JSTestRunnerManager.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    private static Set<JsPackageDependentTestRunConfigurationProducer<?>> findPackageDependentProducers(@NotNull Project project, @Nullable VirtualFile fileOrDir, boolean directDepsOnly) {
        if (project == null) {
            JSTestRunnerManager.$$$reportNull$$$0(27);
        }
        if (fileOrDir == null) {
            Set<JsPackageDependentTestRunConfigurationProducer<?>> set = Set.of();
            if (set == null) {
                JSTestRunnerManager.$$$reportNull$$$0(28);
            }
            return set;
        }
        NotNullLazyValue allProducers = NotNullLazyValue.createValue(JSTestRunnerManager::getAllPackageDependentProducers);
        Set<JsPackageDependentTestRunConfigurationProducer<?>> directProducers = JSTestRunnerManager.findTestRunnerAsDirectDependency(project, fileOrDir, allProducers);
        if (!directProducers.isEmpty() || directDepsOnly) {
            Set<JsPackageDependentTestRunConfigurationProducer<?>> set = directProducers;
            if (set == null) {
                JSTestRunnerManager.$$$reportNull$$$0(29);
            }
            return set;
        }
        return JSTestRunnerManager.findTestRunnerAsIndirectDependency(project, fileOrDir, allProducers);
    }

    @NotNull
    static List<JsTestRunConfigurationProducer<?>> getAllProducers() {
        List producers;
        List list2 = producers = ContainerUtil.filterIsInstance((Collection)RunConfigurationProducer.EP_NAME.getExtensionList(), JsTestRunConfigurationProducer.class);
        if (list2 == null) {
            JSTestRunnerManager.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    static List<JsPackageDependentTestRunConfigurationProducer<?>> getAllPackageDependentProducers() {
        List producers;
        List list2 = producers = ContainerUtil.filterIsInstance((Collection)RunConfigurationProducer.EP_NAME.getExtensionList(), JsPackageDependentTestRunConfigurationProducer.class);
        if (list2 == null) {
            JSTestRunnerManager.$$$reportNull$$$0(31);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 24, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestRunnerManager";
                break;
            }
            case 1: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 3: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProducers";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgDescriptor";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDescriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestRunnerManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestRunnerAsDirectDependency";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestRunnerAsIndirectDependency";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findProducers";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackageDependentProducers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProducers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackageDependentProducers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTestRunnerAsDirectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasChild";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaredProducers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInPackageJson";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAnyPackageDeclared";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTestRunnerAsIndirectDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAnyPackageInstalled";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPackageInstalled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findProducers";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findPackageDependentProducers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 24, 27 -> new IllegalArgumentException(string);
        };
    }
}

