/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsPsiUtils {
    private JsPsiUtils() {
    }

    @Nullable
    public static PsiElement getMethodNameLeafElement(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression referenceExpression;
        if (callExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(0);
        }
        return (referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null ? referenceExpression.getReferenceNameElement() : null;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String getPrettyText(@Nullable JSExpression expr) {
        if (expr == null) {
            return null;
        }
        String value = JsPsiUtils.getLiteralPrettyText((JSLiteralExpression)ObjectUtils.tryCast((Object)expr, JSLiteralExpression.class));
        return value != null ? value : expr.getText();
    }

    @Nullable
    private static String getLiteralPrettyText(@Nullable JSLiteralExpression literalExpression) {
        char firstChar;
        String text2;
        if (literalExpression != null && literalExpression.isQuotedLiteral() && (text2 = literalExpression.getText()) != null && text2.length() > 0 && ((firstChar = text2.charAt(0)) == '\'' || firstChar == '\"' || firstChar == '`')) {
            return StringUtil.unquoteString((String)text2, (char)firstChar);
        }
        return null;
    }

    @Nullable
    static JSExpression extractInitExpression(@NotNull JSReferenceExpression jsReferenceExpression) {
        JSElement scopeElement;
        if (jsReferenceExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(1);
        }
        if ((scopeElement = JsPsiUtils.getNearestContainingScopeElement(jsReferenceExpression)) == null) {
            return null;
        }
        String refName = jsReferenceExpression.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return null;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(scopeElement);
        int maxOffset = jsReferenceExpression.getTextRange().getStartOffset();
        JSExpression lastExpr = null;
        for (JSStatement statement : statements) {
            JSReferenceExpression refExpr;
            JSDefinitionExpression defExpr;
            JSAssignmentExpression assignmentExpr;
            JSExpressionStatement exprStmt;
            if (statement.getTextRange().getEndOffset() > maxOffset) break;
            JSVarStatement varStmt = (JSVarStatement)ObjectUtils.tryCast((Object)statement, JSVarStatement.class);
            if (varStmt != null) {
                JSVariable[] vars;
                for (JSVariable var : vars = (JSVariable[])ObjectUtils.notNull((Object)varStmt.getVariables(), (Object)JSVariable.EMPTY_ARRAY)) {
                    if (!refName.equals(var.getName())) continue;
                    lastExpr = var.getInitializer();
                }
            }
            if ((exprStmt = (JSExpressionStatement)ObjectUtils.tryCast((Object)statement, JSExpressionStatement.class)) == null || (assignmentExpr = (JSAssignmentExpression)ObjectUtils.tryCast((Object)exprStmt.getExpression(), JSAssignmentExpression.class)) == null || (defExpr = (JSDefinitionExpression)ObjectUtils.tryCast((Object)assignmentExpr.getLOperand(), JSDefinitionExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)defExpr.getExpression(), JSReferenceExpression.class)) == null || refExpr.getQualifier() != null || !refName.equals(refExpr.getReferenceName())) continue;
            lastExpr = assignmentExpr.getROperand();
        }
        return lastExpr;
    }

    @Nullable
    public static JSFunctionExpression extractFunctionExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSFunctionExpression jsFunctionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
        if (jsFunctionExpression != null) {
            return jsFunctionExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractFunctionExpression(initializer);
        }
        final Ref functionRef = Ref.create();
        expression.accept(new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                functionRef.set((Object)node);
                this.stopWalking();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/testFramework/util/JsPsiUtils$1", "visitJSFunctionExpression"));
            }
        });
        return (JSFunctionExpression)functionRef.get();
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(2);
        }
        ArrayList<JSStatement> statements = new ArrayList<JSStatement>();
        for (PsiElement child : jsFile.getChildren()) {
            JSElement element = (JSElement)ObjectUtils.tryCast((Object)child, JSElement.class);
            if (element == null) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder(element, statements);
        }
        ArrayList<JSStatement> arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFunctionExpression funcExpr) {
        JSBlockStatement block;
        if (funcExpr == null) {
            JsPsiUtils.$$$reportNull$$$0(4);
        }
        if ((block = funcExpr.getBlock()) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JsPsiUtils.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<JSStatement> statements = new ArrayList<JSStatement>();
        JsPsiUtils.collectJsStatementsInExecutionOrder(block, statements);
        ArrayList<JSStatement> arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void collectJsStatementsInExecutionOrder(@Nullable JSElement statement, @NotNull List<JSStatement> statements) {
        JSFunction function2;
        block23: {
            block20: {
                JSCallExpression callExpression;
                JSVariable[] expressionOfStatement;
                block21: {
                    block22: {
                        if (statements == null) {
                            JsPsiUtils.$$$reportNull$$$0(7);
                        }
                        if (statement == null) {
                            return;
                        }
                        function2 = null;
                        if (!(statement instanceof JSExpressionStatement)) break block20;
                        expressionOfStatement = ((JSExpressionStatement)statement).getExpression();
                        if (expressionOfStatement == null) {
                            return;
                        }
                        if (!(expressionOfStatement instanceof JSCallExpression)) break block21;
                        callExpression = (JSCallExpression)expressionOfStatement;
                        JSFunction unwrappedFunc = JsPsiUtils.unwrapCallExpression(callExpression);
                        if (unwrappedFunc != null) {
                            JsPsiUtils.collectJsStatementsInExecutionOrder(unwrappedFunc, statements);
                            return;
                        }
                        JSParenthesizedExpression parenthesizedExpression = JsPsiUtils.getParenthesizedExpression(callExpression);
                        if (parenthesizedExpression == null) break block22;
                        function2 = (JSFunction)ObjectUtils.tryCast((Object)parenthesizedExpression.getInnerExpression(), JSFunction.class);
                        break block23;
                    }
                    if (!JSAmdPsiUtil.isDefineCall(callExpression)) break block23;
                    JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer(callExpression);
                    function2 = (JSFunction)ObjectUtils.tryCast((Object)moduleInitializer, JSFunction.class);
                    break block23;
                }
                if (!(expressionOfStatement instanceof JSParenthesizedExpression) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)((JSParenthesizedExpression)expressionOfStatement).getInnerExpression(), JSCallExpression.class)) == null) break block23;
                function2 = (JSFunction)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSFunction.class);
                break block23;
            }
            if (statement instanceof JSVarStatement) {
                JSVarStatement varStatement = (JSVarStatement)statement;
                for (JSVariable variable : varStatement.getStubSafeVariables()) {
                    JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)ObjectUtils.tryCast((Object)variable.getInitializerOrStub(), JSFunction.class), statements);
                }
            }
        }
        if (function2 == null) {
            function2 = (JSFunction)ObjectUtils.tryCast((Object)statement, JSFunction.class);
        }
        if (function2 != null) {
            JsPsiUtils.collectJsStatementsInExecutionOrder(function2.getBlock(), statements);
        } else if (statement instanceof JSBlockStatement) {
            JSSourceElement[] childStatements;
            for (JSSourceElement childStatement : childStatements = ((JSBlockStatement)statement).getStatementListItems()) {
                JsPsiUtils.collectJsStatementsInExecutionOrder(childStatement, statements);
            }
        } else if (statement instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)statement;
            JsPsiUtils.collectJsStatementsInExecutionOrder(ifStatement.getThenBranch(), statements);
            JsPsiUtils.collectJsStatementsInExecutionOrder(ifStatement.getElseBranch(), statements);
        } else if (statement instanceof JSStatement) {
            statements.add((JSStatement)statement);
        } else if (statement instanceof TypeScriptImplicitModule) {
            TypeScriptModule module = ((TypeScriptImplicitModule)statement).getRealModule();
            if (module != null) {
                JsPsiUtils.collectStatementsInsideModule(module, statements);
            }
        } else if (statement instanceof TypeScriptModule) {
            JsPsiUtils.collectStatementsInsideModule((TypeScriptModule)statement, statements);
        }
    }

    @Nullable
    private static JSFunction unwrapCallExpression(@NotNull JSCallExpression statement) {
        JSReferenceExpression methodExpression;
        if (statement == null) {
            JsPsiUtils.$$$reportNull$$$0(8);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)statement.getMethodExpression(), JSReferenceExpression.class), "setTimeout")) {
            return (JSFunction)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])statement.getArguments()), JSFunction.class);
        }
        if (methodExpression != null && "forEach".equals(methodExpression.getReferenceName())) {
            return (JSFunction)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])statement.getArguments()), JSFunction.class);
        }
        return null;
    }

    private static void collectStatementsInsideModule(@NotNull TypeScriptModule tsm, @NotNull List<JSStatement> statements) {
        if (tsm == null) {
            JsPsiUtils.$$$reportNull$$$0(9);
        }
        if (statements == null) {
            JsPsiUtils.$$$reportNull$$$0(10);
        }
        for (PsiElement element : tsm.getChildren()) {
            if (!(element instanceof JSElement)) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, statements);
        }
    }

    private static JSParenthesizedExpression getParenthesizedExpression(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
        if (referenceExpression != null && "call".equals(referenceExpression.getReferenceName())) {
            return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSParenthesizedExpression.class);
        }
        return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)methodExpression, JSParenthesizedExpression.class);
    }

    @Nullable
    @Contract(value="null -> null")
    public static JSCallExpression toCallExpressionFromStatement(@Nullable JSStatement statement) {
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class);
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)returnStatement.getExpression(), JSCallExpression.class);
        }
        return null;
    }

    public static JSProperty @NotNull [] getProperties(@NotNull JSObjectLiteralExpression objectLiteralExpression) {
        if (objectLiteralExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(11);
        }
        JSProperty[] properties = objectLiteralExpression.getProperties();
        int cnt = 0;
        for (JSProperty property : properties) {
            if (property == null) continue;
            ++cnt;
        }
        if (cnt < properties.length) {
            JSProperty[] a = new JSProperty[cnt];
            int id = 0;
            for (JSProperty property : properties) {
                if (property == null) continue;
                a[id] = property;
                ++id;
            }
            if (a == null) {
                JsPsiUtils.$$$reportNull$$$0(12);
            }
            return a;
        }
        if (properties == null) {
            JsPsiUtils.$$$reportNull$$$0(13);
        }
        return properties;
    }

    public static boolean containsOffsetStrictly(@NotNull TextRange textRange, int offset) {
        if (textRange == null) {
            JsPsiUtils.$$$reportNull$$$0(14);
        }
        return textRange.getStartOffset() < offset && offset < textRange.getEndOffset();
    }

    public static JSExpression @NotNull [] getArguments(@Nullable JSArgumentList argumentList) {
        JSExpression[] expressions = null;
        if (argumentList != null) {
            expressions = argumentList.getArguments();
        }
        if (expressions == null) {
            expressions = JSExpression.EMPTY_ARRAY;
        }
        if (expressions == null) {
            JsPsiUtils.$$$reportNull$$$0(15);
        }
        return expressions;
    }

    public static JSExpression @NotNull [] getArguments(@NotNull JSCallExpression jsCallExpression) {
        if (jsCallExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(16);
        }
        return JsPsiUtils.getArguments(jsCallExpression.getArgumentList());
    }

    @Nullable
    public static PsiElement getPropertyNamePsiElement(@NotNull JSProperty property) {
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(17);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)property.getFirstChild(), LeafPsiElement.class);
    }

    @Nullable
    public static String getPropertyName(@NotNull JSProperty property) {
        PsiElement testMethodNameDeclaration;
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(18);
        }
        if ((testMethodNameDeclaration = JsPsiUtils.getPropertyNamePsiElement(property)) == null) {
            return null;
        }
        return StringUtil.unquoteString((String)testMethodNameDeclaration.getText());
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type2) {
        if (type2 == null) {
            JsPsiUtils.$$$reportNull$$$0(19);
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            return node.getElementType() == type2;
        }
        return false;
    }

    @Nullable
    public static PsiElement getFunctionLeftBrace(@Nullable JSFunction function2) {
        if (function2 == null) {
            return null;
        }
        JSBlockStatement block = function2.getBlock();
        return block == null ? null : block.getFirstChild();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static Document getDocument(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(20);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
    }

    @Nullable
    private static JSElement getNearestContainingScopeElement(@NotNull JSElement element) {
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(21);
        }
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof JSFunction) {
                return (JSFunction)parent;
            }
            if (parent instanceof PsiFile) {
                return (JSElement)ObjectUtils.tryCast((Object)parent, JSFile.class);
            }
            PsiElement newParent = parent.getParent();
            if (newParent == parent) break;
            parent = newParent;
        }
        return null;
    }

    @NotNull
    private static List<JSStatement> getTopLevelStatementsOf(@NotNull JSElement parent) {
        JSBlockStatement block;
        if (parent == null) {
            JsPsiUtils.$$$reportNull$$$0(22);
        }
        JSSourceElement[] elements = JSSourceElement.EMPTY_ARRAY;
        if (parent instanceof JSFile) {
            JSFile jsFile = (JSFile)parent;
            elements = jsFile.getStatements();
        } else if (parent instanceof JSFunction && (block = ((JSFunction)parent).getBlock()) != null) {
            elements = block.getStatementListItems();
        }
        ArrayList<JSStatement> out = new ArrayList<JSStatement>();
        for (JSSourceElement element : elements) {
            JsPsiUtils.collectJsStatementsInExecutionOrder(element, out);
        }
        ArrayList<JSStatement> arrayList = out;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    public static String wrapWithMostFrequentQuote(@NotNull JSFile jsFile, String stringLiteralValue) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(24);
        }
        QuoteCountingVisitor visitor = new QuoteCountingVisitor();
        visitor.visitFile(jsFile);
        int quoteChar = visitor.mySingleQuotes == visitor.myDoubleQuotes ? 39 : (visitor.mySingleQuotes < visitor.myDoubleQuotes ? 34 : 39);
        String string = (char)quoteChar + stringLiteralValue + (char)quoteChar;
        if (string == null) {
            JsPsiUtils.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static boolean mightContainGlobalCall(@NotNull PsiFile file, @NotNull String globalName, boolean globalAsQualifier) {
        if (file == null) {
            JsPsiUtils.$$$reportNull$$$0(26);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(27);
        }
        return JsPsiUtils.mightContainGlobalCall(file.getViewProvider().getContents(), globalName, globalAsQualifier);
    }

    public static boolean mightContainGlobalCall(@NotNull CharSequence fileContents, @NotNull String globalName, boolean globalAsQualifier) {
        if (fileContents == null) {
            JsPsiUtils.$$$reportNull$$$0(28);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(29);
        }
        int ind = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName);
        while (ind >= 0) {
            char prevChar;
            char c2 = prevChar = ind > 0 ? (char)fileContents.charAt(ind - 1) : (char)' ';
            if (prevChar != '.' && prevChar != '_' && !Character.isLetterOrDigit(prevChar)) {
                char nextChar;
                int nextCharInd = ind + globalName.length();
                char c3 = nextChar = nextCharInd < fileContents.length() ? (char)fileContents.charAt(nextCharInd) : (char)'(';
                if (nextChar == '(' || Character.isWhitespace(nextChar)) {
                    return true;
                }
                if (globalAsQualifier && nextChar == '.') {
                    return true;
                }
            }
            ind = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName, (int)(ind + globalName.length() + 1));
        }
        return false;
    }

    public static boolean mightContainGlobalsMethodCall(@NotNull PsiFile file, @NotNull String globalName) {
        if (file == null) {
            JsPsiUtils.$$$reportNull$$$0(30);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(31);
        }
        CharSequence fileContents = file.getViewProvider().getContents();
        int index = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName);
        while (index >= 0) {
            char prevChar;
            char c2 = prevChar = index > 0 ? (char)fileContents.charAt(index - 1) : (char)' ';
            if (prevChar != '.' && prevChar != '_' && !Character.isLetterOrDigit(prevChar)) {
                int nextChar;
                int n = nextChar = (index += globalName.length()) < fileContents.length() ? (int)fileContents.charAt(index) : 32;
                if (nextChar == 46 && ++index < fileContents.length() && Character.isJavaIdentifierStart(fileContents.charAt(index))) {
                    while (index < fileContents.length() - 1) {
                        char currentChar;
                        if ((currentChar = fileContents.charAt(index++)) == '(') {
                            return true;
                        }
                        if (Character.isJavaIdentifierPart(currentChar)) continue;
                        break;
                    }
                }
            }
            index = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName, (int)(index + 1));
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String extractStringValue(@Nullable JSExpression expr) {
        return JsPsiUtils.getPrettyText(expr);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static JSObjectLiteralExpression extractObjectLiteralExpression(@Nullable JSExpression expression) {
        return (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)expression, JSObjectLiteralExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 12, 13, 15, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsReferenceExpression";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcExpr";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteralExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCallExpression";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listStatementsInExecutionOrder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStatementsOf";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithMostFrequentQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameLeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractInitExpression";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listStatementsInExecutionOrder";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectJsStatementsInExecutionOrder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unwrapCallExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectStatementsInsideModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsOffsetStrictly";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamePsiElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isElementOfType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNearestContainingScopeElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStatementsOf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMostFrequentQuote";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mightContainGlobalCall";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mightContainGlobalsMethodCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 12, 13, 15, 23, 25 -> new IllegalStateException(string);
        };
    }

    private static class QuoteCountingVisitor
    extends JSRecursiveWalkingElementVisitor {
        private int myDoubleQuotes = 0;
        private int mySingleQuotes = 0;

        private QuoteCountingVisitor() {
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression expr) {
            if (expr == null) {
                QuoteCountingVisitor.$$$reportNull$$$0(0);
            }
            if (expr.isQuotedLiteral()) {
                CharSequence seq;
                LeafPsiElement firstChild = (LeafPsiElement)ObjectUtils.tryCast((Object)expr.getFirstChild(), LeafPsiElement.class);
                CharSequence charSequence = seq = firstChild != null ? firstChild.getChars() : expr.getText();
                if (StringUtil.startsWithChar((CharSequence)seq, (char)'\"')) {
                    ++this.myDoubleQuotes;
                } else {
                    ++this.mySingleQuotes;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/javascript/testFramework/util/JsPsiUtils$QuoteCountingVisitor", "visitJSLiteralExpression"));
        }
    }
}

