/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/testFramework/util/CypressDetectionUtils;", "", "()V", "CYPRESS_DEFAULT_TESTS_DIR_NAME", "", "CYPRESS_GLOBAL_VAR_NAME", "hasDefaultTestsDirInFilePath", "", "filePath", "mightHasCypressApiCall", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "intellij.javascript.testing"})
public final class CypressDetectionUtils {
    @NotNull
    public static final CypressDetectionUtils INSTANCE = new CypressDetectionUtils();
    @NotNull
    private static final String CYPRESS_GLOBAL_VAR_NAME = "cy";
    @NotNull
    private static final String CYPRESS_DEFAULT_TESTS_DIR_NAME = "e2e";

    private CypressDetectionUtils() {
    }

    @JvmStatic
    public static final boolean mightHasCypressApiCall(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return JsPsiUtils.mightContainGlobalsMethodCall(jsFile, CYPRESS_GLOBAL_VAR_NAME);
    }

    public final boolean hasDefaultTestsDirInFilePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return JSLibraryUtil.containsDirInPath(filePath, CYPRESS_DEFAULT_TESTS_DIR_NAME);
    }
}

