/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.WorkingDirectoryDependentNpmPackageVersionManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodePackageRenderer
implements ListCellRenderer<NodePackageRef> {
    private static final SimpleTextAttributes DETAILS_ATTRS = new SimpleTextAttributes(128, null);
    private static final SimpleTextAttributes GRAY_DETAILS_ATTRS = new SimpleTextAttributes(128, (Color)JBColor.GRAY);
    private final Project myProject;
    private final SimpleColoredComponent myNameComp;
    private final SimpleColoredComponent myDetailsComp;
    private final SimpleColoredComponent myVersionComp;
    private final JPanel myPanel;
    private final NodePackageRefResolver myResolver;
    private final Supplier<? extends NodeJsInterpreter> myInterpreterSupplier;

    NodePackageRenderer(@NotNull Project project, @NotNull NodePackageRefResolver resolver, @NotNull Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            NodePackageRenderer.$$$reportNull$$$0(0);
        }
        if (resolver == null) {
            NodePackageRenderer.$$$reportNull$$$0(1);
        }
        if (interpreterSupplier == null) {
            NodePackageRenderer.$$$reportNull$$$0(2);
        }
        this.myNameComp = new SimpleColoredComponent();
        this.myDetailsComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myProject = project;
        this.myResolver = resolver;
        this.myInterpreterSupplier = interpreterSupplier;
        this.myNameComp.setOpaque(false);
        this.myNameComp.setIpad((Insets)JBInsets.emptyInsets());
        this.myNameComp.setMyBorder(null);
        this.myDetailsComp.setOpaque(false);
        this.myDetailsComp.setIpad((Insets)JBInsets.emptyInsets());
        this.myDetailsComp.setMyBorder(null);
        this.myVersionComp.setOpaque(false);
        this.myVersionComp.setIpad((Insets)JBInsets.emptyInsets());
        this.myVersionComp.setMyBorder(null);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)1));
        NodeJsInterpreterRenderer.adjustBorderHeight(this.myNameComp);
        JPanel nameContainer = NodePackageRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 3, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myDetailsComp, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 256, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodePackageRenderer.$$$reportNull$$$0(3);
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder((Border)JBUI.Borders.empty());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            NodePackageRenderer.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(@NotNull JList<? extends NodePackageRef> list2, @NotNull NodePackageRef ref, int index, boolean isSelected, boolean cellHasFocus) {
        if (list2 == null) {
            NodePackageRenderer.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            NodePackageRenderer.$$$reportNull$$$0(6);
        }
        Font baseFont = list2.getFont();
        this.myNameComp.setFont(baseFont);
        if (this.myPanel.isEnabled() != list2.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list2.isEnabled(), (boolean)true);
        }
        this.myPanel.setBackground(isSelected ? list2.getSelectionBackground() : list2.getBackground());
        Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myDetailsComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        this.myNameComp.clear();
        this.myNameComp.append(ref.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        NodePackage pkg = this.myResolver.resolve(ref);
        NodePackageRenderer.formatDetailsAndVersionComponents(this.myDetailsComp, this.myVersionComp, ref, pkg, this.myInterpreterSupplier.get(), isSelected, this.myProject, list2, index);
        return this.myPanel;
    }

    static void formatDetailsAndVersionComponents(@NotNull SimpleColoredComponent detailsComponent, @NotNull SimpleColoredComponent versionComponent, @NotNull NodePackageRef pkgRef, @Nullable NodePackage pkg, @Nullable NodeJsInterpreter interpreter, boolean isSelected, @NotNull Project project, @Nullable JList<? extends NodePackageRef> list2, int index) {
        if (detailsComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(7);
        }
        if (versionComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(8);
        }
        if (pkgRef == null) {
            NodePackageRenderer.$$$reportNull$$$0(9);
        }
        if (project == null) {
            NodePackageRenderer.$$$reportNull$$$0(10);
        }
        detailsComponent.clear();
        versionComponent.clear();
        String detailsLeftSpacing = "  ";
        if (pkg != null) {
            String path2;
            String string = path2 = !pkgRef.isConstant() ? pkg.getPresentablePath() : "";
            if (!path2.isEmpty()) {
                detailsComponent.append(detailsLeftSpacing);
                detailsComponent.append(path2, isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            NodePackageRenderer.processVersion(interpreter, pkg, project, version2 -> {
                if (version2 == null) {
                    return;
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    NodePackageRenderer.setVersion(versionComponent, isSelected, version2);
                } else {
                    UIUtil.invokeLaterIfNeeded(() -> NodePackageRenderer.repaint(versionComponent, isSelected, version2, list2, index));
                }
            });
        } else {
            detailsComponent.append(detailsLeftSpacing);
            detailsComponent.append(JavaScriptBundle.message("node.package.field.not_found.text", new Object[0]) + " ", isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static void repaint(@NotNull SimpleColoredComponent versionComponent, boolean isSelected, @NotNull SemVer version2, @Nullable JList<? extends NodePackageRef> list2, int index) {
        Rectangle bounds;
        if (versionComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(11);
        }
        if (version2 == null) {
            NodePackageRenderer.$$$reportNull$$$0(12);
        }
        if (versionComponent.isShowing()) {
            NodePackageRenderer.setVersion(versionComponent, isSelected, version2);
        } else if (list2 != null && index >= 0 && list2.isShowing() && (bounds = list2.getCellBounds(index, index)) != null) {
            list2.repaint(bounds);
        }
    }

    private static void processVersion(@Nullable NodeJsInterpreter interpreter, @NotNull NodePackage pkg, @NotNull Project project, @NotNull Consumer<SemVer> versionConsumer) {
        if (pkg == null) {
            NodePackageRenderer.$$$reportNull$$$0(13);
        }
        if (project == null) {
            NodePackageRenderer.$$$reportNull$$$0(14);
        }
        if (versionConsumer == null) {
            NodePackageRenderer.$$$reportNull$$$0(15);
        }
        if (pkg instanceof NpmNodePackage && interpreter != null) {
            WorkingDirectoryDependentNpmPackageVersionManager.getInstance(project).fetchVersion(interpreter, pkg, version2 -> {
                if (version2 != null) {
                    versionConsumer.accept((SemVer)version2);
                }
            });
        } else {
            pkg.getVersionPromise(project).onSuccess(versionConsumer);
        }
    }

    private static void setVersion(@NotNull SimpleColoredComponent versionComponent, boolean isSelected, @NotNull SemVer version2) {
        if (versionComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(16);
        }
        if (version2 == null) {
            NodePackageRenderer.$$$reportNull$$$0(17);
        }
        versionComponent.clear();
        versionComponent.append("   ");
        versionComponent.append(version2.getRawVersion(), isSelected ? DETAILS_ATTRS : GRAY_DETAILS_ATTRS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsComponent";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgRef";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInLeftRightJustifyingContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getListCellRendererComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatDetailsAndVersionComponents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "repaint";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

