/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packages;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.javascript.nodejs.packages.NodePackageInfoException;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodePackageUtil {
    private static final Logger LOG = Logger.getInstance(NodePackageUtil.class);
    private static final String[] GIT_PREFIXES = new String[]{"git://", "git@"};
    private static final File WORKING_DIR;

    private NodePackageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NodePackageInfo loadPackageInfo(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull String packageName, boolean cacheOnFs, @Nullable ProgressIndicator indicator) throws IOException {
        NodePackageInfo nodePackageInfo;
        if (project == null) {
            NodePackageUtil.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            NodePackageUtil.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            NodePackageUtil.$$$reportNull$$$0(2);
        }
        long startNano = System.nanoTime();
        LOG.debug("Loading node package info for " + packageName + " ...");
        String status = "with exception";
        try {
            NodePackageInfo packageInfo = NodePackageUtil.doLoadPackageInfo(project, interpreter, packageName, cacheOnFs, indicator);
            status = packageInfo == null ? "as null" : "successfully";
            nodePackageInfo = packageInfo;
        }
        catch (Throwable throwable) {
            LOG.debug(String.format("Info for %s node package loaded %s in %d ms", packageName, status, TimeoutUtil.getDurationMillis((long)startNano)));
            throw throwable;
        }
        LOG.debug(String.format("Info for %s node package loaded %s in %d ms", packageName, status, TimeoutUtil.getDurationMillis((long)startNano)));
        return nodePackageInfo;
    }

    @Nullable
    private static NodePackageInfo doLoadPackageInfo(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull String packageName, boolean cacheOnFs, @Nullable ProgressIndicator indicator) throws IOException {
        File cacheFile;
        ProcessOutput output;
        GeneralCommandLine commandLine;
        if (project == null) {
            NodePackageUtil.$$$reportNull$$$0(3);
        }
        if (interpreter == null) {
            NodePackageUtil.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            NodePackageUtil.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        try {
            commandLine = NpmUtil.createNpmCommandLine(project, WORKING_DIR, interpreter, NpmCommand.INFO, Arrays.asList("--json", packageName));
            output = NodeCommandLineUtil.execute(commandLine, indicator, TimeUnit.SECONDS.toMillis(120L));
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new IOException("Command '" + commandLine.getCommandLineString() + "' is timed out.");
        }
        if (exitCode != 0) {
            throw new NodePackageInfoException(commandLine.getCommandLineString(), exitCode, output.getStdout(), output.getStderr());
        }
        String stdout = output.getStdout();
        if (StringUtil.isEmptyOrSpaces((String)stdout)) {
            throw new IOException("Got empty stdout, exit code: 0, stderr:\n" + output.getStderr());
        }
        NodePackageInfo info2 = NodePackageUtil.parsePackageInfo(stdout);
        if (info2 != null && cacheOnFs && (cacheFile = NodePackageUtil.getCacheFile(packageName)) != null) {
            try {
                Files.write((CharSequence)stdout, (File)cacheFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.warn("Can't cache result of 'npm info " + packageName + "' in " + cacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return info2;
    }

    @Nullable
    private static File getCacheFile(@NotNull String packageName) {
        File npmInfoDir;
        if (packageName == null) {
            NodePackageUtil.$$$reportNull$$$0(6);
        }
        if (FileUtil.createDirectory((File)(npmInfoDir = new File(PathManager.getSystemPath(), "extLibs" + File.separator + "nodejs" + File.separator + "npm-info-cache")))) {
            return new File(npmInfoDir, packageName.replace('/', '$').replace('\\', '$'));
        }
        return null;
    }

    @Nullable
    public static NodePackageInfo loadCachedPackageInfo(@NotNull String packageName) {
        File cacheFile;
        if (packageName == null) {
            NodePackageUtil.$$$reportNull$$$0(7);
        }
        if ((cacheFile = NodePackageUtil.getCacheFile(packageName)) != null && cacheFile.isFile()) {
            try {
                String stdout = Files.toString((File)cacheFile, (Charset)StandardCharsets.UTF_8);
                return NodePackageUtil.parsePackageInfo(stdout);
            }
            catch (IOException e) {
                LOG.warn("Can't read cached output of 'npm info " + packageName + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static NodePackageInfo parsePackageInfo(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            NodePackageUtil.$$$reportNull$$$0(8);
        }
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));){
            jsonReader.setLenient(true);
            NodePackageInfo nodePackageInfo = NodePackageUtil.doParsePackageInfo(jsonReader, true);
            return nodePackageInfo;
        }
    }

    @Nullable
    private static NodePackageInfo doParsePackageInfo(@NotNull JsonReader reader2, boolean onRootObject) throws IOException {
        JsonToken nextToken;
        if (reader2 == null) {
            NodePackageUtil.$$$reportNull$$$0(9);
        }
        if ((nextToken = reader2.peek()) != JsonToken.BEGIN_OBJECT) {
            reader2.skipValue();
            return null;
        }
        List<String> versions = Collections.emptyList();
        String latestVersion = null;
        String packageName = null;
        String description = null;
        String author = null;
        String repositoryUrl = null;
        reader2.beginObject();
        boolean typeKeyEncountered = false;
        NodePackageInfo innerResult = null;
        while (reader2.hasNext()) {
            String key2 = reader2.nextName();
            if ("versions".equals(key2)) {
                versions = NodePackageUtil.parseVersions(reader2);
                continue;
            }
            if ("dist-tags".equals(key2)) {
                latestVersion = JsonUtil.getChildAsString((JsonReader)reader2, (String)"latest");
                continue;
            }
            if ("name".equals(key2)) {
                packageName = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            if ("description".equals(key2)) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            if ("author".equals(key2)) {
                author = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            if ("repository".equals(key2)) {
                repositoryUrl = NodePackageUtil.parseRepositoryUrl(reader2);
                continue;
            }
            if (onRootObject && "data".equals(key2)) {
                innerResult = NodePackageUtil.doParsePackageInfo(reader2, false);
                continue;
            }
            if (onRootObject && "type".equals(key2)) {
                typeKeyEncountered = true;
                reader2.skipValue();
                continue;
            }
            reader2.skipValue();
        }
        reader2.endObject();
        if (packageName != null) {
            return new NodePackageInfo(packageName, StringUtil.notNullize(description), versions, latestVersion, author, repositoryUrl);
        }
        return typeKeyEncountered ? innerResult : null;
    }

    private static List<String> parseVersions(@NotNull JsonReader reader2) throws IOException {
        JsonToken nextToken;
        if (reader2 == null) {
            NodePackageUtil.$$$reportNull$$$0(10);
        }
        if ((nextToken = reader2.peek()) != JsonToken.BEGIN_ARRAY) {
            reader2.skipValue();
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>(JsonUtil.nextStringList((JsonReader)reader2));
        Collections.reverse(versions);
        return versions;
    }

    @Nullable
    private static String parseRepositoryUrl(@NotNull JsonReader reader2) throws IOException {
        boolean gitRepo;
        JsonToken nextToken;
        if (reader2 == null) {
            NodePackageUtil.$$$reportNull$$$0(11);
        }
        if ((nextToken = reader2.peek()) != JsonToken.BEGIN_OBJECT) {
            reader2.skipValue();
            return null;
        }
        Object url = null;
        String type2 = null;
        reader2.beginObject();
        while (reader2.hasNext()) {
            String key2 = reader2.nextName();
            if ("url".equals(key2)) {
                url = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            if ("type".equals(key2)) {
                type2 = JsonUtil.nextStringOrSkip((JsonReader)reader2);
                continue;
            }
            reader2.skipValue();
        }
        reader2.endObject();
        if (url == null) {
            return null;
        }
        boolean bl = gitRepo = "git".equals(type2) || StringUtil.isEmpty(type2);
        if (gitRepo) {
            String gitPrefix = null;
            for (String gp : GIT_PREFIXES) {
                if (!((String)url).startsWith(gp)) continue;
                gitPrefix = gp;
                break;
            }
            if (gitPrefix != null) {
                if (gitPrefix.equals("git@")) {
                    int colonInd = ((String)url).indexOf(58);
                    if (colonInd >= 0) {
                        url = ((String)url).substring(0, colonInd) + "/" + ((String)url).substring(colonInd + 1);
                    } else {
                        return url;
                    }
                }
                url = "http://" + ((String)url).substring(gitPrefix.length());
                String gitSuffix = ".git";
                url = StringUtil.trimEnd((String)url, (String)gitSuffix);
            }
        }
        return url;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateNpmPackageName(@NotNull String name) {
        if (name == null) {
            NodePackageUtil.$$$reportNull$$$0(12);
        }
        if (name.isEmpty()) {
            return JavaScriptBundle.message("node.package.empty.error.message", new Object[0]);
        }
        if (name.startsWith(".")) {
            return JavaScriptBundle.message("node.package.name.period.error.message", new Object[0]);
        }
        if (name.startsWith("_")) {
            return JavaScriptBundle.message("node.package.name.underscore.error.message", new Object[0]);
        }
        if (!name.trim().equals(name)) {
            return JavaScriptBundle.message("node.package.name.leading.or.trailing.spaces.error.message", new Object[0]);
        }
        for (String blacklistedName : new String[]{"node_modules", "favicon.ico"}) {
            if (!StringUtil.toLowerCase((String)name).equals(blacklistedName)) continue;
            return JavaScriptBundle.message("node.package.name.forbidden.error.message", blacklistedName);
        }
        if (NodeCoreModulesCatalog.INSTANCE.isPublicCoreModule(StringUtil.toLowerCase((String)name))) {
            return JavaScriptBundle.message("node.package.name.core.module.error.message", name);
        }
        if (name.length() > 214) {
            return JavaScriptBundle.message("node.package.name.too.long.error.message", StringUtil.toLowerCase((String)name));
        }
        if (!StringUtil.toLowerCase((String)name).equals(name)) {
            return JavaScriptBundle.message("node.package.name.capital.letters.error.message", new Object[0]);
        }
        if (StringUtil.containsAnyChar((String)name, (String)"~'!()*")) {
            return JavaScriptBundle.message("node.package.name.special.characters.error.message", new Object[0]);
        }
        if (!NodePackageUtil.isUrlFriendly(name)) {
            return JavaScriptBundle.message("node.package.name.URL-friendly.characters.error.message", new Object[0]);
        }
        return null;
    }

    private static boolean isUrlFriendly(@NotNull String name) {
        if (name == null) {
            NodePackageUtil.$$$reportNull$$$0(13);
        }
        if (NodeModuleSearchUtil.isScopedPackageName(name)) {
            int separatorInd = name.indexOf(47);
            String scope2 = name.substring(1, separatorInd);
            String scopePkgName = name.substring(separatorInd + 1);
            return URLUtil.encodeURIComponent((String)scope2).equals(scope2) && URLUtil.encodeURIComponent((String)scopePkgName).equals(scopePkgName);
        }
        return URLUtil.encodeURIComponent((String)name).equals(name);
    }

    static {
        File workingDir2 = null;
        try {
            workingDir2 = FileUtil.createTempDirectory((String)"intellij-npm-info", null, (boolean)false);
        }
        catch (Exception e) {
            LOG.warn("Can't create temporary directory, working directory won't be specified.");
        }
        WORKING_DIR = workingDir2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonContent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/packages/NodePackageUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackageInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doLoadPackageInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCacheFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCachedPackageInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePackageInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doParsePackageInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVersions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseRepositoryUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "validateNpmPackageName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isUrlFriendly";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

