/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.NodeJsEnvironmentProvider;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.notification.EnablePackageJsonMismatchedDependenciesNotificationAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonSeveralFilesAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(PackageJsonUpdateNotifier.class);
    private static final String DISMISSED = "dismissed";
    private static final long MERGING_DELAY_MILLIS = 1000L;
    @NonNls
    private static final String NOTIFICATION_GROUP_ID = "Dependencies from package.json";
    @NonNls
    private static final String LOG_ONLY_NOTIFICATION_GROUP_ID = "Dismiss notifications about package.json";
    private final Project myProject;
    private final Set<VirtualFile> myDismissedFiles;
    private final Set<VirtualFile> myOpenedPackageJsonFiles;
    private final Map<VirtualFile, Notification> myShownNotifications;
    @TestOnly
    private final Set<VirtualFile> myTestShownNotifications;
    private final Alarm mySchedulingAlarm;
    private final BlockingQueue<VirtualFile> myScheduledPackageJsonFiles;
    private ProjectFileIndex myFileIndex;
    private final ExecutorService myExecutor;

    public PackageJsonUpdateNotifier(@NotNull Project project) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(0);
        }
        this.myDismissedFiles = Collections.synchronizedSet(new HashSet());
        this.myOpenedPackageJsonFiles = ConcurrentCollectionFactory.createConcurrentSet();
        this.myShownNotifications = ContainerUtil.createWeakValueMap();
        this.myTestShownNotifications = ConcurrentCollectionFactory.createConcurrentSet();
        this.myScheduledPackageJsonFiles = new LinkedBlockingQueue<VirtualFile>();
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PackageJsonUpdateNotifier", (int)1);
        this.myProject = project;
        this.mySchedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        PackageJsonDependenciesExternalUpdateManager.getInstance(project).addListener(new PackageJsonDependenciesExternalUpdateListener(){

            @Override
            public void externalUpdateStarted(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }

            @Override
            public void externalUpdateFinished(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }
        });
    }

    private PackageJsonNotifierConfiguration getPackageJsonNotifierConfiguration() {
        return (PackageJsonNotifierConfiguration)this.myProject.getService(PackageJsonNotifierConfiguration.class);
    }

    public void onPackageJsonUpdated(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("checking " + packageJson.getPath());
        }
        ReadAction.nonBlocking(() -> this.findProjectPackageJson(packageJson)).expireWith((Disposable)this).coalesceBy(new Object[]{Pair.create((Object)this, (Object)packageJson)}).submit((Executor)this.myExecutor).onSuccess(projectPackageJson -> {
            if (projectPackageJson != null) {
                this.scheduleProcessing((VirtualFile)projectPackageJson);
            }
        });
    }

    private void scheduleProcessing(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(2);
        }
        this.scheduleProcessing(Collections.singleton(packageJson), 1000L);
    }

    @Nullable
    private VirtualFile findProjectPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        if (this.getFileIndex().isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && this.getFileIndex().isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    @NotNull
    private ProjectFileIndex getFileIndex() {
        ProjectFileIndex fileIndex = this.myFileIndex;
        if (fileIndex == null) {
            this.myFileIndex = fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        }
        ProjectFileIndex projectFileIndex = fileIndex;
        if (projectFileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(4);
        }
        return projectFileIndex;
    }

    private void scheduleProcessing(@NotNull Collection<? extends VirtualFile> packageJsonFiles, long delayMillis) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.processPackageJsonFiles(new HashSet<VirtualFile>(packageJsonFiles));
            return;
        }
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed()) {
                this.mySchedulingAlarm.cancelAllRequests();
                this.myScheduledPackageJsonFiles.addAll(packageJsonFiles);
                this.mySchedulingAlarm.addRequest(() -> {
                    HashSet copy = new HashSet(this.myScheduledPackageJsonFiles.size());
                    this.myScheduledPackageJsonFiles.drainTo(copy);
                    this.processPackageJsonFiles(copy);
                }, delayMillis);
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(6);
        }
        PackageJsonUpdateNotifier packageJsonUpdateNotifier = (PackageJsonUpdateNotifier)project.getService(PackageJsonUpdateNotifier.class);
        if (packageJsonUpdateNotifier == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(7);
        }
        return packageJsonUpdateNotifier;
    }

    private void onProjectOpened() {
        this.getPackageJsonNotifierConfiguration().detectPackageJsonFiles().onSuccess(packageJsonFiles -> this.init(List.copyOf(packageJsonFiles)));
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PackageJsonFileManager.CHANGES_TOPIC, events -> {
            for (PackageJsonFileManager.PackageJsonChangeEvent event : events) {
                if (event.getType() != PackageJsonFileManager.PackageJsonEventType.CREATED && event.getType() != PackageJsonFileManager.PackageJsonEventType.CHANGED) continue;
                this.onPackageJsonUpdated(event.getFile());
            }
        });
    }

    private void init(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackOpenedFiles();
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PackageJsonBuildFileManager.getInstance(this.myProject).setPackageJsonFilesFromConfiguration(packageJsonFiles);
            List openedPackageJsonFiles = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getOpenFiles(), PackageJsonUtil::isPackageJsonFile);
            this.scheduleProcessing(ContainerUtil.union((Collection)packageJsonFiles, (Collection)openedPackageJsonFiles), 300L);
            this.myOpenedPackageJsonFiles.addAll(openedPackageJsonFiles);
            this.trackOpenedFiles();
        }, this.myProject.getDisposed());
    }

    private void trackOpenedFiles() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (PackageJsonUtil.isPackageJsonFile(file)) {
                    PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.add(file);
                    PackageJsonUpdateNotifier.this.scheduleProcessing(file);
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(3);
                }
                PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.remove(file);
                if (PackageJsonUtil.isPackageJsonFile(file)) {
                    ReadAction.nonBlocking(() -> PackageJsonUpdateNotifier.this.getPackageJsonNotifierConfiguration().isEssential(file)).expireWith((Disposable)PackageJsonUpdateNotifier.this).submit((Executor)PackageJsonUpdateNotifier.this.myExecutor).onSuccess(essential -> {
                        if (essential == Boolean.FALSE) {
                            PackageJsonUpdateNotifier.this.hideNotificationLater(file);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void processPackageJsonFiles(@NotNull Set<? extends VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPackageJsonFiles " + packageJsonFiles);
        }
        ArrayList matchDepsPackageJsons = new ArrayList();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() && !NodeJsInterpreterManager.getInstance(this.myProject).isInterpreterAvailable()) {
                return;
            }
            boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).isExternalUpdateRunning();
            PackageJsonNotifierConfiguration packageJsonNotifierConfiguration = this.getPackageJsonNotifierConfiguration();
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
            for (VirtualFile file : packageJsonFiles) {
                PackageJsonData data;
                VirtualFile nodeModulesDir;
                if (!file.isValid() || !packageJsonNotifierConfiguration.isNpmPackageJson(file) || this.isPackageJsonNotificationSuppressed(file) || !PackageJsonUpdateNotifier.isNodeJsPackageJson(file, fileIndex) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file)) == null && !packageJsonNotifierConfiguration.isEssential(file) && !this.myOpenedPackageJsonFiles.contains(file) || PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)file) || (data = PackageJsonData.getOrCreate(file)).getAllDependencies().isEmpty()) continue;
                if (externalUpdateRunning) {
                    this.hideNotificationLater(file);
                    continue;
                }
                if (PackageJsonUpdateNotifier.isNodeModulesUpdatingExternally(file)) {
                    this.hideNotificationLater(file);
                    continue;
                }
                matchDepsPackageJsons.add(file);
            }
        });
        ArrayList<VirtualFile> toShow = new ArrayList<VirtualFile>();
        for (VirtualFile packageJson : matchDepsPackageJsons) {
            boolean depsMatched = new PackageJsonDependenciesVerifier(this.myProject, packageJson).verify();
            if (depsMatched) {
                this.hideNotificationLater(packageJson);
                continue;
            }
            toShow.add(packageJson);
        }
        this.showNotification(toShow);
    }

    private boolean isPackageJsonNotificationSuppressed(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(10);
        }
        return this.myDismissedFiles.contains(packageJson);
    }

    void enableNotificationForPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(11);
        }
        this.myDismissedFiles.remove(packageJson);
        this.scheduleProcessing(packageJson);
    }

    void enableNotificationForAllPackageJsonFiles() {
        ArrayList<VirtualFile> packageJsonFiles = new ArrayList<VirtualFile>(this.myDismissedFiles);
        this.myDismissedFiles.clear();
        this.scheduleProcessing(packageJsonFiles, 1000L);
    }

    private static boolean isNodeModulesUpdatingExternally(@NotNull VirtualFile packageJson) {
        File parent;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(12);
        }
        if ((parent = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson).getParentFile()) == null) {
            return true;
        }
        return new File(parent, "node_modules" + File.separator + ".staging").isDirectory();
    }

    private void showNotification(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(13);
        }
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestShownNotifications.addAll(packageJsonFiles);
            return;
        }
        if (this.processEnvironmentValue(packageJsonFiles)) {
            return;
        }
        ReadAction.nonBlocking(() -> this.createFileLink(Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem((List)packageJsonFiles)))).expireWith((Disposable)this).finishOnUiThread(ModalityState.nonModal(), packageJsonLink -> this.showNotificationInUiThread((String)packageJsonLink, packageJsonFiles)).submit((Executor)this.myExecutor);
    }

    private boolean processEnvironmentValue(List<VirtualFile> packageJsonFiles) {
        Boolean environmentAction = NodeJsEnvironmentProvider.getInstallActionFromEnvironment();
        if (environmentAction != null) {
            if (environmentAction.booleanValue()) {
                for (VirtualFile packageJsonFile : packageJsonFiles) {
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, packageJsonFile);
                }
            } else {
                this.myDismissedFiles.addAll(packageJsonFiles);
            }
            return true;
        }
        return false;
    }

    @RequiresEdt(generateAssertion=false)
    private void showNotificationInUiThread(@NotNull String packageJsonLink, @NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonLink == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(14);
        }
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(15);
        }
        NotificationGroup notificationGroup = PackageJsonUpdateNotifier.getNotificationGroup();
        VirtualFile packageJson = Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem(packageJsonFiles));
        if (packageJsonFiles.size() > 1) {
            Notification notification = notificationGroup.createNotification(JavaScriptBundle.message("package_json.install_dependencies.notification.title", new Object[0]), JavaScriptBundle.message("package_json.install_dependencies_multiple.notification.content", packageJsonLink, packageJsonFiles.size() - 1), NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            notification.setSuggestionType(true);
            notification.addAction((AnAction)new PackageJsonSeveralFilesAction(this.myProject, packageJsonFiles, notification));
            notification.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles));
            notification.notify(this.myProject);
        } else {
            if (this.isNotificationShownFor(packageJson)) {
                return;
            }
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            String title = nodeModulesDir == null ? JavaScriptBundle.message("package_json.install_dependencies.notification.title", new Object[0]) : JavaScriptBundle.message("package_json.update_dependencies.notification.title", new Object[0]);
            Notification notification = notificationGroup.createNotification(title, JavaScriptBundle.message("package_json.install_dependencies.notification.content", packageJsonLink), NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            notification.setSuggestionType(true);
            notification.addAction((AnAction)new PackageJsonGetDependenciesAction(this.myProject, packageJson, notification));
            notification.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles));
            notification.notify(this.myProject);
            this.register(packageJson, notification);
        }
    }

    @NotNull
    public static NotificationGroup getNotificationGroup() {
        return PackageJsonUpdateNotifier.getNotificationGroup(NOTIFICATION_GROUP_ID);
    }

    @NotNull
    public static NotificationGroup getLogOnlyNotificationGroup() {
        return PackageJsonUpdateNotifier.getNotificationGroup(LOG_ONLY_NOTIFICATION_GROUP_ID);
    }

    @NotNull
    public static NotificationGroup getNotificationGroup(@NotNull String notificationGroupId) {
        NotificationGroup group;
        if (notificationGroupId == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(16);
        }
        if ((group = NotificationGroupManager.getInstance().getNotificationGroup(notificationGroupId)) != null) {
            NotificationGroup notificationGroup = group;
            if (notificationGroup == null) {
                PackageJsonUpdateNotifier.$$$reportNull$$$0(17);
            }
            return notificationGroup;
        }
        throw new AssertionError((Object)("Cannot find notificationGroup '" + notificationGroupId + "'"));
    }

    @TestOnly
    public boolean isNotificationShownInTests(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(18);
        }
        return this.myTestShownNotifications.contains(packageJson);
    }

    private boolean isNotificationShownFor(@NotNull VirtualFile packageJson) {
        Notification notification;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(19);
        }
        if ((notification = this.myShownNotifications.get(packageJson)) != null) {
            Balloon balloon = notification.getBalloon();
            return balloon != null && !balloon.isDisposed();
        }
        return false;
    }

    private void hideNotificationLater(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestShownNotifications.remove(packageJson);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Notification notification = this.myShownNotifications.get(packageJson);
            if (notification != null && !notification.isExpired()) {
                notification.expire();
            }
        }, this.myProject.getDisposed());
    }

    private void register(final @NotNull VirtualFile packageJson, @NotNull Notification notification) {
        Balloon balloon;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(21);
        }
        if (notification == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(22);
        }
        if ((balloon = notification.getBalloon()) != null) {
            this.myShownNotifications.put(packageJson, notification);
            balloon.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PackageJsonUpdateNotifier.this.myShownNotifications.remove(packageJson);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$3", "onClosed"));
                }
            });
        }
    }

    @NotNull
    private String createFileLink(@NotNull VirtualFile file) {
        if (file == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(23);
        }
        return this.createFileLink(file, false);
    }

    @NotNull
    private String createFileLink(@NotNull VirtualFile file, boolean prependContentRootName) {
        if (file == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(24);
        }
        String string = HtmlChunk.link((String)file.getPath(), (String)JsbtUtil.getRelativePath(this.myProject, file, prependContentRootName)).toString();
        if (string == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static boolean isNodeJsPackageJson(@NotNull VirtualFile packageJson, @NotNull ProjectFileIndex fileIndex) {
        Module module;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(26);
        }
        if (fileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(27);
        }
        if ((module = fileIndex.getModuleForFile(packageJson, true)) == null || module.isDisposed()) {
            return false;
        }
        ModuleType moduleType = ModuleType.get((Module)module);
        if (moduleType instanceof ModuleTypeWithWebFeatures && !((ModuleTypeWithWebFeatures)moduleType).hasWebFeatures(module)) {
            return false;
        }
        VirtualFile contentRoot = JSProjectUtil.getBaseDirectoryForFile(module.getProject(), packageJson, true);
        return contentRoot != null && !NodeModuleUtil.hasNodeModulesDirInPath(packageJson, contentRoot);
    }

    @NotNull
    public Element getState() {
        Element root = new Element("root");
        ArrayList<String> paths = new ArrayList<String>();
        for (VirtualFile file : this.myDismissedFiles) {
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)DISMISSED, paths);
        Element element = root;
        if (element == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(28);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(29);
        }
        ArrayList paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)DISMISSED);
        paths = new ArrayList(paths);
        ArrayList<VirtualFile> dismissedFiles = new ArrayList<VirtualFile>();
        for (String path2 : paths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file == null || !file.isValid() || !PackageJsonUtil.isPackageJsonFile(file)) continue;
            dismissedFiles.add(file);
        }
        this.myDismissedFiles.clear();
        this.myDismissedFiles.addAll(dismissedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 17, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 4: 
            case 7: 
            case 17: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonLink";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroupId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLink";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonUpdated";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleProcessing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProjectPackageJson";
                break;
            }
            case 4: 
            case 7: 
            case 17: 
            case 25: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processPackageJsonFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonNotificationSuppressed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableNotificationForPackageJson";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesUpdatingExternally";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationInUiThread";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationShownInTests";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationShownFor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hideNotificationLater";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFileLink";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isNodeJsPackageJson";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 17, 25, 28 -> new IllegalStateException(string);
        };
    }

    private class MyNotificationListener
    implements NotificationListener {
        private MyNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            VirtualFile file;
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (file = LocalFileSystem.getInstance().findFileByPath(event.getDescription())) != null && file.isValid()) {
                FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.myProject).openFile(file, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PackageJsonDismissAction
    extends NotificationAction {
        private final Collection<? extends VirtualFile> myPackageJsonFiles;

        PackageJsonDismissAction(Collection<? extends VirtualFile> packageJsonFiles) {
            if (packageJsonFiles == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(0);
            }
            super(JavaScriptBundle.messagePointer("action.don.t.ask.again.text", new Object[0]));
            this.myPackageJsonFiles = packageJsonFiles;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(2);
            }
            notification.expire();
            PackageJsonUpdateNotifier.this.myDismissedFiles.addAll(this.myPackageJsonFiles);
            List paths = ContainerUtil.map(this.myPackageJsonFiles, packageJson -> PackageJsonUpdateNotifier.this.createFileLink((VirtualFile)packageJson, this.myPackageJsonFiles.size() > 1));
            String content = JavaScriptBundle.message("package_json.notifications_are_disabled.notification.content", StringUtil.join((Collection)paths, (String)", "), EnablePackageJsonMismatchedDependenciesNotificationAction.ACTION_NAME.get());
            PackageJsonUpdateNotifier.getLogOnlyNotificationGroup().createNotification(content, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener()).notify(PackageJsonUpdateNotifier.this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MyStartupActivity
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            PackageJsonUpdateNotifier.getInstance(project).onProjectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity", "runActivity"));
        }
    }
}

