/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="NodePackageJsonFileManager", storages={@Storage(value="$CACHE_FILE$")})
public final class PackageJsonFileManager
implements PersistentStateComponent<State> {
    @Topic.ProjectLevel
    public static final Topic<PackageJsonChangesListener> CHANGES_TOPIC = new Topic(PackageJsonChangesListener.class, Topic.BroadcastDirection.NONE);
    private final Project myProject;
    private final Object LOCK;
    private Set<VirtualFile> myPackageJsonFiles;
    private final SimpleModificationTracker myTracker;
    private final boolean myJsAwareProject;

    public PackageJsonFileManager(@NotNull Project project) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myPackageJsonFiles = Collections.emptySet();
        this.myTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myJsAwareProject = !NodeModulesDirectoryManager.isIdeaProject(project);
    }

    @NotNull
    public static PackageJsonFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(1);
        }
        PackageJsonFileManager packageJsonFileManager = (PackageJsonFileManager)project.getService(PackageJsonFileManager.class);
        if (packageJsonFileManager == null) {
            PackageJsonFileManager.$$$reportNull$$$0(2);
        }
        return packageJsonFileManager;
    }

    public State getState() {
        List<String> list2 = this.getValidPackageJsonFiles().stream().map(VirtualFile::getPath).sorted().collect(Collectors.toList());
        return new State(list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            PackageJsonFileManager.$$$reportNull$$$0(3);
        }
        SmartList files = new SmartList();
        for (String path2 : state.myPaths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file == null || !file.isValid() || !PackageJsonUtil.isPackageJsonFile(file)) continue;
            files.add(file);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myPackageJsonFiles = ImmutableSet.copyOf((Collection)files);
        }
    }

    private boolean accept(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(4);
        }
        if (!packageJson.isValid() || !PackageJsonUtil.isPackageJsonFile(packageJson)) {
            return false;
        }
        VirtualFile root = JSProjectUtil.getBaseDirectoryForFile(this.myProject, packageJson, true);
        return root != null && this.myJsAwareProject && !JSLibraryUtil.hasDirectoryInPath(packageJson, "node_modules", root);
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTracker;
        if (simpleModificationTracker == null) {
            PackageJsonFileManager.$$$reportNull$$$0(5);
        }
        return simpleModificationTracker;
    }

    public void onPackageJsonAdded(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(6);
        }
        this.updatePackageJsonFiles(Collections.emptyList(), List.of(packageJson));
    }

    public void onPackageJsonRemoved(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(7);
        }
        this.updatePackageJsonFiles(List.of(packageJson), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        boolean alreadyAdded;
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(8);
        }
        Object object = this.LOCK;
        synchronized (object) {
            alreadyAdded = this.myPackageJsonFiles.contains(packageJson);
            if (alreadyAdded) {
                this.myTracker.incModificationCount();
            }
        }
        if (alreadyAdded) {
            this.publishEvents(List.of(new PackageJsonChangeEvent(PackageJsonEventType.CHANGED, packageJson)));
        } else {
            this.updatePackageJsonFiles(Collections.emptyList(), List.of(packageJson));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<VirtualFile> getValidPackageJsonFiles() {
        Set<VirtualFile> packageJsonFiles;
        Object object = this.LOCK;
        synchronized (object) {
            packageJsonFiles = this.myPackageJsonFiles;
        }
        return this.filterAndUpdate(packageJsonFiles, false);
    }

    @NotNull
    private Set<VirtualFile> filterAndUpdate(@NotNull Set<VirtualFile> packageJsonFiles, boolean checkIsInContent) {
        if (packageJsonFiles == null) {
            PackageJsonFileManager.$$$reportNull$$$0(9);
        }
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : packageJsonFiles) {
            if (file.isValid() && (!checkIsInContent || this.accept(file))) continue;
            toRemove.add(file);
        }
        if (!toRemove.isEmpty()) {
            Set<VirtualFile> set = this.updatePackageJsonFiles(toRemove, Collections.emptyList());
            if (set == null) {
                PackageJsonFileManager.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<VirtualFile> set = packageJsonFiles;
        if (set == null) {
            PackageJsonFileManager.$$$reportNull$$$0(11);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootsChanged() {
        Set<VirtualFile> packageJsonFiles;
        Object object = this.LOCK;
        synchronized (object) {
            packageJsonFiles = this.myPackageJsonFiles;
        }
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed()) {
                this.filterAndUpdate(packageJsonFiles, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<VirtualFile> updatePackageJsonFiles(@NotNull Collection<VirtualFile> toRemove, @NotNull Collection<VirtualFile> toAdd) {
        HashSet<VirtualFile> newFiles;
        if (toRemove == null) {
            PackageJsonFileManager.$$$reportNull$$$0(12);
        }
        if (toAdd == null) {
            PackageJsonFileManager.$$$reportNull$$$0(13);
        }
        toAdd = ContainerUtil.filter(toAdd, it -> this.accept((VirtualFile)it));
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            Object object = this.LOCK;
            synchronized (object) {
                return this.myPackageJsonFiles;
            }
        }
        ArrayList<PackageJsonChangeEvent> events = new ArrayList<PackageJsonChangeEvent>();
        Object object = this.LOCK;
        synchronized (object) {
            newFiles = new HashSet<VirtualFile>(this.myPackageJsonFiles);
            for (VirtualFile r : toRemove) {
                if (!newFiles.remove(r)) continue;
                events.add(new PackageJsonChangeEvent(PackageJsonEventType.DELETED, r));
            }
            for (VirtualFile a : toAdd) {
                if (!newFiles.add(a)) continue;
                events.add(new PackageJsonChangeEvent(PackageJsonEventType.CREATED, a));
            }
            this.myPackageJsonFiles = Collections.unmodifiableSet(newFiles);
            if (!events.isEmpty()) {
                this.myTracker.incModificationCount();
            }
        }
        if (!events.isEmpty()) {
            this.publishEvents(events);
        }
        return newFiles;
    }

    private void publishEvents(@NotNull @NotNull List<@NotNull PackageJsonChangeEvent> events) {
        if (events == null) {
            PackageJsonFileManager.$$$reportNull$$$0(14);
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            @NotNull List validEvents = ContainerUtil.filter((Collection)events, it -> it.myFile.isValid());
            if (validEvents.isEmpty()) {
                return;
            }
            ((PackageJsonChangesListener)this.myProject.getMessageBus().syncPublisher(CHANGES_TOPIC)).onChange(validEvents);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonContentChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterAndUpdate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updatePackageJsonFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "publishEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 10, 11 -> new IllegalStateException(string);
        };
    }

    static class State {
        @XCollection(propertyElementName="packageJsonPaths", elementName="path")
        public final List<String> myPaths;

        State() {
            this.myPaths = new SmartList();
        }

        State(@NotNull List<String> paths) {
            if (paths == null) {
                State.$$$reportNull$$$0(0);
            }
            this.myPaths = new SmartList();
            this.myPaths.addAll(paths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$State", "<init>"));
        }
    }

    public static final class PackageJsonChangeEvent {
        @NotNull
        private final PackageJsonEventType myType;
        @NotNull
        private final VirtualFile myFile;

        private PackageJsonChangeEvent(@NotNull PackageJsonEventType type2, @NotNull VirtualFile file) {
            if (type2 == null) {
                PackageJsonChangeEvent.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PackageJsonChangeEvent.$$$reportNull$$$0(1);
            }
            this.myType = type2;
            this.myFile = file;
        }

        @NotNull
        public PackageJsonEventType getType() {
            PackageJsonEventType packageJsonEventType = this.myType;
            if (packageJsonEventType == null) {
                PackageJsonChangeEvent.$$$reportNull$$$0(2);
            }
            return packageJsonEventType;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                PackageJsonChangeEvent.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$PackageJsonChangeEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonFileManager$PackageJsonChangeEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum PackageJsonEventType {
        CREATED,
        CHANGED,
        DELETED;

    }

    public static interface PackageJsonChangesListener {
        public void onChange(@NotNull List<PackageJsonChangeEvent> var1);
    }
}

