/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class WorkingDirectoryDependentNpmPackageVersionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(WorkingDirectoryDependentNpmPackageVersionManager.class);
    private static final ExecutorService ourExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)(WorkingDirectoryDependentNpmPackageVersionManager.class.getSimpleName() + " Pool"));
    private static final int TIMEOUT = 30000;
    private final Project myProject;
    private final ConcurrentMap<InputData, VersionInfo> myVersionCache;
    private final ConcurrentMap<InputData, Fetch> myFetchInProgressByPkgMap;
    private final List<ModificationTracker> myModificationTrackers;

    public WorkingDirectoryDependentNpmPackageVersionManager(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(0);
        }
        this.myVersionCache = new ConcurrentHashMap<InputData, VersionInfo>();
        this.myFetchInProgressByPkgMap = new ConcurrentHashMap<InputData, Fetch>();
        this.myProject = project;
        final SimpleModificationTracker switchedOutModificationTracker = new SimpleModificationTracker();
        this.myModificationTrackers = List.of(switchedOutModificationTracker, VirtualFileManager.getInstance());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                switchedOutModificationTracker.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$1", "applicationDeactivated"));
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static WorkingDirectoryDependentNpmPackageVersionManager getInstance(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(1);
        }
        WorkingDirectoryDependentNpmPackageVersionManager workingDirectoryDependentNpmPackageVersionManager = (WorkingDirectoryDependentNpmPackageVersionManager)project.getService(WorkingDirectoryDependentNpmPackageVersionManager.class);
        if (workingDirectoryDependentNpmPackageVersionManager == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(2);
        }
        return workingDirectoryDependentNpmPackageVersionManager;
    }

    public void fetchVersion(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage pkg, @NotNull Consumer<SemVer> versionConsumer) {
        if (interpreter == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(3);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(4);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(5);
        }
        this.fetchVersion(interpreter, pkg, null, versionConsumer);
    }

    public void fetchVersion(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage pkg, @Nullable File workingDirectory, @NotNull Consumer<SemVer> versionConsumer) {
        if (interpreter == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(6);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(7);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(8);
        }
        if (pkg.isEmptyPath()) {
            versionConsumer.accept(null);
            return;
        }
        File effectiveWorkingDirectory = workingDirectory != null ? workingDirectory : this.getDefaultWorkingDir();
        InputData inputData = new InputData(interpreter, pkg, effectiveWorkingDirectory.getAbsolutePath());
        VersionInfo info2 = (VersionInfo)this.myVersionCache.get(inputData);
        NullableLazyValue pkgVersionFromPackageJsonValue = NullableLazyValue.lazyNullable(() -> pkg.getVersion());
        SemVer initialVersion = info2 != null && info2.myPkgVersionInProjectRoot != null ? info2.myPkgVersionInProjectRoot : (SemVer)pkgVersionFromPackageJsonValue.getValue();
        versionConsumer.accept(initialVersion);
        if (info2 != null && info2.isModCountsUpToDate() && Objects.equals(pkgVersionFromPackageJsonValue.getValue(), info2.myPkgVersionFromPackageJson)) {
            return;
        }
        Fetch newFetch = new Fetch(inputData);
        Fetch prevFetch = this.myFetchInProgressByPkgMap.putIfAbsent(inputData, newFetch);
        Fetch fetch = (Fetch)ObjectUtils.notNull((Object)prevFetch, (Object)newFetch);
        fetch.notifyWhenDone(versionConsumer, initialVersion);
    }

    @NotNull
    private SemVer fetchProjectVersion(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage pkg, @NotNull File workingDirectory) throws com.intellij.execution.ExecutionException {
        ProcessOutput output;
        if (interpreter == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(9);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(10);
        }
        if (workingDirectory == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(11);
        }
        if (interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron()) {
            throw new com.intellij.execution.ExecutionException("Electron Node.js interpreter is not supported");
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, null, NodeTargetRunOptions.of(false));
        WorkingDirectoryDependentNpmPackageVersionManager.configureCommandLine(targetRun, pkg, workingDirectory);
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        long startNano = System.nanoTime();
        try {
            output = new ProcessOutputCatcher((BaseOSProcessHandler)processWithCmdLine.getProcessHandler()).run(null, 30000L);
        }
        catch (com.intellij.execution.ExecutionException e) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version (" + processWithCmdLine.getCommandLinePresentation() + ")", (Throwable)e);
        }
        String shortInfo = "command: " + processWithCmdLine.getCommandLinePresentation() + ", duration: " + TimeoutUtil.getDurationMillis((long)startNano) + "ms";
        String longInfo = shortInfo + ", " + output;
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: timed out; " + longInfo);
        }
        if (output.getExitCode() != 0) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: non-zero exit code; " + longInfo);
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version: expected single line, actual lines " + stdout + "; " + longInfo);
        }
        SemVer version2 = SemVer.parseFromText((String)StringUtil.trimStart((String)((String)stdout.get(0)), (String)"v"));
        if (version2 == null) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version from '" + (String)stdout.get(0) + "'; " + longInfo);
        }
        LOG.info("Version fetched successfully: " + version2 + "; " + shortInfo);
        SemVer semVer = version2;
        if (semVer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(12);
        }
        return semVer;
    }

    private static void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg, @NotNull File workingDirectory) throws com.intellij.execution.ExecutionException {
        if (targetRun == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(13);
        }
        if (npmPkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(14);
        }
        if (workingDirectory == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(15);
        }
        targetRun.setEnableWrappingWithYarnNode(false);
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setWorkingDirectory(targetRun.path(workingDirectory.getAbsolutePath()));
        NpmNodePackage.configureNpmPackage(targetRun, npmPkg, new String[0]);
        commandLine.addParameter("--version");
    }

    @NotNull
    private File getDefaultWorkingDir() {
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (projectRoot != null) {
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)projectRoot);
            if (file == null) {
                WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(16);
            }
            return file;
        }
        return new File(SystemProperties.getUserHome());
    }

    private long @NotNull [] createModCounts() {
        long[] counts = new long[this.myModificationTrackers.size()];
        for (int i = 0; i < this.myModificationTrackers.size(); ++i) {
            counts[i] = this.myModificationTrackers.get(i).getModificationCount();
        }
        if (counts == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(17);
        }
        return counts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 12, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionConsumer";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProjectVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultWorkingDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createModCounts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fetchProjectVersion";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 12, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static class InputData {
        private final NodeJsInterpreter myInterpreter;
        private final NodePackage myPkg;
        private final String myWorkingDirectory;

        private InputData(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage pkg, @NotNull String workingDirectory) {
            if (interpreter == null) {
                InputData.$$$reportNull$$$0(0);
            }
            if (pkg == null) {
                InputData.$$$reportNull$$$0(1);
            }
            if (workingDirectory == null) {
                InputData.$$$reportNull$$$0(2);
            }
            this.myInterpreter = interpreter;
            this.myPkg = pkg;
            this.myWorkingDirectory = workingDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputData data = (InputData)o;
            return this.myPkg.equals(data.myPkg) && this.myWorkingDirectory.equals(data.myWorkingDirectory);
        }

        public int hashCode() {
            return Objects.hash(this.myPkg, this.myWorkingDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDirectory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$InputData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VersionInfo {
        private final SemVer myPkgVersionFromPackageJson;
        private final SemVer myPkgVersionInProjectRoot;
        private final long[] myModificationCounts;

        VersionInfo(@Nullable SemVer pkgVersionFromPackageJson, SemVer pkgVersionInProjectRoot) {
            this.myPkgVersionFromPackageJson = pkgVersionFromPackageJson;
            this.myPkgVersionInProjectRoot = pkgVersionInProjectRoot;
            this.myModificationCounts = WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts();
        }

        boolean isModCountsUpToDate() {
            return Arrays.equals(this.myModificationCounts, WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts());
        }
    }

    private final class Fetch {
        private final AtomicBoolean myStarted;
        private final FutureTask<SemVer> myFuture;

        private Fetch(InputData inputData) {
            if (inputData == null) {
                Fetch.$$$reportNull$$$0(0);
            }
            this.myStarted = new AtomicBoolean(false);
            this.myFuture = new FutureTask<SemVer>(() -> (SemVer)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                SemVer version2 = null;
                try {
                    version2 = WorkingDirectoryDependentNpmPackageVersionManager.this.fetchProjectVersion(inputData.myInterpreter, inputData.myPkg, new File(inputData.myWorkingDirectory));
                }
                catch (Throwable t) {
                    LOG.warn("Failed to fetch version for " + inputData.myPkg.getSystemIndependentPath(), t);
                }
                finally {
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myVersionCache.put(inputData, new VersionInfo(inputData.myPkg.getVersion(), version2));
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myFetchInProgressByPkgMap.remove(inputData);
                }
                return version2;
            }));
        }

        public void notifyWhenDone(@NotNull Consumer<SemVer> consumer, @Nullable SemVer initialVersion) {
            if (consumer == null) {
                Fetch.$$$reportNull$$$0(1);
            }
            if (this.myStarted.compareAndSet(false, true)) {
                ourExecutorService.execute(this.myFuture);
            }
            ourExecutorService.execute(() -> {
                SemVer version2 = null;
                try {
                    version2 = this.myFuture.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unexpected exception", (Throwable)e);
                }
                if (!Objects.equals(initialVersion, version2)) {
                    consumer.accept(version2);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$Fetch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyWhenDone";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

