/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmPackageDescriptor
extends NodePackageDescriptor {
    private static final EnumMap<Platform, List<String>> EXT_BY_PLATFORM = new EnumMap<Platform, List<String>>(Map.of(Platform.WINDOWS, List.of(".cmd", ".exe"), Platform.UNIX, List.of("")));
    private final boolean myProjectField;

    NpmPackageDescriptor(boolean projectField) {
        super("npm", "yarn", "pnpm");
        this.myProjectField = projectField;
    }

    @Override
    @NotNull
    public NodePackageRef createPackageRef(@NotNull String text2) {
        if (text2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(0);
        }
        if (this.getPackageNames().contains(text2) || "Project".equals(text2)) {
            NodePackageRef nodePackageRef = NodePackageRef.create(text2);
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(1);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(this.createPackage(text2));
        if (nodePackageRef == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(2);
        }
        return nodePackageRef;
    }

    @Override
    @NotNull
    public NpmNodePackage createPackage(@NotNull String path2) {
        if (path2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(3);
        }
        return new NpmNodePackage(LocalFilePath.stripRemoteProtocol(path2));
    }

    @Override
    @NotNull
    public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
        if (project == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(5);
        }
        if (NpmUtil.isProjectPackageManagerPackageRef(ref)) {
            NodePackageRef nodePackageRef = NpmManager.getInstance(project).getPackageRef();
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(6);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = ref;
        if (nodePackageRef == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(7);
        }
        return nodePackageRef;
    }

    @Override
    @NotNull
    public FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        descriptor.withTitle(JavaScriptBundle.message("node.package.selector.multiple.packages.binary.file.title", StringUtil.join(this.getPackageNames(), (String)"/")));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(8);
        }
        return fileChooserDescriptor;
    }

    @Override
    @NotNull
    public String getHintText() {
        String string = JavaScriptBundle.message("node.package.binary.file.hint", StringUtil.join(this.getPackageNames(), (String)"/"));
        if (string == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(10);
        }
        ArrayList<NodePackageRef> result2 = new ArrayList<NodePackageRef>();
        if (!this.myProjectField) {
            result2.add(NpmUtil.createProjectPackageManagerPackageRef());
        }
        for (String pkgName : this.getPackageNames()) {
            result2.add(NodePackageRef.create(pkgName));
        }
        List<NodePackage> yarnProjectLocalBinaryFiles = NpmPackageDescriptor.findYarnProjectLocalBinaryCjsFiles(project);
        List pkgs = ContainerUtil.mapNotNull(this.getPackageNames(), name -> NpmPackageDescriptor.findBinaryFilePackage(interpreter, name));
        List<NpmNodePackage> systemPackages = this.detectSystemWideInstallations(interpreter);
        for (NodePackage systemPkg : ContainerUtil.concat((List[])new List[]{yarnProjectLocalBinaryFiles, pkgs, systemPackages})) {
            NodePackageRef pkg = NodePackageRef.create(systemPkg);
            if (result2.contains(pkg)) continue;
            result2.add(pkg);
        }
        ArrayList<NodePackageRef> arrayList = result2;
        if (arrayList == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackage> findYarnProjectLocalBinaryCjsFiles(@NotNull Project project) {
        if (project == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(12);
        }
        List list2 = (List)ReadAction.compute(() -> PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles().stream().flatMap(packageJsonFile -> {
            VirtualFile parent = packageJsonFile.getParent();
            VirtualFile releasesDir = parent != null ? parent.findFileByRelativePath(".yarn/releases") : null;
            return Arrays.stream(releasesDir != null ? releasesDir.getChildren() : VirtualFile.EMPTY_ARRAY).filter(child -> NpmNodePackage.isJavaScriptFile(child.getName())).map(child -> new NpmNodePackage(child.getPath()));
        }).collect(Collectors.toList()));
        if (list2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Nullable
    public static NpmNodePackage findBinaryFilePackage(@Nullable NodeJsInterpreter interpreter, @NotNull String binaryFileNameWithoutExtension) {
        if (binaryFileNameWithoutExtension == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(14);
        }
        if (interpreter instanceof NodeJsLocalInterpreter) {
            String interpreterPath = ((NodeJsLocalInterpreter)interpreter).getInterpreterSystemDependentPath();
            return NpmPackageDescriptor.findLocalBinaryFilePackage(PathUtil.getParentPath((String)interpreterPath), binaryFileNameWithoutExtension);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            WslNodeInterpreter wslInterpreter = (WslNodeInterpreter)interpreter;
            return NpmPackageDescriptor.findBinaryFilePackage(PathUtil.getParentPath((String)wslInterpreter.getWslInterpreterPath()), binaryFileNameWithoutExtension, Platform.UNIX, binaryFilePath -> NpmPackageDescriptor.findWslBinaryFilePackage(binaryFilePath, wslInterpreter));
        }
        if (interpreter instanceof NodeJsRemoteInterpreter) {
            return new NpmNodePackage(binaryFileNameWithoutExtension);
        }
        return null;
    }

    @Nullable
    private static NpmNodePackage findBinaryFilePackage(@NotNull String targetBinDirectory, @NotNull String binaryFileNameWithoutExtension, @NotNull Platform targetPlatform, @NotNull Function<String, NpmNodePackage> producer) {
        if (targetBinDirectory == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(15);
        }
        if (binaryFileNameWithoutExtension == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(16);
        }
        if (targetPlatform == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(17);
        }
        if (producer == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(18);
        }
        List<String> binaryFilePaths = NpmPackageDescriptor.getBinaryFilePaths(targetBinDirectory, binaryFileNameWithoutExtension, targetPlatform);
        return binaryFilePaths.stream().map(producer).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    private static List<String> getBinaryFilePaths(@NotNull String targetBinDirectory, @NotNull String binaryFileNameWithoutExtension, @NotNull Platform targetPlatform) {
        if (targetBinDirectory == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(19);
        }
        if (binaryFileNameWithoutExtension == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(20);
        }
        if (targetPlatform == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(21);
        }
        List<String> extensions = EXT_BY_PLATFORM.get(targetPlatform);
        List list2 = ContainerUtil.map(extensions, ext -> targetBinDirectory + targetPlatform.fileSeparator + binaryFileNameWithoutExtension + ext);
        if (list2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    private List<NpmNodePackage> detectSystemWideInstallations(@Nullable NodeJsInterpreter interpreter) {
        if (interpreter instanceof NodeJsLocalInterpreter) {
            return this.findAllLocalBinaryFilePackagesInPath();
        }
        List<NpmNodePackage> list2 = List.of();
        if (list2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    private List<NpmNodePackage> findAllLocalBinaryFilePackagesInPath() {
        List<NpmNodePackage> list2 = this.getPackageNames().stream().flatMap(name -> {
            List allExeFiles = EXT_BY_PLATFORM.get(Platform.current()).stream().flatMap(ext -> PathEnvironmentVariableUtil.findAllExeFilesInPath((String)(name + ext)).stream()).toList();
            HashSet<String> parentDirs = new HashSet<String>();
            ArrayList<File> uniqueExeFiles = new ArrayList<File>();
            for (File file2 : allExeFiles) {
                String parentDirPath = file2.getParent();
                if (!parentDirs.add(parentDirPath)) continue;
                uniqueExeFiles.add(file2);
            }
            return uniqueExeFiles.stream().map(file -> NpmPackageDescriptor.findLocalBinaryFilePackage(file.getAbsolutePath())).filter(Objects::nonNull);
        }).collect(Collectors.toList());
        if (list2 == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @Nullable
    static NpmNodePackage findLocalBinaryFilePackageInPath(@NotNull String binaryFileNameWithoutExtension) {
        File exeFile;
        if (binaryFileNameWithoutExtension == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(25);
        }
        return (exeFile = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)binaryFileNameWithoutExtension)) != null ? NpmPackageDescriptor.findLocalBinaryFilePackage(exeFile.getAbsolutePath()) : null;
    }

    @Nullable
    public static NpmNodePackage findLocalBinaryFilePackage(@NotNull String targetBinDirectory, @NotNull String binaryFileNameWithoutExtension) {
        if (targetBinDirectory == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(26);
        }
        if (binaryFileNameWithoutExtension == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(27);
        }
        return NpmPackageDescriptor.findBinaryFilePackage(targetBinDirectory, binaryFileNameWithoutExtension, Platform.current(), NpmPackageDescriptor::findLocalBinaryFilePackage);
    }

    @Nullable
    private static NpmNodePackage findLocalBinaryFilePackage(@NotNull String localFilePath) {
        if (localFilePath == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(28);
        }
        if (NpmNodePackage.getLocalFileKind(localFilePath) == NpmNodePackage.FileKind.FILE) {
            return new NpmNodePackage(localFilePath);
        }
        return null;
    }

    @Nullable
    private static NpmNodePackage findWslBinaryFilePackage(@NotNull String linuxBinaryFile, @NotNull WslNodeInterpreter interpreter) {
        if (linuxBinaryFile == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(29);
        }
        if (interpreter == null) {
            NpmPackageDescriptor.$$$reportNull$$$0(30);
        }
        if (NpmNodePackage.getWslFileKind(linuxBinaryFile, interpreter) == NpmNodePackage.FileKind.FILE) {
            return new NpmNodePackage(linuxBinaryFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 8, 9, 11, 13, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmPackageDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFileNameWithoutExtension";
                break;
            }
            case 15: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBinDirectory";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPlatform";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFilePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxBinaryFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmPackageDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRef";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProjectRef";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooserDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageRefs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findYarnProjectLocalBinaryCjsFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryFilePaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "detectSystemWideInstallations";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllLocalBinaryFilePackagesInPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRef";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProjectRef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listPackageRefs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findYarnProjectLocalBinaryCjsFiles";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findBinaryFilePackage";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryFilePaths";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBinaryFilePackageInPath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBinaryFilePackage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findWslBinaryFilePackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 8, 9, 11, 13, 22, 23, 24 -> new IllegalStateException(string);
        };
    }
}

