/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends DumbAwareAction {
    private static final Key<Queue<VirtualFile>> QUEUE_KEY = Key.create((String)"package.json queue to install");
    private static final Key<VirtualFile> CONTEXT_PACKAGE_JSON_KEY = Key.create((String)"package.json associated with package.json");

    public InstallNodeLocalDependenciesAction() {
        super(JavaScriptBundle.messagePointer("action.InstallNodeLocalDependencies.text", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Install);
    }

    public @NotNull List<Supplier<@Nls String>> getSynonyms() {
        List<Supplier<String>> list2 = List.of(() -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("npm"), () -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("yarn"), () -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("pnpm"));
        if (list2 == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    @Nls
    private static String getActionNameByPackageManager(@NotNull String packageName) {
        if (packageName == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(1);
        }
        String string = JavaScriptBundle.message("node.js.quickfix.run.command", NpmManager.getNpmCommandPresentableText(NodePackageRef.create(packageName), NpmCommand.INSTALL)).replace("'", "");
        if (string == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        List<VirtualFile> packageJsonFiles = this.getPackageJsonFiles(e);
        boolean show = project != null && !packageJsonFiles.isEmpty();
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            e.getPresentation().setText(JavaScriptBundle.message("node.js.quickfix.run.command", NpmManager.getInstance(project).getNpmInstallPresentableText()));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        List<VirtualFile> packageJsonFiles = this.getPackageJsonFiles(e);
        if (project != null && !packageJsonFiles.isEmpty()) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJsonFiles);
        }
    }

    @NotNull
    protected List<VirtualFile> getPackageJsonFiles(@NotNull AnActionEvent e) {
        Object[] files;
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(6);
        }
        if ((files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                InstallNodeLocalDependenciesAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter((Object[])files, packageJson -> PackageJsonUtil.isPackageJsonFile(packageJson) && packageJson.isValid());
        if (list3 == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(8);
        }
        return list3;
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(9);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(10);
        }
        InstallNodeLocalDependenciesAction.runAndShowConsole(project, Collections.singletonList(packageJson));
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(11);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(12);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        LinkedList<VirtualFile> queue = (LinkedList<VirtualFile>)project.getUserData(QUEUE_KEY);
        if (queue == null) {
            queue = new LinkedList<VirtualFile>();
            project.putUserData(QUEUE_KEY, queue);
        }
        queue.addAll(packageJsonFiles);
        ApplicationManager.getApplication().invokeLater(() -> InstallNodeLocalDependenciesAction.installNext(project), ModalityState.nonModal());
    }

    private static void installNext(@NotNull Project project) {
        Queue queue;
        VirtualFile packageJson;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = packageJson = (queue = (Queue)project.getUserData(QUEUE_KEY)) != null ? (VirtualFile)queue.poll() : null;
        if (packageJson == null) {
            project.putUserData(QUEUE_KEY, null);
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        ReadAction.nonBlocking(() -> InstallNodeLocalDependenciesAction.getTitle(project, packageJson)).finishOnUiThread(ModalityState.nonModal(), title -> {
            if (title != null) {
                InstallNodeLocalDependenciesAction.installDepsForPackageJson(project, packageJson, title);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void installDepsForPackageJson(final @NotNull Project project, final @NotNull VirtualFile packageJson, @NotNull String title) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(14);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(15);
        }
        if (title == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(16);
        }
        NpmRunConfiguration configuration = new NpmRunConfiguration(project, (ConfigurationFactory)NpmConfigurationType.getInstance(), title){

            @NotNull
            public Icon getIcon() {
                Icon icon2 = AllIcons.Actions.Install;
                if (icon2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            @Override
            @NotNull
            public RunProfileState getState(@NotNull com.intellij.execution.Executor executor, @NotNull ExecutionEnvironment environment) {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new NpmRunProfileState(this, environment){

                    @Override
                    @NotNull
                    public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
                        ProcessHandler processHandler = super.startProcess(configurator);
                        InstallNodeLocalDependenciesAction.onProcessStarted(project, processHandler, packageJson);
                        ProcessHandler processHandler2 = processHandler;
                        if (processHandler2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return processHandler2;
                    }

                    @Override
                    protected void onNpmPackageBecomeValid() {
                        InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$1$1", "startProcess"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        configuration.setRunSettings(NpmRunSettings.builder().setPackageJsonPath(packageJson.getPath()).setCommand(NpmCommand.INSTALL).build());
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile((RunProfile)configuration);
        RunContentDescriptor otherDescriptor = (RunContentDescriptor)ContainerUtil.find((Iterable)RunContentManager.getInstance((Project)project).getAllDescriptors(), d -> {
            VirtualFile contextPackageJson;
            ProcessHandler handler = d.getProcessHandler();
            return handler != null && packageJson.equals(contextPackageJson = (VirtualFile)handler.getUserData(CONTEXT_PACKAGE_JSON_KEY)) && !handler.isProcessTerminated();
        });
        if (otherDescriptor != null) {
            ProcessHandler otherProcessHandler = otherDescriptor.getProcessHandler();
            if (otherProcessHandler != null) {
                otherProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
                ProcessCloseConfirmation result2 = TerminateRemoteProcessDialog.show((Project)project, (String)title, (ProcessHandler)otherProcessHandler);
                if (result2 == null) {
                    return;
                }
            }
            builder2.contentToReuse(otherDescriptor);
        }
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.build());
    }

    @Nullable
    private static String getTitle(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(17);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(18);
        }
        if (project.isDisposed()) {
            return null;
        }
        Object title = NpmManager.getInstance(project).getNpmInstallPresentableText();
        VirtualFile dir = packageJson.getParent();
        if (dir != null) {
            title = (String)title + " in " + JsbtUtil.getRelativePath(project, dir);
        }
        return title;
    }

    private static void saveFile(@NotNull VirtualFile file) {
        FileDocumentManager fileDocumentManager;
        Document doc;
        if (file == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(19);
        }
        if ((doc = (fileDocumentManager = FileDocumentManager.getInstance()).getDocument(file)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    private static void onProcessStarted(final @NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull VirtualFile packageJson) throws ExecutionException {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(20);
        }
        if (processHandler == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(21);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(22);
        }
        processHandler.putUserData(CONTEXT_PACKAGE_JSON_KEY, (Object)packageJson);
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(packageJson, null);
        NodePackageRef npmRef = NpmManager.getInstance(project).getPackageRef();
        String activityName = NpmManager.getNpmCommandPresentableText(npmRef, NpmCommand.INSTALL);
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, activityName);
        final VirtualFile workingDirectory = packageJson.getParent();
        if (workingDirectory == null) {
            throw new ExecutionException(JavaScriptBundle.message("dialog.message.cannot.determine.package.json.directory", new Object[0]));
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                InstallNodeLocalDependenciesAction.doWhenRefreshed(project, workingDirectory, () -> {
                    ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
                    done.run();
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    if (event.getExitCode() == 0) {
                        InstallNodeLocalDependenciesAction.scheduleNextInstall(project);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$2", "processTerminated"));
            }
        });
    }

    private static void doWhenRefreshed(@NotNull Project project, @NotNull VirtualFile dir, @NotNull Runnable onDone) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(23);
        }
        if (dir == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(24);
        }
        if (onDone == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(25);
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> InstallNodeLocalDependenciesAction.processJsonDirsOnRefresh(project, dir, onDone), 300L, TimeUnit.MILLISECONDS);
    }

    private static void processJsonDirsOnRefresh(@NotNull Project project, @NotNull VirtualFile dir, @NotNull Runnable onDone) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(26);
        }
        if (dir == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(27);
        }
        if (onDone == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(28);
        }
        ReadAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            HashSet<VirtualFile> refreshDirs = new HashSet<VirtualFile>();
            refreshDirs.add(dir);
            PackageJsonUtil.processUpPackageJsonFiles(project, dir, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
                ContainerUtil.addIfNotNull((Collection)refreshDirs, (Object)packageJsonFile.getParent());
                return true;
            }));
            AtomicInteger count = new AtomicInteger(refreshDirs.size());
            for (VirtualFile refreshDir : refreshDirs) {
                refreshDir.refresh(true, true, () -> {
                    if (count.decrementAndGet() == 0 && !project.isDisposed()) {
                        onDone.run();
                    }
                });
            }
        });
    }

    private static void scheduleNextInstall(@NotNull Project project) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(29);
        }
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)JSDisposable.getInstance(project)).addRequest(() -> InstallNodeLocalDependenciesAction.installNext(project), 2000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynonyms";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionNameByPackageManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionNameByPackageManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runAndShowConsole";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installNext";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installDepsForPackageJson";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onProcessStarted";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doWhenRefreshed";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processJsonDirsOnRefresh";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "scheduleNextInstall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    public static class Root
    extends InstallNodeLocalDependenciesAction {
        @Override
        @NotNull
        protected List<VirtualFile> getPackageJsonFiles(@NotNull AnActionEvent e) {
            if (e == null) {
                Root.$$$reportNull$$$0(0);
            }
            Project project = Objects.requireNonNull(e.getProject());
            VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
            List list2 = ContainerUtil.createMaybeSingletonList((Object)PackageJsonUtil.findChildPackageJsonFile(root));
            if (list2 == null) {
                Root.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Project project;
            VirtualFile packageJson;
            if (e == null) {
                Root.$$$reportNull$$$0(2);
            }
            VirtualFile virtualFile = packageJson = (project = e.getProject()) != null ? this.getRootPackageJson(e) : null;
            if (packageJson == null) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setText(JavaScriptBundle.message("action.InstallNodeLocalDependencies$Root.text", NpmManager.getInstance(project).getNpmInstallPresentableText(), JsbtUtil.getRelativePath(project, packageJson)));
            }
        }

        @Nullable
        private VirtualFile getRootPackageJson(@NotNull AnActionEvent e) {
            VirtualFile packageJson;
            if (e == null) {
                Root.$$$reportNull$$$0(3);
            }
            return (packageJson = (VirtualFile)ContainerUtil.getFirstItem(this.getPackageJsonFiles(e))) != null && !super.getPackageJsonFiles(e).contains(packageJson) ? packageJson : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$Root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$Root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageJsonFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageJsonFiles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootPackageJson";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

