/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.monorepo;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.monorepo.Delimiter;
import com.intellij.javascript.nodejs.monorepo.JsMonorepoNameManagerKt;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0017\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "workspaceMonorepoCached", "Lcom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager$CachedResult;", "calcIsWorkspaceMonorepo", "", "dispose", "", "getRoots", "guessContextPackageName", "", "Lorg/jetbrains/annotations/Nls;", "file", "guessContextPackageRoot", "hasPackageJsonWithWorkspaces", "root", "isWorkspaceMonorepo", "CachedResult", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJsMonorepoNameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMonorepoNameManager.kt\ncom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1#2:165\n1#2:176\n1603#3,9:166\n1855#3:175\n1856#3:177\n1612#3:178\n*S KotlinDebug\n*F\n+ 1 JsMonorepoNameManager.kt\ncom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager\n*L\n54#1:176\n54#1:166,9\n54#1:175\n54#1:177\n54#1:178\n*E\n"})
public final class JsMonorepoNameManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile CachedResult workspaceMonorepoCached;
    @Nullable
    private Set<? extends VirtualFile> roots;

    public JsMonorepoNameManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> JsMonorepoNameManager._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final VirtualFile guessContextPackageRoot(@Nullable VirtualFile file) {
        Object object;
        VirtualFile foundRoot2;
        if (file == null) {
            return null;
        }
        if (!JsMonorepoNameManager.Companion.isEnabled()) {
            return null;
        }
        if (!this.isWorkspaceMonorepo()) {
            return null;
        }
        Set<VirtualFile> roots = this.getRoots();
        if (roots.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = foundRoot2 = JSProjectUtil.traverseUpAndFindFirst(file, arg_0 -> JsMonorepoNameManager.guessContextPackageRoot$lambda$1((Function1)new Function1<VirtualFile, VirtualFile>(roots){
            final /* synthetic */ Set<VirtualFile> $roots;
            {
                this.$roots = $roots;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(VirtualFile it) {
                return this.$roots.contains(it) ? it : null;
            }
        }, arg_0));
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = !Intrinsics.areEqual((Object)it, (Object)ProjectUtil.guessProjectDir((Project)this.project)) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final String guessContextPackageName(@Nullable VirtualFile file) {
        return Companion.getPackageName(this.guessContextPackageRoot(file));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> getRoots() {
        Set result2 = this.roots;
        if (result2 == null) {
            void $this$mapNotNullTo$iv$iv;
            Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (it.getParent() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            this.roots = result2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result2;
    }

    private final boolean isWorkspaceMonorepo() {
        long vfsModCount = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
        CachedResult result2 = this.workspaceMonorepoCached;
        if (result2 == null || result2.getVfsModCount() != vfsModCount) {
            this.workspaceMonorepoCached = result2 = new CachedResult(vfsModCount, this.calcIsWorkspaceMonorepo());
        }
        return result2.isWorkspaceMonorepo();
    }

    private final boolean calcIsWorkspaceMonorepo() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        return root.findChild("pnpm-workspace.yaml") != null || this.hasPackageJsonWithWorkspaces(root);
    }

    private final boolean hasPackageJsonWithWorkspaces(VirtualFile root) {
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(root);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile packageJson = virtualFile;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData data = packageJsonData;
        List<String> list2 = data.getWorkspaces();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getWorkspaces(...)");
        return !((Collection)list2).isEmpty();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(JsMonorepoNameManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.workspaceMonorepoCached = null;
        this$0.roots = null;
    }

    private static final VirtualFile guessContextPackageRoot$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JsMonorepoNameManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final String buildContextName(@Nullable String contextPackagedName, @NotNull String baseName) {
        return Companion.buildContextName(contextPackagedName, baseName);
    }

    @JvmStatic
    @NotNull
    public static final String buildContextName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull Function0<String> baseNameProvider) {
        return Companion.buildContextName(project, contextFileOrDir, baseNameProvider);
    }

    @JvmStatic
    @NotNull
    public static final String buildContextName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull String baseName) {
        return Companion.buildContextName(project, contextFileOrDir, baseName);
    }

    @JvmStatic
    public static final boolean isComposed(@NotNull String name) {
        return Companion.isComposed(name);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager$CachedResult;", "", "vfsModCount", "", "isWorkspaceMonorepo", "", "(JZ)V", "()Z", "getVfsModCount", "()J", "intellij.javascript.impl"})
    private static final class CachedResult {
        private final long vfsModCount;
        private final boolean isWorkspaceMonorepo;

        public CachedResult(long vfsModCount, boolean isWorkspaceMonorepo) {
            this.vfsModCount = vfsModCount;
            this.isWorkspaceMonorepo = isWorkspaceMonorepo;
        }

        public final long getVfsModCount() {
            return this.vfsModCount;
        }

        public final boolean isWorkspaceMonorepo() {
            return this.isWorkspaceMonorepo;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\r\u0010\u0006\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u000b\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0007J2\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0011\u0010\f\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\rH\u0007J,\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000b\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0007J\u0017\u0010\u0012\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager$Companion;", "", "()V", "buildContextName", "", "Lorg/jetbrains/annotations/Nls;", "contextPackagedName", "baseName", "project", "Lcom/intellij/openapi/project/Project;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseNameProvider", "Lkotlin/Function0;", "getDelimiter", "Lcom/intellij/javascript/nodejs/monorepo/Delimiter;", "getInstance", "Lcom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager;", "getPackageName", "packageRootDir", "isComposed", "", "name", "isEnabled", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJsMonorepoNameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMonorepoNameManager.kt\ncom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n31#2,2:165\n1747#3,3:167\n*S KotlinDebug\n*F\n+ 1 JsMonorepoNameManager.kt\ncom/intellij/javascript/nodejs/monorepo/JsMonorepoNameManager$Companion\n*L\n87#1:165,2\n124#1:167,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsMonorepoNameManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JsMonorepoNameManager> serviceClass$iv = JsMonorepoNameManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JsMonorepoNameManager)object;
        }

        private final boolean isEnabled() {
            return Registry.is((String)"js.show.package_name.in.run.configuration", (boolean)true);
        }

        private final Delimiter getDelimiter() {
            String string;
            try {
                string = Registry.stringValue((String)"js.monorepo.configuration.name.delimiter");
            }
            catch (MissingResourceException e) {
                string = null;
            }
            String value = string;
            return JsMonorepoNameManagerKt.access$parseDelimiter(value);
        }

        @JvmStatic
        @NotNull
        public final String buildContextName(@Nullable String contextPackagedName, @NotNull String baseName) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            if (contextPackagedName == null) {
                return baseName;
            }
            return this.getDelimiter().compose(contextPackagedName, baseName);
        }

        @Nullable
        public final String getPackageName(@Nullable VirtualFile packageRootDir) {
            VirtualFile virtualFile = packageRootDir;
            return virtualFile != null ? virtualFile.getName() : null;
        }

        @JvmStatic
        @NotNull
        public final String buildContextName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull Function0<String> baseNameProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(baseNameProvider, (String)"baseNameProvider");
            String contextPackageName = this.getInstance(project).guessContextPackageName(contextFileOrDir);
            return this.buildContextName(contextPackageName, (String)baseNameProvider.invoke());
        }

        @JvmStatic
        @NotNull
        public final String buildContextName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull String baseName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            return this.buildContextName(project, contextFileOrDir, (Function0<String>)((Function0)new Function0<String>(baseName){
                final /* synthetic */ String $baseName;
                {
                    this.$baseName = $baseName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$baseName;
                }
            }));
        }

        @JvmStatic
        public final boolean isComposed(@NotNull String name) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable $this$any$iv = (Iterable)Delimiter.getEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Delimiter it = (Delimiter)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.isComposed(name)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

