/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependencyTreeJsonFileManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.model.YarnPnpDependencyTreeReader;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState;", "", "()V", "fileStates", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$PnpFileState;", "convertStateToFile", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "state", "project", "Lcom/intellij/openapi/project/Project;", "convertStateToFileList", "Companion", "PnpFileState", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nYarnPnpManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpManagerState.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n1603#2,9:114\n1855#2:123\n1856#2:125\n1612#2:126\n1#3:124\n11#4:127\n*S KotlinDebug\n*F\n+ 1 YarnPnpManagerState.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState\n*L\n27#1:114,9\n27#1:123\n27#1:125\n27#1:126\n27#1:124\n82#1:127\n*E\n"})
public final class YarnPnpManagerState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @XCollection(propertyElementName="pnp-files")
    @Nullable
    private List<PnpFileState> fileStates;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<YarnPnpFile> convertStateToFileList(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list2 = this.fileStates;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            YarnPnpFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PnpFileState it = (PnpFileState)element$iv$iv;
            boolean bl2 = false;
            if (this.convertStateToFile(it, project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final YarnPnpFile convertStateToFile(PnpFileState state, Project project) {
        String dependencyTreeJsonFilePath;
        String string;
        String pnpFilePath;
        block7: {
            block6: {
                pnpFilePath = state.getPath();
                string = pnpFilePath;
                if (string == null) break block6;
                String it = string;
                boolean bl = false;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
                string = virtualFile;
                if (virtualFile != null) break block7;
            }
            return null;
        }
        String pnpFile = string;
        YarnPnpFile file = new YarnPnpFile((VirtualFile)pnpFile, project);
        try {
            dependencyTreeJsonFilePath = state.getDependencyTreeJsonFilePath();
            dependencyTreeJsonFilePath = dependencyTreeJsonFilePath != null && new File(pnpFilePath).lastModified() == state.getLastModified() ? Files.readString(Path.of(dependencyTreeJsonFilePath, new String[0])) : null;
        }
        catch (IOException ignored) {
            dependencyTreeJsonFilePath = null;
        }
        String dependencyTreeJson = dependencyTreeJsonFilePath;
        if (dependencyTreeJson != null) {
            YarnPnpDependencyTreeReader reader2 = new YarnPnpDependencyTreeReader(file, (Function1<? super String, String>)((Function1)new Function1<String, String>(state){
                final /* synthetic */ PnpFileState $state;
                {
                    this.$state = $state;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String workspaceLocation) {
                    String string;
                    String libraryName;
                    Intrinsics.checkNotNullParameter((Object)workspaceLocation, (String)"workspaceLocation");
                    Map map = this.$state.getWorkspaceLocationToLibraryNameMap();
                    if (map == null) {
                        map = MapsKt.emptyMap();
                    }
                    if ((libraryName = (String)map.get(workspaceLocation)) != null) {
                        string = libraryName;
                    } else {
                        YarnPnpManagerState.access$getLOG$cp().error("Cannot find library name for " + workspaceLocation);
                        Object[] objectArray = new Object[]{FileUtil.getLocationRelativeToUserHome((String)workspaceLocation) + File.separator + "package.json"};
                        String string2 = JavaScriptBundle.message("yarn.pnp.library_name", objectArray);
                        Intrinsics.checkNotNull((Object)string2);
                        string = string2;
                    }
                    return string;
                }
            }));
            file.setWorkspaceList(reader2.read(dependencyTreeJson));
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final YarnPnpManagerState convertFileListToState(@NotNull Collection<? extends YarnPnpFile> files) {
        return Companion.convertFileListToState(files);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(YarnPnpManagerState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "convertFileListToState", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState;", "files", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "convertFileToState", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$PnpFileState;", "file", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nYarnPnpManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpManagerState.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1045#2:118\n1179#2,2:119\n1253#2,4:121\n42#3,3:125\n*S KotlinDebug\n*F\n+ 1 YarnPnpManagerState.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$Companion\n*L\n86#1:114\n86#1:115,3\n86#1:118\n99#1:119,2\n99#1:121,4\n103#1:125,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final YarnPnpManagerState convertFileListToState(@NotNull Collection<? extends YarnPnpFile> files) {
            YarnPnpManagerState yarnPnpManagerState;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Iterable $this$map$iv = files;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                YarnPnpFile yarnPnpFile = (YarnPnpFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.convertFileToState((YarnPnpFile)it));
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List fileStates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PnpFileState it = (PnpFileState)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (PnpFileState)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                }
            });
            YarnPnpManagerState it = yarnPnpManagerState = new YarnPnpManagerState();
            boolean bl = false;
            it.fileStates = UtilKt.nullize((List)fileStates);
            return yarnPnpManagerState;
        }

        /*
         * WARNING - void declaration
         */
        private final PnpFileState convertFileToState(YarnPnpFile file) {
            String string = file.getPnpFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String pnpFilePath = string;
            PnpFileState fileState = new PnpFileState();
            fileState.setPath(pnpFilePath);
            fileState.setLastModified(new File(pnpFilePath).lastModified());
            YarnPnpWorkspaceList workspaceList = file.getWorkspaceList();
            if (workspaceList != null) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Iterable iterable = workspaceList.getWorkspaces();
                PnpFileState pnpFileState = fileState;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Object object = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    YarnPnpWorkspace it = (YarnPnpWorkspace)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getLocation(), (Object)it.getLibraryName());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                pnpFileState.setWorkspaceLocationToLibraryNameMap(destination$iv$iv);
                try {
                    boolean $i$f$service = false;
                    Class<YarnPnpDependencyTreeJsonFileManager> serviceClass$iv = YarnPnpDependencyTreeJsonFileManager.class;
                    object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    Path dependencyTreeJsonPath = ((YarnPnpDependencyTreeJsonFileManager)object).store(pnpFilePath, workspaceList.getDependencyTreeJson());
                    fileState.setDependencyTreeJsonFilePath(((Object)dependencyTreeJsonPath).toString());
                }
                catch (Exception e) {
                    LOG.error("Cannot store dependency tree json for " + pnpFilePath);
                }
            }
            return fileState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Tag(value="pnp-file")
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR,\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManagerState$PnpFileState;", "", "()V", "dependencyTreeJsonFilePath", "", "getDependencyTreeJsonFilePath", "()Ljava/lang/String;", "setDependencyTreeJsonFilePath", "(Ljava/lang/String;)V", "lastModified", "", "getLastModified", "()J", "setLastModified", "(J)V", "path", "getPath", "setPath", "workspaceLocationToLibraryNameMap", "", "getWorkspaceLocationToLibraryNameMap", "()Ljava/util/Map;", "setWorkspaceLocationToLibraryNameMap", "(Ljava/util/Map;)V", "intellij.javascript.impl"})
    public static final class PnpFileState {
        @Attribute(value="path")
        @Nullable
        private String path;
        @Attribute(value="last-modified")
        private long lastModified;
        @Attribute(value="dependency-tree-json-file-path")
        @Nullable
        private String dependencyTreeJsonFilePath;
        @Tag(value="workspace-location-to-library-name-map")
        @MapAnnotation
        @Nullable
        private Map<String, String> workspaceLocationToLibraryNameMap;

        @Nullable
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@Nullable String string) {
            this.path = string;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(long l) {
            this.lastModified = l;
        }

        @Nullable
        public final String getDependencyTreeJsonFilePath() {
            return this.dependencyTreeJsonFilePath;
        }

        public final void setDependencyTreeJsonFilePath(@Nullable String string) {
            this.dependencyTreeJsonFilePath = string;
        }

        @Nullable
        public final Map<String, String> getWorkspaceLocationToLibraryNameMap() {
            return this.workspaceLocationToLibraryNameMap;
        }

        public final void setWorkspaceLocationToLibraryNameMap(@Nullable Map<String, String> map) {
            this.workspaceLocationToLibraryNameMap = map;
        }
    }
}

